/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.Supplier;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.NameCacheEntry;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class JSONFactory {
    static long defaultReaderFeatures;
    static String defaultReaderFormat;
    static ZoneId defaultReaderZoneId;
    static long defaultWriterFeatures;
    static String defaultWriterFormat;
    static ZoneId defaultWriterZoneId;
    static Supplier<Map> defaultObjectSupplier;
    static Supplier<List> defaultArraySupplier;
    static final NameCacheEntry[] NAME_CACHE;
    static final NameCacheEntry2[] NAME_CACHE2;
    static Class JSON_OBJECT_CLASS_1x;
    static Supplier JSON_OBJECT_1x_SUPPLIER;
    static Function JSON_OBJECT_1x_BUILDER;
    static Function JSON_OBJECT_1x_INNER_MAP;
    static Class JSON_ARRAY_CLASS_1x;
    static Supplier JSON_ARRAY_1x_SUPPLIER;
    static volatile boolean JSON_REFLECT_1x_ERROR;
    static int defaultDecimalMaxScale;
    static final BigDecimal LOW;
    static final BigDecimal HIGH;
    static final BigInteger LOW_BIGINT;
    static final BigInteger HIGH_BIGINT;
    static final char[] CA;
    static final int[] DIGITS2;
    static final float[] FLOAT_10_POW;
    static final double[] DOUBLE_10_POW;
    static final Double DOUBLE_ZERO;
    static final CacheItem[] CACHE_ITEMS;
    static final int CACHE_THRESHOLD = 0x100000;
    static final AtomicReferenceFieldUpdater<CacheItem, char[]> CHARS_UPDATER;
    static final AtomicReferenceFieldUpdater<CacheItem, byte[]> BYTES_UPDATER;
    public static final ObjectWriterProvider defaultObjectWriterProvider;
    public static final ObjectReaderProvider defaultObjectReaderProvider;
    static final ObjectReader<JSONArray> ARRAY_READER;
    static final ObjectReader<com.alibaba.fastjson2.JSONObject> OBJECT_READER;
    static final char[] UUID_LOOKUP;
    static final byte[] UUID_VALUES;

    public static void setDefaultObjectSupplier(Supplier<Map> objectSupplier) {
        defaultObjectSupplier = objectSupplier;
    }

    public static void setDefaultArraySupplier(Supplier<List> arraySupplier) {
        defaultArraySupplier = arraySupplier;
    }

    public static Supplier<Map> getDefaultObjectSupplier() {
        return defaultObjectSupplier;
    }

    public static Supplier<List> getDefaultArraySupplier() {
        return defaultArraySupplier;
    }

    public static JSONWriter.Context createWriteContext() {
        return new JSONWriter.Context(defaultObjectWriterProvider);
    }

    public static JSONWriter.Context createWriteContext(ObjectWriterProvider provider, JSONWriter.Feature ... features) {
        JSONWriter.Context context = new JSONWriter.Context(provider);
        context.config(features);
        return context;
    }

    public static JSONWriter.Context createWriteContext(JSONWriter.Feature ... features) {
        return new JSONWriter.Context(defaultObjectWriterProvider, features);
    }

    public static JSONReader.Context createReadContext() {
        return new JSONReader.Context(defaultObjectReaderProvider);
    }

    public static JSONReader.Context createReadContext(long features) {
        return new JSONReader.Context(defaultObjectReaderProvider, features);
    }

    public static JSONReader.Context createReadContext(JSONReader.Feature ... features) {
        return new JSONReader.Context(defaultObjectReaderProvider, features);
    }

    public static JSONReader.Context createReadContext(Filter filter, JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(defaultObjectReaderProvider, features);
        context.config(filter);
        return context;
    }

    public static JSONReader.Context createReadContext(Filter[] filters, JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(defaultObjectReaderProvider, features);
        context.config(filters, new JSONReader.Feature[0]);
        return context;
    }

    public static JSONReader.Context createReadContext(ObjectReaderProvider provider, JSONReader.Feature ... features) {
        if (provider == null) {
            provider = defaultObjectReaderProvider;
        }
        JSONReader.Context context = new JSONReader.Context(provider);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable) {
        return new JSONReader.Context(defaultObjectReaderProvider, symbolTable);
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable, JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(defaultObjectReaderProvider, symbolTable);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(defaultObjectReaderProvider);
        context.setObjectSupplier(objectSupplier);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, Supplier<List> arraySupplier, JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(defaultObjectReaderProvider);
        context.setObjectSupplier(objectSupplier);
        context.setArraySupplier(arraySupplier);
        context.config(features);
        return context;
    }

    public static ObjectReader getObjectReader(Type type, long features) {
        return JSONFactory.getDefaultObjectReaderProvider().getObjectReader(type, JSONReader.Feature.FieldBased.isEnabled(features));
    }

    public static ObjectWriter getObjectWriter(Type type, long features) {
        return JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(type, TypeUtils.getClass(type), JSONWriter.Feature.FieldBased.isEnabled(features));
    }

    public static ObjectWriterProvider getDefaultObjectWriterProvider() {
        return defaultObjectWriterProvider;
    }

    public static ObjectReaderProvider getDefaultObjectReaderProvider() {
        return defaultObjectReaderProvider;
    }

    public static Class getClassJSONObject1x() {
        if (JSON_OBJECT_CLASS_1x == null && !JSON_REFLECT_1x_ERROR) {
            try {
                JSON_OBJECT_CLASS_1x = JSONObject.class;
            }
            catch (Throwable ignored) {
                JSON_REFLECT_1x_ERROR = true;
            }
        }
        return JSON_OBJECT_CLASS_1x;
    }

    public static Class getClassJSONArray1x() {
        if (JSON_ARRAY_CLASS_1x == null && !JSON_REFLECT_1x_ERROR) {
            try {
                JSON_ARRAY_CLASS_1x = com.alibaba.fastjson.JSONArray.class;
            }
            catch (Throwable ignored) {
                JSON_REFLECT_1x_ERROR = true;
            }
        }
        return JSON_ARRAY_CLASS_1x;
    }

    public static Function getBuilderJSONObject1x() {
        Class classJSONObject1x;
        if (JSON_OBJECT_1x_BUILDER == null && !JSON_REFLECT_1x_ERROR && (classJSONObject1x = JSONFactory.getClassJSONObject1x()) != null) {
            try {
                JSON_OBJECT_1x_BUILDER = new FJ1OjbectBuilder();
            }
            catch (Throwable e) {
                JSON_REFLECT_1x_ERROR = true;
                throw new JSONException("create JSONObject1 error");
            }
        }
        return JSON_OBJECT_1x_BUILDER;
    }

    public static Function getInnerMap() {
        Class classJSONObject1x;
        if (JSON_OBJECT_1x_INNER_MAP == null && !JSON_REFLECT_1x_ERROR && (classJSONObject1x = JSONFactory.getClassJSONObject1x()) != null) {
            try {
                JSON_OBJECT_1x_INNER_MAP = new FJ1ObjectInnerSupplier();
            }
            catch (Throwable e) {
                JSON_REFLECT_1x_ERROR = true;
                throw new JSONException("create getInnerMap error");
            }
        }
        return JSON_OBJECT_1x_INNER_MAP;
    }

    public static Map createJSONObject1(Map map) {
        return new JSONObject(map);
    }

    static {
        int c;
        NAME_CACHE = new NameCacheEntry[8192];
        NAME_CACHE2 = new NameCacheEntry2[8192];
        defaultDecimalMaxScale = 2048;
        LOW = BigDecimal.valueOf(-9007199254740991L);
        HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
        LOW_BIGINT = BigInteger.valueOf(-9007199254740991L);
        HIGH_BIGINT = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
        CA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DIGITS2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        FLOAT_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        DOUBLE_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        DOUBLE_ZERO = 0.0;
        CacheItem[] items = new CacheItem[16];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new CacheItem();
        }
        CACHE_ITEMS = items;
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, char[].class, "chars");
        BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, byte[].class, "bytes");
        defaultObjectWriterProvider = new ObjectWriterProvider();
        defaultObjectReaderProvider = new ObjectReaderProvider();
        ARRAY_READER = ObjectReaderImplList.JSON_ARRAY_READER;
        OBJECT_READER = ObjectReaderImplMap.INSTANCE_OBJECT;
        UUID_LOOKUP = new char[256];
        UUID_VALUES = new byte[55];
        for (int i = 0; i < 256; ++i) {
            int hi = i >> 4 & 0xF;
            int lo = i & 0xF;
            JSONFactory.UUID_LOOKUP[i] = (char)(((hi < 10 ? 48 + hi : 97 + hi - 10) << 8) + (lo < 10 ? 48 + lo : 97 + lo - 10));
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 48);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            JSONFactory.UUID_VALUES[c - 48] = (byte)(c - 65 + 10);
        }
    }

    private static final class FJ1OjbectBuilder
    implements Function {
        private FJ1OjbectBuilder() {
        }

        public Object apply(Object o) {
            return new JSONObject((Map)o);
        }
    }

    private static final class FJ1ObjectInnerSupplier
    implements Function {
        private FJ1ObjectInnerSupplier() {
        }

        public Object apply(Object o) {
            return ((JSONObject)o).getInnerMap();
        }
    }

    static final class NameCacheEntry2 {
        final String name;
        final long value0;
        final long value1;

        public NameCacheEntry2(String name, long value0, long value1) {
            this.name = name;
            this.value0 = value0;
            this.value1 = value1;
        }
    }

    static final class CacheItem {
        volatile char[] chars;
        volatile byte[] bytes;

        CacheItem() {
        }
    }
}

