/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.Supplier;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.reflect.Type;

public class ObjectReader1<T>
extends ObjectReaderAdapter<T> {
    protected final FieldReader fieldReader0;
    final long hashCode0;
    final long hashCode0LCase;
    protected ObjectReader objectReader0;

    public ObjectReader1(Class objectClass, String typeKey, String typeName, long features, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        super(objectClass, typeKey, typeName, features, creator, buildFunction, (Class[])null, (String[])null, (Class)null, fieldReaders);
        this.fieldReader0 = fieldReaders[0];
        this.hashCode0 = this.fieldReader0.fieldNameHash;
        this.hashCode0LCase = this.fieldReader0.fieldNameHashLCase;
        this.hasDefaultValue = this.fieldReader0.defaultValue != null;
    }

    @Override
    public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, null, null, this.features);
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features)) != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        Object object = this.creator.get();
        int entryCnt = jsonReader.startArray();
        if (entryCnt > 0) {
            this.fieldReader0.readFieldValue(jsonReader, object);
            for (int i = 1; i < entryCnt; ++i) {
                jsonReader.skipValue();
            }
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object object;
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features)) != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.isArray()) {
            Object object2 = this.creator.get();
            int entryCnt = jsonReader.startArray();
            if (entryCnt > 0) {
                this.fieldReader0.readFieldValue(jsonReader, object2);
                for (int i = 1; i < entryCnt; ++i) {
                    jsonReader.skipValue();
                }
            }
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            if (jsonReader.isTypeRedirect()) {
                jsonReader.setTypeRedirect(false);
            } else {
                throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
            }
        }
        if (this.creator != null) {
            object = this.creator.get();
        } else if (((features | jsonReader.context.features) & JSONReader.Feature.FieldBased.mask) != 0L) {
            try {
                object = JDKUtils.UNSAFE.allocateInstance(this.objectClass);
            }
            catch (InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error"), e);
            }
        } else {
            object = null;
        }
        if (object != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == this.getTypeKeyHash() && i == 0) {
                String typeName;
                JSONReader.Context context = jsonReader.context;
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException(jsonReader.info("auotype not support : " + typeName));
                }
                if (autoTypeObjectReader != this) {
                    return autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                }
            } else if (hashCode != 0L) {
                if (hashCode == this.hashCode0) {
                    this.fieldReader0.readFieldValueJSONB(jsonReader, object);
                } else if (jsonReader.isSupportSmartMatch(features | this.features) && jsonReader.getNameHashCodeLCase() == this.hashCode0LCase) {
                    this.fieldReader0.readFieldValue(jsonReader, object);
                } else {
                    this.processExtra(jsonReader, object, features);
                }
            }
            ++i;
        }
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.fieldReader0.acceptDefaultValue(object);
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object object;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        long featuresAll = jsonReader.features(this.features | features);
        if (jsonReader.isArray()) {
            if ((featuresAll & JSONReader.Feature.SupportArrayToBean.mask) != 0L) {
                jsonReader.next();
                Object object2 = this.creator.get();
                this.fieldReader0.readFieldValue(jsonReader, object2);
                if (!jsonReader.nextIfArrayEnd()) {
                    throw new JSONException(jsonReader.info("array to bean end error, " + jsonReader.current()));
                }
                jsonReader.nextIfComma();
                if (this.buildFunction != null) {
                    return (T)this.buildFunction.apply(object2);
                }
                return object2;
            }
            return this.processObjectInputSingleItemArray(jsonReader, fieldType, fieldName, featuresAll);
        }
        jsonReader.nextIfObjectStart();
        Object t = object = this.creator != null ? (Object)this.creator.get() : null;
        if (this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        if (object != null && (featuresAll & JSONReader.Feature.InitStringFieldAsEmpty.mask) != 0L) {
            this.initStringFieldAsEmpty(object);
        }
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (i == 0 && hashCode == 435678704704L) {
                String typeName;
                JSONReader.Context context = jsonReader.context;
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                    object = autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, features);
                    break;
                }
            } else if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
            } else if (jsonReader.isSupportSmartMatch(features | this.features) && jsonReader.getNameHashCodeLCase() == this.hashCode0LCase) {
                this.fieldReader0.readFieldValue(jsonReader, object);
            } else {
                this.processExtra(jsonReader, object, features);
            }
            ++i;
        }
        jsonReader.nextIfComma();
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode0) {
            return this.fieldReader0;
        }
        return null;
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        if (hashCode == this.hashCode0LCase) {
            return this.fieldReader0;
        }
        return null;
    }
}

