/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplStringArray;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NameCacheEntry;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class JSONReaderJSONB
extends JSONReader {
    static final long BASE = JDKUtils.UNSAFE.arrayBaseOffset(byte[].class);
    static final byte[] SHANGHAI_ZONE_ID_NAME_BYTES = JSONB.toBytes("Asia/Shanghai");
    static Charset GB18030;
    static final byte[] FIXED_TYPE_SIZE;
    protected final byte[] bytes;
    protected final int length;
    protected final int end;
    protected byte type;
    protected int strlen;
    protected byte strtype;
    protected int strBegin;
    protected byte[] valueBytes;
    protected char[] charBuf;
    protected final JSONFactory.CacheItem cacheItem;
    protected final SymbolTable symbolTable;
    protected long symbol0Hash;
    protected int symbol0Begin;
    protected int symbol0Length;
    protected byte symbol0StrType;
    protected long[] symbols;

    JSONReaderJSONB(JSONReader.Context ctx, InputStream is) {
        super(ctx, true);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (bytes == null) {
            bytes = new byte[ctx.bufferSize];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + ctx.bufferSize);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.bytes = bytes;
        this.offset = 0;
        this.end = this.length = off;
        this.symbolTable = ctx.symbolTable;
    }

    JSONReaderJSONB(JSONReader.Context ctx, byte[] bytes, int off, int length) {
        super(ctx, true);
        this.bytes = bytes;
        this.offset = off;
        this.length = length;
        this.end = off + length;
        this.symbolTable = ctx.symbolTable;
        this.cacheItem = JSONFactory.CACHE_ITEMS[System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1];
    }

    String getLatin1String(int offset, int length) {
        if (JDKUtils.ANDROID_SDK_INT >= 34) {
            return new String(this.bytes, offset, length, StandardCharsets.ISO_8859_1);
        }
        char[] charBuf = this.charBuf;
        if (charBuf == null) {
            this.charBuf = charBuf = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
        }
        if (charBuf == null || charBuf.length < length) {
            this.charBuf = charBuf = new char[length];
        }
        for (int i = 0; i < length; ++i) {
            charBuf[i] = (char)(this.bytes[offset + i] & 0xFF);
        }
        return new String(charBuf, 0, length);
    }

    @Override
    public String getString() {
        Charset charset;
        if (this.strtype == -81) {
            return null;
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        if (this.strtype == 121 || this.strtype >= 73 && this.strtype <= 120) {
            charset = StandardCharsets.ISO_8859_1;
            if (JDKUtils.ANDROID_SDK_INT < 34) {
                int strOff = this.strBegin;
                char[] charBuf = this.charBuf;
                if (charBuf == null) {
                    this.charBuf = charBuf = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                }
                if (charBuf == null || charBuf.length < this.strlen) {
                    this.charBuf = charBuf = new char[this.strlen];
                }
                for (int i = 0; i < this.strlen; ++i) {
                    charBuf[i] = (char)(this.bytes[strOff + i] & 0xFF);
                }
                return new String(charBuf, 0, this.strlen);
            }
        } else if (this.strtype == 122) {
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            charset = StandardCharsets.UTF_16BE;
        } else {
            throw JSONReaderJSONB.notSupportType(this.strtype);
        }
        return new String(this.bytes, this.strBegin, this.strlen, charset);
    }

    public int readLength() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int len = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return len;
        }
        if (type == 72) {
            int len = JSONReaderJSONB.getInt(this.bytes, this.offset);
            this.offset += 4;
            if (len > 0x10000000) {
                throw new JSONException("input length overflow");
            }
            return len;
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    static int getInt3(byte[] bytes, int offset, int type) {
        return (type - 68 << 16) + ((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF);
    }

    @Override
    public boolean isArray() {
        if (this.offset >= this.bytes.length) {
            return false;
        }
        byte type = this.bytes[this.offset];
        return type >= -108 && type <= -92;
    }

    @Override
    public boolean isObject() {
        return this.offset < this.end && this.bytes[this.offset] == -90;
    }

    @Override
    public boolean isNumber() {
        byte type = this.bytes[this.offset];
        return type >= -78 && type <= 72;
    }

    @Override
    public boolean isString() {
        return this.offset < this.bytes.length && (this.type = this.bytes[this.offset]) >= 73;
    }

    @Override
    public boolean nextIfMatch(char ch) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfArrayStart() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfArrayEnd() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfComma() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfObjectStart() {
        if (this.bytes[this.offset] != -90) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfObjectEnd() {
        if (this.bytes[this.offset] != -91) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfNullOrEmptyString() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        if (this.bytes[this.offset] != 73) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public Map<String, Object> readObject() {
        byte[] bytes = this.bytes;
        long features = this.context.features;
        this.type = bytes[this.offset++];
        if (this.type == -81) {
            return null;
        }
        if (this.type >= -90) {
            Map<String, Object> map = (features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : (this.context.objectSupplier != null ? this.context.objectSupplier.get() : new JSONObject());
            while (true) {
                List<Object> value;
                byte type;
                if ((type = bytes[this.offset]) == -91) {
                    ++this.offset;
                    break;
                }
                Object name = type >= 73 ? this.readFieldName() : this.readAny();
                byte valueType = bytes[this.offset];
                if (valueType == -109) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        map.put((String)name, map);
                        continue;
                    }
                    this.addResolveTask(map, name, JSONPath.of(reference));
                    continue;
                }
                if (valueType >= 73 && valueType <= 126) {
                    value = this.readString();
                } else if (valueType >= -16 && valueType <= 47) {
                    ++this.offset;
                    value = Integer.valueOf(valueType);
                } else if (valueType == -79) {
                    ++this.offset;
                    value = Boolean.TRUE;
                } else if (valueType == -80) {
                    ++this.offset;
                    value = Boolean.FALSE;
                } else if (valueType == -90) {
                    value = this.readObject();
                } else if (valueType == -66) {
                    ++this.offset;
                    long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                    this.offset += 8;
                    value = JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
                } else if (valueType >= -108 && valueType <= -92) {
                    int len;
                    ++this.offset;
                    if (valueType == -92) {
                        int itemType = bytes[this.offset];
                        if (itemType >= -16 && itemType <= 47) {
                            ++this.offset;
                            len = itemType;
                        } else if (itemType >= 48 && itemType <= 63) {
                            len = (itemType - 56 << 8) + (bytes[this.offset + 1] & 0xFF);
                            this.offset += 2;
                        } else {
                            len = this.readLength();
                        }
                    } else {
                        len = valueType - -108;
                    }
                    if (len == 0) {
                        value = (features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList() : (this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray());
                    } else {
                        List<Object> list = (features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : (this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray(len));
                        for (int i = 0; i < len; ++i) {
                            byte itemType = bytes[this.offset];
                            if (itemType == -109) {
                                String reference = this.readReference();
                                if ("..".equals(reference)) {
                                    list.add(list);
                                    continue;
                                }
                                list.add(null);
                                this.addResolveTask(list, i, JSONPath.of(reference));
                                continue;
                            }
                            Object item = itemType >= 73 && itemType <= 126 ? this.readString() : (itemType == -90 ? this.readObject() : this.readAny());
                            list.add(item);
                        }
                        value = list;
                    }
                } else if (valueType >= 48 && valueType <= 63) {
                    value = (valueType - 56 << 8) + (bytes[this.offset + 1] & 0xFF);
                    this.offset += 2;
                } else if (valueType >= 64 && valueType <= 71) {
                    int int32Value = JSONReaderJSONB.getInt3(bytes, this.offset + 1, valueType);
                    this.offset += 3;
                    value = new Integer(int32Value);
                } else if (valueType == 72) {
                    int int32Value = JSONReaderJSONB.getInt(bytes, this.offset + 1);
                    this.offset += 5;
                    value = new Integer(int32Value);
                } else {
                    value = this.readAny();
                }
                if (value == null && (features & JSONReader.Feature.IgnoreNullPropertyValue.mask) != 0L) continue;
                map.put((String)name, value);
            }
            return map;
        }
        if (this.type == -110) {
            ObjectReader objectReader = this.checkAutoType(Map.class, 0L, 0L);
            return (Map)objectReader.readObject(this, null, null, 0L);
        }
        throw JSONReaderJSONB.notSupportType(this.type);
    }

    @Override
    public void read(Map map, long features) {
        if (this.bytes[this.offset] != -90) {
            throw new JSONException("object not support input " + this.error(this.type));
        }
        ++this.offset;
        int i = 0;
        while (true) {
            byte type;
            if ((type = this.bytes[this.offset]) == -91) {
                ++this.offset;
                break;
            }
            Object name = type >= 73 ? this.readFieldName() : this.readAny();
            if (this.isReference()) {
                String reference = this.readReference();
                if ("..".equals(reference)) {
                    map.put(name, map);
                } else {
                    this.addResolveTask(map, name, JSONPath.of(reference));
                    map.put(name, null);
                }
            } else {
                Object value;
                byte valueType = this.bytes[this.offset];
                if (valueType >= 73 && valueType <= 126) {
                    value = this.readString();
                } else if (valueType >= -16 && valueType <= 47) {
                    ++this.offset;
                    value = (int)valueType;
                } else if (valueType == -79) {
                    ++this.offset;
                    value = Boolean.TRUE;
                } else if (valueType == -80) {
                    ++this.offset;
                    value = Boolean.FALSE;
                } else {
                    value = valueType == -90 ? this.readObject() : this.readAny();
                }
                if (value != null || (this.context.features & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) {
                    map.put(name, value);
                }
            }
            ++i;
        }
    }

    @Override
    public Object readAny() {
        if (this.offset >= this.bytes.length) {
            throw new JSONException("readAny overflow : " + this.offset + "/" + this.bytes.length);
        }
        this.type = this.bytes[this.offset++];
        switch (this.type) {
            case -81: {
                return null;
            }
            case -79: {
                return true;
            }
            case -80: {
                return false;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                return (short)((this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF));
            }
            case 72: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Integer(int32Value);
            }
            case -65: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Long(int32Value);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case 122: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                if (strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                    str = null;
                }
                this.offset += strlen;
                return str;
            }
            case 123: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16);
                if (strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                    str = null;
                }
                this.offset += strlen;
                return str;
            }
            case 124: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                if (strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                    str = null;
                }
                this.offset += strlen;
                return str;
            }
            case 125: {
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16BE);
                if (strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                    str = null;
                }
                this.offset += strlen;
                return str;
            }
            case 126: {
                if (GB18030 == null) {
                    GB18030 = Charset.forName("GB18030");
                }
                int strlen = this.readLength();
                String str = new String(this.bytes, this.offset, strlen, GB18030);
                if (strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                    str = null;
                }
                this.offset += strlen;
                return str;
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal;
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -111: {
                int len = this.readLength();
                byte[] binary = Arrays.copyOfRange(this.bytes, this.offset, this.offset + len);
                this.offset += len;
                return binary;
            }
            case -83: {
                long minutes = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Date(minutes * 60L * 1000L);
            }
            case -84: {
                long seconds = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Date(seconds * 1000L);
            }
            case -87: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                return LocalDate.of(year, month, (int)dayOfMonth);
            }
            case -89: {
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                return LocalTime.of(hour, minute, second, nano);
            }
            case -88: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
            }
            case -86: {
                return this.readTimestampWithTimeZone();
            }
            case -82: {
                long epochSeconds = this.readInt64Value();
                int nano = this.readInt32Value();
                return Instant.ofEpochSecond(epochSeconds, nano);
            }
            case -85: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return new Date(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis));
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -110: {
                String typeName;
                boolean supportAutoType;
                ObjectReader autoTypeObjectReader;
                long typeHash = this.readTypeHashCode();
                if (this.context.autoTypeBeforeHandler != null) {
                    Class<?> filterClass = this.context.autoTypeBeforeHandler.apply(typeHash, null, this.context.features);
                    if (filterClass == null) {
                        String typeName2 = this.getString();
                        filterClass = this.context.autoTypeBeforeHandler.apply(typeName2, null, this.context.features);
                    }
                    if (filterClass != null) {
                        autoTypeObjectReader = this.context.getObjectReader(filterClass);
                        return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                    }
                }
                boolean bl = supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                if (!supportAutoType) {
                    if (this.isObject()) {
                        return this.readObject();
                    }
                    if (this.isArray()) {
                        return this.readArray();
                    }
                    throw new JSONException("autoType not support , offset " + this.offset + "/" + this.bytes.length);
                }
                autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                    throw new JSONException("autoType not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                }
                return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
            }
            case -78: {
                return 0.0;
            }
            case -77: {
                return 1.0;
            }
            case -112: {
                int intValue = this.readInt32Value();
                return Character.valueOf((char)intValue);
            }
            case -90: {
                Map<String, Object> map = null;
                boolean supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                int i = 0;
                while (true) {
                    Object name;
                    byte type;
                    if ((type = this.bytes[this.offset]) == -91) {
                        ++this.offset;
                        break;
                    }
                    if (supportAutoType && i == 0 && type >= 73) {
                        long hash = this.readFieldNameHashCode();
                        if (hash == 435678704704L) {
                            String typeName;
                            long typeHash = this.readValueHashCode();
                            ObjectReader autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                            if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                                throw new JSONException("auotype not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                            }
                            this.typeRedirect = true;
                            return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                        }
                        name = this.getString();
                    } else {
                        name = type >= 73 ? this.readFieldName() : this.readAny();
                    }
                    if (map == null) {
                        map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : (this.context.objectSupplier != null ? this.context.objectSupplier.get() : new JSONObject());
                    }
                    if (this.isReference()) {
                        String reference = this.readReference();
                        if ("..".equals(reference)) {
                            map.put((String)name, map);
                        } else {
                            this.addResolveTask(map, name, JSONPath.of(reference));
                            map.put((String)name, null);
                        }
                    } else {
                        Object value;
                        byte valueType = this.bytes[this.offset];
                        if (valueType >= 73 && valueType <= 126) {
                            value = this.readString();
                        } else if (valueType >= -16 && valueType <= 47) {
                            ++this.offset;
                            value = (int)valueType;
                        } else if (valueType == -79) {
                            ++this.offset;
                            value = Boolean.TRUE;
                        } else if (valueType == -80) {
                            ++this.offset;
                            value = Boolean.FALSE;
                        } else {
                            value = valueType == -90 ? this.readObject() : this.readAny();
                        }
                        if (value != null || (this.context.features & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) {
                            map.put((String)name, value);
                        }
                    }
                    ++i;
                }
                if (map == null) {
                    map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
                }
                return map;
            }
        }
        if (this.type >= -16 && this.type <= 47) {
            return (int)this.type;
        }
        if (this.type >= 48 && this.type <= 63) {
            return (this.type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= 64 && this.type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, this.type);
            this.offset += 2;
            return int3;
        }
        if (this.type >= -40 && this.type <= -17) {
            return -8L + (long)(this.type - -40);
        }
        if (this.type >= -56 && this.type <= -41) {
            return (long)(this.type - -48 << 8) + (long)(this.bytes[this.offset++] & 0xFF);
        }
        if (this.type >= -64 && this.type <= -57) {
            return (long)((this.type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF));
        }
        if (this.type >= -108 && this.type <= -92) {
            int len;
            int n = len = this.type == -92 ? this.readLength() : this.type - -108;
            if (len == 0) {
                if ((this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L) {
                    return new ArrayList();
                }
                if (this.context.arraySupplier != null) {
                    return this.context.arraySupplier.get();
                }
                return new JSONArray();
            }
            JSONArray list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                if (this.isReference()) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        list.add(list);
                        continue;
                    }
                    list.add(null);
                    this.addResolveTask(list, i, JSONPath.of(reference));
                    continue;
                }
                Object item = this.readAny();
                list.add(item);
            }
            return list;
        }
        if (this.type >= 73 && this.type <= 121) {
            int n = this.strlen = this.type == 121 ? this.readLength() : this.type - 73;
            if (this.strlen < 0) {
                return this.symbolTable.getName(-this.strlen);
            }
            String str = this.getLatin1String(this.offset, this.strlen);
            this.offset += this.strlen;
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (this.strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                str = null;
            }
            return str;
        }
        if (this.type == 127) {
            this.strlen = this.readLength();
            if (this.strlen >= 0) {
                throw new JSONException("not support symbol : " + this.strlen);
            }
            return this.symbolTable.getName(-this.strlen);
        }
        throw new JSONException("not support type : " + this.error(this.type));
    }

    private ZonedDateTime readTimestampWithTimeZone() {
        ZoneId zoneId;
        boolean shanghai;
        byte[] bytes = this.bytes;
        int year = (bytes[this.offset++] << 8) + (bytes[this.offset++] & 0xFF);
        byte month = bytes[this.offset++];
        byte dayOfMonth = bytes[this.offset++];
        byte hour = bytes[this.offset++];
        byte minute = bytes[this.offset++];
        byte second = bytes[this.offset++];
        int nano = this.readInt32Value();
        byte[] shanghaiZoneIdNameBytes = SHANGHAI_ZONE_ID_NAME_BYTES;
        if (this.offset + shanghaiZoneIdNameBytes.length < bytes.length) {
            shanghai = true;
            for (int i = 0; i < shanghaiZoneIdNameBytes.length; ++i) {
                if (bytes[this.offset + i] == shanghaiZoneIdNameBytes[i]) continue;
                shanghai = false;
                break;
            }
        } else {
            shanghai = false;
        }
        if (shanghai) {
            this.offset += shanghaiZoneIdNameBytes.length;
            zoneId = DateUtils.SHANGHAI_ZONE_ID;
        } else {
            String zoneIdStr = this.readString();
            zoneId = DateUtils.getZoneId(zoneIdStr, DateUtils.SHANGHAI_ZONE_ID);
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
        return ZonedDateTime.of(ldt, zoneId);
    }

    @Override
    public byte getType() {
        return this.bytes[this.offset];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public List readArray() {
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        int i = 0;
        while (true) {
            block24: {
                void var5_5;
                block9: {
                    JSONArray list;
                    int len;
                    block18: {
                        block22: {
                            String reference;
                            block23: {
                                byte valueType;
                                block21: {
                                    block20: {
                                        block19: {
                                            block16: {
                                                block17: {
                                                    block15: {
                                                        block14: {
                                                            block13: {
                                                                block12: {
                                                                    block11: {
                                                                        block10: {
                                                                            if (i >= entryCnt) {
                                                                                return array;
                                                                            }
                                                                            valueType = this.bytes[this.offset];
                                                                            if (valueType < 73 || valueType > 126) break block10;
                                                                            String string = this.readString();
                                                                            break block9;
                                                                        }
                                                                        if (valueType < -16 || valueType > 47) break block11;
                                                                        ++this.offset;
                                                                        Integer n = valueType;
                                                                        break block9;
                                                                    }
                                                                    if (valueType != -79) break block12;
                                                                    ++this.offset;
                                                                    Boolean bl = Boolean.TRUE;
                                                                    break block9;
                                                                }
                                                                if (valueType != -80) break block13;
                                                                ++this.offset;
                                                                Boolean bl = Boolean.FALSE;
                                                                break block9;
                                                            }
                                                            if (valueType != -90) break block14;
                                                            Map<String, Object> map = this.readObject();
                                                            break block9;
                                                        }
                                                        if (valueType != -66) break block15;
                                                        ++this.offset;
                                                        long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                                                        this.offset += 8;
                                                        Long l = JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
                                                        break block9;
                                                    }
                                                    if (valueType < -108 || valueType > -92) break block16;
                                                    ++this.offset;
                                                    int n = len = valueType == -92 ? this.readLength() : valueType - -108;
                                                    if (len != 0) break block17;
                                                    if ((this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L) {
                                                        ArrayList arrayList = new ArrayList();
                                                        break block9;
                                                    } else if (this.context.arraySupplier != null) {
                                                        List list2 = this.context.arraySupplier.get();
                                                        break block9;
                                                    } else {
                                                        JSONArray jSONArray = new JSONArray();
                                                    }
                                                    break block9;
                                                }
                                                list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
                                                break block18;
                                            }
                                            if (valueType < 48 || valueType > 63) break block19;
                                            Integer n = (valueType - 56 << 8) + (this.bytes[this.offset + 1] & 0xFF);
                                            this.offset += 2;
                                            break block9;
                                        }
                                        if (valueType < 64 || valueType > 71) break block20;
                                        int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset + 1, valueType);
                                        this.offset += 3;
                                        Integer n = new Integer(int3);
                                        break block9;
                                    }
                                    if (valueType != 72) break block21;
                                    int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset + 1);
                                    this.offset += 5;
                                    Integer n = new Integer(int32Value);
                                    break block9;
                                }
                                if (valueType != -109) break block22;
                                reference = this.readReference();
                                if (!"..".equals(reference)) break block23;
                                JSONArray jSONArray = array;
                                break block9;
                            }
                            this.addResolveTask(array, i, JSONPath.of(reference));
                            break block24;
                        }
                        Object object = this.readAny();
                        break block9;
                    }
                    for (int j = 0; j < len; ++j) {
                        if (this.isReference()) {
                            String reference = this.readReference();
                            if ("..".equals(reference)) {
                                list.add(list);
                                continue;
                            }
                            list.add(null);
                            this.addResolveTask(list, j, JSONPath.of(reference));
                            continue;
                        }
                        byte itemType = this.bytes[this.offset];
                        Object item = itemType >= 73 && itemType <= 126 ? this.readString() : (itemType == -90 ? this.readObject() : this.readAny());
                        list.add(item);
                    }
                    JSONArray jSONArray = list;
                }
                array.add(var5_5);
            }
            ++i;
        }
    }

    @Override
    public List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.bytes[this.offset] == -110) {
            Object obj = this.readAny();
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof Collection) {
                return new JSONArray((Collection<?>)((Collection)obj));
            }
            throw new JSONException("not support class " + obj.getClass());
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public List readList(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            Type itemType = types[i];
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public byte[] readHex() {
        String str = this.readString();
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            char c0 = str.charAt(i * 2);
            char c1 = str.charAt(i * 2 + 1);
            int b0 = c0 - (c0 <= '9' ? 48 : 55);
            int b1 = c1 - (c1 <= '9' ? 48 : 55);
            bytes[i] = (byte)(b0 << 4 | b1);
        }
        return bytes;
    }

    @Override
    public boolean isReference() {
        return this.offset < this.bytes.length && this.bytes[this.offset] == -109;
    }

    @Override
    public String readReference() {
        if (this.bytes[this.offset] != -109) {
            return null;
        }
        ++this.offset;
        if (this.isString()) {
            return this.readString();
        }
        throw new JSONException("reference not support input " + this.error(this.type));
    }

    @Override
    public ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        ObjectReader autoTypeObjectReader = null;
        byte type = this.bytes[this.offset];
        if (type == -110) {
            ClassLoader tcl;
            ClassLoader classLoader;
            Class objectClass;
            long features2;
            ObjectReader objectReader;
            Class<Object> objectClass2;
            ++this.offset;
            long typeHash = this.readTypeHashCode();
            ObjectReaderProvider provider = this.context.provider;
            if (expectClassHash == typeHash && (objectClass2 = (objectReader = this.context.getObjectReader(expectClass)).getObjectClass()) != null && objectClass2 == expectClass) {
                provider.registerIfAbsent(typeHash, objectReader);
                return objectReader;
            }
            JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = this.context.autoTypeBeforeHandler;
            if (autoTypeBeforeHandler != null) {
                ObjectReader objectReader2;
                objectClass2 = autoTypeBeforeHandler.apply(typeHash, expectClass, features);
                if (objectClass2 == null) {
                    objectClass2 = autoTypeBeforeHandler.apply(this.getString(), expectClass, features);
                }
                if (objectClass2 != null && (objectReader2 = this.context.getObjectReader(objectClass2)) != null) {
                    return objectReader2;
                }
            }
            if (((features2 = this.context.features | features) & JSONReader.Feature.SupportAutoType.mask) == 0L) {
                if ((features2 & JSONReader.Feature.ErrorOnNotSupportAutoType.mask) == 0L) {
                    return null;
                }
                this.autoTypeError();
            }
            if ((autoTypeObjectReader = provider.getObjectReader(typeHash)) != null && (objectClass = autoTypeObjectReader.getObjectClass()) != null && (classLoader = objectClass.getClassLoader()) != null && classLoader != (tcl = Thread.currentThread().getContextClassLoader())) {
                autoTypeObjectReader = this.getObjectReaderContext(autoTypeObjectReader, objectClass, tcl);
            }
            if (autoTypeObjectReader == null && (autoTypeObjectReader = provider.getObjectReader(this.getString(), expectClass, features2)) == null) {
                this.autoTypeError();
            }
            this.type = this.bytes[this.offset];
        }
        return autoTypeObjectReader;
    }

    final void autoTypeError() {
        throw new JSONException("auotype not support : " + this.getString());
    }

    private ObjectReader getObjectReaderContext(ObjectReader autoTypeObjectReader, Class objectClass, ClassLoader contextClassLoader) {
        String typeName = this.getString();
        Class<?> contextClass = TypeUtils.getMapping(typeName);
        if (contextClass == null) {
            try {
                if (contextClassLoader == null) {
                    contextClassLoader = JSON.class.getClassLoader();
                }
                contextClass = contextClassLoader.loadClass(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (contextClass != null && !objectClass.equals(contextClass)) {
            autoTypeObjectReader = this.getObjectReader(contextClass);
        }
        return autoTypeObjectReader;
    }

    @Override
    public int startArray() {
        byte type;
        if ((type = (this.type = this.bytes[this.offset++])) == -81) {
            return -1;
        }
        if (type >= -108 && type <= -93) {
            this.ch = (char)(-type);
            return type - -108;
        }
        if (type == -111) {
            return this.readInt32Value();
        }
        if (type != -92) {
            throw new JSONException("array not support input " + this.error(type));
        }
        return this.readInt32Value();
    }

    public String error(byte type) {
        StringBuilder buf = new StringBuilder();
        buf.append(JSONB.typeName(type));
        if (this.isString()) {
            int mark = this.offset--;
            String str = null;
            try {
                str = this.readString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (str != null) {
                buf.append(' ');
                buf.append(str);
            }
            this.offset = mark;
        }
        buf.append(", offset ");
        buf.append(this.offset);
        buf.append('/');
        buf.append(this.bytes.length);
        return buf.toString();
    }

    @Override
    public void next() {
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        int strlen;
        byte strtype;
        boolean typeSymbol;
        byte[] bytes = this.bytes;
        boolean bl = typeSymbol = (strtype = (this.strtype = bytes[this.offset++])) == 127;
        if (typeSymbol) {
            this.strtype = bytes[this.offset];
            strtype = this.strtype;
            if (strtype >= -16 && strtype <= 72) {
                int symbol;
                if (strtype <= 47) {
                    ++this.offset;
                    symbol = strtype;
                } else {
                    symbol = this.readInt32Value();
                }
                if (symbol < 0) {
                    return this.symbolTable.getHashCode(-symbol);
                }
                if (symbol == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    if (this.symbol0Hash == 0L) {
                        this.symbol0Hash = this.getNameHashCode();
                    }
                    return this.symbol0Hash;
                }
                int index = symbol * 2;
                long strInfo = this.symbols[index + 1];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                long nameHashCode = this.symbols[index];
                if (nameHashCode == 0L) {
                    this.symbols[index] = nameHashCode = this.getNameHashCode();
                }
                return nameHashCode;
            }
            ++this.offset;
        }
        if (strtype >= 73 && strtype <= 120) {
            strlen = strtype - 73;
        } else if (strtype == 121 || strtype == 122) {
            strlen = this.readLength();
        } else {
            throw this.readFieldNameHashCodeError();
        }
        this.strlen = strlen;
        this.strBegin = this.offset;
        if (strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-strlen);
        } else {
            long nameValue = 0L;
            if (strlen <= 8 && this.offset + strlen <= bytes.length) {
                int offset = this.offset;
                switch (strlen) {
                    case 1: {
                        nameValue = bytes[offset];
                        break;
                    }
                    case 2: {
                        nameValue = (long)JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset) & 0xFFFFL;
                        break;
                    }
                    case 3: {
                        nameValue = (long)(bytes[offset + 2] << 16) + ((long)JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset) & 0xFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)bytes[offset + 4] << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset) & 0xFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset + 4L) << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset) & 0xFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)bytes[offset + 6] << 48) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset) & 0xFFFFFFFFL);
                        break;
                    }
                    default: {
                        nameValue = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset);
                    }
                }
            }
            if (nameValue != 0L) {
                this.offset += strlen;
                hashCode = nameValue;
            } else {
                hashCode = -3750763034362895579L;
                for (int i = 0; i < strlen; ++i) {
                    hashCode ^= (long)bytes[this.offset++];
                    hashCode *= 1099511628211L;
                }
            }
        }
        if (typeSymbol) {
            int symbol = bytes[this.offset];
            if (symbol >= -16 && symbol <= 47) {
                ++this.offset;
            } else {
                symbol = this.readInt32Value();
            }
            if (symbol == 0) {
                this.symbol0Begin = this.strBegin;
                this.symbol0Length = strlen;
                this.symbol0StrType = strtype;
                this.symbol0Hash = hashCode;
            } else {
                int symbolIndex = symbol << 1;
                int minCapacity = symbolIndex + 2;
                if (this.symbols == null) {
                    this.symbols = new long[Math.max(minCapacity, 32)];
                } else if (this.symbols.length < minCapacity) {
                    this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
                }
                this.symbols[symbolIndex] = hashCode;
                this.symbols[symbolIndex + 1] = ((long)this.strBegin << 32) + ((long)strlen << 8) + (long)strtype;
            }
        }
        return hashCode;
    }

    JSONException readFieldNameHashCodeError() {
        StringBuilder message = new StringBuilder().append("fieldName not support input type ").append(JSONB.typeName(this.strtype));
        if (this.strtype == -109) {
            message.append(" ").append(this.readString());
        }
        message.append(", offset ").append(this.offset);
        return new JSONException(message.toString());
    }

    @Override
    public boolean isInt() {
        byte type = this.bytes[this.offset];
        return type >= -70 && type <= 72 || type == -84 || type == -83 || type == -85;
    }

    @Override
    public boolean isNull() {
        return this.bytes[this.offset] == -81;
    }

    @Override
    public Date readNullOrNewDate() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public void readNull() {
        this.type = this.bytes[this.offset++];
        if (this.type != -81) {
            throw new JSONException("null not match, " + this.type);
        }
    }

    @Override
    public boolean readIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public long readTypeHashCode() {
        int type;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        this.strtype = bytes[offset];
        byte strtype = this.strtype;
        if (strtype == 121 && (type = bytes[++offset]) > 8 && type <= 63) {
            int typelen;
            if (type <= 47) {
                ++offset;
                typelen = type;
            } else {
                typelen = (type - 56 << 8) + (bytes[offset + 1] & 0xFF);
                offset += 2;
            }
            int strBegin = offset;
            long hashCode = -3750763034362895579L;
            for (int i = 0; i < typelen; ++i) {
                hashCode ^= (long)bytes[offset++];
                hashCode *= 1099511628211L;
            }
            byte symbol = bytes[offset];
            if (symbol >= 0 && symbol <= 47) {
                ++offset;
                if (symbol == 0) {
                    this.symbol0Begin = strBegin;
                    this.symbol0Length = typelen;
                    this.symbol0StrType = strtype;
                    this.symbol0Hash = hashCode;
                } else {
                    int minCapacity = symbol * 2 + 2;
                    if (this.symbols == null) {
                        this.symbols = new long[Math.max(minCapacity, 32)];
                    } else if (this.symbols.length < minCapacity) {
                        this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
                    }
                    this.symbols[symbol * 2 + 1] = ((long)strBegin << 32) + ((long)typelen << 8) + (long)strtype;
                }
                this.strBegin = strBegin;
                this.strlen = typelen;
                this.offset = offset;
                return hashCode;
            }
        }
        return this.readTypeHashCode0();
    }

    public long readTypeHashCode0() {
        int symbol;
        byte c1;
        byte c0;
        long hashCode;
        byte[] bytes = this.bytes;
        this.strtype = bytes[this.offset];
        byte strtype = this.strtype;
        if (strtype == 127) {
            ++this.offset;
            this.strtype = bytes[this.offset];
            strtype = this.strtype;
            if (strtype >= -16 && strtype <= 72) {
                int symbol2;
                if (strtype <= 47) {
                    ++this.offset;
                    symbol2 = strtype;
                } else {
                    symbol2 = this.readInt32Value();
                }
                if (symbol2 < 0) {
                    return this.symbolTable.getHashCode(-symbol2);
                }
                if (symbol2 == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    if (this.symbol0Hash == 0L) {
                        this.symbol0Hash = this.getNameHashCode();
                    }
                    return this.symbol0Hash;
                }
                int index = symbol2 * 2;
                long strInfo = this.symbols[index + 1];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                long nameHashCode = this.symbols[index];
                if (nameHashCode == 0L) {
                    this.symbols[index] = nameHashCode = this.getNameHashCode();
                }
                return nameHashCode;
            }
        }
        if (strtype >= -16 && strtype <= 72) {
            long refTypeHash;
            int typeIndex;
            if (strtype <= 47) {
                ++this.offset;
                typeIndex = strtype;
            } else if (strtype <= 63) {
                ++this.offset;
                typeIndex = (strtype - 56 << 8) + (bytes[this.offset++] & 0xFF);
            } else {
                typeIndex = this.readInt32Value();
            }
            if (typeIndex == 0) {
                this.strtype = this.symbol0StrType;
                this.strlen = this.symbol0Length;
                this.strBegin = this.symbol0Begin;
                if (this.symbol0Hash == 0L) {
                    this.symbol0Hash = Fnv.hashCode64(this.getString());
                }
                refTypeHash = this.symbol0Hash;
            } else if (typeIndex < 0) {
                this.strlen = strtype;
                refTypeHash = this.symbolTable.getHashCode(-typeIndex);
            } else {
                refTypeHash = this.symbols[typeIndex * 2];
                if (refTypeHash == 0L) {
                    long strInfo = this.symbols[typeIndex * 2 + 1];
                    this.strtype = (byte)strInfo;
                    this.strlen = (int)strInfo >> 8;
                    this.strBegin = (int)(strInfo >> 32);
                    refTypeHash = Fnv.hashCode64(this.getString());
                }
            }
            if (refTypeHash == -1L) {
                throw JSONReaderJSONB.typeRefNotFound(typeIndex);
            }
            return refTypeHash;
        }
        ++this.offset;
        this.strBegin = this.offset;
        if (strtype >= 73 && strtype <= 120) {
            this.strlen = strtype - 73;
        } else if (strtype == 121 || strtype == 122 || strtype == 123 || strtype == 124 || strtype == 125) {
            int type = bytes[this.offset];
            if (type >= -16 && type <= 47) {
                ++this.offset;
                this.strlen = type;
            } else if (type >= 48 && type <= 63) {
                ++this.offset;
                this.strlen = (type - 56 << 8) + (bytes[this.offset++] & 0xFF);
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
        } else {
            throw this.readStringError();
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            c = JSONReaderUTF8.char2_utf8(c, bytes[this.offset + 1], this.offset);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            c = JSONReaderUTF8.char2_utf8(c, bytes[this.offset + 1], bytes[this.offset + 2], this.offset);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (strtype == 123 || strtype == 125) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                c0 = bytes[this.offset + i];
                c1 = bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (strtype == 124) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                c0 = bytes[this.offset + i];
                c1 = bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            int i;
            long nameValue = 0L;
            if (this.strlen <= 8) {
                int start = this.offset;
                for (i = 0; i < this.strlen; ++i) {
                    byte c = bytes[this.offset];
                    if (c < 0 || c == 0 && bytes[start] == 0) {
                        nameValue = 0L;
                        this.offset = start;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++this.offset;
                }
            }
            if (nameValue != 0L) {
                hashCode = nameValue;
            } else {
                hashCode = -3750763034362895579L;
                for (i = 0; i < this.strlen; ++i) {
                    byte c = bytes[this.offset++];
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
            }
        }
        this.type = bytes[this.offset];
        if (this.type >= -16 && this.type <= 47) {
            symbol = this.type;
            ++this.offset;
        } else {
            symbol = this.readInt32Value();
        }
        if (symbol == 0) {
            this.symbol0Begin = this.strBegin;
            this.symbol0Length = this.strlen;
            this.symbol0StrType = strtype;
            this.symbol0Hash = hashCode;
        } else {
            long strInfo;
            int minCapacity = symbol * 2 + 2;
            if (this.symbols == null) {
                this.symbols = new long[Math.max(minCapacity, 32)];
            } else if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
            }
            this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)strtype;
        }
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        long hashCode;
        byte[] bytes = this.bytes;
        byte strtype = this.strtype = bytes[this.offset++];
        this.strBegin = this.offset;
        if (strtype >= 73 && strtype <= 120) {
            this.strlen = strtype - 73;
        } else if (strtype == 121 || strtype == 122 || strtype == 123 || strtype == 124 || strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else if (strtype == 127) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            throw this.readStringError();
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            c = JSONReaderUTF8.char2_utf8(c, bytes[this.offset + 1], this.offset);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            c = JSONReaderUTF8.char2_utf8(c, bytes[this.offset + 1], bytes[this.offset + 2], this.offset);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (strtype == 123) {
            int offset = this.offset;
            hashCode = -3750763034362895579L;
            if (bytes[offset] == -2 && bytes[offset + 1] == -1) {
                if (this.strlen <= 16) {
                    long nameValue = 0L;
                    block45: for (int i = 2; i < this.strlen; i += 2) {
                        byte c1 = bytes[offset + i + 1];
                        byte c0 = bytes[offset + i];
                        char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                        if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                            nameValue = 0L;
                            break;
                        }
                        byte c = (byte)ch;
                        switch (i - 2 >> 1) {
                            case 0: {
                                nameValue = c;
                                continue block45;
                            }
                            case 1: {
                                nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                                continue block45;
                            }
                            case 2: {
                                nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                                continue block45;
                            }
                            case 3: {
                                nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                                continue block45;
                            }
                            case 4: {
                                nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                                continue block45;
                            }
                            case 5: {
                                nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                                continue block45;
                            }
                            case 6: {
                                nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                                continue block45;
                            }
                            case 7: {
                                nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                                continue block45;
                            }
                        }
                    }
                    if (nameValue != 0L) {
                        return nameValue;
                    }
                }
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c0 = bytes[offset + i];
                    byte c1 = bytes[offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else if (bytes[offset] == -1 && bytes[offset + 1] == -2) {
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c1 = bytes[offset + i];
                    byte c0 = bytes[offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else {
                for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = bytes[offset + i];
                    byte c1 = bytes[offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            }
        } else if (strtype == 125) {
            int offset = this.offset;
            if (this.strlen <= 16) {
                long nameValue = 0L;
                block49: for (int i = 0; i < this.strlen; i += 2) {
                    byte c1 = bytes[offset + i + 1];
                    byte c0 = bytes[offset + i];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                        nameValue = 0L;
                        break;
                    }
                    byte c = (byte)ch;
                    switch (i >> 1) {
                        case 0: {
                            nameValue = c;
                            continue block49;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            continue block49;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            continue block49;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            continue block49;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            continue block49;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            continue block49;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            continue block49;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            continue block49;
                        }
                    }
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = bytes[offset + i];
                byte c1 = bytes[offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (strtype == 124) {
            int offset = this.offset;
            if (this.strlen <= 16) {
                long nameValue = 0L;
                block51: for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = bytes[offset + i];
                    byte c1 = bytes[offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                        nameValue = 0L;
                        break;
                    }
                    byte c = (byte)ch;
                    switch (i >> 1) {
                        case 0: {
                            nameValue = c;
                            continue block51;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            continue block51;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            continue block51;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            continue block51;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            continue block51;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            continue block51;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            continue block51;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            continue block51;
                        }
                    }
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = bytes[offset + i];
                byte c1 = bytes[offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            if (this.strlen <= 8) {
                long nameValue = 0L;
                int start = this.offset;
                for (int i = 0; i < this.strlen; ++i) {
                    byte c = bytes[this.offset];
                    if (c < 0 || c == 0 && bytes[start] == 0) {
                        nameValue = 0L;
                        this.offset = start;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++this.offset;
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; ++i) {
                byte c = bytes[this.offset++];
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        }
        return hashCode;
    }

    protected final long getNameHashCode() {
        byte c;
        int offset = this.strBegin;
        long nameValue = 0L;
        int i = 0;
        while (i < this.strlen) {
            c = this.bytes[offset];
            if (c < 0 || i >= 8 || i == 0 && this.bytes[this.strBegin] == 0) {
                offset = this.strBegin;
                nameValue = 0L;
                break;
            }
            switch (i) {
                case 0: {
                    nameValue = c;
                    break;
                }
                case 1: {
                    nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
            ++offset;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        for (i = 0; i < this.strlen; ++i) {
            c = this.bytes[offset++];
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        byte c;
        int offset = this.strBegin;
        long nameValue = 0L;
        int i = 0;
        while (i < this.strlen) {
            byte c1;
            c = this.bytes[offset];
            if (c < 0 || i >= 8 || i == 0 && this.bytes[this.strBegin] == 0) {
                offset = this.strBegin;
                nameValue = 0L;
                break;
            }
            if (c != 95 && c != 45 && c != 32 || (c1 = this.bytes[offset + 1]) == c) {
                if (c >= 65 && c <= 90) {
                    c = (byte)(c + 32);
                }
                switch (i) {
                    case 0: {
                        nameValue = c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++i;
            }
            ++offset;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        for (i = 0; i < this.strlen; ++i) {
            if ((c = this.bytes[offset++]) >= 65 && c <= 90) {
                c = (byte)(c + 32);
            }
            if (c == 95 || c == 45 || c == 32) continue;
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public void skipValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -108: 
            case -81: 
            case -80: 
            case -79: 
            case 73: {
                return;
            }
            case -67: {
                ++this.offset;
                return;
            }
            case -68: {
                this.offset += 2;
                return;
            }
            case -87: 
            case -84: 
            case -83: 
            case -73: 
            case -65: 
            case 72: {
                this.offset += 4;
                return;
            }
            case -74: {
                this.readInt32Value();
                return;
            }
            case -85: 
            case -75: 
            case -66: {
                this.offset += 8;
                return;
            }
            case -76: {
                this.readInt64Value();
                return;
            }
            case -71: {
                this.readInt32Value();
                this.readBigInteger();
                return;
            }
            case -72: {
                this.readInt64Value();
                return;
            }
            case -89: {
                this.offset += 3;
                this.readInt32Value();
                return;
            }
            case -88: {
                this.offset += 7;
                this.readInt32Value();
                return;
            }
            case -86: {
                this.offset += 7;
                this.readInt32Value();
                this.readString();
                return;
            }
            case -111: {
                int byteslen = this.readInt32Value();
                this.offset += byteslen;
                return;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                int strlen = this.readInt32Value();
                this.offset += strlen;
                return;
            }
            case -110: {
                this.readTypeHashCode();
                this.skipValue();
                return;
            }
            case -90: {
                while (true) {
                    int len;
                    byte b;
                    if ((b = this.bytes[this.offset]) == -91) {
                        ++this.offset;
                        break;
                    }
                    byte size = FIXED_TYPE_SIZE[b & 0xFF];
                    if (size > 0) {
                        this.offset += size;
                    } else if (size == -1) {
                        ++this.offset;
                        len = this.readInt32Value();
                        this.offset += len;
                    } else {
                        this.skipName();
                    }
                    b = this.bytes[this.offset];
                    size = FIXED_TYPE_SIZE[b & 0xFF];
                    if (size > 0) {
                        this.offset += size;
                        continue;
                    }
                    if (size == -1) {
                        ++this.offset;
                        len = this.readInt32Value();
                        this.offset += len;
                        continue;
                    }
                    this.skipValue();
                }
                return;
            }
            case -109: {
                if (this.isString()) {
                    this.skipName();
                    return;
                }
                throw new JSONException("skip not support type " + JSONB.typeName(type));
            }
        }
        if (type >= -16 && type <= 47) {
            return;
        }
        if (type >= -40 && type <= -17) {
            return;
        }
        if (type >= 48 && type <= 63) {
            ++this.offset;
            return;
        }
        if (type >= 64 && type <= 71) {
            this.offset += 2;
            return;
        }
        if (type >= 73 && type <= 120) {
            this.offset += type - 73;
            return;
        }
        if (type >= -56 && type <= -41) {
            ++this.offset;
            return;
        }
        if (type >= -64 && type <= -57) {
            this.offset += 2;
            return;
        }
        if (type >= -108 && type <= -92) {
            int itemCnt = type == -92 ? this.readInt32Value() : type - -108;
            for (int i = 0; i < itemCnt; ++i) {
                byte size = FIXED_TYPE_SIZE[this.bytes[this.offset] & 0xFF];
                if (size > 0) {
                    this.offset += size;
                    continue;
                }
                if (size == -1) {
                    ++this.offset;
                    int len = this.readInt32Value();
                    this.offset += len;
                    continue;
                }
                this.skipValue();
            }
            return;
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    public boolean skipName() {
        this.strtype = this.bytes[this.offset++];
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.offset += this.strtype - 73;
            return true;
        }
        if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.offset += this.strlen;
            return true;
        }
        if (this.strtype == 127) {
            byte type = this.bytes[this.offset];
            if (type >= -16 && type <= 72) {
                this.readInt32Value();
                return true;
            }
            this.readString();
            this.readInt32Value();
            return true;
        }
        throw JSONReaderJSONB.notSupportType(this.strtype);
    }

    private static JSONException notSupportType(byte type) {
        return new JSONException("name not support input : " + JSONB.typeName(type));
    }

    private JSONException notSupportString() {
        throw new JSONException("readString not support type " + JSONB.typeName(this.strtype) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    private JSONException readInt32ValueError(byte type) {
        throw new JSONException("readInt32Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    private JSONException readInt64ValueError(byte type) {
        throw new JSONException("readInt64Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    private JSONException readStringError() {
        throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + this.bytes.length);
    }

    static JSONException typeRefNotFound(int typeIndex) {
        throw new JSONException("type ref not found : " + typeIndex);
    }

    @Override
    public String readFieldName() {
        Charset charset;
        boolean typeSymbol;
        byte[] bytes = this.bytes;
        this.strtype = bytes[this.offset];
        if (this.strtype == -81) {
            ++this.offset;
            return null;
        }
        ++this.offset;
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol = this.readInt32Value();
                if (symbol < 0) {
                    return this.symbolTable.getName(-symbol);
                }
                if (symbol == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    return this.getString();
                }
                int index = symbol * 2 + 1;
                long strInfo = this.symbols[index];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                return this.getString();
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        String str = null;
        if (this.strtype >= 73 && this.strtype <= 121) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            if (this.strtype == 121) {
                this.strlen = this.readLength();
                this.strBegin = this.offset;
            } else {
                this.strlen = this.strtype - 73;
                if (JDKUtils.BIG_ENDIAN) {
                    switch (this.strlen) {
                        case 1: {
                            nameValue0 = (long)bytes[this.offset] & 0xFFL;
                            break;
                        }
                        case 2: {
                            nameValue0 = (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 3: {
                            nameValue0 = (long)(bytes[this.offset + 2] << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 4: {
                            nameValue0 = JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset);
                            break;
                        }
                        case 5: {
                            nameValue0 = ((long)bytes[this.offset + 4] << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue0 = ((long)bytes[this.offset + 5] << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue0 = ((long)bytes[this.offset + 6] << 48) + (((long)bytes[this.offset + 5] & 0xFFL) << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 8: {
                            nameValue0 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset);
                            break;
                        }
                        case 9: {
                            nameValue0 = bytes[this.offset];
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 1L);
                            break;
                        }
                        case 10: {
                            nameValue0 = JDKUtils.UNSAFE.getShort(bytes, BASE + (long)this.offset);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 2L);
                            break;
                        }
                        case 11: {
                            nameValue0 = (long)(bytes[this.offset] << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset + 2] & 0xFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 3L);
                            break;
                        }
                        case 12: {
                            nameValue0 = JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 4L);
                            break;
                        }
                        case 13: {
                            nameValue0 = ((long)bytes[this.offset + 4] << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 5L);
                            break;
                        }
                        case 14: {
                            nameValue0 = ((long)bytes[this.offset + 5] << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 6L);
                            break;
                        }
                        case 15: {
                            nameValue0 = ((long)bytes[this.offset + 6] << 48) + (((long)bytes[this.offset + 5] & 0xFFL) << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 7L);
                            break;
                        }
                        case 16: {
                            nameValue0 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset);
                            nameValue1 = JDKUtils.UNSAFE.getLong(bytes, BASE + (long)this.offset + 8L);
                            break;
                        }
                    }
                } else {
                    switch (this.strlen) {
                        case 3: {
                            nameValue0 = (long)(bytes[this.offset + 2] << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 4: {
                            nameValue0 = (long)(bytes[this.offset + 3] << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 5: {
                            nameValue0 = ((long)bytes[this.offset + 4] << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 6: {
                            nameValue0 = ((long)bytes[this.offset + 5] << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 7: {
                            nameValue0 = ((long)bytes[this.offset + 6] << 48) + (((long)bytes[this.offset + 5] & 0xFFL) << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + (((long)bytes[this.offset + 4] & 0xFFL) << 24) + (((long)bytes[this.offset + 3] & 0xFFL) << 16) + (((long)bytes[this.offset + 2] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 8: {
                            nameValue0 = ((long)bytes[this.offset + 7] << 56) + (((long)bytes[this.offset + 6] & 0xFFL) << 48) + (((long)bytes[this.offset + 5] & 0xFFL) << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 9: {
                            nameValue0 = bytes[this.offset];
                            nameValue1 = ((long)bytes[this.offset + 8] << 56) + (long)(bytes[this.offset + 7] << 48) + (((long)bytes[this.offset + 6] & 0xFFL) << 40) + (((long)bytes[this.offset + 5] & 0xFFL) << 32) + (((long)bytes[this.offset + 4] & 0xFFL) << 24) + (((long)bytes[this.offset + 3] & 0xFFL) << 16) + (((long)bytes[this.offset + 2] & 0xFFL) << 8) + ((long)bytes[this.offset + 1] & 0xFFL);
                            break;
                        }
                        case 10: {
                            nameValue0 = (long)(bytes[this.offset + 1] << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 9] << 56) + (((long)bytes[this.offset + 8] & 0xFFL) << 48) + (((long)bytes[this.offset + 7] & 0xFFL) << 40) + (((long)bytes[this.offset + 6] & 0xFFL) << 32) + (((long)bytes[this.offset + 5] & 0xFFL) << 24) + (((long)bytes[this.offset + 4] & 0xFFL) << 16) + (((long)bytes[this.offset + 3] & 0xFFL) << 8) + ((long)bytes[this.offset + 2] & 0xFFL);
                            break;
                        }
                        case 11: {
                            nameValue0 = (long)(bytes[this.offset + 2] << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 10] << 56) + (((long)bytes[this.offset + 9] & 0xFFL) << 48) + (((long)bytes[this.offset + 8] & 0xFFL) << 40) + (((long)bytes[this.offset + 7] & 0xFFL) << 32) + (((long)bytes[this.offset + 6] & 0xFFL) << 24) + (((long)bytes[this.offset + 5] & 0xFFL) << 16) + (((long)bytes[this.offset + 4] & 0xFFL) << 8) + ((long)bytes[this.offset + 3] & 0xFFL);
                            break;
                        }
                        case 12: {
                            nameValue0 = (long)(bytes[this.offset + 3] << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 11] << 56) + (((long)bytes[this.offset + 10] & 0xFFL) << 48) + (((long)bytes[this.offset + 9] & 0xFFL) << 40) + (((long)bytes[this.offset + 8] & 0xFFL) << 32) + (((long)bytes[this.offset + 7] & 0xFFL) << 24) + (((long)bytes[this.offset + 6] & 0xFFL) << 16) + (((long)bytes[this.offset + 5] & 0xFFL) << 8) + ((long)bytes[this.offset + 4] & 0xFFL);
                            break;
                        }
                        case 13: {
                            nameValue0 = ((long)bytes[this.offset + 4] << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 12] << 56) + (((long)bytes[this.offset + 11] & 0xFFL) << 48) + (((long)bytes[this.offset + 10] & 0xFFL) << 40) + (((long)bytes[this.offset + 9] & 0xFFL) << 32) + (((long)bytes[this.offset + 8] & 0xFFL) << 24) + (((long)bytes[this.offset + 7] & 0xFFL) << 16) + (((long)bytes[this.offset + 6] & 0xFFL) << 8) + ((long)bytes[this.offset + 5] & 0xFFL);
                            break;
                        }
                        case 14: {
                            nameValue0 = ((long)bytes[this.offset + 5] << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 13] << 56) + (((long)bytes[this.offset + 12] & 0xFFL) << 48) + (((long)bytes[this.offset + 11] & 0xFFL) << 40) + (((long)bytes[this.offset + 10] & 0xFFL) << 32) + (((long)bytes[this.offset + 9] & 0xFFL) << 24) + (((long)bytes[this.offset + 8] & 0xFFL) << 16) + (((long)bytes[this.offset + 7] & 0xFFL) << 8) + ((long)bytes[this.offset + 6] & 0xFFL);
                            break;
                        }
                        case 15: {
                            nameValue0 = ((long)bytes[this.offset + 6] << 48) + (((long)bytes[this.offset + 5] & 0xFFL) << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 14] << 56) + (((long)bytes[this.offset + 13] & 0xFFL) << 48) + (((long)bytes[this.offset + 12] & 0xFFL) << 40) + (((long)bytes[this.offset + 11] & 0xFFL) << 32) + (((long)bytes[this.offset + 10] & 0xFFL) << 24) + (((long)bytes[this.offset + 9] & 0xFFL) << 16) + (((long)bytes[this.offset + 8] & 0xFFL) << 8) + ((long)bytes[this.offset + 7] & 0xFFL);
                            break;
                        }
                        case 16: {
                            nameValue0 = ((long)bytes[this.offset + 7] << 56) + (long)(bytes[this.offset + 6] << 48) + (((long)bytes[this.offset + 5] & 0xFFL) << 40) + (((long)bytes[this.offset + 4] & 0xFFL) << 32) + (((long)bytes[this.offset + 3] & 0xFFL) << 24) + (((long)bytes[this.offset + 2] & 0xFFL) << 16) + (((long)bytes[this.offset + 1] & 0xFFL) << 8) + ((long)bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)bytes[this.offset + 15] << 56) + (((long)bytes[this.offset + 14] & 0xFFL) << 48) + (((long)bytes[this.offset + 13] & 0xFFL) << 40) + (((long)bytes[this.offset + 12] & 0xFFL) << 32) + (((long)bytes[this.offset + 11] & 0xFFL) << 24) + (((long)bytes[this.offset + 10] & 0xFFL) << 16) + (((long)bytes[this.offset + 9] & 0xFFL) << 8) + ((long)bytes[this.offset + 8] & 0xFFL);
                            break;
                        }
                    }
                }
            }
            if (bytes[this.offset + this.strlen - 1] > 0 && nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    long nameValue01 = nameValue0 ^ nameValue1;
                    int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        str = this.getLatin1String(this.offset, this.strlen);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(str, nameValue0, nameValue1);
                        this.offset += this.strlen;
                    } else if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        this.offset += this.strlen;
                        str = entry.name;
                    }
                } else {
                    int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                    NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        str = this.getLatin1String(this.offset, this.strlen);
                        JSONFactory.NAME_CACHE[indexMask] = new NameCacheEntry(str, nameValue0);
                        this.offset += this.strlen;
                    } else if (entry.value == nameValue0) {
                        this.offset += this.strlen;
                        str = entry.name;
                    }
                }
            }
            charset = StandardCharsets.ISO_8859_1;
        } else if (this.strtype == 122) {
            int type = bytes[this.offset];
            if (type >= -16 && type <= 47) {
                this.strlen = type;
                ++this.offset;
            } else if (type >= 48 && type <= 63) {
                this.strlen = (type - 56 << 8) + (bytes[this.offset + 1] & 0xFF);
                this.offset += 2;
            } else if (type >= 64 && type <= 71) {
                this.strlen = JSONReaderJSONB.getInt3(bytes, this.offset + 1, type);
                this.offset += 3;
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16BE;
        } else if (this.strtype == 126) {
            this.strlen = this.readLength();
            if (GB18030 == null) {
                GB18030 = Charset.forName("GB18030");
            }
            charset = GB18030;
        } else {
            charset = StandardCharsets.UTF_8;
        }
        if (this.strlen < 0) {
            str = this.symbolTable.getName(-this.strlen);
        }
        if (str == null) {
            if (charset == StandardCharsets.ISO_8859_1 && JDKUtils.ANDROID_SDK_INT < 34) {
                char[] charBuf = this.charBuf;
                int strlen = this.strlen;
                if (charBuf == null) {
                    this.charBuf = charBuf = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                }
                if (charBuf == null || charBuf.length < strlen) {
                    this.charBuf = charBuf = new char[strlen];
                }
                for (int i = 0; i < strlen; ++i) {
                    charBuf[i] = (char)(bytes[this.offset + i] & 0xFF);
                }
                str = new String(charBuf, 0, strlen);
            }
            if (str == null) {
                str = new String(bytes, this.offset, this.strlen, charset);
            }
            this.offset += this.strlen;
        }
        if (typeSymbol) {
            int symbol = this.readInt32Value();
            if (symbol == 0) {
                this.symbol0Begin = this.strBegin;
                this.symbol0Length = this.strlen;
                this.symbol0StrType = this.strtype;
            } else {
                long strInfo;
                if (this.symbols == null) {
                    this.symbols = new long[symbol * 2 + 2 < 32 ? 32 : symbol * 2 + 2];
                } else if (this.symbols.length < symbol * 2 + 2) {
                    this.symbols = Arrays.copyOf(this.symbols, this.symbols.length + 16);
                }
                this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
            }
        }
        return str;
    }

    @Override
    public String getFieldName() {
        return this.getString();
    }

    @Override
    public String readString() {
        byte strtype;
        if ((strtype = (this.strtype = this.bytes[this.offset++])) == -81) {
            return null;
        }
        this.strBegin = this.offset;
        if (strtype >= 73 && strtype <= 121) {
            String str;
            int strlen;
            if (strtype == 121) {
                int strType = this.bytes[this.offset];
                if (strType >= -16 && strType <= 47) {
                    ++this.offset;
                    strlen = strType;
                } else if (strType >= 48 && strType <= 63) {
                    strlen = (strType - 56 << 8) + (this.bytes[this.offset + 1] & 0xFF);
                    this.offset += 2;
                } else if (strType >= 64 && strType <= 71) {
                    strlen = JSONReaderJSONB.getInt3(this.bytes, this.offset + 1, strType);
                    this.offset += 3;
                } else {
                    strlen = this.readLength();
                }
                this.strBegin = this.offset;
            } else {
                strlen = strtype - 73;
            }
            if (strlen < 0) {
                return this.symbolTable.getName(-strlen);
            }
            this.strlen = strlen;
            if (JDKUtils.ANDROID_SDK_INT < 34) {
                char[] charBuf = this.charBuf;
                if (charBuf == null) {
                    this.charBuf = charBuf = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                }
                if (charBuf == null || charBuf.length < strlen) {
                    this.charBuf = charBuf = new char[strlen];
                }
                for (int i = 0; i < strlen; ++i) {
                    charBuf[i] = (char)(this.bytes[this.offset + i] & 0xFF);
                }
                str = new String(charBuf, 0, strlen);
            } else {
                str = new String(this.bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
            }
            this.offset += strlen;
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                str = null;
            }
            return str;
        }
        return this.readStringNonAscii();
    }

    private String readStringNonAscii() {
        Charset charset;
        String str = null;
        if (this.strtype == 122) {
            int type = this.bytes[this.offset];
            if (type >= -16 && type <= 47) {
                this.strlen = type;
                ++this.offset;
            } else if (type >= 48 && type <= 63) {
                this.strlen = (type - 56 << 8) + (this.bytes[this.offset + 1] & 0xFF);
                this.offset += 2;
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = StandardCharsets.UTF_16;
        } else if (this.strtype == 124) {
            str = this.readUTF16LE();
            charset = StandardCharsets.UTF_16LE;
        } else if (this.strtype == 125) {
            str = this.readUTF16BE();
            if (str != null) {
                return str;
            }
            charset = StandardCharsets.UTF_16BE;
        } else if (this.strtype == 126) {
            this.readGB18030();
            charset = GB18030;
        } else {
            return this.readStringTypeNotMatch();
        }
        if (str != null) {
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            return str;
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        str = new String(this.bytes, this.offset, this.strlen, charset);
        this.offset += this.strlen;
        if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
            str = str.trim();
        }
        if (this.strlen == 0 && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
            str = null;
        }
        return str;
    }

    private String readGB18030() {
        this.strlen = this.readLength();
        this.strBegin = this.offset;
        if (GB18030 == null) {
            GB18030 = Charset.forName("GB18030");
        }
        return null;
    }

    private String readUTF16BE() {
        this.strlen = this.readLength();
        this.strBegin = this.offset;
        return null;
    }

    private String readUTF16LE() {
        int strType = this.bytes[this.offset];
        if (strType >= -16 && strType <= 47) {
            ++this.offset;
            this.strlen = strType;
        } else if (strType >= 48 && strType <= 63) {
            ++this.offset;
            this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        } else {
            this.strlen = this.readLength();
        }
        this.strBegin = this.offset;
        if (this.strlen == 0) {
            return "";
        }
        return null;
    }

    private String readStringUTF8() {
        int strType = this.bytes[this.offset];
        if (strType >= -16 && strType <= 47) {
            ++this.offset;
            this.strlen = strType;
        } else if (strType >= 48 && strType <= 63) {
            ++this.offset;
            this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        } else {
            this.strlen = this.readLength();
        }
        this.strBegin = this.offset;
        return null;
    }

    private String readStringTypeNotMatch() {
        if (this.strtype >= -16 && this.strtype <= 47) {
            return Byte.toString(this.strtype);
        }
        if (this.strtype >= 48 && this.strtype <= 63) {
            int intValue = (this.strtype - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return Integer.toString(intValue);
        }
        if (this.strtype >= 64 && this.strtype <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, this.strtype);
            this.offset += 2;
            return Integer.toString(int3);
        }
        if (this.strtype >= -40 && this.strtype <= -17) {
            int intValue = -8 + (this.strtype - -40);
            return Integer.toString(intValue);
        }
        if (this.strtype >= -56 && this.strtype <= -41) {
            int intValue = (this.strtype - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return Integer.toString(intValue);
        }
        if (this.strtype >= -64 && this.strtype <= -57) {
            int intValue = (this.strtype - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return Integer.toString(intValue);
        }
        switch (this.strtype) {
            case -81: {
                return null;
            }
            case -78: {
                return "0.0";
            }
            case -77: {
                return "1.0";
            }
            case -65: 
            case 72: {
                long int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Long.toString(int32Value);
            }
            case -74: {
                return Float.toString(this.readInt32Value());
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return Float.toString(floatValue);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
                return Double.toString(doubleValue);
            }
            case -84: {
                long seconds = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                long millis = seconds * 1000L;
                return DateUtils.toString(millis, false, DateUtils.DEFAULT_ZONE_ID);
            }
            case -83: {
                long minutes = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                long millis = minutes * 60L * 1000L;
                return DateUtils.toString(millis, false, DateUtils.DEFAULT_ZONE_ID);
            }
            case -85: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return DateUtils.toString(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis), false, DateUtils.DEFAULT_ZONE_ID);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                if (!JDKUtils.BIG_ENDIAN) {
                    int64Value = Long.reverseBytes(int64Value);
                }
                this.offset += 8;
                return Long.toString(int64Value);
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes).toString();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.toString();
            }
            case -110: {
                --this.offset;
                Object typedAny = this.readAny();
                return typedAny == null ? null : JSON.toJSONString(typedAny, JSONWriter.Feature.WriteThrowableClassName);
            }
            case -72: 
            case -70: {
                return Long.toString(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return Double.toString(doubleValue);
            }
        }
        throw this.notSupportString();
    }

    @Override
    public String[] readStringArray() {
        long typeHash;
        if (this.nextIfMatch((byte)-110) && (typeHash = this.readTypeHashCode()) != ObjectReaderImplStringArray.HASH_TYPE) {
            throw new JSONException(this.info("not support type " + this.getString()));
        }
        int entryCnt = this.startArray();
        if (entryCnt == -1) {
            return null;
        }
        String[] array = new String[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = this.readString();
        }
        return array;
    }

    @Override
    public char readCharValue() {
        byte type = this.bytes[this.offset];
        if (type == -112) {
            ++this.offset;
            return (char)this.readInt32Value();
        }
        if (type == 73) {
            ++this.offset;
            return '\u0000';
        }
        if (type > 73 && type < 120) {
            ++this.offset;
            return (char)(this.bytes[this.offset++] & 0xFF);
        }
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            return '\u0000';
        }
        return str.charAt(0);
    }

    @Override
    public long[] readInt64ValueArray() {
        long typeHash;
        if (this.nextIfMatch((byte)-110) && (typeHash = this.readTypeHashCode()) != ObjectReaderImplInt64ValueArray.HASH_TYPE && typeHash != ObjectReaderImplInt64Array.HASH_TYPE && typeHash != ObjectReaderImplInt32Array.HASH_TYPE && typeHash != ObjectReaderImplInt32ValueArray.HASH_TYPE) {
            throw new JSONException(this.info("not support " + this.getString()));
        }
        int entryCnt = this.startArray();
        if (entryCnt == -1) {
            return null;
        }
        long[] array = new long[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = this.readInt64Value();
        }
        return array;
    }

    @Override
    public long readInt64Value() {
        long int64Value;
        byte type;
        this.wasNull = false;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((type = bytes[offset++]) >= -40 && type <= -17) {
            int64Value = -8 + (type - -40);
        } else if (type >= -56 && type <= -41) {
            int64Value = (type - -48 << 8) + (bytes[offset] & 0xFF);
            ++offset;
        } else if (type >= -64 && type <= -57) {
            int64Value = (type - -60 << 16) + ((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF);
            offset += 2;
        } else if (type == -65) {
            int64Value = JSONReaderJSONB.getInt(bytes, offset);
            offset += 4;
        } else if (type == -66) {
            int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            if (!JDKUtils.BIG_ENDIAN) {
                int64Value = Long.reverseBytes(int64Value);
            }
            offset += 8;
        } else {
            this.offset = offset;
            return this.readInt64Value0(bytes, type);
        }
        this.offset = offset;
        return int64Value;
    }

    private long readInt64Value0(byte[] bytes, byte type) {
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0L;
            }
            case -80: 
            case -78: {
                return 0L;
            }
            case -79: 
            case -77: {
                return 1L;
            }
            case -67: {
                return bytes[this.offset++];
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case 72: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (long)floatValue;
            }
            case -75: {
                --this.offset;
                return (long)this.readDoubleValue();
            }
            case -74: {
                return (long)((float)this.readInt32Value());
            }
            case -76: {
                return (long)((double)this.readInt64Value());
            }
            case -83: {
                long minutes = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                return minutes * 60L * 1000L;
            }
            case -84: {
                long seconds = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                return seconds * 1000L;
            }
            case -85: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.longValue();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = this.getLatin1String(this.offset, strlen);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).longValue();
            }
            return TypeUtils.toBigDecimal(str).longValue();
        }
        throw new JSONException("readInt64Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + bytes.length);
    }

    @Override
    public int readInt32Value() {
        int int32Value;
        int type;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((type = bytes[offset++]) >= -16 && type <= 47) {
            int32Value = type;
        } else if (type >= 48 && type <= 63) {
            int32Value = (type - 56 << 8) + (bytes[offset] & 0xFF);
            ++offset;
        } else if (type >= 64 && type <= 71) {
            int32Value = JSONReaderJSONB.getInt3(bytes, offset, type);
            offset += 2;
        } else if (type == 72) {
            int32Value = JSONReaderJSONB.getInt(bytes, offset);
            offset += 4;
        } else {
            this.offset = offset;
            return this.readInt32Value0(bytes, (byte)type);
        }
        this.offset = offset;
        return int32Value;
    }

    private int readInt32Value0(byte[] bytes, byte type) {
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((bytes[this.offset++] & 0xFF) << 8) + (bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("int value not support input null"));
                }
                this.wasNull = true;
                return 0;
            }
            case -80: 
            case -78: {
                return 0;
            }
            case -79: 
            case -77: {
                return 1;
            }
            case -67: {
                return bytes[this.offset++];
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -76: {
                return (int)this.readInt64Value();
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return (int)(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -74: {
                return (int)((float)this.readInt32Value());
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (int)floatValue;
            }
            case -75: {
                --this.offset;
                return (int)this.readDoubleValue();
            }
            case -84: 
            case -83: 
            case -65: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = this.getLatin1String(this.offset, strlen);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return TypeUtils.toBigDecimal(str).intValue();
        }
        throw new JSONException("readInt32Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + bytes.length);
    }

    @Override
    public boolean isBinary() {
        return this.bytes[this.offset] == -111;
    }

    @Override
    public byte[] readBinary() {
        byte type;
        if ((type = this.bytes[this.offset++]) != -111) {
            throw JSONReaderJSONB.notSupportType(type);
        }
        int len = this.readLength();
        byte[] bytes = new byte[len];
        System.arraycopy(this.bytes, this.offset, bytes, 0, len);
        this.offset += len;
        return bytes;
    }

    @Override
    public Integer readInt32() {
        int int32Value;
        int type;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((type = bytes[offset++]) == -81) {
            this.offset = offset;
            return null;
        }
        if (type >= -16 && type <= 47) {
            int32Value = type;
        } else if (type >= 48 && type <= 63) {
            int32Value = (type - 56 << 8) + (bytes[offset] & 0xFF);
            ++offset;
        } else if (type >= 64 && type <= 71) {
            int32Value = (type - 68 << 16) + ((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF);
            offset += 2;
        } else if (type == 72) {
            int32Value = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            if (!JDKUtils.BIG_ENDIAN) {
                int32Value = Integer.reverseBytes(int32Value);
            }
            offset += 4;
        } else {
            this.offset = offset;
            return this.readInt32Value0(bytes, (byte)type);
        }
        this.offset = offset;
        return int32Value;
    }

    @Override
    public Long readInt64() {
        long int64Value;
        byte type;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((type = bytes[offset++]) == -81) {
            this.offset = offset;
            return null;
        }
        if (type >= -40 && type <= -17) {
            int64Value = -8 + (type - -40);
        } else if (type >= -56 && type <= -41) {
            int64Value = (type - -48 << 8) + (bytes[offset] & 0xFF);
            ++offset;
        } else if (type >= -64 && type <= -57) {
            int64Value = (type - -60 << 16) + ((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF);
            offset += 2;
        } else if (type == -65) {
            int int32Val = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            int64Value = JDKUtils.BIG_ENDIAN ? (long)int32Val : (long)Integer.reverseBytes(int32Val);
            offset += 4;
        } else if (type == -66) {
            int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            if (!JDKUtils.BIG_ENDIAN) {
                int64Value = Long.reverseBytes(int64Value);
            }
            offset += 8;
        } else {
            this.offset = offset;
            return this.readInt64Value0(bytes, type);
        }
        this.offset = offset;
        return int64Value;
    }

    @Override
    public float readFloatValue() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (bytes[offset] == -73) {
            int int32Val = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset + 1L);
            this.offset = offset + 5;
            return Float.intBitsToFloat(JDKUtils.BIG_ENDIAN ? int32Val : Integer.reverseBytes(int32Val));
        }
        return this.readFloat0();
    }

    private float readFloat0() {
        byte[] bytes = this.bytes;
        byte type = bytes[this.offset++];
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0.0f;
            }
            case -67: {
                return bytes[this.offset++];
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -65: 
            case 72: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return (float)Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -74: {
                return this.readInt32Value();
            }
            case -76: {
                return (float)((double)this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0f;
            }
            case -79: 
            case -77: {
                return 1.0f;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((bytes[this.offset++] & 0xFF) << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return TypeUtils.toBigDecimal(str).intValue();
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    public double readDoubleValue() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (bytes[offset] == -75) {
            long int64Value = ((long)bytes[offset + 8] & 0xFFL) + (((long)bytes[offset + 7] & 0xFFL) << 8) + (((long)bytes[offset + 6] & 0xFFL) << 16) + (((long)bytes[offset + 5] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 3] & 0xFFL) << 40) + (((long)bytes[offset + 2] & 0xFFL) << 48) + ((long)bytes[offset + 1] << 56);
            this.offset = offset + 9;
            return Double.longBitsToDouble(int64Value);
        }
        return this.readDoubleValue0();
    }

    private double readDoubleValue0() {
        byte[] bytes = this.bytes;
        byte type = bytes[this.offset++];
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0.0;
            }
            case -67: {
                return bytes[this.offset++];
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -65: 
            case 72: {
                int int32Value = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 4;
                return JDKUtils.BIG_ENDIAN ? (double)int32Value : (double)Integer.reverseBytes(int32Value);
            }
            case -73: {
                int int32Value = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 4;
                return Float.intBitsToFloat(JDKUtils.BIG_ENDIAN ? int32Value : Integer.reverseBytes(int32Value));
            }
            case -74: {
                return this.readInt32Value();
            }
            case -76: {
                return this.readInt64Value();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((bytes[this.offset++] & 0xFF) << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return TypeUtils.toBigDecimal(str).intValue();
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    protected void readNumber0() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public Number readNumber() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return (int)type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return (short)int16Value;
            }
            case 72: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -65: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return (long)int32Value;
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = this.getLatin1String(this.offset, strlen);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case -110: {
                String typeName = this.readString();
                throw new JSONException("not support input type : ".concat(typeName));
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            return TypeUtils.toBigDecimal(str);
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    public BigDecimal readBigDecimal() {
        BigDecimal decimal;
        byte type;
        byte[] bytes = this.bytes;
        if ((type = bytes[this.offset++]) == -71) {
            int scale = this.readInt32Value();
            if (bytes[this.offset] == -70) {
                ++this.offset;
                long unscaledLongValue = this.readInt64Value();
                decimal = BigDecimal.valueOf(unscaledLongValue, scale);
            } else if (bytes[this.offset] == 72) {
                decimal = BigDecimal.valueOf(JSONReaderJSONB.getInt(bytes, this.offset + 1), scale);
                this.offset += 5;
            } else if (bytes[this.offset] == -66) {
                long unscaledValue = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset + 1L);
                decimal = BigDecimal.valueOf(JDKUtils.BIG_ENDIAN ? unscaledValue : Long.reverseBytes(unscaledValue), scale);
                this.offset += 9;
            } else {
                BigInteger unscaledValue = this.readBigInteger();
                decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
            }
        } else {
            decimal = type == -72 ? BigDecimal.valueOf(this.readInt64Value()) : this.readDecimal0(type);
        }
        return decimal;
    }

    private BigDecimal readDecimal0(byte type) {
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigDecimal.ZERO;
            }
            case -79: 
            case -77: {
                return BigDecimal.ONE;
            }
            case -67: {
                return BigDecimal.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigDecimal.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return BigDecimal.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigDecimal.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigDecimal.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
                return BigDecimal.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return BigDecimal.valueOf(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -69: {
                BigInteger bigInt = this.readBigInteger();
                return new BigDecimal(bigInt);
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigDecimal.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
        }
        if (type >= -16 && type <= 47) {
            return BigDecimal.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return BigDecimal.valueOf(int3);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            return TypeUtils.toBigDecimal(str);
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    public BigInteger readBigInteger() {
        BigInteger bigInt;
        byte type;
        if ((type = this.bytes[this.offset++]) == -70) {
            bigInt = BigInteger.valueOf(this.readInt64Value());
        } else if (type == -69) {
            int len = this.readInt32Value();
            byte[] bytes = new byte[len];
            System.arraycopy(this.bytes, this.offset, bytes, 0, len);
            this.offset += len;
            bigInt = new BigInteger(bytes);
        } else {
            bigInt = this.readBigInteger0(type);
        }
        return bigInt;
    }

    private BigInteger readBigInteger0(byte type) {
        byte[] bytes = this.bytes;
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigInteger.ZERO;
            }
            case -79: 
            case -77: {
                return BigInteger.ONE;
            }
            case -67: {
                return BigInteger.valueOf(bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return BigInteger.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                return BigInteger.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigInteger.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = JSONReaderJSONB.getInt(bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigInteger.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
                return BigInteger.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return BigInteger.valueOf(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -111: {
                int len = this.readInt32Value();
                byte[] buf = new byte[len];
                System.arraycopy(this.bytes, this.offset, buf, 0, len);
                this.offset += len;
                return new BigInteger(buf);
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.toBigInteger();
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigInteger.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return TypeUtils.toBigDecimal(str).toBigInteger();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return TypeUtils.toBigDecimal(str).toBigInteger();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return TypeUtils.toBigDecimal(str).toBigInteger();
            }
        }
        if (type >= -16 && type <= 47) {
            return BigInteger.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(bytes, this.offset, type);
            this.offset += 2;
            return BigInteger.valueOf(int3);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((bytes[this.offset++] & 0xFF) << 8) + (bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.getLatin1String(this.offset, strlen);
            this.offset += strlen;
            return new BigInteger(str);
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    public LocalDate readLocalDate() {
        byte type = this.bytes[this.offset];
        if (type == -87) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            return LocalDate.of(year, month, (int)dayOfMonth);
        }
        if (type == -81) {
            ++this.offset;
            return null;
        }
        return this.readLocalDate0(type);
    }

    private LocalDate readLocalDate0(int type) {
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        if (type == 122 || type == 121) {
            this.strtype = (byte)type;
            ++this.offset;
            this.strlen = this.readLength();
            switch (this.strlen) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        byte type = this.bytes[this.offset];
        if (type == -88) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
        }
        if (type == -81) {
            ++this.offset;
            return null;
        }
        return this.readLocalDateTime0(type);
    }

    private LocalDateTime readLocalDateTime0(int type) {
        if (type == -87) {
            LocalDate localDate = this.readLocalDate();
            return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
        }
        if (type == -86) {
            return this.readZonedDateTime().toLocalDateTime();
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    return this.readLocalDateTime17();
                }
                case 18: {
                    return this.readLocalDateTime18();
                }
                case 19: {
                    return this.readLocalDateTime19();
                }
                case 20: {
                    return this.readLocalDateTime20();
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.toLocalDateTime();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        throw new JSONException("not support type : " + JSONB.typeName((byte)type));
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 85 || (ldt = DateUtils.parseLocalDateTime12(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 13;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 87 || (ldt = DateUtils.parseLocalDateTime14(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 15;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 89 || (ldt = DateUtils.parseLocalDateTime16(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 17;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 90 || (ldt = DateUtils.parseLocalDateTime17(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 18;
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime10() {
        LocalTime time;
        if (this.bytes[this.offset] != 83 || (time = DateUtils.parseLocalTime10(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 11;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        LocalTime time;
        if (this.bytes[this.offset] != 84 || (time = DateUtils.parseLocalTime11(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 12;
        return time;
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime ldt;
        this.type = this.bytes[this.offset];
        if (this.type < 73 || this.type > 120) {
            throw new JSONException("date only support string input");
        }
        if (len < 19 || (ldt = DateUtils.parseZonedDateTime(this.bytes, this.offset + 1, len, this.context.zoneId)) == null) {
            throw new JSONException("illegal LocalDateTime string : " + this.readString());
        }
        this.offset += len + 1;
        return ldt;
    }

    @Override
    public void skipComment() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public LocalTime readLocalTime() {
        byte type = this.bytes[this.offset];
        if (type == -89) {
            ++this.offset;
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalTime.of(hour, minute, second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 5: {
                    return this.readLocalTime5();
                }
                case 8: {
                    return this.readLocalTime8();
                }
                case 10: {
                    return this.readLocalTime10();
                }
                case 11: {
                    return this.readLocalTime11();
                }
                case 12: {
                    return this.readLocalTime12();
                }
                case 18: {
                    return this.readLocalTime18();
                }
            }
            throw new JSONException("not support len : " + len);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant readInstant() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                return Instant.ofEpochSecond(second, nano);
            }
            case -83: {
                long minutes = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Instant.ofEpochSecond(minutes * 60L, 0L);
            }
            case -84: {
                long seconds = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Instant.ofEpochSecond(seconds, 0L);
            }
            case -85: 
            case -66: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Instant.ofEpochMilli(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetTime readOffsetTime() {
        ZonedDateTime zdt = this.readZonedDateTime();
        return zdt == null ? null : zdt.toOffsetDateTime().toOffsetTime();
    }

    @Override
    public OffsetDateTime readOffsetDateTime() {
        ZonedDateTime zdt = this.readZonedDateTime();
        return zdt == null ? null : zdt.toOffsetDateTime();
    }

    @Override
    public ZonedDateTime readZonedDateTime() {
        byte type;
        if ((type = this.bytes[this.offset++]) == -86) {
            ZoneId zoneId;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
            long zoneIdHash = this.readValueHashCode();
            long SHANGHAI_ZONE_ID_HASH = -4800907791268808639L;
            if (zoneIdHash == -4800907791268808639L) {
                zoneId = DateUtils.SHANGHAI_ZONE_ID;
            } else {
                String zoneIdStr = this.getString();
                ZoneId contextZoneId = this.context.getZoneId();
                zoneId = contextZoneId.getId().equals(zoneIdStr) ? contextZoneId : DateUtils.getZoneId(zoneIdStr, DateUtils.SHANGHAI_ZONE_ID);
            }
            return ZonedDateTime.ofLocal(ldt, zoneId, null);
        }
        return this.readZonedDateTime0(type);
    }

    private ZonedDateTime readZonedDateTime0(int type) {
        switch (type) {
            case -81: {
                return null;
            }
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                Instant instant = Instant.ofEpochSecond(second, nano);
                return ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
            }
            case -83: {
                long minutes = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                Instant instant = Instant.ofEpochSecond(minutes * 60L);
                return ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
            }
            case -84: {
                long seconds = JSONReaderJSONB.getInt(this.bytes, this.offset);
                this.offset += 4;
                Instant instant = Instant.ofEpochSecond(seconds);
                return ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
            }
            case -87: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                LocalDate localDate = LocalDate.of(year, month, (int)dayOfMonth);
                return ZonedDateTime.of(localDate, LocalTime.MIN, DateUtils.DEFAULT_ZONE_ID);
            }
            case -88: {
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                LocalDateTime ldt = LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, (int)minute, (int)second, nano);
                return ZonedDateTime.of(ldt, DateUtils.DEFAULT_ZONE_ID);
            }
            case -85: 
            case -66: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                Instant instant = Instant.ofEpochMilli(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis));
                return ZonedDateTime.ofInstant(instant, DateUtils.DEFAULT_ZONE_ID);
            }
        }
        if (type >= 73 && type <= 120) {
            --this.offset;
            return this.readZonedDateTimeX(type - 73);
        }
        throw new JSONException("type not support : " + JSONB.typeName((byte)type));
    }

    @Override
    public UUID readUUID() {
        byte[] bytes = this.bytes;
        byte type = bytes[this.offset++];
        long hi = 0L;
        long lo = 0L;
        switch (type) {
            case -81: {
                return null;
            }
            case -111: {
                int len = this.readLength();
                if (len != 16) {
                    throw new JSONException("uuid not support " + len);
                }
                long msb = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                long lsb = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset + 8L);
                this.offset += 16;
                hi = JDKUtils.BIG_ENDIAN ? msb : Long.reverseBytes(msb);
                lo = JDKUtils.BIG_ENDIAN ? lsb : Long.reverseBytes(lsb);
                break;
            }
            case 105: {
                int i;
                for (i = 0; i < 16; ++i) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                }
                for (i = 16; i < 32; ++i) {
                    lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                }
                this.offset += 32;
                break;
            }
            case 109: {
                byte ch1 = bytes[this.offset + 8];
                byte ch2 = bytes[this.offset + 13];
                byte ch3 = bytes[this.offset + 18];
                byte ch4 = bytes[this.offset + 23];
                if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45) {
                    int i;
                    for (i = 0; i < 8; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 9; i < 13; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 14; i < 18; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 19; i < 23; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 24; i < 36; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    this.offset += 36;
                    break;
                }
                throw new JSONException("Invalid UUID string:  " + new String(bytes, this.offset, 36, StandardCharsets.ISO_8859_1));
            }
            case 121: 
            case 122: {
                int strlen = this.readLength();
                if (strlen == 32) {
                    int i;
                    for (i = 0; i < 16; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 16; i < 32; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    this.offset += 32;
                    break;
                }
                if (strlen == 36) {
                    int i;
                    byte ch1 = bytes[this.offset + 8];
                    byte ch2 = bytes[this.offset + 13];
                    byte ch3 = bytes[this.offset + 18];
                    byte ch4 = bytes[this.offset + 23];
                    if (ch1 != 45 || ch2 != 45 || ch3 != 45 || ch4 != 45) break;
                    for (i = 0; i < 8; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 9; i < 13; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 14; i < 18; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 19; i < 23; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    for (i = 24; i < 36; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[this.offset + i] - 48];
                    }
                    this.offset += 36;
                    break;
                }
                String str = new String(bytes, this.offset, strlen, StandardCharsets.UTF_8);
                this.offset += strlen;
                throw new JSONException("Invalid UUID string:  " + str);
            }
            default: {
                throw JSONReaderJSONB.notSupportType(type);
            }
        }
        return new UUID(hi, lo);
    }

    @Override
    public Boolean readBool() {
        byte type;
        if ((type = this.bytes[this.offset++]) == -81) {
            return null;
        }
        if (type == -79) {
            return true;
        }
        if (type == -80) {
            return false;
        }
        return this.readBoolValue0(type);
    }

    @Override
    public boolean readBoolValue() {
        byte type;
        this.wasNull = false;
        if ((type = this.bytes[this.offset++]) == -79) {
            return true;
        }
        if (type == -80) {
            return false;
        }
        return this.readBoolValue0(type);
    }

    private boolean readBoolValue0(byte type) {
        byte[] bytes = this.bytes;
        switch (type) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return false;
            }
            case 74: {
                if (bytes[this.offset] == 49 || bytes[this.offset] == 89) {
                    ++this.offset;
                    return true;
                }
                if (bytes[this.offset] == 48 || bytes[this.offset] == 78) {
                    ++this.offset;
                    return false;
                }
            }
            case 77: {
                if (bytes[this.offset] == 116 && bytes[this.offset + 1] == 114 && bytes[this.offset + 2] == 117 && bytes[this.offset + 3] == 101) {
                    this.offset += 4;
                    return true;
                }
                if (bytes[this.offset] == 84 && bytes[this.offset + 1] == 82 && bytes[this.offset + 2] == 85 && bytes[this.offset + 3] == 69) {
                    this.offset += 4;
                    return true;
                }
            }
            case 78: {
                if (bytes[this.offset] == 102 && bytes[this.offset + 1] == 97 && bytes[this.offset + 2] == 108 && bytes[this.offset + 3] == 115 && bytes[this.offset + 4] == 101) {
                    this.offset += 5;
                    return false;
                }
                if (bytes[this.offset] == 70 && bytes[this.offset + 1] == 65 && bytes[this.offset + 2] == 76 && bytes[this.offset + 3] == 83 && bytes[this.offset + 4] == 69) {
                    this.offset += 5;
                    return false;
                }
            }
            case 121: 
            case 122: {
                this.strlen = this.readLength();
                if (this.strlen == 1) {
                    if (bytes[this.offset] == 89) {
                        ++this.offset;
                        return true;
                    }
                    if (bytes[this.offset] == 78) {
                        ++this.offset;
                        return true;
                    }
                } else {
                    if (this.strlen == 4 && bytes[this.offset] == 116 && bytes[this.offset + 1] == 114 && bytes[this.offset + 2] == 117 && bytes[this.offset + 3] == 101) {
                        this.offset += 4;
                        return true;
                    }
                    if (this.strlen == 5) {
                        if (bytes[this.offset] == 102 && bytes[this.offset + 1] == 97 && bytes[this.offset + 2] == 108 && bytes[this.offset + 3] == 115 && bytes[this.offset + 4] == 101) {
                            this.offset += 5;
                            return false;
                        }
                        if (bytes[this.offset] == 70 && bytes[this.offset + 1] == 65 && bytes[this.offset + 2] == 76 && bytes[this.offset + 3] == 83 && bytes[this.offset + 4] == 69) {
                            this.offset += 5;
                            return false;
                        }
                    }
                }
                String str = new String(bytes, this.offset, this.strlen, StandardCharsets.ISO_8859_1);
                this.offset += this.strlen;
                throw new JSONException("not support input " + str);
            }
            case 123: 
            case 124: 
            case 125: {
                this.strlen = this.readLength();
                byte[] chars = new byte[this.strlen];
                System.arraycopy(bytes, this.offset, chars, 0, this.strlen);
                Charset charset = type == 125 ? StandardCharsets.UTF_16BE : (type == 124 ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16);
                String str = new String(chars, charset);
                this.offset += this.strlen;
                switch (str) {
                    case "0": 
                    case "N": 
                    case "false": 
                    case "FALSE": {
                        return false;
                    }
                    case "1": 
                    case "Y": 
                    case "true": 
                    case "TRUE": {
                        return true;
                    }
                }
                throw new JSONException("not support input " + str);
            }
        }
        throw JSONReaderJSONB.notSupportType(type);
    }

    @Override
    public boolean nextIfMatch(byte type) {
        if (this.bytes[this.offset] == type) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextIfMatchTypedAny() {
        if (this.bytes[this.offset] == -110) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    protected final int getStringLength() {
        this.type = this.bytes[this.offset];
        if (this.type >= 73 && this.type < 120) {
            return this.type - 73;
        }
        throw new UnsupportedOperationException(JSONB.typeName(this.type));
    }

    @Override
    public boolean isDate() {
        byte type = this.bytes[this.offset];
        return type >= -89 && type <= -82;
    }

    @Override
    public Date readDate() {
        ChronoZonedDateTime zdt = null;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        byte type = bytes[offset];
        switch (type) {
            case -89: {
                LocalTime localTime = this.readLocalTime();
                LocalDateTime ldt = LocalDateTime.of(LocalDate.of(1970, 1, 1), localTime);
                zdt = ZonedDateTime.ofLocal(ldt, this.context.getZoneId(), null);
                break;
            }
            case -88: {
                LocalDateTime ldt = this.readLocalDateTime();
                zdt = ZonedDateTime.ofLocal(ldt, this.context.getZoneId(), null);
                break;
            }
            case -87: {
                LocalDate localDate = this.readLocalDate();
                zdt = ZonedDateTime.ofLocal(LocalDateTime.of(localDate, LocalTime.MIN), this.context.getZoneId(), null);
                break;
            }
            case -85: {
                long millis = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset + 1L);
                this.offset += 9;
                return new Date(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis));
            }
            case -83: {
                long minutes = JSONReaderJSONB.getInt(bytes, offset + 1);
                this.offset += 5;
                return new Date(minutes * 60L * 1000L);
            }
            case -84: {
                long seconds = JSONReaderJSONB.getInt(bytes, offset + 1);
                this.offset += 5;
                return new Date(seconds * 1000L);
            }
            case -86: {
                this.offset = offset + 1;
                zdt = this.readTimestampWithTimeZone();
                break;
            }
            case -82: {
                this.offset = offset + 1;
                long epochSeconds = this.readInt64Value();
                int nano = this.readInt32Value();
                return Date.from(Instant.ofEpochSecond(epochSeconds, nano));
            }
        }
        if (zdt != null) {
            long millis;
            long seconds = zdt.toEpochSecond();
            int nanos = ((ZonedDateTime)zdt).toLocalTime().getNano();
            if (seconds < 0L && nanos > 0) {
                millis = (seconds + 1L) * 1000L;
                long adjustment = nanos / 1000000 - 1000;
                millis += adjustment;
            } else {
                millis = seconds * 1000L;
                millis += (long)(nanos / 1000000);
            }
            return new Date(millis);
        }
        return super.readDate();
    }

    @Override
    public LocalDate readLocalDate8() {
        LocalDate ldt;
        if (this.bytes[this.offset] != 81 || (ldt = DateUtils.parseLocalDate8(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 9;
        return ldt;
    }

    @Override
    public LocalDate readLocalDate9() {
        LocalDate ldt;
        if (this.bytes[this.offset] != 82 || (ldt = DateUtils.parseLocalDate9(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 10;
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate10() {
        LocalDate ldt;
        if ((this.strtype == 121 || this.strtype == 122) && this.strlen == 10) {
            ldt = DateUtils.parseLocalDate10(this.bytes, this.offset);
        } else if (this.bytes[this.offset] != 83 || (ldt = DateUtils.parseLocalDate10(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 11;
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate11() {
        LocalDate ldt;
        if ((this.strtype == 121 || this.strtype == 122) && this.strlen == 11) {
            ldt = DateUtils.parseLocalDate11(this.bytes, this.offset);
        } else if (this.bytes[this.offset] != 84 || (ldt = DateUtils.parseLocalDate11(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 12;
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        LocalTime time;
        if (this.bytes[this.offset] != 78 || (time = DateUtils.parseLocalTime5(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 6;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        LocalTime time;
        if (this.bytes[this.offset] != 81 || (time = DateUtils.parseLocalTime8(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 9;
        return time;
    }

    @Override
    protected LocalTime readLocalTime9() {
        LocalTime time;
        if (this.bytes[this.offset] != 81 || (time = DateUtils.parseLocalTime8(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 10;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        LocalTime time;
        if (this.bytes[this.offset] != 85 || (time = DateUtils.parseLocalTime12(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 13;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        LocalTime time;
        if (this.bytes[this.offset] != 91 || (time = DateUtils.parseLocalTime18(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 19;
        return time;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 91 || (ldt = DateUtils.parseLocalDateTime18(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 19;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 93 || (ldt = DateUtils.parseLocalDateTime20(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 21;
        return ldt;
    }

    @Override
    public long readMillis19() {
        if (this.bytes[this.offset] != 92) {
            throw new JSONException("date only support string input");
        }
        long millis = DateUtils.parseMillis19(this.bytes, this.offset + 1, this.context.zoneId);
        this.offset += 20;
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        this.type = this.bytes[this.offset];
        if (this.type != 92) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.bytes, this.offset + 1);
        if (ldt == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 20;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        LocalDateTime ldt;
        this.type = this.bytes[this.offset];
        if (this.type < 73 || this.type > 120) {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29 || (ldt = DateUtils.parseLocalDateTimeX(this.bytes, this.offset + 1, len)) == null) {
            throw new JSONException("illegal LocalDateTime string : " + this.readString());
        }
        this.offset += len + 1;
        return ldt;
    }

    @Override
    public String readPattern() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        return this.readFieldNameHashCode();
    }

    @Override
    public boolean nextIfSet() {
        return false;
    }

    @Override
    public boolean nextIfInfinity() {
        return false;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public JSONReader.SavePoint mark() {
        return new JSONReader.SavePoint(this.offset, this.type);
    }

    @Override
    public void reset(JSONReader.SavePoint savePoint) {
        this.offset = savePoint.offset;
        this.type = (byte)savePoint.current;
    }

    @Override
    public void close() {
        char[] nameChars;
        byte[] valueBytes = this.valueBytes;
        if (valueBytes != null && valueBytes.length < 0x100000) {
            JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, valueBytes);
        }
        if ((nameChars = this.charBuf) != null && nameChars.length < 0x100000) {
            JSONFactory.CHARS_UPDATER.lazySet(this.cacheItem, nameChars);
        }
    }

    @Override
    public boolean isEnd() {
        return this.offset >= this.end;
    }

    @Override
    public int getRawInt() {
        return this.offset + 3 < this.end ? JDKUtils.UNSAFE.getInt(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) : 0;
    }

    @Override
    public long getRawLong() {
        return this.offset + 7 < this.end ? JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) : 0L;
    }

    @Override
    public boolean nextIfName4Match2() {
        return false;
    }

    @Override
    public boolean nextIfName4Match3() {
        int offset = this.offset + 4;
        if (offset > this.end) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match4(byte name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 5;
        if (offset > this.end || bytes[offset - 1] != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match5(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 6;
        if (offset > this.end || JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset - 2L) != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match6(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 7;
        if (offset > this.end || (JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 3L) & 0xFFFFFF) != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match7(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 8;
        if (offset > this.end || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 4L) != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match8(int name1, byte name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 9;
        if (offset >= this.end || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 5L) != name1 || bytes[offset - 1] != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match9(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 10;
        if (offset + 1 >= this.end || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 6L) & 0xFFFFFFFFFFFFL) != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match10(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 11;
        if (offset >= this.end || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 7L) & 0xFFFFFFFFFFFFFFL) != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match11(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 12;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 8L) != name1) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match12(long name1, byte name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 13;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 9L) != name1 || bytes[offset - 1] != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match13(long name1, int name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 14;
        if (offset + 1 >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 10L) != name1 || JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset - 2L) != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match14(long name1, int name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 15;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 11L) != name1 || (JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 3L) & 0xFFFFFF) != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match15(long name1, int name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 16;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 12L) != name1 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 4L) != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match16(long name1, int name2, byte name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 17;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 13L) != name1 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 5L) != name2 || bytes[offset - 1] != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match17(long name1, long name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 18;
        if (offset + 1 >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 14L) != name1 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 6L) & 0xFFFFFFFFFFFFL) != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match18(long name1, long name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 19;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 15L) != name1 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 7L) & 0xFFFFFFFFFFFFFFL) != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match19(long name1, long name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 20;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 16L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 8L) != name2) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match20(long name1, long name2, byte name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 21;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 17L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 9L) != name2 || bytes[offset - 1] != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match21(long name1, long name2, int name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 22;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 18L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 10L) != name2 || JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset - 2L) != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match22(long name1, long name2, int name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 23;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 19L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 11L) != name2 || (JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 3L) & 0xFFFFFF) != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match23(long name1, long name2, int name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 24;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 20L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 12L) != name2 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 4L) != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match24(long name1, long name2, int name3, byte name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 25;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 21L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 13L) != name2 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 5L) != name3 || bytes[offset - 1] != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match25(long name1, long name2, long name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 26;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 22L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 14L) != name2 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 6L) & 0xFFFFFFFFFFFFL) != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match26(long name1, long name2, long name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 27;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 23L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 15L) != name2 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 7L) & 0xFFFFFFFFFFFFFFL) != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match27(long name1, long name2, long name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 28;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 24L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 16L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 8L) != name3) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match28(long name1, long name2, long name3, byte name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 29;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 25L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 17L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 9L) != name3 || bytes[offset - 1] != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match29(long name1, long name2, long name3, int name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 30;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 26L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 18L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 10L) != name3 || JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset - 2L) != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match30(long name1, long name2, long name3, int name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 31;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 27L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 19L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 11L) != name3 || (JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 3L) & 0xFFFFFF) != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match31(long name1, long name2, long name3, int name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 32;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 28L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 20L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 12L) != name3 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 4L) != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match32(long name1, long name2, long name3, int name4, byte name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 33;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 29L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 21L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 13L) != name3 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 5L) != name4 || bytes[offset - 1] != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match33(long name1, long name2, long name3, long name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 34;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 30L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 22L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 14L) != name3 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 6L) & 0xFFFFFFFFFFFFL) != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match34(long name1, long name2, long name3, long name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 35;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 31L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 23L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 15L) != name3 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 7L) & 0xFFFFFFFFFFFFFFL) != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match35(long name1, long name2, long name3, long name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 36;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 32L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 24L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 16L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 8L) != name4) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match36(long name1, long name2, long name3, long name4, byte name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 37;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 33L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 25L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 17L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 9L) != name4 || bytes[offset - 1] != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match37(long name1, long name2, long name3, long name4, int name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 38;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 34L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 26L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 18L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 10L) != name4 || JDKUtils.UNSAFE.getShort(bytes, BASE + (long)offset - 2L) != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match38(long name1, long name2, long name3, long name4, int name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 39;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 35L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 27L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 19L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 11L) != name4 || (JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 3L) & 0xFFFFFF) != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match39(long name1, long name2, long name3, long name4, int name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 40;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 36L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 28L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 20L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 12L) != name4 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 4L) != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match40(long name1, long name2, long name3, long name4, int name5, byte name6) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 41;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 37L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 29L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 21L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 13L) != name4 || JDKUtils.UNSAFE.getInt(bytes, BASE + (long)offset - 5L) != name5 || bytes[offset - 1] != name6) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match41(long name1, long name2, long name3, long name4, long name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 42;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 38L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 30L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 22L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 14L) != name4 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 6L) & 0xFFFFFFFFFFFFL) != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match42(long name1, long name2, long name3, long name4, long name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 43;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 39L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 31L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 23L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 15L) != name4 || (JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 7L) & 0xFFFFFFFFFFFFFFL) != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    @Override
    public boolean nextIfName4Match43(long name1, long name2, long name3, long name4, long name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset + 44;
        if (offset >= this.end || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 40L) != name1 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 32L) != name2 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 24L) != name3 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 16L) != name4 || JDKUtils.UNSAFE.getLong(bytes, BASE + (long)offset - 8L) != name5) {
            return false;
        }
        this.offset = offset;
        return true;
    }

    static int getInt(byte[] bytes, int offset) {
        int int32Value = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
        return JDKUtils.BIG_ENDIAN ? int32Value : Integer.reverseBytes(int32Value);
    }

    static {
        FIXED_TYPE_SIZE = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 5, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 5, 0, 0, 1, 1, 1, 0, 0, 0, 9, 0, 5, 0, 0, 0, 0, 3, 2, 9, 5, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    }
}

