/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.function.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public final class ToAny
implements Function {
    private final Class targetClass;
    private Object defaultValue;

    public ToAny(Class targetClass) {
        this(targetClass, null);
    }

    public ToAny(Class targetClass, Object defaultValue) {
        this.targetClass = targetClass;
        this.defaultValue = defaultValue;
    }

    public Object apply(Object o) {
        if (o == null) {
            return this.defaultValue;
        }
        if (this.targetClass.isInstance(o)) {
            return o;
        }
        if (this.targetClass == String.class) {
            return o.toString();
        }
        if (this.targetClass == BigDecimal.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
                return BigDecimal.valueOf(((Number)o).longValue());
            }
            if (o instanceof Float || o instanceof Double) {
                double doubleValue = ((Number)o).doubleValue();
                return TypeUtils.toBigDecimal(doubleValue);
            }
            if (o instanceof BigInteger) {
                return new BigDecimal((BigInteger)o);
            }
            if (o instanceof String) {
                return new BigDecimal((String)o);
            }
        } else if (this.targetClass == BigInteger.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong || o instanceof Float || o instanceof Double) {
                return BigInteger.valueOf(((Number)o).longValue());
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).toBigInteger();
            }
        } else if (this.targetClass == Boolean.class) {
            if (o instanceof Number) {
                return ((Number)o).intValue() == 1;
            }
            if (o instanceof String) {
                String str;
                switch (str = (String)o) {
                    case "true": 
                    case "TRUE": 
                    case "True": 
                    case "T": 
                    case "Y": 
                    case "YES": 
                    case "Yes": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "false": 
                    case "FALSE": 
                    case "False": 
                    case "F": 
                    case "N": 
                    case "NO": 
                    case "no": 
                    case "No": {
                        return Boolean.FALSE;
                    }
                    case "null": {
                        return this.defaultValue;
                    }
                }
            }
        } else if (this.targetClass == Byte.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? (byte)1 : 0;
            }
            if (o instanceof Number) {
                return ((Number)o).byteValue();
            }
        } else if (this.targetClass == Double.class) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (o instanceof String) {
                String str = (String)o;
                if (str.isEmpty()) {
                    return this.defaultValue;
                }
                return Double.parseDouble(str);
            }
            if (o instanceof List) {
                List list = (List)o;
                JSONArray array = new JSONArray(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    array.add(this.apply(item));
                }
                return array;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1.0 : 0.0;
            }
        } else if (this.targetClass == Float.class) {
            if (o instanceof Boolean) {
                return Float.valueOf((Boolean)o != false ? 1.0f : 0.0f);
            }
            if (o instanceof Number) {
                return Float.valueOf(((Number)o).floatValue());
            }
        } else if (this.targetClass == Integer.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
        } else if (this.targetClass == Long.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1L : 0L;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
        } else if (this.targetClass == Short.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? (short)1 : 0;
            }
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
        } else if (this.targetClass == Number.class) {
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof Number) {
                return o;
            }
        }
        throw new JSONException("can not cast to " + this.targetClass.getName() + " " + o.getClass());
    }
}

