/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplCalendar;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDateTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplOffsetDateTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplOffsetTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import com.alibaba.fastjson2.reader.ObjectReaderImplZonedDateTime;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public abstract class FieldReader<T>
implements Comparable<FieldReader> {
    public final int ordinal;
    public final String fieldName;
    public final Class fieldClass;
    public final Type fieldType;
    public final long features;
    public final String format;
    public final Method method;
    public final Field field;
    protected final long fieldOffset;
    public final Object defaultValue;
    public final Locale locale;
    final boolean fieldClassSerializable;
    final long fieldNameHash;
    final long fieldNameHashLCase;
    volatile ObjectReader reader;
    volatile JSONPath referenceCache;
    final boolean noneStaticMemberClass;
    final boolean readOnly;
    Type itemType;
    Class itemClass;
    volatile ObjectReader itemReader;

    public FieldReader(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, Method method, Field field) {
        boolean noneStaticMemberClass;
        boolean readOnly;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && (fieldClass.isPrimitive() || fieldClass == String.class || fieldClass == List.class || Serializable.class.isAssignableFrom(fieldClass) || Modifier.isInterface(fieldClass.getModifiers()));
        this.features = features;
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.fieldNameHashLCase = Fnv.hashCode64LCase(fieldName);
        this.ordinal = ordinal;
        this.format = format;
        this.locale = locale;
        this.defaultValue = defaultValue;
        this.method = method;
        this.field = field;
        this.readOnly = readOnly = field != null && Modifier.isFinal(field.getModifiers()) || (features & 0x100000000000000L) != 0L;
        long fieldOffset = -1L;
        if (field != null && (features & 0x80000000000000L) == 0L) {
            fieldOffset = JDKUtils.UNSAFE.objectFieldOffset(field);
        }
        this.fieldOffset = fieldOffset;
        if (fieldOffset == -1L && field != null && method == null) {
            try {
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fieldClass == null || fieldClass.isPrimitive() || fieldClass == String.class || fieldClass == List.class || fieldClass == Map.class || fieldClass.isEnum()) {
            noneStaticMemberClass = false;
        } else {
            Class<?> declaringClass = null;
            if (method != null) {
                declaringClass = method.getDeclaringClass();
            } else if (field != null) {
                declaringClass = field.getDeclaringClass();
            }
            noneStaticMemberClass = BeanUtils.isNoneStaticMemberClass(declaringClass, fieldClass);
        }
        this.noneStaticMemberClass = noneStaticMemberClass;
    }

    public void acceptDefaultValue(T object) {
        if (this.defaultValue != null) {
            this.accept(object, this.defaultValue);
        }
    }

    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    public ObjectReader getObjectReader(JSONReader.Context context) {
        if (this.reader != null) {
            return this.reader;
        }
        this.reader = context.getObjectReader(this.fieldType);
        return this.reader;
    }

    public Type getItemType() {
        return this.itemType;
    }

    public Class getItemClass() {
        if (this.itemType == null) {
            return null;
        }
        if (this.itemClass == null) {
            this.itemClass = TypeUtils.getClass(this.itemType);
        }
        return this.itemClass;
    }

    public long getItemClassHash() {
        Class itemClass = this.getItemClass();
        if (itemClass == null) {
            return 0L;
        }
        return Fnv.hashCode64(itemClass.getName());
    }

    public String toString() {
        AccessibleObject member;
        AccessibleObject accessibleObject = member = this.method != null ? this.method : this.field;
        if (member != null) {
            return member.getName();
        }
        return this.fieldName;
    }

    public void addResolveTask(JSONReader jsonReader, Object object, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(this, object, path);
    }

    @Override
    public int compareTo(FieldReader o) {
        Class<?> s;
        Class<?> otherDeclaringClass;
        Class<?> thisDeclaringClass;
        AccessibleObject otherMember;
        int cmp;
        int nameCompare = this.fieldName.compareTo(o.fieldName);
        if (nameCompare != 0) {
            if (this.ordinal < o.ordinal) {
                return -1;
            }
            if (this.ordinal > o.ordinal) {
                return 1;
            }
            return nameCompare;
        }
        int n = this.isReadOnly() == o.isReadOnly() ? 0 : (cmp = this.isReadOnly() ? 1 : -1);
        if (cmp != 0) {
            return cmp;
        }
        AccessibleObject thisMember = this.field != null ? this.field : this.method;
        AccessibleObject accessibleObject = otherMember = o.field != null ? o.field : o.method;
        if (thisMember != null && otherMember != null && thisMember.getClass() != otherMember.getClass()) {
            Class<?> otherDeclaringClass2 = otherMember.getDeclaringClass();
            Class<?> thisDeclaringClass2 = thisMember.getDeclaringClass();
            if (thisDeclaringClass2 != otherDeclaringClass2) {
                if (thisDeclaringClass2.isAssignableFrom(otherDeclaringClass2)) {
                    return 1;
                }
                if (otherDeclaringClass2.isAssignableFrom(thisDeclaringClass2)) {
                    return -1;
                }
            }
        }
        if (this.field != null && o.field != null) {
            thisDeclaringClass = this.field.getDeclaringClass();
            otherDeclaringClass = o.field.getDeclaringClass();
            for (s = thisDeclaringClass.getSuperclass(); s != null && s != Object.class; s = s.getSuperclass()) {
                if (s != otherDeclaringClass) continue;
                return 1;
            }
            for (s = otherDeclaringClass.getSuperclass(); s != null && s != Object.class; s = s.getSuperclass()) {
                if (s != thisDeclaringClass) continue;
                return -1;
            }
        }
        if (this.method != null && o.method != null) {
            String otherMethodName;
            String thisMethodName;
            Class<?> otherParamType;
            Class<?> thisParamType;
            thisDeclaringClass = this.method.getDeclaringClass();
            otherDeclaringClass = o.method.getDeclaringClass();
            for (s = thisDeclaringClass.getSuperclass(); s != null && s != Object.class; s = s.getSuperclass()) {
                if (s != otherDeclaringClass) continue;
                return -1;
            }
            for (s = otherDeclaringClass.getSuperclass(); s != null && s != Object.class; s = s.getSuperclass()) {
                if (s != thisDeclaringClass) continue;
                return 1;
            }
            Class<?>[] thisParameterTypes = this.method.getParameterTypes();
            Class<?>[] otherParameterTypes = o.method.getParameterTypes();
            if (thisParameterTypes.length == 1 && otherParameterTypes.length == 1 && (thisParamType = thisParameterTypes[0]) != (otherParamType = otherParameterTypes[0])) {
                if (thisParamType.isAssignableFrom(otherParamType)) {
                    return 1;
                }
                if (otherParamType.isAssignableFrom(thisParamType)) {
                    return -1;
                }
                if (FieldReader.needCompareToActualFieldClass(thisParamType) || FieldReader.needCompareToActualFieldClass(otherParamType)) {
                    Class<?> actualFieldClass = null;
                    try {
                        actualFieldClass = thisDeclaringClass.getDeclaredField(this.fieldName).getType();
                        if (actualFieldClass == null) {
                            actualFieldClass = otherDeclaringClass.getDeclaredField(this.fieldName).getType();
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (actualFieldClass != null) {
                        Class<?> s2;
                        for (s2 = thisParamType; s2 != null && s2 != Object.class; s2 = s2.getSuperclass()) {
                            if (s2 != actualFieldClass) continue;
                            return -1;
                        }
                        for (s2 = otherParamType; s2 != null && s2 != Object.class; s2 = s2.getSuperclass()) {
                            if (s2 != actualFieldClass) continue;
                            return 1;
                        }
                    }
                }
                JSONField thisAnnotation = BeanUtils.findAnnotation(this.method, JSONField.class);
                JSONField otherAnnotation = BeanUtils.findAnnotation(o.method, JSONField.class);
                if (thisAnnotation != null && otherAnnotation == null) {
                    return -1;
                }
                if (thisAnnotation == null && otherAnnotation != null) {
                    return 1;
                }
            }
            if (!(thisMethodName = this.method.getName()).equals(otherMethodName = o.method.getName())) {
                String thisName = BeanUtils.setterName(thisMethodName, null);
                String otherName = BeanUtils.setterName(otherMethodName, null);
                if (this.fieldName.equals(thisName) && !o.fieldName.equals(otherName)) {
                    return 1;
                }
                if (o.fieldName.equals(otherName) && !this.fieldName.equals(thisName)) {
                    return -1;
                }
            }
        }
        ObjectReader thisInitReader = this.getInitReader();
        ObjectReader otherInitReader = o.getInitReader();
        if (thisInitReader != null && otherInitReader == null) {
            return -1;
        }
        if (thisInitReader == null && otherInitReader != null) {
            return 1;
        }
        Class thisFieldClass = this.fieldClass;
        Class otherClass = o.fieldClass;
        boolean thisClassPrimitive = thisFieldClass.isPrimitive();
        boolean otherClassPrimitive = otherClass.isPrimitive();
        if (thisClassPrimitive && !otherClassPrimitive) {
            return -1;
        }
        if (!thisClassPrimitive && otherClassPrimitive) {
            return 1;
        }
        boolean thisClassStartsWithJava = thisFieldClass.getName().startsWith("java.", 0);
        boolean otherClassStartsWithJava = otherClass.getName().startsWith("java.", 0);
        if (thisClassStartsWithJava && !otherClassStartsWithJava) {
            return -1;
        }
        if (!thisClassStartsWithJava && otherClassStartsWithJava) {
            return 1;
        }
        return cmp;
    }

    public boolean isUnwrapped() {
        return (this.features & 0x2000000000000L) != 0L;
    }

    public void addResolveTask(JSONReader jsonReader, List object, int i, String reference) {
        jsonReader.addResolveTask(object, i, JSONPath.of(reference));
    }

    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        this.readFieldValue(jsonReader, object);
    }

    public abstract Object readFieldValue(JSONReader var1);

    public void accept(T object, boolean value) {
        this.accept(object, (Object)value);
    }

    public boolean supportAcceptType(Class valueClass) {
        return this.fieldClass == valueClass;
    }

    public void accept(T object, byte value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, short value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, int value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, long value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, char value) {
        this.accept(object, Character.valueOf(value));
    }

    public void accept(T object, float value) {
        this.accept(object, Float.valueOf(value));
    }

    public void accept(T object, double value) {
        this.accept(object, (Object)value);
    }

    public abstract void accept(T var1, Object var2);

    protected void acceptAny(T object, Object fieldValue, long features) {
        Object typedFieldValue;
        Class<?> valueClass;
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        boolean autoCast = true;
        if (fieldValue != null && !this.supportAcceptType(valueClass = fieldValue.getClass())) {
            Function typeConvert;
            if (valueClass == String.class) {
                if (this.fieldClass == Date.class) {
                    autoCast = false;
                }
            } else if (valueClass == Integer.class && (this.fieldClass == Boolean.TYPE || this.fieldClass == Boolean.class) && (features & JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue.mask) != 0L) {
                int intValue = (Integer)fieldValue;
                fieldValue = intValue != 0;
            }
            if (valueClass != this.fieldClass && autoCast && (typeConvert = provider.getTypeConvert(valueClass, this.fieldClass)) != null) {
                fieldValue = typeConvert.apply(fieldValue);
            }
        }
        if (fieldValue == null || this.fieldType == fieldValue.getClass()) {
            typedFieldValue = fieldValue;
        } else if (fieldValue instanceof JSONObject) {
            JSONReader.Feature[] featureArray;
            if ((features & JSONReader.Feature.SupportSmartMatch.mask) != 0L) {
                JSONReader.Feature[] featureArray2 = new JSONReader.Feature[1];
                featureArray = featureArray2;
                featureArray2[0] = JSONReader.Feature.SupportSmartMatch;
            } else {
                featureArray = new JSONReader.Feature[]{};
            }
            JSONReader.Feature[] toFeatures = featureArray;
            typedFieldValue = ((JSONObject)fieldValue).to(this.fieldType, toFeatures);
        } else if (fieldValue instanceof JSONArray) {
            typedFieldValue = ((JSONArray)fieldValue).to(this.fieldType, features);
        } else if (features == 0L && !this.fieldClass.isInstance(fieldValue) && this.format == null) {
            ObjectReader initReader = this.getInitReader();
            if (initReader != null) {
                String fieldValueJson = JSON.toJSONString(fieldValue);
                typedFieldValue = initReader.readObject(JSONReader.of(fieldValueJson), null, null, features);
            } else {
                typedFieldValue = TypeUtils.cast(fieldValue, this.fieldClass, provider);
            }
        } else if (autoCast) {
            String fieldValueJSONString = JSON.toJSONString(fieldValue);
            JSONReader.Context readContext = JSONFactory.createReadContext(features);
            try (JSONReader jsonReader = JSONReader.of(fieldValueJSONString, readContext);){
                ObjectReader fieldObjectReader = this.getObjectReader(jsonReader);
                typedFieldValue = fieldObjectReader.readObject(jsonReader, null, this.fieldName, features);
            }
        } else {
            typedFieldValue = fieldValue;
        }
        this.accept(object, typedFieldValue);
    }

    public abstract void readFieldValue(JSONReader var1, T var2);

    public ObjectReader checkObjectAutoType(JSONReader jsonReader) {
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ObjectReader getInitReader() {
        return null;
    }

    public void processExtra(JSONReader jsonReader, Object object) {
        jsonReader.skipValue();
    }

    public void acceptExtra(Object object, String name, Object value) {
    }

    public ObjectReader getItemObjectReader(JSONReader.Context ctx) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        this.itemReader = ctx.getObjectReader(this.itemType);
        return this.itemReader;
    }

    public ObjectReader getObjectReader(ObjectReaderProvider provider) {
        if (this.reader != null) {
            return this.reader;
        }
        boolean fieldBased = (this.features & JSONReader.Feature.FieldBased.mask) != 0L;
        this.reader = provider.getObjectReader(this.fieldType, fieldBased);
        return this.reader;
    }

    public ObjectReader getItemObjectReader(JSONReader jsonReader) {
        return this.getItemObjectReader(jsonReader.context);
    }

    static ObjectReader createFormattedObjectReader(Type fieldType, Class fieldClass, String format, Locale locale) {
        if (format != null && !format.isEmpty()) {
            String typeName;
            switch (typeName = TypeUtils.getTypeName(fieldType)) {
                case "java.sql.Time": {
                    return new JdbcSupport.TimeReader(format, locale);
                }
                case "java.sql.Timestamp": {
                    return new JdbcSupport.TimestampReader(format, locale);
                }
                case "java.sql.Date": {
                    return new JdbcSupport.DateReader(format, locale);
                }
                case "byte[]": 
                case "[B": {
                    return new ObjectReaderImplInt8Array(format);
                }
            }
            if (Calendar.class.isAssignableFrom(fieldClass)) {
                return ObjectReaderImplCalendar.of(format, locale);
            }
            if (fieldClass == Date.class) {
                return ObjectReaderImplDate.of(format, locale);
            }
            if (fieldClass == ZonedDateTime.class) {
                return ObjectReaderImplZonedDateTime.of(format, locale);
            }
            if (fieldClass == LocalDateTime.class) {
                return new ObjectReaderImplLocalDateTime(format, locale);
            }
            if (fieldClass == LocalDate.class) {
                return ObjectReaderImplLocalDate.of(format, locale);
            }
            if (fieldClass == LocalTime.class) {
                return new ObjectReaderImplLocalTime(format, locale);
            }
            if (fieldClass == Instant.class) {
                return ObjectReaderImplInstant.of(format, locale);
            }
            if (fieldClass == OffsetTime.class) {
                return ObjectReaderImplOffsetTime.of(format, locale);
            }
            if (fieldClass == OffsetDateTime.class) {
                return ObjectReaderImplOffsetDateTime.of(format, locale);
            }
            if (fieldClass == Optional.class) {
                return ObjectReaderImplOptional.of(fieldType, format, locale);
            }
        }
        return null;
    }

    private static boolean needCompareToActualFieldClass(Class clazz) {
        return clazz.isEnum() || clazz.isInterface();
    }
}

