/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderASCII;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class JSONReaderASCIINonSlash
extends JSONReaderASCII {
    JSONReaderASCIINonSlash(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, str, bytes, offset, length);
    }

    @Override
    public String readString() {
        char quote = this.ch;
        if (quote == '\"' || quote == '\'') {
            int ch;
            byte[] bytes = this.bytes;
            int start = this.offset;
            int end = this.end;
            int offset = IOUtils.indexOfQuote(bytes, quote, start, end);
            if (offset == -1) {
                throw new JSONException("invalid escape character EOI");
            }
            String str = JDKUtils.STRING_CREATOR_JDK11 != null ? JDKUtils.STRING_CREATOR_JDK11.apply(Arrays.copyOfRange(bytes, start, offset), JDKUtils.LATIN1) : new String(bytes, start, offset - start, StandardCharsets.ISO_8859_1);
            long features = this.context.features;
            if ((features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (str.isEmpty() && (features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                str = null;
            }
            int n = ch = ++offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.comma = ch == 44;
            if (this.comma) {
                int n2 = ch = offset == end ? 26 : bytes[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? 26 : bytes[offset++];
                }
            }
            this.ch = (char)ch;
            this.offset = offset;
            return str;
        }
        return this.readStringNotMatch();
    }
}

