/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;

final class JSONWriterUTF16JDK9UF
extends JSONWriterUTF16 {
    JSONWriterUTF16JDK9UF(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeStringNull();
            return;
        }
        byte[] value = JDKUtils.STRING_VALUE.apply(str);
        if (JDKUtils.STRING_CODER.applyAsInt(str) == 0) {
            this.writeStringLatin1(value);
        } else {
            this.writeStringUTF16(value);
        }
    }

    @Override
    public void writeBool(boolean value) {
        int minCapacity = this.off + 5;
        if (minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        char[] chars = this.chars;
        int off = this.off;
        if ((this.context.features & JSONWriter.Feature.WriteBooleanAsNumber.mask) != 0L) {
            chars[off++] = value ? 49 : 48;
        } else {
            off = IOUtils.putBoolean(chars, off, value);
        }
        this.off = off;
    }
}

