/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.DoubleToDecimal;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONWriterUTF8
extends JSONWriter {
    static final long REF;
    static final short QUOTE2_COLON;
    static final short QUOTE_COLON;
    static final short[] HEX256;
    final JSONFactory.CacheItem cacheItem;
    protected byte[] bytes;
    protected final long byteVectorQuote;
    private static final short U2;
    private static final int U4;
    private static final short[] ESCAPED_CHARS;

    JSONWriterUTF8(JSONWriter.Context ctx) {
        super(ctx, null, false, StandardCharsets.UTF_8);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (bytes == null) {
            bytes = new byte[8192];
        }
        this.bytes = bytes;
        this.byteVectorQuote = this.useSingleQuote ? -2821266740684990248L : -2459565876494606883L;
    }

    @Override
    public final void writeNull() {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 4 > bytes.length) {
            bytes = this.grow(off + 4);
        }
        IOUtils.putNULL(bytes, off);
        this.off = off + 4;
    }

    @Override
    public final void writeReference(String path) {
        this.lastReference = path;
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, REF);
        this.off = off + 8;
        this.writeString(path);
        this.writeRaw((byte)125);
    }

    @Override
    public final void writeBase64(byte[] value) {
        int i;
        int off = this.off;
        int charsLen = (value.length - 1) / 3 + 1 << 2;
        int minCapacity = off + charsLen + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        int eLen = value.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (value[s++] & 0xFF) << 16 | (value[s++] & 0xFF) << 8 | value[s++] & 0xFF;
            IOUtils.putByte(bytes, off, (byte)JSONFactory.CA[i >>> 18 & 0x3F]);
            IOUtils.putByte(bytes, off + 1, (byte)JSONFactory.CA[i >>> 12 & 0x3F]);
            IOUtils.putByte(bytes, off + 2, (byte)JSONFactory.CA[i >>> 6 & 0x3F]);
            IOUtils.putByte(bytes, off + 3, (byte)JSONFactory.CA[i & 0x3F]);
            off += 4;
        }
        int left = value.length - eLen;
        if (left > 0) {
            i = (value[eLen] & 0xFF) << 10 | (left == 2 ? (value[value.length - 1] & 0xFF) << 2 : 0);
            IOUtils.putByte(bytes, off, (byte)JSONFactory.CA[i >> 12]);
            IOUtils.putByte(bytes, off + 1, (byte)JSONFactory.CA[i >>> 6 & 0x3F]);
            IOUtils.putByte(bytes, off + 2, left == 2 ? (byte)JSONFactory.CA[i & 0x3F] : (byte)61);
            IOUtils.putByte(bytes, off + 3, (byte)61);
            off += 4;
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeHex(byte[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int charsLen = values.length * 2 + 3;
        int minCapacity = off + charsLen + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putShortLE(bytes, off, (short)10104);
        off += 2;
        for (int i = 0; i < values.length; ++i) {
            IOUtils.putShortLE(bytes, off, IOUtils.hex2U(values[i]));
            off += 2;
        }
        IOUtils.putByte(bytes, off, (byte)39);
        this.off = off + 1;
    }

    @Override
    public final void close() {
        byte[] bytes = this.bytes;
        if (bytes.length > 0x800000) {
            return;
        }
        JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, bytes);
    }

    @Override
    public final int size() {
        return this.off;
    }

    @Override
    public final byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public final byte[] getBytes(Charset charset) {
        if (charset == StandardCharsets.UTF_8) {
            return Arrays.copyOf(this.bytes, this.off);
        }
        return this.toString().getBytes(charset);
    }

    @Override
    public final int flushTo(OutputStream to) throws IOException {
        int off = this.off;
        if (off > 0) {
            to.write(this.bytes, 0, off);
            this.off = 0;
        }
        return off;
    }

    @Override
    protected final void write0(char c) {
        int off = this.off;
        if (off == this.bytes.length) {
            this.ensureCapacity(off + 1);
        }
        IOUtils.putByte(this.bytes, off, (byte)c);
        this.off = off + 1;
    }

    @Override
    public final void writeColon() {
        int off = this.off;
        IOUtils.putByte(this.grow1(off), off, (byte)58);
        this.off = off + 1;
    }

    @Override
    public final void startObject() {
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        this.startObject = true;
        int off = this.off;
        int minCapacity = off + 3 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)123);
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        this.off = off;
    }

    @Override
    public final void endObject() {
        byte[] bytes;
        --this.level;
        int off = this.off;
        int minCapacity = off + 1 + (this.pretty == 0 ? 0 : this.pretty * this.level + 1);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        IOUtils.putByte(bytes, off, (byte)125);
        this.off = off + 1;
        this.startObject = false;
    }

    @Override
    public final void writeComma() {
        this.startObject = false;
        int off = this.off;
        int minCapacity = off + 2 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)44);
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        this.off = off;
    }

    @Override
    public final void startArray() {
        byte[] bytes;
        int off;
        int minCapacity;
        if (++this.level > this.context.maxLevel) {
            this.overflowLevel();
        }
        if ((minCapacity = (off = this.off) + 3 + this.pretty * this.level) > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        this.off = off;
    }

    @Override
    public final void endArray() {
        byte[] bytes;
        --this.level;
        int off = this.off;
        int minCapacity = off + 1 + (this.pretty == 0 ? 0 : this.pretty * this.level + 1);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (this.pretty != 0) {
            off = this.indent(bytes, off);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
        this.startObject = false;
    }

    @Override
    public final void writeString(List<String> list) {
        if (this.pretty != 0) {
            super.writeString(list);
            return;
        }
        int off = this.off;
        byte[] bytes = this.grow1(off);
        IOUtils.putByte(bytes, off, (byte)91);
        this.off = off + 1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                off = this.off;
                bytes = this.grow1(off);
                IOUtils.putByte(bytes, off, (byte)44);
                this.off = off + 1;
            }
            this.writeString(list.get(i));
        }
        off = this.off;
        bytes = this.grow1(off);
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeString(boolean value) {
        byte quote = (byte)this.quote;
        IOUtils.putByte(this.bytes, this.off++, quote);
        this.writeBool(value);
        IOUtils.putByte(this.bytes, this.off++, quote);
    }

    @Override
    public final void writeString(byte value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt8(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(short value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt16(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(int value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt32(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    @Override
    public final void writeString(long value) {
        boolean writeAsString;
        boolean bl = writeAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) == 0L;
        if (writeAsString) {
            this.writeQuote();
        }
        this.writeInt64(value);
        if (writeAsString) {
            this.writeQuote();
        }
    }

    private void writeQuote() {
        this.writeRaw((byte)this.quote);
    }

    @Override
    public void writeString(String str) {
        char c0;
        int i;
        byte[] bytes;
        if (str == null) {
            this.writeStringNull();
            return;
        }
        char[] chars = JDKUtils.getCharArray(str);
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int off = this.off;
        int minCapacity = off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        for (i = 0; i < chars.length && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')'); ++i) {
            IOUtils.putByte(bytes, off++, (byte)c0);
        }
        if (i == chars.length) {
            IOUtils.putByte(bytes, off, (byte)this.quote);
            this.off = off + 1;
            return;
        }
        this.off = off;
        if (i < chars.length) {
            this.writeStringEscapedRest(chars, chars.length, browserSecure, escapeNoneAscii, i);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)this.quote);
    }

    @Override
    public void writeStringLatin1(byte[] value) {
        int i;
        boolean escape = false;
        if ((this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L) {
            this.writeStringLatin1BrowserSecure(value);
            return;
        }
        byte quote = (byte)this.quote;
        long vecQuote = this.byteVectorQuote;
        int upperBound = value.length - i & 0xFFFFFFF8;
        for (i = 0; i < upperBound && JSONWriterUTF8.noneEscaped(IOUtils.getLongUnaligned(value, i), vecQuote); i += 8) {
        }
        while (i < value.length) {
            byte c = value[i];
            if (c == quote || c == 92 || c < 32) {
                escape = true;
                break;
            }
            ++i;
        }
        int off = this.off;
        if (escape) {
            this.writeStringEscaped(value);
            return;
        }
        int minCapacity = off + value.length + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, quote);
        System.arraycopy(value, 0, bytes, off + 1, value.length);
        IOUtils.putByte(bytes, off += value.length + 1, quote);
        this.off = off + 1;
    }

    static boolean noneEscaped(long v, long quote) {
        return (v + 0x6060606060606060L & 0x8080808080808080L) == -9187201950435737472L && ((v ^ quote) + 0x101010101010101L & 0x8080808080808080L) == -9187201950435737472L && ((v ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & 0x8080808080808080L) == -9187201950435737472L;
    }

    protected final void writeStringLatin1BrowserSecure(byte[] values) {
        boolean escape = false;
        byte quote = (byte)this.quote;
        for (int i = 0; i < values.length; ++i) {
            byte c = values[i];
            if (c != quote && c != 92 && c >= 32 && c != 60 && c != 62 && c != 40 && c != 41) continue;
            escape = true;
            break;
        }
        int off = this.off;
        if (!escape) {
            int minCapacity = off + values.length + 2;
            byte[] bytes = this.bytes;
            if (minCapacity > bytes.length) {
                bytes = this.grow(minCapacity);
            }
            IOUtils.putByte(bytes, off, quote);
            System.arraycopy(values, 0, bytes, off + 1, values.length);
            IOUtils.putByte(bytes, off += values.length + 1, quote);
            this.off = off + 1;
            return;
        }
        this.writeStringEscaped(values);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeStringUTF16(byte[] value) {
        byte[] bytes;
        if (value == null) {
            this.writeStringNull();
            return;
        }
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        int off = this.off;
        int minCapacity = off + value.length * 4 + 2;
        if (escapeNoneAscii) {
            minCapacity += value.length * 2;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        int coff = 0;
        int char_len = value.length >> 1;
        block5: while (true) {
            char c;
            block21: {
                int uc;
                block20: {
                    block22: {
                        if (coff >= char_len) {
                            IOUtils.putByte(bytes, off, (byte)this.quote);
                            this.off = off + 1;
                            return;
                        }
                        if ((c = IOUtils.getChar(value, coff++)) < '\u0080') {
                            switch (c) {
                                case '\b': 
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case '\\': {
                                    JSONWriterUTF8.writeEscapedChar(bytes, off, c);
                                    off += 2;
                                    continue block5;
                                }
                                case '\u0000': 
                                case '\u0001': 
                                case '\u0002': 
                                case '\u0003': 
                                case '\u0004': 
                                case '\u0005': 
                                case '\u0006': 
                                case '\u0007': 
                                case '\u000b': 
                                case '\u000e': 
                                case '\u000f': 
                                case '\u0010': 
                                case '\u0011': 
                                case '\u0012': 
                                case '\u0013': 
                                case '\u0014': 
                                case '\u0015': 
                                case '\u0016': 
                                case '\u0017': 
                                case '\u0018': 
                                case '\u0019': 
                                case '\u001a': 
                                case '\u001b': 
                                case '\u001c': 
                                case '\u001d': 
                                case '\u001e': 
                                case '\u001f': {
                                    JSONWriterUTF8.writeU4Hex2(bytes, off, c);
                                    off += 6;
                                    continue block5;
                                }
                                case '(': 
                                case ')': 
                                case '<': 
                                case '>': {
                                    if (browserSecure) {
                                        JSONWriterUTF8.writeU4HexU(bytes, off, c);
                                        off += 6;
                                        continue block5;
                                    }
                                    IOUtils.putByte(bytes, off++, (byte)c);
                                    continue block5;
                                }
                            }
                            if (c == this.quote) {
                                IOUtils.putByte(bytes, off, (byte)92);
                                IOUtils.putByte(bytes, off + 1, (byte)this.quote);
                                off += 2;
                                continue;
                            }
                            IOUtils.putByte(bytes, off++, (byte)c);
                            continue;
                        }
                        if (c < '\u0800') {
                            IOUtils.putByte(bytes, off, (byte)(0xC0 | c >> 6));
                            IOUtils.putByte(bytes, off + 1, (byte)(0x80 | c & 0x3F));
                            off += 2;
                            continue;
                        }
                        if (escapeNoneAscii) {
                            JSONWriterUTF8.writeU4HexU(bytes, off, c);
                            off += 6;
                            continue;
                        }
                        if (c < '\ud800' || c >= '\ue000') break block21;
                        if (c >= '\udc00') break block22;
                        if (coff + 1 > char_len) {
                            uc = -1;
                            break block20;
                        } else {
                            char d = IOUtils.getChar(value, coff);
                            if (d >= '\udc00' && d < '\ue000') {
                                ++coff;
                                uc = (c << 10) + d + -56613888;
                                break block20;
                            } else {
                                IOUtils.putByte(bytes, off++, (byte)63);
                                continue;
                            }
                        }
                    }
                    IOUtils.putByte(bytes, off++, (byte)63);
                    continue;
                }
                if (uc < 0) {
                    IOUtils.putByte(bytes, off++, (byte)63);
                    continue;
                }
                IOUtils.putByte(bytes, off, (byte)(0xF0 | uc >> 18));
                IOUtils.putByte(bytes, off + 1, (byte)(0x80 | uc >> 12 & 0x3F));
                IOUtils.putByte(bytes, off + 2, (byte)(0x80 | uc >> 6 & 0x3F));
                IOUtils.putByte(bytes, off + 3, (byte)(0x80 | uc & 0x3F));
                off += 4;
                continue;
            }
            IOUtils.putByte(bytes, off, (byte)(0xE0 | c >> 12));
            IOUtils.putByte(bytes, off + 1, (byte)(0x80 | c >> 6 & 0x3F));
            IOUtils.putByte(bytes, off + 2, (byte)(0x80 | c & 0x3F));
            off += 3;
        }
    }

    @Override
    public final void writeString(char[] chars) {
        char c;
        int i;
        byte[] bytes;
        if (chars == null) {
            this.writeStringNull();
            return;
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int off = this.off;
        int minCapacity = off + chars.length * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += chars.length * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        for (i = 0; i < chars.length && (c = chars[i]) != this.quote && c != '\\' && c >= ' ' && c <= '\u007f' && (!browserSecure || c != '<' && c != '>' && c != '(' && c != ')'); ++i) {
            IOUtils.putByte(bytes, off++, (byte)c);
        }
        this.off = off;
        if (i < chars.length) {
            this.writeStringEscapedRest(chars, chars.length, browserSecure, escapeNoneAscii, i);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)this.quote);
    }

    @Override
    public final void writeString(char[] chars, int stroff, int strlen) {
        char c0;
        int i;
        byte[] bytes;
        if (chars == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        int end = stroff + strlen;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int off = this.off;
        int minCapacity = off + strlen * 3 + 2;
        if (escapeNoneAscii || browserSecure) {
            minCapacity += strlen * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        for (i = stroff; i < end && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f' && (!browserSecure || c0 != '<' && c0 != '>' && c0 != '(' && c0 != ')'); ++i) {
            IOUtils.putByte(bytes, off++, (byte)c0);
        }
        this.off = off;
        if (i < end) {
            this.writeStringEscapedRest(chars, end, browserSecure, escapeNoneAscii, i);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)this.quote);
    }

    protected final void writeStringEscaped(byte[] values) {
        int minCapacity = this.off + values.length * 6 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        int off = this.off;
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        block5: for (int i = 0; i < values.length; ++i) {
            byte ch = values[i];
            switch (ch) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 92: {
                    JSONWriterUTF8.writeEscapedChar(bytes, off, ch);
                    off += 2;
                    continue block5;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    JSONWriterUTF8.writeU4Hex2(bytes, off, ch);
                    off += 6;
                    continue block5;
                }
                case 40: 
                case 41: 
                case 60: 
                case 62: {
                    if (browserSecure) {
                        JSONWriterUTF8.writeU4HexU(bytes, off, ch);
                        off += 6;
                        continue block5;
                    }
                    IOUtils.putByte(bytes, off++, ch);
                    continue block5;
                }
                default: {
                    if (ch == this.quote) {
                        IOUtils.putByte(bytes, off, (byte)92);
                        IOUtils.putByte(bytes, off + 1, (byte)this.quote);
                        off += 2;
                        continue block5;
                    }
                    if (ch < 0) {
                        int c = ch & 0xFF;
                        IOUtils.putByte(bytes, off, (byte)(0xC0 | c >> 6));
                        IOUtils.putByte(bytes, off + 1, (byte)(0x80 | c & 0x3F));
                        off += 2;
                        continue block5;
                    }
                    IOUtils.putByte(bytes, off++, ch);
                }
            }
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    protected final void writeStringEscapedRest(char[] chars, int end, boolean browserSecure, boolean escapeNoneAscii, int i) {
        int rest = chars.length - i;
        int minCapacity = this.off + rest * 6 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        int off = this.off;
        while (i < end) {
            block14: {
                char ch;
                block16: {
                    int uc;
                    block19: {
                        block17: {
                            block20: {
                                block18: {
                                    block15: {
                                        block13: {
                                            ch = chars[i];
                                            if (ch > '\u007f') break block13;
                                            switch (ch) {
                                                case '\b': 
                                                case '\t': 
                                                case '\n': 
                                                case '\f': 
                                                case '\r': 
                                                case '\\': {
                                                    JSONWriterUTF8.writeEscapedChar(bytes, off, ch);
                                                    off += 2;
                                                    break;
                                                }
                                                case '\u0000': 
                                                case '\u0001': 
                                                case '\u0002': 
                                                case '\u0003': 
                                                case '\u0004': 
                                                case '\u0005': 
                                                case '\u0006': 
                                                case '\u0007': 
                                                case '\u000b': 
                                                case '\u000e': 
                                                case '\u000f': 
                                                case '\u0010': 
                                                case '\u0011': 
                                                case '\u0012': 
                                                case '\u0013': 
                                                case '\u0014': 
                                                case '\u0015': 
                                                case '\u0016': 
                                                case '\u0017': 
                                                case '\u0018': 
                                                case '\u0019': 
                                                case '\u001a': 
                                                case '\u001b': 
                                                case '\u001c': 
                                                case '\u001d': 
                                                case '\u001e': 
                                                case '\u001f': {
                                                    JSONWriterUTF8.writeU4Hex2(bytes, off, ch);
                                                    off += 6;
                                                    break;
                                                }
                                                case '(': 
                                                case ')': 
                                                case '<': 
                                                case '>': {
                                                    if (browserSecure) {
                                                        JSONWriterUTF8.writeU4HexU(bytes, off, ch);
                                                        off += 6;
                                                        break;
                                                    }
                                                    IOUtils.putByte(bytes, off++, (byte)ch);
                                                    break;
                                                }
                                                default: {
                                                    if (ch == this.quote) {
                                                        IOUtils.putByte(bytes, off, (byte)92);
                                                        IOUtils.putByte(bytes, off + 1, (byte)this.quote);
                                                        off += 2;
                                                        break;
                                                    }
                                                    IOUtils.putByte(bytes, off++, (byte)ch);
                                                    break;
                                                }
                                            }
                                            break block14;
                                        }
                                        if (!escapeNoneAscii) break block15;
                                        JSONWriterUTF8.writeU4HexU(bytes, off, ch);
                                        off += 6;
                                        break block14;
                                    }
                                    if (ch < '\ud800' || ch >= '\ue000') break block16;
                                    if (ch >= '\udc00') break block17;
                                    if (chars.length - i >= 2) break block18;
                                    uc = -1;
                                    break block19;
                                }
                                char d = chars[i + 1];
                                if (d < '\udc00' || d >= '\ue000') break block20;
                                uc = (ch << 10) + d + -56613888;
                                break block19;
                            }
                            IOUtils.putByte(bytes, off++, (byte)63);
                            break block14;
                        }
                        IOUtils.putByte(bytes, off++, (byte)63);
                        break block14;
                    }
                    if (uc < 0) {
                        IOUtils.putByte(bytes, off++, (byte)63);
                    } else {
                        IOUtils.putByte(bytes, off, (byte)(0xF0 | uc >> 18));
                        IOUtils.putByte(bytes, off + 1, (byte)(0x80 | uc >> 12 & 0x3F));
                        IOUtils.putByte(bytes, off + 2, (byte)(0x80 | uc >> 6 & 0x3F));
                        IOUtils.putByte(bytes, off + 3, (byte)(0x80 | uc & 0x3F));
                        off += 4;
                        ++i;
                    }
                    break block14;
                }
                if (ch > '\u07ff') {
                    IOUtils.putByte(bytes, off, (byte)(0xE0 | ch >> 12 & 0xF));
                    IOUtils.putByte(bytes, off + 1, (byte)(0x80 | ch >> 6 & 0x3F));
                    IOUtils.putByte(bytes, off + 2, (byte)(0x80 | ch & 0x3F));
                    off += 3;
                } else {
                    IOUtils.putByte(bytes, off, (byte)(0xC0 | ch >> 6 & 0x1F));
                    IOUtils.putByte(bytes, off + 1, (byte)(0x80 | ch & 0x3F));
                    off += 2;
                }
            }
            ++i;
        }
        this.off = off;
    }

    @Override
    public final void writeString(char[] chars, int offset, int len, boolean quoted) {
        char c0;
        int i;
        byte[] bytes;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int minCapacity = this.off + chars.length * 3 + 2;
        if (escapeNoneAscii) {
            minCapacity += len * 3;
        }
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        int off = this.off;
        if (quoted) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        int end = offset + len;
        for (i = offset; i < end && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f'; ++i) {
            IOUtils.putByte(bytes, off++, (byte)c0);
        }
        if (i == end) {
            if (quoted) {
                IOUtils.putByte(bytes, off++, (byte)this.quote);
            }
            this.off = off;
            return;
        }
        while (i < len) {
            block18: {
                char ch;
                block20: {
                    int uc;
                    block23: {
                        block21: {
                            block24: {
                                block22: {
                                    block19: {
                                        block17: {
                                            ch = chars[i];
                                            if (ch > '\u007f') break block17;
                                            switch (ch) {
                                                case '\b': 
                                                case '\t': 
                                                case '\n': 
                                                case '\f': 
                                                case '\r': 
                                                case '\\': {
                                                    JSONWriterUTF8.writeEscapedChar(bytes, off, ch);
                                                    off += 2;
                                                    break;
                                                }
                                                case '\u0000': 
                                                case '\u0001': 
                                                case '\u0002': 
                                                case '\u0003': 
                                                case '\u0004': 
                                                case '\u0005': 
                                                case '\u0006': 
                                                case '\u0007': 
                                                case '\u000b': 
                                                case '\u000e': 
                                                case '\u000f': 
                                                case '\u0010': 
                                                case '\u0011': 
                                                case '\u0012': 
                                                case '\u0013': 
                                                case '\u0014': 
                                                case '\u0015': 
                                                case '\u0016': 
                                                case '\u0017': 
                                                case '\u0018': 
                                                case '\u0019': 
                                                case '\u001a': 
                                                case '\u001b': 
                                                case '\u001c': 
                                                case '\u001d': 
                                                case '\u001e': 
                                                case '\u001f': {
                                                    JSONWriterUTF8.writeU4Hex2(bytes, off, ch);
                                                    off += 6;
                                                    break;
                                                }
                                                default: {
                                                    if (ch == this.quote) {
                                                        IOUtils.putByte(bytes, off, (byte)92);
                                                        IOUtils.putByte(bytes, off + 1, (byte)this.quote);
                                                        off += 2;
                                                        break;
                                                    }
                                                    IOUtils.putByte(bytes, off++, (byte)ch);
                                                    break;
                                                }
                                            }
                                            break block18;
                                        }
                                        if (!escapeNoneAscii) break block19;
                                        JSONWriterUTF8.writeU4HexU(bytes, off, ch);
                                        off += 6;
                                        break block18;
                                    }
                                    if (ch < '\ud800' || ch >= '\ue000') break block20;
                                    if (ch >= '\udc00') break block21;
                                    if (chars.length - i >= 2) break block22;
                                    uc = -1;
                                    break block23;
                                }
                                char d = chars[i + 1];
                                if (d < '\udc00' || d >= '\ue000') break block24;
                                uc = (ch << 10) + d + -56613888;
                                break block23;
                            }
                            IOUtils.putByte(bytes, off++, (byte)63);
                            break block18;
                        }
                        IOUtils.putByte(bytes, off++, (byte)63);
                        break block18;
                    }
                    if (uc < 0) {
                        IOUtils.putByte(bytes, off++, (byte)63);
                    } else {
                        IOUtils.putByte(bytes, off, (byte)(0xF0 | uc >> 18));
                        IOUtils.putByte(bytes, off + 1, (byte)(0x80 | uc >> 12 & 0x3F));
                        IOUtils.putByte(bytes, off + 2, (byte)(0x80 | uc >> 6 & 0x3F));
                        IOUtils.putByte(bytes, off + 3, (byte)(0x80 | uc & 0x3F));
                        off += 4;
                        ++i;
                    }
                    break block18;
                }
                if (ch > '\u07ff') {
                    IOUtils.putByte(bytes, off, (byte)(0xE0 | ch >> 12 & 0xF));
                    IOUtils.putByte(bytes, off + 1, (byte)(0x80 | ch >> 6 & 0x3F));
                    IOUtils.putByte(bytes, off + 2, (byte)(0x80 | ch & 0x3F));
                    off += 3;
                } else {
                    IOUtils.putByte(bytes, off, (byte)(0xC0 | ch >> 6 & 0x1F));
                    IOUtils.putByte(bytes, off + 1, (byte)(0x80 | ch & 0x3F));
                    off += 2;
                }
            }
            ++i;
        }
        if (quoted) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        this.off = off;
    }

    @Override
    public final void writeString(String[] strings) {
        if (strings == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < strings.length; ++i) {
            String item;
            if (i != 0) {
                this.writeComma();
            }
            if ((item = strings[i]) == null) {
                if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                    this.writeString("");
                    continue;
                }
                this.writeNull();
                continue;
            }
            this.writeString(item);
        }
        this.endArray();
    }

    @Override
    public final void writeChar(char ch) {
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 8 > bytes.length) {
            bytes = this.grow(off + 8);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        if (ch <= '\u007f') {
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    JSONWriterUTF8.writeEscapedChar(bytes, off, ch);
                    off += 2;
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    JSONWriterUTF8.writeU4Hex2(bytes, off, ch);
                    off += 6;
                    break;
                }
                default: {
                    if (ch == this.quote) {
                        IOUtils.putByte(bytes, off, (byte)92);
                        IOUtils.putByte(bytes, off + 1, (byte)this.quote);
                        off += 2;
                        break;
                    }
                    IOUtils.putByte(bytes, off++, (byte)ch);
                    break;
                }
            }
        } else {
            if (ch >= '\ud800' && ch < '\ue000') {
                throw new JSONException("illegal char " + ch);
            }
            if (ch > '\u07ff') {
                IOUtils.putByte(bytes, off, (byte)(0xE0 | ch >> 12 & 0xF));
                IOUtils.putByte(bytes, off + 1, (byte)(0x80 | ch >> 6 & 0x3F));
                IOUtils.putByte(bytes, off + 2, (byte)(0x80 | ch & 0x3F));
                off += 3;
            } else {
                IOUtils.putByte(bytes, off, (byte)(0xC0 | ch >> 6 & 0x1F));
                IOUtils.putByte(bytes, off + 1, (byte)(0x80 | ch & 0x3F));
                off += 2;
            }
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    static int packDigits(int b0, int b1) {
        int v = HEX256[b0 & 0xFF] | HEX256[b1 & 0xFF] << 16;
        return JDKUtils.BIG_ENDIAN ? Integer.reverseBytes(v) : v;
    }

    static long packDigits(int b0, int b1, int b2, int b3) {
        short[] digits = HEX256;
        long v = (long)digits[b0 & 0xFF] | (long)digits[b1 & 0xFF] << 16 | (long)digits[b2 & 0xFF] << 32 | (long)digits[b3 & 0xFF] << 48;
        return JDKUtils.BIG_ENDIAN ? Long.reverseBytes(v) : v;
    }

    @Override
    public final void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        int off = this.off;
        int minCapacity = off + 38;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        long base = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off;
        JDKUtils.UNSAFE.putByte(bytes, base, (byte)34);
        JDKUtils.UNSAFE.putLong(bytes, base + 1L, JSONWriterUTF8.packDigits((int)(msb >> 56), (int)(msb >> 48), (int)(msb >> 40), (int)(msb >> 32)));
        JDKUtils.UNSAFE.putByte(bytes, base + 9L, (byte)45);
        JDKUtils.UNSAFE.putLong(bytes, base + 10L, JSONWriterUTF8.packDigits((int)msb >> 24, (int)msb >> 16));
        JDKUtils.UNSAFE.putByte(bytes, base + 14L, (byte)45);
        JDKUtils.UNSAFE.putLong(bytes, base + 15L, JSONWriterUTF8.packDigits((int)msb >> 8, (int)msb));
        JDKUtils.UNSAFE.putByte(bytes, base + 19L, (byte)45);
        JDKUtils.UNSAFE.putLong(bytes, base + 20L, JSONWriterUTF8.packDigits((int)(lsb >> 56), (int)(lsb >> 48)));
        JDKUtils.UNSAFE.putByte(bytes, base + 24L, (byte)45);
        JDKUtils.UNSAFE.putLong(bytes, base + 25L, JSONWriterUTF8.packDigits((int)(lsb >> 40), (int)(lsb >> 32), (int)lsb >> 24, (int)lsb >> 16));
        JDKUtils.UNSAFE.putLong(bytes, base + 33L, JSONWriterUTF8.packDigits((int)lsb >> 8, (int)lsb));
        JDKUtils.UNSAFE.putByte(bytes, base + 37L, (byte)34);
        this.off += 38;
    }

    @Override
    public final void writeRaw(String str) {
        byte[] bytes;
        int off = this.off;
        char[] chars = JDKUtils.getCharArray(str);
        int minCapacity = off + chars.length * 3;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                IOUtils.putByte(bytes, off++, (byte)c);
                continue;
            }
            if (c > '\u07ff') {
                IOUtils.putByte(bytes, off, (byte)(0xE0 | c >> 12 & 0xF));
                IOUtils.putByte(bytes, off + 1, (byte)(0x80 | c >> 6 & 0x3F));
                IOUtils.putByte(bytes, off + 2, (byte)(0x80 | c & 0x3F));
                off += 3;
                continue;
            }
            IOUtils.putByte(bytes, off, (byte)(0xC0 | c >> 6 & 0x1F));
            IOUtils.putByte(bytes, off + 1, (byte)(0x80 | c & 0x3F));
            off += 2;
        }
        this.off = off;
    }

    @Override
    public final void writeRaw(byte[] raw) {
        int off = this.off;
        int minCapacity = off + raw.length;
        if (minCapacity > this.bytes.length) {
            this.grow(minCapacity);
        }
        System.arraycopy(raw, 0, this.bytes, off, raw.length);
        this.off = off + raw.length;
    }

    @Override
    public final void writeNameRaw(byte[] name) {
        int off = this.off;
        int minCapacity = off + name.length + 2 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        System.arraycopy(name, 0, bytes, off, name.length);
        this.off = off + name.length;
    }

    @Override
    public final void writeName2Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 5;
    }

    private int indent(byte[] bytes, int off) {
        IOUtils.putByte(bytes, off, (byte)10);
        int toIndex = off + 1 + this.pretty * this.level;
        Arrays.fill(bytes, off + 1, toIndex, this.pretty == 1 ? (byte)9 : 32);
        return toIndex;
    }

    @Override
    public final void writeName3Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 6;
    }

    @Override
    public final void writeName4Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 7;
    }

    @Override
    public final void writeName5Raw(long name) {
        int off = this.off;
        int minCapacity = off + 10 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        this.off = off + 8;
    }

    @Override
    public final void writeName6Raw(long name) {
        int off = this.off;
        int minCapacity = off + 11 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        IOUtils.putByte(bytes, off + 8, (byte)58);
        this.off = off + 9;
    }

    @Override
    public final void writeName7Raw(long name) {
        int off = this.off;
        int minCapacity = off + 12 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name);
        IOUtils.putByte(bytes, off + 8, (byte)this.quote);
        IOUtils.putByte(bytes, off + 9, (byte)58);
        this.off = off + 10;
    }

    @Override
    public final void writeName8Raw(long name) {
        int off = this.off;
        int minCapacity = off + 13 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 1L, name);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 9L, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 11;
    }

    @Override
    public final void writeName9Raw(long name0, int name1) {
        int off = this.off;
        int minCapacity = off + 14 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 12;
    }

    @Override
    public final void writeName10Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 13;
    }

    @Override
    public final void writeName11Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 14;
    }

    @Override
    public final void writeName12Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 15;
    }

    @Override
    public final void writeName13Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 18 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        this.off = off + 16;
    }

    @Override
    public final void writeName14Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 19 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        IOUtils.putByte(bytes, off + 16, (byte)58);
        this.off = off + 17;
    }

    @Override
    public final void writeName15Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 20 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 16L, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 18;
    }

    @Override
    public final void writeName16Raw(long name0, long name1) {
        int off = this.off;
        int minCapacity = off + 21 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, name0);
        JDKUtils.UNSAFE.putLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 8L, name1);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 16L, this.useSingleQuote ? QUOTE_COLON : QUOTE2_COLON);
        this.off = off + 18;
    }

    @Override
    public final void writeRaw(byte b) {
        int off = this.off;
        IOUtils.putByte(this.grow1(off), off, b);
        this.off = off + 1;
    }

    @Override
    public final void writeRaw(char ch) {
        if (ch > '\u0080') {
            throw new JSONException("not support " + ch);
        }
        if (this.off == this.bytes.length) {
            this.ensureCapacity(this.off + 1);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)ch);
    }

    @Override
    public final void writeRaw(char c0, char c1) {
        if (c0 > '\u0080' || c1 > '\u0080') {
            throw new JSONException("not support " + c0 + ", " + c1);
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 2 > bytes.length) {
            bytes = this.grow(off + 2);
        }
        IOUtils.putByte(bytes, off, (byte)c0);
        IOUtils.putByte(bytes, off + 1, (byte)c1);
        this.off = off + 2;
    }

    @Override
    public final void writeNameRaw(byte[] name, int coff, int len) {
        int off = this.off;
        int minCapacity = off + len + 2 + this.pretty * this.level;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (!this.startObject) {
            IOUtils.putByte(bytes, off++, (byte)44);
            if (this.pretty != 0) {
                off = this.indent(bytes, off);
            }
        }
        this.startObject = false;
        System.arraycopy(name, coff, bytes, off, len);
        this.off = off + len;
    }

    final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.bytes.length) {
            this.grow0(minCapacity);
        }
    }

    private byte[] grow(int minCapacity) {
        this.grow0(minCapacity);
        return this.bytes;
    }

    private byte[] grow1(int off) {
        byte[] bytes = this.bytes;
        if (off == bytes.length) {
            bytes = this.grow(off + 1);
        }
        return bytes;
    }

    private void grow0(int minCapacity) {
        this.bytes = Arrays.copyOf(this.bytes, this.newCapacity(minCapacity, this.bytes.length));
    }

    @Override
    public final void writeInt32(int[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 13 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if (writeAsString) {
                IOUtils.putByte(bytes, off++, (byte)this.quote);
            }
            off = IOUtils.writeInt32(bytes, off, values[i]);
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeInt8(byte i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        off = IOUtils.writeInt8(bytes, off, i);
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        this.off = off;
    }

    @Override
    public final void writeInt8(byte[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 5 + 2;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if (writeAsString) {
                IOUtils.putByte(bytes, off++, (byte)this.quote);
            }
            off = IOUtils.writeInt8(bytes, off, values[i]);
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeInt16(short i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 7;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        off = IOUtils.writeInt16(bytes, off, i);
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        this.off = off;
    }

    @Override
    public final void writeInt32(Integer i) {
        if (i == null) {
            this.writeNumberNull();
        } else {
            this.writeInt32((int)i);
        }
    }

    @Override
    public final void writeInt32(int i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 13;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        off = IOUtils.writeInt32(bytes, off, i);
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        this.off = off;
    }

    @Override
    public final void writeListInt32(List<Integer> values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int size = values.size();
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 2 + size * 23;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < size; ++i) {
            Number item;
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if ((item = (Number)values.get(i)) == null) {
                IOUtils.putNULL(bytes, off);
                off += 4;
                continue;
            }
            int v = item.intValue();
            if (writeAsString) {
                IOUtils.putByte(bytes, off++, (byte)this.quote);
            }
            off = IOUtils.writeInt32(bytes, off, v);
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeInt64(long[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 2 + values.length * 23;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < values.length; ++i) {
            long v;
            boolean writeAsString;
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if (writeAsString = JSONWriterUTF8.isWriteAsString(v = values[i], this.context.features)) {
                IOUtils.putByte(bytes, off++, (byte)this.quote);
            }
            off = IOUtils.writeInt64(bytes, off, v);
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeListInt64(List<Long> values) {
        byte[] bytes;
        if (values == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int size = values.size();
        int minCapacity = off + 2 + size * 23;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < size; ++i) {
            Long item;
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if ((item = values.get(i)) == null) {
                IOUtils.putNULL(bytes, off);
                off += 4;
                continue;
            }
            long v = item;
            boolean writeAsString = JSONWriterUTF8.isWriteAsString(v, this.context.features);
            if (writeAsString) {
                IOUtils.putByte(bytes, off++, (byte)this.quote);
            }
            off = IOUtils.writeInt64(bytes, off, v);
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeInt64(long i) {
        long features = this.context.features;
        boolean writeAsString = JSONWriterUTF8.isWriteAsString(i, features);
        int off = this.off;
        int minCapacity = off + 23;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        }
        off = IOUtils.writeInt64(bytes, off, i);
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)this.quote);
        } else if ((features & JSONWriter.Feature.WriteClassName.mask) != 0L && (features & JSONWriter.Feature.NotWriteNumberClassName.mask) == 0L && i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE) {
            IOUtils.putByte(bytes, off++, (byte)76);
        }
        this.off = off;
    }

    @Override
    public final void writeInt64(Long i) {
        if (i == null) {
            this.writeNumberNull();
        } else {
            this.writeInt64((long)i);
        }
    }

    @Override
    public final void writeFloat(float value) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 17;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        int len = DoubleToDecimal.toString(value, bytes, off, true);
        off += len;
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        this.off = off;
    }

    @Override
    public final void writeDouble(double value) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + 26;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        off += DoubleToDecimal.toString(value, bytes, off, true);
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        this.off = off;
    }

    @Override
    public final void writeFloat(float[] values) {
        byte[] bytes;
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int off = this.off;
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = off + values.length * (writeAsString ? 16 : 18) + 1;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if (writeAsString) {
                IOUtils.putByte(bytes, off++, (byte)34);
            }
            float value = values[i];
            int len = DoubleToDecimal.toString(value, bytes, off, true);
            off += len;
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeDouble(double[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int off = this.off;
        int minCapacity = off + values.length * 27 + 1;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)91);
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                IOUtils.putByte(bytes, off++, (byte)44);
            }
            if (writeAsString) {
                IOUtils.putByte(bytes, off++, (byte)34);
            }
            double value = values[i];
            int len = DoubleToDecimal.toString(value, bytes, off, true);
            off += len;
            if (!writeAsString) continue;
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        IOUtils.putByte(bytes, off, (byte)93);
        this.off = off + 1;
    }

    @Override
    public final void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 16;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF8.illegalYear(year);
        }
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        IOUtils.writeDigitPair(bytes, off + 1, y01);
        IOUtils.writeDigitPair(bytes, off + 3, y23);
        IOUtils.writeDigitPair(bytes, off + 5, month);
        IOUtils.writeDigitPair(bytes, off + 7, dayOfMonth);
        IOUtils.writeDigitPair(bytes, off + 9, hour);
        IOUtils.writeDigitPair(bytes, off + 11, minute);
        IOUtils.writeDigitPair(bytes, off + 13, second);
        IOUtils.putByte(bytes, off + 15, (byte)this.quote);
        this.off = off + 16;
    }

    @Override
    public final void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 21;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        off = IOUtils.writeLocalDate(bytes, off + 1, year, month, dayOfMonth);
        IOUtils.putByte(bytes, off, (byte)32);
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        IOUtils.putByte(bytes, off + 9, (byte)this.quote);
        this.off = off + 10;
    }

    @Override
    public final void writeLocalDate(LocalDate date) {
        if (date == null) {
            this.writeNull();
            return;
        }
        if (this.context.dateFormat != null && this.writeLocalDateWithFormat(date)) {
            return;
        }
        int off = this.off;
        int minCapacity = off + 18;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        off = IOUtils.writeLocalDate(bytes, off, date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeLocalDateTime(LocalDateTime dateTime) {
        int off = this.off;
        int minCapacity = off + 38;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        LocalDate localDate = dateTime.toLocalDate();
        off = IOUtils.writeLocalDate(bytes, off, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        IOUtils.putByte(bytes, off++, (byte)32);
        off = IOUtils.writeLocalTime(bytes, off, dateTime.toLocalTime());
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        int off = this.off;
        int minCapacity = off + 10;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        if (year < 0 || year > 9999) {
            throw JSONWriterUTF8.illegalYear(year);
        }
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        IOUtils.writeDigitPair(bytes, off + 1, y01);
        IOUtils.writeDigitPair(bytes, off + 3, y23);
        IOUtils.writeDigitPair(bytes, off + 5, month);
        IOUtils.writeDigitPair(bytes, off + 7, dayOfMonth);
        IOUtils.putByte(bytes, off + 9, (byte)this.quote);
        this.off = off + 10;
    }

    @Override
    public final void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        int off = this.off;
        int minCapacity = off + 13;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        off = IOUtils.writeLocalDate(bytes, off, year, month, dayOfMonth);
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeTimeHHMMSS8(int hour, int minute, int second) {
        int off = this.off;
        int minCapacity = off + 10;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        IOUtils.putByte(bytes, off + 9, (byte)this.quote);
        this.off = off + 10;
    }

    @Override
    public final void writeLocalTime(LocalTime time) {
        int off = this.off;
        int minCapacity = off + 20;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off++, (byte)this.quote);
        off = IOUtils.writeLocalTime(bytes, off, time);
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeZonedDateTime(ZonedDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneId zone = dateTime.getZone();
        String zoneId = zone.getId();
        int zoneIdLength = zoneId.length();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == zone || zoneIdLength <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneIdLength != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneIdLength : 2 + zoneIdLength;
        }
        int off = this.off;
        int minCapacity = off + zoneSize + 38;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        LocalDate localDate = dateTime.toLocalDate();
        off = IOUtils.writeLocalDate(bytes, off + 1, localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        IOUtils.putByte(bytes, off, (byte)84);
        off = IOUtils.writeLocalTime(bytes, off + 1, dateTime.toLocalTime());
        if (zoneSize == 1) {
            IOUtils.putByte(bytes, off++, (byte)90);
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getBytes(0, zoneIdLength, bytes, off);
            off += zoneIdLength;
        } else {
            IOUtils.putByte(bytes, off++, (byte)91);
            zoneId.getBytes(0, zoneIdLength, bytes, off);
            off += zoneIdLength;
            IOUtils.putByte(bytes, off++, (byte)93);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeOffsetDateTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 45;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        LocalDateTime ldt = dateTime.toLocalDateTime();
        LocalDate date = ldt.toLocalDate();
        off = IOUtils.writeLocalDate(bytes, off + 1, date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        IOUtils.putByte(bytes, off, (byte)84);
        off = IOUtils.writeLocalTime(bytes, off + 1, ldt.toLocalTime());
        ZoneOffset offset = dateTime.getOffset();
        if (offset.getTotalSeconds() == 0) {
            IOUtils.putByte(bytes, off++, (byte)90);
        } else {
            String zoneId = offset.getId();
            zoneId.getBytes(0, zoneId.length(), bytes, off);
            off += zoneId.length();
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeOffsetTime(OffsetTime time) {
        if (time == null) {
            this.writeNull();
            return;
        }
        int off = this.off;
        int minCapacity = off + 28;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        off = IOUtils.writeLocalTime(bytes, off + 1, time.toLocalTime());
        ZoneOffset offset = time.getOffset();
        if (offset.getTotalSeconds() == 0) {
            IOUtils.putByte(bytes, off++, (byte)90);
        } else {
            String zoneId = offset.getId();
            zoneId.getBytes(0, zoneId.length(), bytes, off);
            off += zoneId.length();
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeBigInt(BigInteger value, long features) {
        byte[] bytes;
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (TypeUtils.isInt64(value) && features == 0L) {
            this.writeInt64(value.longValue());
            return;
        }
        String str = value.toString(10);
        boolean writeAsString = JSONWriterUTF8.isWriteAsString(value, this.context.features | features);
        int off = this.off;
        int strlen = str.length();
        int minCapacity = off + strlen + (writeAsString ? 2 : 0);
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        str.getBytes(0, strlen, bytes, off);
        off += strlen;
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        this.off = off;
    }

    @Override
    public final void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        byte[] bytes;
        int off = this.off;
        int zonelen = timeZone ? (offsetSeconds == 0 ? 1 : 6) : 0;
        int minCapacity = off + 25 + zonelen;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        off = IOUtils.writeLocalDate(bytes, off + 1, year, month, dayOfMonth);
        IOUtils.putByte(bytes, off, (byte)(timeZone ? 84 : 32));
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        off += 9;
        if (millis > 0) {
            int div = millis / 10;
            int div2 = div / 10;
            int rem1 = millis - div * 10;
            if (rem1 != 0) {
                IOUtils.putIntLE(bytes, off, IOUtils.DIGITS_K_32[millis & 0x3FF] & 0xFFFFFF00 | 0x2E);
                off += 4;
            } else {
                IOUtils.putByte(bytes, off++, (byte)46);
                int rem2 = div - div2 * 10;
                if (rem2 != 0) {
                    IOUtils.writeDigitPair(bytes, off, div);
                    off += 2;
                } else {
                    IOUtils.putByte(bytes, off++, (byte)(div2 + 48));
                }
            }
        }
        if (timeZone) {
            int offset = offsetSeconds / 3600;
            if (offsetSeconds == 0) {
                IOUtils.putByte(bytes, off++, (byte)90);
            } else {
                int offsetAbs = Math.abs(offset);
                IOUtils.putByte(bytes, off, offset >= 0 ? (byte)43 : 45);
                IOUtils.writeDigitPair(bytes, off + 1, offsetAbs);
                IOUtils.putByte(bytes, off + 3, (byte)58);
                int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.writeDigitPair(bytes, off + 4, offsetMinutes);
                off += 6;
            }
        }
        IOUtils.putByte(bytes, off, (byte)this.quote);
        this.off = off + 1;
    }

    @Override
    public final void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        long unscaleValue;
        int scale;
        boolean asPlain;
        byte[] bytes;
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (format != null) {
            String str = format.format(value);
            this.writeRaw(str);
            return;
        }
        int precision = value.precision();
        boolean writeAsString = JSONWriterUTF8.isWriteAsString(value, features |= this.context.features);
        int off = this.off;
        int minCapacity = off + precision + value.scale() + 7;
        if (minCapacity > (bytes = this.bytes).length) {
            bytes = this.grow(minCapacity);
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        boolean bl = asPlain = (features & JSONWriter.Feature.WriteBigDecimalAsPlain.mask) != 0L;
        if (precision < 19 && (scale = value.scale()) >= 0 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L && (unscaleValue = JDKUtils.UNSAFE.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET)) != Long.MIN_VALUE && !asPlain) {
            off = IOUtils.writeDecimal(bytes, off, unscaleValue, scale);
        } else {
            String str = asPlain ? value.toPlainString() : value.toString();
            str.getBytes(0, str.length(), bytes, off);
            off += str.length();
        }
        if (writeAsString) {
            IOUtils.putByte(bytes, off++, (byte)34);
        }
        this.off = off;
    }

    @Override
    public final void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void write(Map<?, ?> map) {
        if (this.pretty != 0) {
            super.write(map);
            return;
        }
        if (map == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)123);
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null && (this.context.features & JSONWriter.Feature.WriteMapNullValue.mask) == 0L) continue;
            if (!first) {
                if (this.off == this.bytes.length) {
                    this.ensureCapacity(this.off + 1);
                }
                IOUtils.putByte(this.bytes, this.off++, (byte)44);
            }
            first = false;
            Object key = entry.getKey();
            if (key instanceof String) {
                this.writeString((String)key);
            } else {
                this.writeAny(key);
            }
            if (this.off == this.bytes.length) {
                this.ensureCapacity(this.off + 1);
            }
            IOUtils.putByte(this.bytes, this.off++, (byte)58);
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)125);
    }

    @Override
    public final void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)91);
        boolean first = true;
        for (int i = 0; i < array.size(); ++i) {
            Object o = array.get(i);
            if (!first) {
                if (this.off == this.bytes.length) {
                    this.grow(this.off + 1);
                }
                IOUtils.putByte(this.bytes, this.off++, (byte)44);
            }
            first = false;
            if (o == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = o.getClass();
            if (valueClass == String.class) {
                this.writeString((String)o);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)o);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)o);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)o);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)o, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)o);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)o);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, o, null, null, 0L);
        }
        if (this.off == this.bytes.length) {
            this.grow(this.off + 1);
        }
        IOUtils.putByte(this.bytes, this.off++, (byte)93);
    }

    @Override
    public void writeBool(boolean value) {
        int minCapacity = this.off + 5;
        byte[] bytes = this.bytes;
        if (minCapacity > bytes.length) {
            bytes = this.grow(minCapacity);
        }
        int off = this.off;
        if ((this.context.features & JSONWriter.Feature.WriteBooleanAsNumber.mask) != 0L) {
            IOUtils.putByte(bytes, off++, (byte)(value ? 49 : 48));
        } else {
            off = IOUtils.putBoolean(bytes, off, value);
        }
        this.off = off;
    }

    public final String toString() {
        return new String(this.bytes, 0, this.off, StandardCharsets.UTF_8);
    }

    @Override
    public final int flushTo(OutputStream out, Charset charset) throws IOException {
        if (this.off == 0) {
            return 0;
        }
        if (charset == null || charset == StandardCharsets.UTF_8 || charset == StandardCharsets.US_ASCII) {
            int len = this.off;
            out.write(this.bytes, 0, this.off);
            this.off = 0;
            return len;
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            boolean hasNegative = false;
            if (JDKUtils.METHOD_HANDLE_HAS_NEGATIVE != null) {
                try {
                    hasNegative = JDKUtils.METHOD_HANDLE_HAS_NEGATIVE.invoke(this.bytes, 0, this.bytes.length);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!hasNegative) {
                int len = this.off;
                out.write(this.bytes, 0, this.off);
                this.off = 0;
                return len;
            }
        }
        String str = new String(this.bytes, 0, this.off);
        byte[] encodedBytes = str.getBytes(charset);
        out.write(encodedBytes);
        return encodedBytes.length;
    }

    static void writeEscapedChar(byte[] bytes, int off, int c0) {
        IOUtils.putShortLE(bytes, off, ESCAPED_CHARS[c0 & 0x7F]);
    }

    static void writeU4Hex2(byte[] bytes, int off, int c) {
        IOUtils.putIntUnaligned(bytes, off, U4);
        IOUtils.putShortLE(bytes, off + 4, IOUtils.hex2(c));
    }

    static void writeU4HexU(byte[] bytes, int off, int c) {
        IOUtils.putShortUnaligned(bytes, off, U2);
        IOUtils.putIntLE(bytes, off + 2, IOUtils.hex4U(c));
    }

    static {
        short[] digits = new short[256];
        for (int i = 0; i < 16; ++i) {
            short hi = (short)(i < 10 ? i + 48 : i - 10 + 97);
            for (int j = 0; j < 16; ++j) {
                short lo = (short)(j < 10 ? j + 48 : j - 10 + 97);
                digits[(i << 4) + j] = JDKUtils.BIG_ENDIAN ? (short)(hi << 8 | lo) : (short)(hi | lo << 8);
            }
        }
        HEX256 = digits;
        byte[] chars = new byte[]{123, 34, 36, 114, 101, 102, 34, 58};
        REF = JDKUtils.UNSAFE.getLong(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET);
        QUOTE2_COLON = JDKUtils.UNSAFE.getShort(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 6L);
        chars[6] = 39;
        QUOTE_COLON = JDKUtils.UNSAFE.getShort(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + 6L);
        byte[] bytes = "\\u00".getBytes(StandardCharsets.UTF_8);
        U2 = JDKUtils.UNSAFE.getShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
        U4 = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
        int slash = 92;
        short[] shorts = new short[128];
        shorts[92] = (short)(slash | 0x5C00);
        shorts[10] = (short)(slash | 0x6E00);
        shorts[13] = (short)(slash | 0x7200);
        shorts[12] = (short)(slash | 0x6600);
        shorts[8] = (short)(slash | 0x6200);
        shorts[9] = (short)(slash | 0x7400);
        ESCAPED_CHARS = shorts;
    }
}

