/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.RyuFloat;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

class JSONWriterUTF16
extends JSONWriter {
    protected char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(JSONFactory.CACHE, null);

    JSONWriterUTF16(JSONWriter.Context ctx) {
        super(ctx, StandardCharsets.UTF_16);
        if (this.chars == null) {
            this.chars = new char[1024];
        }
    }

    @Override
    public void flushTo(Writer to) {
        try {
            to.write(this.chars, 0, this.off);
        }
        catch (IOException e) {
            throw new JSONException("flushTo error", e);
        }
    }

    @Override
    public void close() {
        if (this.chars.length > 0x100000) {
            return;
        }
        JSONFactory.CHARS_UPDATER.set(JSONFactory.CACHE, this.chars);
    }

    @Override
    protected void write0(char c) {
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = c;
    }

    @Override
    public void startObject() {
        ++this.level;
        this.startObject = true;
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 123;
    }

    @Override
    public void endObject() {
        --this.level;
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 125;
        this.startObject = false;
    }

    @Override
    public void writeComma() {
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 44;
    }

    @Override
    public void startArray() {
        ++this.level;
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 91;
    }

    @Override
    public void endArray() {
        --this.level;
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public void writeString(String str) {
        char c1;
        char c0;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        int strlen = str.length();
        boolean special = false;
        int i = 0;
        while (i + 4 <= strlen) {
            c0 = str.charAt(i);
            c1 = str.charAt(i + 1);
            char c2 = str.charAt(i + 2);
            char c3 = str.charAt(i + 3);
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote) {
                special = true;
                break;
            }
            if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') {
                special = true;
                break;
            }
            if (c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ') {
                special = true;
                break;
            }
            i += 4;
        }
        if (!special && i + 2 <= strlen) {
            c0 = str.charAt(i);
            c1 = str.charAt(i + 1);
            if (c0 == this.quote || c1 == this.quote || c0 == '\\' || c1 == '\\' || c0 < ' ' || c1 < ' ') {
                special = true;
            } else {
                i += 2;
            }
        }
        if (!special && i + 1 == strlen) {
            c0 = str.charAt(i);
            boolean bl = special = c0 == '\"' || c0 == '\\' || c0 < ' ';
        }
        if (!special) {
            int minCapacity = this.off + strlen + 2;
            if (minCapacity - this.chars.length > 0) {
                int oldCapacity = this.chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - MAX_ARRAY_SIZE > 0) {
                    throw new OutOfMemoryError();
                }
                this.chars = Arrays.copyOf(this.chars, newCapacity);
            }
            this.chars[this.off++] = this.quote;
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
            this.chars[this.off++] = this.quote;
            return;
        }
        this.ensureCapacity(this.off + strlen * 2 + 2);
        this.chars[this.off++] = this.quote;
        block10: for (i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block10;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block10;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block10;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block10;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block10;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block10;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block10;
                }
                default: {
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public void writeReference(String path) {
        this.lastReference = path;
        this.startObject();
        this.writeName("$ref");
        this.writeColon();
        this.writeString(path);
        this.endObject();
    }

    @Override
    public void writeBase64(byte[] bytes) {
        int i;
        int charsLen = (bytes.length - 1) / 3 + 1 << 2;
        this.ensureCapacity(this.off + charsLen + 2);
        this.chars[this.off++] = 34;
        int eLen = bytes.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.chars[this.off++] = JSONFactory.CA[i >>> 18 & 0x3F];
            this.chars[this.off++] = JSONFactory.CA[i >>> 12 & 0x3F];
            this.chars[this.off++] = JSONFactory.CA[i >>> 6 & 0x3F];
            this.chars[this.off++] = JSONFactory.CA[i & 0x3F];
        }
        int left = bytes.length - eLen;
        if (left > 0) {
            i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytes.length - 1] & 0xFF) << 2 : 0);
            this.chars[this.off++] = JSONFactory.CA[i >> 12];
            this.chars[this.off++] = JSONFactory.CA[i >>> 6 & 0x3F];
            this.chars[this.off++] = left == 2 ? JSONFactory.CA[i & 0x3F] : 61;
            this.chars[this.off++] = 61;
        }
        this.chars[this.off++] = 34;
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        boolean browserCompatible;
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        String str = value.toString(10);
        boolean bl = browserCompatible = ((this.context.features | features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L;
        if (browserCompatible && (value.compareTo(JSONFactory.LOW_BIGINT) < 0 || value.compareTo(JSONFactory.HIGH_BIGINT) > 0)) {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen + 2);
            this.chars[this.off++] = 34;
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
            this.chars[this.off++] = 34;
        } else {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen);
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
        }
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        String str = value.toString();
        if ((this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0)) {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen + 2);
            this.chars[this.off++] = 34;
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
            this.chars[this.off++] = 34;
        } else {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen);
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
        }
    }

    @Override
    public void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        this.ensureCapacity(this.off + 38);
        this.chars[this.off++] = 34;
        JSONWriterUTF16.formatUnsignedLong0(lsb, this.chars, this.off + 24, 12);
        JSONWriterUTF16.formatUnsignedLong0(lsb >>> 48, this.chars, this.off + 19, 4);
        JSONWriterUTF16.formatUnsignedLong0(msb, this.chars, this.off + 14, 4);
        JSONWriterUTF16.formatUnsignedLong0(msb >>> 16, this.chars, this.off + 9, 4);
        JSONWriterUTF16.formatUnsignedLong0(msb >>> 32, this.chars, this.off + 0, 8);
        this.chars[this.off + 23] = 45;
        this.chars[this.off + 18] = 45;
        this.chars[this.off + 13] = 45;
        this.chars[this.off + 8] = 45;
        this.off += 36;
        this.chars[this.off++] = 34;
    }

    @Override
    public void writeRaw(String str) {
        this.ensureCapacity(this.off + str.length());
        str.getChars(0, str.length(), this.chars, this.off);
        this.off += str.length();
    }

    @Override
    public void writeRaw(char[] chars) {
        int minCapacity = this.off + chars.length;
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        System.arraycopy(chars, 0, this.chars, this.off, chars.length);
        this.off += chars.length;
    }

    @Override
    public void writeRaw(char ch) {
        if (this.off == this.chars.length) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = ch;
    }

    @Override
    public void writeNameRaw(char[] chars) {
        int minCapacity = this.off + chars.length + (this.startObject ? 0 : 1);
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.chars[this.off++] = 44;
        }
        System.arraycopy(chars, 0, this.chars, this.off, chars.length);
        this.off += chars.length;
    }

    @Override
    public void writeNameRaw(char[] chars, int off, int len) {
        int minCapacity = this.off + len + (this.startObject ? 0 : 1);
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.chars[this.off++] = 44;
        }
        System.arraycopy(chars, off, this.chars, this.off, len);
        this.off += len;
    }

    void ensureCapacity(int minCapacity) {
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
    }

    @Override
    public void writeInt32(int i) {
        int r;
        int q;
        int index;
        int minCapacity;
        int x;
        if ((this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            this.writeString(Integer.toString(i));
            return;
        }
        if (i == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int n = x = i < 0 ? -i : i;
        int size = x <= 9 ? 1 : (x <= 99 ? 2 : (x <= 999 ? 3 : (x <= 9999 ? 4 : (x <= 99999 ? 5 : (x <= 999999 ? 6 : (x <= 9999999 ? 7 : (x <= 99999999 ? 8 : (x <= 999999999 ? 9 : 10))))))));
        if (i < 0) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        int p = index = this.off + size;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.chars[--p] = (char)IOUtils.DigitOnes[r];
            this.chars[--p] = (char)IOUtils.DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.chars[--p] = (char)IOUtils.digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            this.chars[--p] = sign;
        }
        this.off += size;
    }

    @Override
    public void writeInt64(long i) {
        int q2;
        int r;
        int index;
        int minCapacity;
        long x;
        if ((this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L || (this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (i > 0x1FFFFFFFFFFFFFL || i < -9007199254740991L)) {
            String str = Long.toString(i);
            this.writeString(str);
            return;
        }
        if (i == Long.MIN_VALUE) {
            this.writeRaw("-9223372036854775808");
            return;
        }
        long l = x = i < 0L ? -i : i;
        int size = x <= 9L ? 1 : (x <= 99L ? 2 : (x <= 999L ? 3 : (x <= 9999L ? 4 : (x <= 99999L ? 5 : (x <= 999999L ? 6 : (x <= 9999999L ? 7 : (x <= 99999999L ? 8 : (x <= 999999999L ? 9 : (x <= 9999999999L ? 10 : (x <= 99999999999L ? 11 : (x <= 999999999999L ? 12 : (x <= 9999999999999L ? 13 : (x <= 99999999999999L ? 14 : (x <= 999999999999999L ? 15 : (x <= 9999999999999999L ? 16 : (x <= 99999999999999999L ? 17 : (x <= 999999999999999999L ? 18 : 19)))))))))))))))));
        if (i < 0L) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        int charPos = index = this.off + size;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.chars[--charPos] = (char)IOUtils.DigitOnes[r];
            this.chars[--charPos] = (char)IOUtils.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.chars[--charPos] = (char)IOUtils.DigitOnes[r];
            this.chars[--charPos] = (char)IOUtils.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.chars[--charPos] = (char)IOUtils.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.chars[--charPos] = sign;
        }
        this.off += size;
    }

    static void getChars(long i, int index, char[] chars) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            chars[--charPos] = (char)IOUtils.DigitOnes[r];
            chars[--charPos] = (char)IOUtils.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            chars[--charPos] = (char)IOUtils.DigitOnes[r];
            chars[--charPos] = (char)IOUtils.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            chars[--charPos] = (char)IOUtils.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            chars[--charPos] = sign;
        }
    }

    @Override
    public void writeFloat(float value) {
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 15;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len = RyuFloat.toString(value, this.chars, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
    }

    @Override
    public void writeFloat(float[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        int minCapacity = value.length * 16 + 1;
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 91;
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.chars[this.off++] = 44;
            }
            int len = RyuFloat.toString(value[i], this.chars, this.off);
            this.off += len;
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public void writeDouble(double value) {
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 24;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len = RyuDouble.toString(value, this.chars, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
    }

    @Override
    public void writeDoubleArray(double value0, double value1) {
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 48 + 3;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        this.chars[this.off++] = 91;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len0 = RyuDouble.toString(value0, this.chars, this.off);
        this.off += len0;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        this.chars[this.off++] = 44;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len1 = RyuDouble.toString(value1, this.chars, this.off);
        this.off += len1;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public void writeDouble(double[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        int minCapacity = value.length * 25 + 1;
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
        this.chars[this.off++] = 91;
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.chars[this.off++] = 44;
            }
            int len = RyuDouble.toString(value[i], this.chars, this.off);
            this.off += len;
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 21);
        this.chars[this.off++] = 34;
        this.chars[this.off++] = (char)(year / 1000 + 48);
        this.chars[this.off++] = (char)(year / 100 % 10 + 48);
        this.chars[this.off++] = (char)(year / 10 % 10 + 48);
        this.chars[this.off++] = (char)(year % 10 + 48);
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(month / 10 + 48);
        this.chars[this.off++] = (char)(month % 10 + 48);
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(dayOfMonth / 10 + 48);
        this.chars[this.off++] = (char)(dayOfMonth % 10 + 48);
        this.chars[this.off++] = 32;
        this.chars[this.off++] = (char)(hour / 10 + 48);
        this.chars[this.off++] = (char)(hour % 10 + 48);
        this.chars[this.off++] = 58;
        this.chars[this.off++] = (char)(minute / 10 + 48);
        this.chars[this.off++] = (char)(minute % 10 + 48);
        this.chars[this.off++] = 58;
        this.chars[this.off++] = (char)(second / 10 + 48);
        this.chars[this.off++] = (char)(second % 10 + 48);
        this.chars[this.off++] = 34;
    }

    public String toString() {
        return new String(this.chars, 0, this.off);
    }

    static void formatUnsignedLong0(long val, char[] buf, int offset, int len) {
        int charPos = offset + len;
        do {
            buf[--charPos] = JSONFactory.DIGITS[(int)val & 0xF];
            val >>>= 4;
        } while (charPos > offset);
    }
}

