/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF16;
import java.util.Arrays;

final class JSONWriterUTF16JDK8
extends JSONWriterUTF16 {
    JSONWriterUTF16JDK8(JSONWriter.Context ctx) {
        super(ctx);
    }

    @Override
    public void writeString(String str) {
        char c1;
        char c0;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        char[] value = str.toCharArray();
        int strlen = value.length;
        boolean special = false;
        int i = 0;
        while (i + 4 <= strlen) {
            c0 = value[i];
            c1 = value[i + 1];
            char c2 = value[i + 2];
            char c3 = value[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote) {
                special = true;
                break;
            }
            if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') {
                special = true;
                break;
            }
            if (c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ') {
                special = true;
                break;
            }
            i += 4;
        }
        if (!special && i + 2 <= strlen) {
            c0 = value[i];
            c1 = value[i + 1];
            if (c0 == this.quote || c1 == this.quote || c0 == '\\' || c1 == '\\' || c0 < ' ' || c1 < ' ') {
                special = true;
            } else {
                i += 2;
            }
        }
        if (!special && i + 1 == strlen) {
            c0 = value[i];
            boolean bl = special = c0 == this.quote || c0 == '\\' || c0 < ' ';
        }
        if (!special) {
            int minCapacity = this.off + strlen + 2;
            if (minCapacity - this.chars.length > 0) {
                int oldCapacity = this.chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - MAX_ARRAY_SIZE > 0) {
                    throw new OutOfMemoryError();
                }
                this.chars = Arrays.copyOf(this.chars, newCapacity);
            }
            this.chars[this.off++] = this.quote;
            System.arraycopy(value, 0, this.chars, this.off, value.length);
            this.off += strlen;
            this.chars[this.off++] = this.quote;
            return;
        }
        this.ensureCapacity(this.off + strlen * 2 + 2);
        this.chars[this.off++] = this.quote;
        block10: for (i = 0; i < strlen; ++i) {
            char ch = value[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block10;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block10;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block10;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block10;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block10;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block10;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block10;
                }
                default: {
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = this.quote;
    }
}

