/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public abstract class TypeReference<T> {
    protected final Type type;
    protected final Class<? super T> rawType;

    public TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public TypeReference(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = BeanUtils.canonicalize(type);
        this.rawType = BeanUtils.getRawType(type);
    }

    public TypeReference(Type[] actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            throw new NullPointerException();
        }
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.type = TypeReference.canonicalize(thisClass, argType, actualTypeArguments, 0);
        this.rawType = BeanUtils.getRawType(this.type);
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public T parseObject(String text) {
        return JSON.parseObject(text, this.type);
    }

    public T parseObject(byte[] utf8Bytes) {
        return JSON.parseObject(utf8Bytes, this.type);
    }

    public List<T> parseArray(String text, JSONReader.Feature ... features) {
        return JSON.parseArray(text, this.type, features);
    }

    public List<T> parseArray(byte[] utf8Bytes, JSONReader.Feature ... features) {
        return JSON.parseArray(utf8Bytes, this.type, features);
    }

    public T to(JSONArray array) {
        return array.to(this.type);
    }

    public T to(JSONObject object, JSONReader.Feature ... features) {
        return object.to(this.type, features);
    }

    @Deprecated
    public T toJavaObject(JSONArray array) {
        return array.to(this.type);
    }

    @Deprecated
    public T toJavaObject(JSONObject object, JSONReader.Feature ... features) {
        return object.to(this.type, features);
    }

    public static TypeReference<?> get(Type type) {
        return new TypeReference<Object>(type){};
    }

    /*
     * Unable to fully structure code
     */
    private static Type canonicalize(Class<?> thisClass, ParameterizedType type, Type[] actualTypeArguments, int actualIndex) {
        rawType = type.getRawType();
        argTypes = type.getActualTypeArguments();
        for (i = 0; i < argTypes.length; ++i) {
            block6: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            if (argTypes[i] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                                                argTypes[i] = actualTypeArguments[actualIndex++];
                                            }
                                            if (!(argTypes[i] instanceof GenericArrayType)) break block6;
                                            componentType = argTypes[i];
                                            dimension = 0;
                                            while (componentType instanceof GenericArrayType) {
                                                ++dimension;
                                                componentType = ((GenericArrayType)componentType).getGenericComponentType();
                                            }
                                            if (!(componentType instanceof Class) || !(cls = (Class)componentType).isPrimitive()) break block6;
                                            if (cls != Integer.TYPE) break block7;
                                            ch = 73;
                                            ** GOTO lbl46
                                        }
                                        if (cls != Long.TYPE) break block8;
                                        ch = 74;
                                        ** GOTO lbl46
                                    }
                                    if (cls != Float.TYPE) break block9;
                                    ch = 70;
                                    ** GOTO lbl46
                                }
                                if (cls != Double.TYPE) break block10;
                                ch = 68;
                                ** GOTO lbl46
                            }
                            if (cls != Boolean.TYPE) break block11;
                            ch = 90;
                            ** GOTO lbl46
                        }
                        if (cls != Character.TYPE) break block12;
                        ch = 67;
                        ** GOTO lbl46
                    }
                    if (cls != Byte.TYPE) break block13;
                    ch = 66;
                    ** GOTO lbl46
                }
                if (cls != Short.TYPE) {
                    ch = 0;
                } else {
                    ch = 83;
lbl46:
                    // 8 sources

                    chars = new char[dimension + 1];
                    for (j = 0; j < dimension; ++j) {
                        chars[j] = 91;
                    }
                    chars[dimension] = ch;
                    typeName = new String(chars);
                    argTypes[i] = TypeUtils.loadClass(typeName);
                }
            }
            if (!(argTypes[i] instanceof ParameterizedType)) continue;
            argTypes[i] = TypeReference.canonicalize(thisClass, (ParameterizedType)argTypes[i], actualTypeArguments, actualIndex);
        }
        return new ParameterizedTypeImpl(argTypes, thisClass, rawType);
    }
}

