/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.FieldReaderReadOnly;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;

class FielderReaderImplMapFieldReadOnly<T>
extends FieldReaderObjectField<T>
implements FieldReaderReadOnly<T> {
    volatile ObjectReader itemReader;

    FielderReaderImplMapFieldReadOnly(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, null, schema, field);
    }

    @Override
    public ObjectReader getItemObjectReader(JSONReader jsonReader) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        ObjectReader objectReader = this.getObjectReader(jsonReader);
        if (objectReader instanceof ObjectReaderImplMap) {
            this.itemReader = ObjectReaderImplString.INSTANCE;
            return this.itemReader;
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            Type valueType = ((ObjectReaderImplMapTyped)objectReader).valueType;
            this.itemReader = jsonReader.getObjectReader(valueType);
            return this.itemReader;
        }
        return ObjectReaderImplObject.INSTANCE;
    }

    @Override
    public void accept(T object, Object value) {
        Map map;
        if (value == null) {
            return;
        }
        try {
            map = (Map)this.field.get(object);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        if (map == Collections.EMPTY_MAP || map == null) {
            return;
        }
        String name = map.getClass().getName();
        if ("java.util.Collections$UnmodifiableMap".equals(name)) {
            return;
        }
        map.putAll((Map)value);
    }

    @Override
    public void processExtra(JSONReader jsonReader, Object object) {
        Map map;
        try {
            map = (Map)this.field.get(object);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        String name = jsonReader.getFieldName();
        ObjectReader itemObjectReader = this.getItemObjectReader(jsonReader);
        Object value = itemObjectReader.readObject(jsonReader, 0L);
        map.put(name, value);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        Object value = jsonReader.isJSONB() ? this.fieldObjectReader.readJSONBObject(jsonReader, this.features) : this.fieldObjectReader.readObject(jsonReader, this.features);
        this.accept(object, value);
    }
}

