/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONBuilder;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderListInt64;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectArrayTypedReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderException;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicLong;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicLongArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicReference;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigDecimal;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplBitSet;
import com.alibaba.fastjson2.reader.ObjectReaderImplByte;
import com.alibaba.fastjson2.reader.ObjectReaderImplCalendar;
import com.alibaba.fastjson2.reader.ObjectReaderImplCharValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplClass;
import com.alibaba.fastjson2.reader.ObjectReaderImplCurrency;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplDoubleArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplDoubleValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloatArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloatValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromString;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt16Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt16ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplListStr;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplNumberArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptionalInt;
import com.alibaba.fastjson2.reader.ObjectReaderImplShort;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.reader.ObjectReaderImplValue;
import com.alibaba.fastjson2.reader.ObjectReaderImplZonedDateTime;
import com.alibaba.fastjson2.reader.ObjectReaderMisc;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.reader.TypeConverts;
import com.alibaba.fastjson2.support.money.MoneySupport;
import com.alibaba.fastjson2.util.ApacheLang3Support;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.JodaSupport;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ObjectReaderBaseModule
implements ObjectReaderModule {
    final ObjectReaderProvider provider;
    final ReaderAnnotationProcessor annotationProcessor;

    public ObjectReaderBaseModule(ObjectReaderProvider provider) {
        this.provider = provider;
        this.annotationProcessor = new ReaderAnnotationProcessor();
    }

    @Override
    public ObjectReaderProvider getProvider() {
        return this.provider;
    }

    @Override
    public void init(ObjectReaderProvider provider) {
        provider.registerTypeConvert((Type)((Object)Character.class), Character.TYPE, o -> o);
        Class[] numberTypes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Number.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, AtomicInteger.class, AtomicLong.class};
        TypeConverts.ToString TO_STRING = new TypeConverts.ToString();
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)String.class), TO_STRING);
        }
        TypeConverts.ToBigDecimal TO_DECIMAL = new TypeConverts.ToBigDecimal();
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)BigDecimal.class), TO_DECIMAL);
        }
        TypeConverts.ToBigInteger TO_BIGINT = new TypeConverts.ToBigInteger();
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)BigInteger.class), TO_BIGINT);
        }
        TypeConverts.ToByte TO_BYTE = new TypeConverts.ToByte(null);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Byte.class), TO_BYTE);
        }
        TypeConverts.ToByte TO_BYTE_VALUE = new TypeConverts.ToByte((byte)0);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, Byte.TYPE, TO_BYTE_VALUE);
        }
        TypeConverts.ToShort TO_SHORT = new TypeConverts.ToShort(null);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Short.class), TO_SHORT);
        }
        TypeConverts.ToShort TO_SHORT_VALUE = new TypeConverts.ToShort((short)0);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, Short.TYPE, TO_SHORT_VALUE);
        }
        TypeConverts.ToInteger TO_INTEGER = new TypeConverts.ToInteger(null);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Integer.class), TO_INTEGER);
        }
        TypeConverts.ToInteger TO_INT = new TypeConverts.ToInteger(0);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, Integer.TYPE, TO_INT);
        }
        TypeConverts.ToLong TO_LONG = new TypeConverts.ToLong(null);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Long.class), TO_LONG);
        }
        TypeConverts.ToLong TO_LONG_VALUE = new TypeConverts.ToLong(0L);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, Long.TYPE, TO_LONG_VALUE);
        }
        TypeConverts.ToFloat TO_FLOAT = new TypeConverts.ToFloat(null);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Float.class), TO_FLOAT);
        }
        TypeConverts.ToFloat TO_FLOAT_VALUE = new TypeConverts.ToFloat(Float.valueOf(0.0f));
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, Float.TYPE, TO_FLOAT_VALUE);
        }
        TypeConverts.ToDouble TO_DOUBLE = new TypeConverts.ToDouble(null);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Double.class), TO_DOUBLE);
        }
        TypeConverts.ToDouble TO_DOUBLE_VALUE = new TypeConverts.ToDouble(0.0);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, Double.TYPE, TO_DOUBLE_VALUE);
        }
        TypeConverts.ToNumber TO_NUMBER = new TypeConverts.ToNumber(0.0);
        for (Class type : numberTypes) {
            provider.registerTypeConvert(type, (Type)((Object)Number.class), TO_NUMBER);
        }
        provider.registerTypeConvert((Type)((Object)String.class), Character.TYPE, new TypeConverts.StringToAny(Character.TYPE, Character.valueOf('0')));
        provider.registerTypeConvert((Type)((Object)String.class), Boolean.TYPE, new TypeConverts.StringToAny(Boolean.TYPE, false));
        provider.registerTypeConvert((Type)((Object)String.class), Float.TYPE, new TypeConverts.StringToAny(Float.TYPE, Float.valueOf(0.0f)));
        provider.registerTypeConvert((Type)((Object)String.class), Double.TYPE, new TypeConverts.StringToAny(Double.TYPE, 0.0));
        provider.registerTypeConvert((Type)((Object)String.class), Byte.TYPE, new TypeConverts.StringToAny(Byte.TYPE, (byte)0));
        provider.registerTypeConvert((Type)((Object)String.class), Short.TYPE, new TypeConverts.StringToAny(Short.TYPE, (short)0));
        provider.registerTypeConvert((Type)((Object)String.class), Integer.TYPE, new TypeConverts.StringToAny(Integer.TYPE, 0));
        provider.registerTypeConvert((Type)((Object)String.class), Long.TYPE, new TypeConverts.StringToAny(Long.TYPE, 0L));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Character.class), new TypeConverts.StringToAny(Character.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Boolean.class), new TypeConverts.StringToAny(Boolean.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Double.class), new TypeConverts.StringToAny(Double.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Float.class), new TypeConverts.StringToAny(Float.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Byte.class), new TypeConverts.StringToAny(Byte.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Short.class), new TypeConverts.StringToAny(Short.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Integer.class), new TypeConverts.StringToAny(Integer.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Long.class), new TypeConverts.StringToAny(Long.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)BigDecimal.class), new TypeConverts.StringToAny(BigDecimal.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)BigInteger.class), new TypeConverts.StringToAny(BigInteger.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Number.class), new TypeConverts.StringToAny(BigDecimal.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)Collection.class), new TypeConverts.StringToAny(Collection.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)List.class), new TypeConverts.StringToAny(List.class, null));
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)JSONArray.class), new TypeConverts.StringToAny(JSONArray.class, null));
        provider.registerTypeConvert((Type)((Object)Boolean.class), Boolean.TYPE, o -> o);
        Function<Object, Object> function = o -> o == null || "null".equals(o) || o.equals(0L) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)o), ZoneId.systemDefault());
        provider.registerTypeConvert((Type)((Object)Long.class), (Type)((Object)LocalDateTime.class), function);
        function = o -> o == null || "null".equals(o) || "".equals(o) ? null : UUID.fromString((String)o);
        provider.registerTypeConvert((Type)((Object)String.class), (Type)((Object)UUID.class), function);
    }

    private void getBeanInfo1xJSONPOJOBuilder(BeanInfo beanInfo, Class<?> builderClass, Annotation builderAnnatation, Class<? extends Annotation> builderAnnatationClass) {
        BeanUtils.annotationMethods(builderAnnatationClass, method -> {
            try {
                String methodName;
                switch (methodName = method.getName()) {
                    case "buildMethod": {
                        String buildMethodName = (String)method.invoke((Object)builderAnnatation, new Object[0]);
                        beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, buildMethodName);
                        break;
                    }
                    case "withPrefix": {
                        String withPrefix = (String)method.invoke((Object)builderAnnatation, new Object[0]);
                        if (withPrefix.isEmpty()) break;
                        beanInfo.builderWithPrefix = withPrefix;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void getCreator(BeanInfo beanInfo, Class<?> objectClass, Constructor constructor) {
        Annotation[] annotations = constructor.getAnnotations();
        boolean creatorMethod = false;
        JSONCreator jsonCreator = null;
        block10: for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == JSONCreator.class) {
                jsonCreator = (JSONCreator)annotation;
                continue;
            }
            switch (annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONCreator": {
                    creatorMethod = true;
                    BeanUtils.annotationMethods(annotationType, m1 -> {
                        try {
                            switch (m1.getName()) {
                                case "parameterNames": {
                                    String[] createParameterNames = (String[])m1.invoke((Object)annotation, new Object[0]);
                                    if (createParameterNames.length == 0) break;
                                    beanInfo.createParameterNames = createParameterNames;
                                    break;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    continue block10;
                }
                case "com.fasterxml.jackson.annotation.JsonCreator": {
                    creatorMethod = true;
                    continue block10;
                }
            }
        }
        if (jsonCreator != null) {
            String[] createParameterNames = jsonCreator.parameterNames();
            if (createParameterNames.length != 0) {
                beanInfo.createParameterNames = createParameterNames;
            }
            creatorMethod = true;
        }
        if (!creatorMethod) {
            return;
        }
        Constructor<?> targetConstructor = null;
        try {
            targetConstructor = objectClass.getDeclaredConstructor(constructor.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (targetConstructor != null) {
            beanInfo.creatorConstructor = targetConstructor;
        }
    }

    private void getCreator(BeanInfo beanInfo, Class<?> objectClass, Method method) {
        Annotation[] annotations = method.getAnnotations();
        boolean creatorMethod = false;
        JSONCreator jsonCreator = null;
        block8: for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == JSONCreator.class) {
                jsonCreator = (JSONCreator)annotation;
                continue;
            }
            switch (annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONCreator": {
                    creatorMethod = true;
                    BeanUtils.annotationMethods(annotationType, m1 -> {
                        try {
                            switch (m1.getName()) {
                                case "parameterNames": {
                                    String[] createParameterNames = (String[])m1.invoke((Object)annotation, new Object[0]);
                                    if (createParameterNames.length == 0) break;
                                    beanInfo.createParameterNames = createParameterNames;
                                    break;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    continue block8;
                }
            }
        }
        if (jsonCreator != null) {
            String[] createParameterNames = jsonCreator.parameterNames();
            if (createParameterNames.length != 0) {
                beanInfo.createParameterNames = createParameterNames;
            }
            creatorMethod = true;
        }
        if (!creatorMethod) {
            return;
        }
        Method targetMethod = null;
        try {
            targetMethod = objectClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (targetMethod != null) {
            beanInfo.createMethod = targetMethod;
        }
    }

    @Override
    public ReaderAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    @Override
    public ObjectReader getObjectReader(ObjectReaderProvider provider, Type type) {
        Type[] upperBounds;
        Class mixin;
        String typeName;
        if (type == String.class || type == CharSequence.class) {
            return ObjectReaderImplString.INSTANCE;
        }
        if (type == Character.TYPE || type == Character.class) {
            return CharacterImpl.INSTANCE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BooleanImpl.INSTANCE;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ObjectReaderImplByte.INSTANCE;
        }
        if (type == Short.TYPE || type == Short.class) {
            return ObjectReaderImplShort.INSTANCE;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return IntegerImpl.INSTANCE;
        }
        if (type == Long.TYPE || type == Long.class) {
            return LongImpl.INSTANCE;
        }
        if (type == Float.TYPE || type == Float.class) {
            return FloatImpl.INSTANCE;
        }
        if (type == Double.TYPE || type == Double.class) {
            return DoubleImpl.INSTANCE;
        }
        if (type == BigInteger.class) {
            return ObjectReaderImplBigInteger.INSTANCE;
        }
        if (type == BigDecimal.class) {
            return ObjectReaderImplBigDecimal.INSTANCE;
        }
        if (type == Number.class) {
            return NumberImpl.INSTANCE;
        }
        if (type == BitSet.class) {
            return ObjectReaderImplBitSet.INSTANCE;
        }
        if (type == OptionalInt.class) {
            return ObjectReaderImplOptionalInt.INSTANCE;
        }
        if (type == OptionalLong.class) {
            return OptionalLongImpl.INSTANCE;
        }
        if (type == OptionalDouble.class) {
            return OptionalDoubleImpl.INSTANCE;
        }
        if (type == Optional.class) {
            return ObjectReaderImplOptional.INSTANCE;
        }
        if (type == UUID.class) {
            return UUIDImpl.INSTANCE;
        }
        if (type == URI.class) {
            return new ObjectReaderImplFromString<URI>(e -> URI.create(e));
        }
        if (type == File.class) {
            return new ObjectReaderImplFromString<File>(e -> new File((String)e));
        }
        if (type == URL.class) {
            return new ObjectReaderImplFromString<URL>(e -> {
                try {
                    return new URL((String)e);
                }
                catch (MalformedURLException ex) {
                    throw new JSONException("read URL error", ex);
                }
            });
        }
        if (type == Class.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        if (type == Type.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        String internalMixin = null;
        switch (typeName = type.getTypeName()) {
            case "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList": 
            case "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet": {
                return null;
            }
            case "org.springframework.util.LinkedMultiValueMap": {
                return ObjectReaderImplMap.of(type, (Class)type, 0L);
            }
            case "org.springframework.security.core.authority.RememberMeAuthenticationToken": {
                internalMixin = "org.springframework.security.jackson2.AnonymousAuthenticationTokenMixin";
                break;
            }
            case "org.springframework.security.core.authority.AnonymousAuthenticationToken": {
                internalMixin = "org.springframework.security.jackson2.RememberMeAuthenticationTokenMixin";
                break;
            }
            case "org.springframework.security.core.authority.SimpleGrantedAuthority": {
                internalMixin = "org.springframework.security.jackson2.SimpleGrantedAuthorityMixin";
                break;
            }
            case "org.springframework.security.core.userdetails.User": {
                internalMixin = "org.springframework.security.jackson2.UserMixin";
                break;
            }
            case "org.springframework.security.authentication.UsernamePasswordAuthenticationToken": {
                internalMixin = "org.springframework.security.jackson2.UsernamePasswordAuthenticationTokenMixin";
                break;
            }
            case "org.springframework.security.authentication.BadCredentialsException": {
                internalMixin = "org.springframework.security.jackson2.BadCredentialsExceptionMixin";
                break;
            }
            case "org.springframework.security.web.csrf.DefaultCsrfToken": {
                internalMixin = "org.springframework.security.web.jackson2.DefaultCsrfTokenMixin";
                break;
            }
            case "org.springframework.security.web.savedrequest.SavedCookie": {
                internalMixin = "org.springframework.security.web.jackson2.SavedCookieMixin";
                break;
            }
            case "org.springframework.security.web.authentication.WebAuthenticationDetails": {
                internalMixin = "org.springframework.security.web.jackson2.WebAuthenticationDetailsMixin";
                break;
            }
        }
        if (internalMixin != null && (mixin = (Class)provider.mixInCache.get(type)) == null && (mixin = TypeUtils.loadClass(internalMixin)) != null) {
            provider.mixInCache.putIfAbsent((Class)type, mixin);
        }
        if (type == Map.class || type == AbstractMap.class) {
            return ObjectReaderImplMap.of(null, (Class)type, 0L);
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return ObjectReaderBaseModule.typedMap((Class)type, ConcurrentHashMap.class, null, Object.class);
        }
        if (type == ConcurrentNavigableMap.class || type == ConcurrentSkipListMap.class) {
            return ObjectReaderBaseModule.typedMap((Class)type, ConcurrentSkipListMap.class, null, Object.class);
        }
        if (type == SortedMap.class || type == NavigableMap.class || type == TreeMap.class) {
            return ObjectReaderBaseModule.typedMap((Class)type, TreeMap.class, null, Object.class);
        }
        if (type == Calendar.class || "javax.xml.datatype.XMLGregorianCalendar".equals(typeName)) {
            return ObjectReaderImplCalendar.INSTANCE;
        }
        if (type == Date.class) {
            return ObjectReaderImplDate.INSTANCE;
        }
        if (type == LocalDate.class) {
            return LocalDateImpl.INSTANCE;
        }
        if (type == LocalTime.class) {
            return LocalTimeImpl.INSTANCE;
        }
        if (type == LocalDateTime.class) {
            return LocalDateTimeImpl.INSTANCE;
        }
        if (type == ZonedDateTime.class) {
            return ObjectReaderImplZonedDateTime.INSTANCE;
        }
        if (type == Instant.class) {
            return ObjectReaderImplInstant.INSTANCE;
        }
        if (type == Locale.class) {
            return LocaleImpl.INSTANCE;
        }
        if (type == Currency.class) {
            return ObjectReaderImplCurrency.INSTANCE;
        }
        if (type == ZoneId.class) {
            return new ObjectReaderImplFromString<ZoneId>(e -> ZoneId.of(e));
        }
        if (type == TimeZone.class) {
            return new ObjectReaderImplFromString<TimeZone>(e -> TimeZone.getTimeZone(e));
        }
        if (type == char[].class) {
            return ObjectReaderImplCharValueArray.INSTANCE;
        }
        if (type == float[].class) {
            return ObjectReaderImplFloatValueArray.INSTANCE;
        }
        if (type == double[].class) {
            return ObjectReaderImplDoubleValueArray.INSTANCE;
        }
        if (type == boolean[].class) {
            return BoolValueArrayImpl.INSTANCE;
        }
        if (type == byte[].class) {
            return ObjectReaderImplInt8ValueArray.INSTANCE;
        }
        if (type == short[].class) {
            return ObjectReaderImplInt16ValueArray.INSTANCE;
        }
        if (type == int[].class) {
            return ObjectReaderImplInt32ValueArray.INSTANCE;
        }
        if (type == long[].class) {
            return ObjectReaderImplInt64ValueArray.INSTANCE;
        }
        if (type == Byte[].class) {
            return ObjectReaderImplInt8Array.INSTANCE;
        }
        if (type == Short[].class) {
            return ObjectReaderImplInt16Array.INSTANCE;
        }
        if (type == Integer[].class) {
            return ObjectReaderImplInt32Array.INSTANCE;
        }
        if (type == Long[].class) {
            return ObjectReaderImplInt64Array.INSTANCE;
        }
        if (type == Float[].class) {
            return ObjectReaderImplFloatArray.INSTANCE;
        }
        if (type == Double[].class) {
            return ObjectReaderImplDoubleArray.INSTANCE;
        }
        if (type == Number[].class) {
            return ObjectReaderImplNumberArray.INSTANCE;
        }
        if (type == AtomicInteger.class) {
            return ObjectReaderImplAtomicInteger.INSTANCE;
        }
        if (type == AtomicLong.class) {
            return ObjectReaderImplAtomicLong.INSTANCE;
        }
        if (type == AtomicIntegerArray.class) {
            return AtomicIntegerArrayImpl.INSTANCE;
        }
        if (type == AtomicLongArray.class) {
            return ObjectReaderImplAtomicLongArray.INSTANCE;
        }
        if (type == AtomicReference.class) {
            return ObjectReaderImplAtomicReference.INSTANCE;
        }
        if (type == Object[].class) {
            return ObjectArrayReader.INSTANCE;
        }
        if (type == Iterable.class || type == Collection.class || type == List.class || type == AbstractCollection.class || type == AbstractList.class || type == ArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Queue.class || type == Deque.class || type == AbstractSequentialList.class || type == LinkedList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Set.class || type == AbstractSet.class || type == EnumSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == NavigableSet.class || type == SortedSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ConcurrentLinkedDeque.class || type == ConcurrentLinkedQueue.class || type == ConcurrentSkipListSet.class || type == LinkedHashSet.class || type == HashSet.class || type == TreeSet.class || type == CopyOnWriteArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ObjectReaderImplList.CLASS_EMPTY_SET || type == ObjectReaderImplList.CLASS_EMPTY_LIST || type == ObjectReaderImplList.CLASS_SINGLETON || type == ObjectReaderImplList.CLASS_SINGLETON_LIST || type == ObjectReaderImplList.CLASS_ARRAYS_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_COLLECTION || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_SET || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_SORTED_SET || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_NAVIGABLE_SET) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == SingletonSetImpl.TYPE) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Object.class || type == Cloneable.class || type == Closeable.class || type == Serializable.class || type == Comparable.class) {
            return ObjectReaderImplObject.INSTANCE;
        }
        if (type == Map.Entry.class) {
            return new MapEntryImpl(null, null);
        }
        if (type instanceof Class) {
            Class objectClass = (Class)type;
            if (Map.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplMap.of(null, objectClass, 0L);
            }
            if (List.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplList.of(objectClass, null, 0L);
            }
            if (objectClass.isArray()) {
                return new ObjectArrayTypedReader(objectClass);
            }
            ObjectReaderCreator creator = JSONFactory.getDefaultObjectReaderProvider().getCreator();
            if (objectClass == StackTraceElement.class) {
                try {
                    Constructor constructor = objectClass.getConstructor(String.class, String.class, String.class, Integer.TYPE);
                    return creator.createObjectReaderNoneDefaultConstrutor(constructor, "className", "methodName", "fileName", "lineNumber");
                }
                catch (Throwable constructor) {
                    // empty catch block
                }
            }
            if (objectClass.isInterface()) {
                BeanInfo beanInfo = new BeanInfo();
                this.annotationProcessor.getBeanInfo(beanInfo, objectClass);
                if (beanInfo.seeAlso != null && beanInfo.seeAlso.length == 0) {
                    return new InterfaceImpl(type);
                }
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                Type actualTypeParam0 = actualTypeArguments[0];
                Type actualTypeParam1 = actualTypeArguments[1];
                if (rawType == Map.class || rawType == AbstractMap.class || rawType == HashMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == ConcurrentMap.class || rawType == ConcurrentHashMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, ConcurrentHashMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == ConcurrentNavigableMap.class || rawType == ConcurrentSkipListMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, ConcurrentSkipListMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == LinkedHashMap.class || rawType == TreeMap.class) {
                    return ObjectReaderBaseModule.typedMap((Class)rawType, (Class)rawType, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == Map.Entry.class) {
                    return new MapEntryImpl(actualTypeArguments[0], actualTypeArguments[1]);
                }
                switch (rawType.getTypeName()) {
                    case "com.google.common.collect.ImmutableMap": 
                    case "com.google.common.collect.RegularImmutableMap": {
                        return new ObjectReaderImplMapTyped((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1, 0L, GuavaSupport.immutableMapConverter());
                    }
                    case "com.google.common.collect.SingletonImmutableBiMap": {
                        return new ObjectReaderImplMapTyped((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1, 0L, GuavaSupport.singletonBiMapConverter());
                    }
                    case "org.springframework.util.LinkedMultiValueMap": {
                        return ObjectReaderImplMap.of(type, (Class)rawType, 0L);
                    }
                }
            }
            if (actualTypeArguments.length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (rawType == Iterable.class || rawType == Collection.class || rawType == List.class || rawType == AbstractCollection.class || rawType == AbstractList.class || rawType == ArrayList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, ArrayList.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, ArrayList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Queue.class || rawType == Deque.class || rawType == AbstractSequentialList.class || rawType == LinkedList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, LinkedList.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, LinkedList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Set.class || rawType == AbstractSet.class || rawType == EnumSet.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, HashSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, HashSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == NavigableSet.class || rawType == SortedSet.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, TreeSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, TreeSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == ConcurrentLinkedDeque.class || rawType == ConcurrentLinkedQueue.class || rawType == ConcurrentSkipListSet.class || rawType == LinkedHashSet.class || rawType == HashSet.class || rawType == TreeSet.class || rawType == CopyOnWriteArrayList.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, (Class)rawType);
                    }
                    if (itemClass == Long.class) {
                        return new FieldReaderListInt64((Class)rawType, (Class)rawType);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                switch (rawType.getTypeName()) {
                    case "com.google.common.collect.ImmutableList": {
                        return ObjectReaderImplList.of(type, null, 0L);
                    }
                    case "com.google.common.collect.ImmutableSet": {
                        return ObjectReaderImplList.of(type, null, 0L);
                    }
                }
                if (rawType == Optional.class) {
                    return ObjectReaderImplOptional.of(type, null, null);
                }
                if (rawType == AtomicReference.class) {
                    return new ObjectReaderImplAtomicReference(itemType);
                }
                if (itemType instanceof WildcardType) {
                    return this.getObjectReader(provider, rawType);
                }
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayImpl(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return this.getObjectReader(provider, upperBounds[0]);
        }
        if (type == ParameterizedType.class) {
            return ObjectReaders.ofReflect(ParameterizedTypeImpl.class);
        }
        switch (typeName) {
            case "java.sql.Time": {
                return JdbcSupport.createTimeReader(null, null);
            }
            case "java.sql.Timestamp": {
                return JdbcSupport.createTimestampReader(null, null);
            }
            case "java.sql.Date": {
                return JdbcSupport.createDateReader(null, null);
            }
            case "org.joda.time.Chronology": {
                return JodaSupport.createChronologyReader((Class)type);
            }
            case "org.joda.time.LocalDate": {
                return JodaSupport.createLocalDateReader((Class)type);
            }
            case "org.joda.time.LocalDateTime": {
                return JodaSupport.createLocalDateTimeReader((Class)type);
            }
            case "org.joda.time.Instant": {
                return JodaSupport.createInstantReader((Class)type);
            }
            case "javax.money.CurrencyUnit": {
                return MoneySupport.createCurrencyUnitReader();
            }
            case "javax.money.MonetaryAmount": 
            case "javax.money.Money": {
                return MoneySupport.createMonetaryAmountReader();
            }
            case "javax.money.NumberValue": {
                return MoneySupport.createNumberValueReader();
            }
            case "java.net.InetSocketAddress": {
                return new ObjectReaderMisc((Class)type);
            }
            case "java.net.InetAddress": {
                return ObjectReaderImplValue.of((Class)type, String.class, address -> {
                    try {
                        return InetAddress.getByName(address);
                    }
                    catch (UnknownHostException e) {
                        throw new JSONException("create address error", e);
                    }
                });
            }
            case "java.text.SimpleDateFormat": {
                return ObjectReaderImplValue.of((Class)type, String.class, SimpleDateFormat::new);
            }
            case "java.lang.Throwable": 
            case "java.lang.Exception": 
            case "java.lang.IllegalStateException": 
            case "java.lang.RuntimeException": 
            case "java.io.IOException": 
            case "java.io.UncheckedIOException": {
                if (JDKUtils.UNSAFE_SUPPORT) break;
                return new ObjectReaderException((Class)type);
            }
        }
        return null;
    }

    public static ObjectReader typedMap(Class mapType, Class instanceType, Type keyType, Type valueType) {
        if ((keyType == null || keyType == String.class) && valueType == String.class) {
            return new ObjectReaderImplMapString(mapType, instanceType, 0L);
        }
        return new ObjectReaderImplMapTyped(mapType, instanceType, keyType, valueType, 0L, null);
    }

    class ReaderAnnotationProcessor
    implements ObjectReaderAnnotationProcessor {
        ReaderAnnotationProcessor() {
        }

        @Override
        public void getBeanInfo(BeanInfo beanInfo, Class<?> objectClass) {
            Class mixInSource = (Class<ApacheLang3Support.PairMixIn>)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource == null) {
                Annotation[] typeName;
                switch (typeName = objectClass.getName()) {
                    case "org.apache.commons.lang3.tuple.Pair": 
                    case "org.apache.commons.lang3.tuple.ImmutablePair": {
                        mixInSource = ApacheLang3Support.PairMixIn.class;
                        ObjectReaderBaseModule.this.provider.mixIn(objectClass, ApacheLang3Support.PairMixIn.class);
                        break;
                    }
                    case "org.apache.commons.lang3.tuple.Triple": {
                        mixInSource = ApacheLang3Support.TripleMixIn.class;
                        ObjectReaderBaseModule.this.provider.mixIn(objectClass, ApacheLang3Support.TripleMixIn.class);
                        break;
                    }
                }
            }
            if (mixInSource != null && mixInSource != objectClass) {
                this.getBeanInfo(beanInfo, mixInSource.getAnnotations());
                BeanUtils.staticMethod(mixInSource, method -> ObjectReaderBaseModule.this.getCreator(beanInfo, objectClass, method));
                BeanUtils.constructor(mixInSource, constructor -> ObjectReaderBaseModule.this.getCreator(beanInfo, objectClass, constructor));
            }
            Annotation[] annotations = objectClass.getAnnotations();
            this.getBeanInfo(beanInfo, annotations);
            block23: for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                switch (annotationType.getName()) {
                    case "com.alibaba.fastjson.annotation.JSONType": {
                        this.getBeanInfo1x(beanInfo, annotation);
                        continue block23;
                    }
                    case "com.fasterxml.jackson.annotation.JsonTypeInfo": {
                        this.processJacksonJsonTypeInfo(beanInfo, annotation);
                        continue block23;
                    }
                    case "com.fasterxml.jackson.annotation.JsonTypeName": {
                        this.processJacksonJsonTypeName(beanInfo, annotation);
                        continue block23;
                    }
                    case "com.fasterxml.jackson.annotation.JsonSubTypes": {
                        this.processJacksonJsonSubTypes(beanInfo, annotation);
                        continue block23;
                    }
                    case "kotlin.Metadata": {
                        beanInfo.kotlin = true;
                        continue block23;
                    }
                }
            }
            BeanUtils.staticMethod(objectClass, method -> ObjectReaderBaseModule.this.getCreator(beanInfo, objectClass, method));
            BeanUtils.constructor(objectClass, constructor -> ObjectReaderBaseModule.this.getCreator(beanInfo, objectClass, constructor));
            if (beanInfo.creatorConstructor == null && beanInfo.kotlin) {
                BeanUtils.getKotlinConstructor(objectClass, beanInfo);
            }
        }

        private void processJacksonJsonTypeName(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "value": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            beanInfo.typeName = value;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonSubTypes(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "value": {
                            Object[] value = (Object[])result;
                            if (value.length == 0) break;
                            beanInfo.seeAlso = new Class[value.length];
                            beanInfo.seeAlsoNames = new String[value.length];
                            for (int i = 0; i < value.length; ++i) {
                                Annotation subTypeAnn = (Annotation)value[i];
                                this.processJacksonJsonSubTypesType(beanInfo, i, subTypeAnn);
                            }
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonSubTypesType(BeanInfo beanInfo, int index, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "value": {
                            Class value;
                            beanInfo.seeAlso[index] = value = (Class)result;
                            break;
                        }
                        case "name": {
                            String value;
                            beanInfo.seeAlsoNames[index] = value = (String)result;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonTypeInfo(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "property": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            beanInfo.typeKey = value;
                            beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void getBeanInfo(BeanInfo beanInfo, Annotation[] annotations) {
            JSONType jsonType = null;
            block6: for (Annotation annotation : annotations) {
                String annotationTypeName;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == JSONType.class) {
                    jsonType = (JSONType)annotation;
                }
                switch (annotationTypeName = annotationType.getName()) {
                    case "com.alibaba.fastjson2.annotation.JSONType": {
                        this.getBeanInfo1x(beanInfo, annotation);
                        continue block6;
                    }
                }
            }
            this.getBeanInfo(beanInfo, jsonType);
        }

        void getBeanInfo1x(BeanInfo beanInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "seeAlso": {
                            Class[] classes = (Class[])result;
                            beanInfo.seeAlso = classes;
                            beanInfo.seeAlsoNames = new String[classes.length];
                            for (int i = 0; i < classes.length; ++i) {
                                Class item = classes[i];
                                BeanInfo itemBeanInfo = new BeanInfo();
                                this.getBeanInfo(itemBeanInfo, item);
                                String typeName = itemBeanInfo.typeName;
                                if (typeName == null || typeName.isEmpty()) {
                                    typeName = item.getSimpleName();
                                }
                                beanInfo.seeAlsoNames[i] = typeName;
                            }
                            beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                            break;
                        }
                        case "typeKey": {
                            String jsonTypeKey = (String)result;
                            if (jsonTypeKey.isEmpty()) break;
                            beanInfo.typeKey = jsonTypeKey;
                            break;
                        }
                        case "typeName": {
                            String typeName = (String)result;
                            if (typeName.isEmpty()) break;
                            beanInfo.typeName = typeName;
                            break;
                        }
                        case "naming": {
                            Enum naming = (Enum)result;
                            beanInfo.namingStrategy = naming.name();
                            break;
                        }
                        case "ignores": {
                            beanInfo.ignores = (String[])result;
                            break;
                        }
                        case "orders": {
                            String[] fields = (String[])result;
                            if (fields.length == 0) break;
                            beanInfo.orders = fields;
                            break;
                        }
                        case "parseFeatures": {
                            Enum[] features;
                            block43: for (Enum feature : features = (Enum[])result) {
                                switch (feature.name()) {
                                    case "SupportAutoType": {
                                        beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                                        continue block43;
                                    }
                                    case "SupportArrayToBean": {
                                        beanInfo.readerFeatures |= JSONReader.Feature.SupportArrayToBean.mask;
                                        continue block43;
                                    }
                                    case "InitStringFieldAsEmpty": {
                                        beanInfo.readerFeatures |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                                        continue block43;
                                    }
                                    case "TrimStringFieldValue": {
                                        continue block43;
                                    }
                                }
                            }
                            break;
                        }
                        case "builder": {
                            Class builderClass = (Class)result;
                            if (builderClass == Void.TYPE || builderClass == Void.class) break;
                            beanInfo.builder = builderClass;
                            block44: for (Annotation builderAnnation : builderClass.getAnnotations()) {
                                String builderAnnationName;
                                Class<? extends Annotation> builderAnnationClass = builderAnnation.annotationType();
                                switch (builderAnnationName = builderAnnationClass.getName()) {
                                    case "com.alibaba.fastjson.annotation.JSONPOJOBuilder": {
                                        ObjectReaderBaseModule.this.getBeanInfo1xJSONPOJOBuilder(beanInfo, builderClass, builderAnnation, builderAnnationClass);
                                        continue block44;
                                    }
                                }
                            }
                            if (beanInfo.buildMethod == null) {
                                beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, "build");
                            }
                            if (beanInfo.buildMethod != null) break;
                            beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, "create");
                            break;
                        }
                        case "deserializeUsing": {
                            Class deserializeUsing = (Class)result;
                            if (!ObjectReader.class.isAssignableFrom(deserializeUsing)) break;
                            beanInfo.deserializer = deserializeUsing;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        void getBeanInfo(BeanInfo beanInfo, JSONType jsonType) {
            String schema;
            String[] ignores;
            Class<?> deserializer;
            String typeName;
            String jsonTypeKey;
            if (jsonType == null) {
                return;
            }
            Class<?>[] classes = jsonType.seeAlso();
            if (classes.length != 0) {
                beanInfo.seeAlso = classes;
                beanInfo.seeAlsoNames = new String[classes.length];
                for (int i = 0; i < classes.length; ++i) {
                    Class<?> item = classes[i];
                    BeanInfo beanInfo2 = new BeanInfo();
                    this.getBeanInfo(beanInfo2, item);
                    String typeName2 = beanInfo2.typeName;
                    if (typeName2 == null || typeName2.isEmpty()) {
                        typeName2 = item.getSimpleName();
                    }
                    beanInfo.seeAlsoNames[i] = typeName2;
                }
                beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
            }
            if (!(jsonTypeKey = jsonType.typeKey()).isEmpty()) {
                beanInfo.typeKey = jsonTypeKey;
            }
            if (!(typeName = jsonType.typeName()).isEmpty()) {
                beanInfo.typeName = typeName;
            }
            beanInfo.namingStrategy = jsonType.naming().name();
            for (JSONReader.Feature feature : jsonType.deserializeFeatures()) {
                beanInfo.readerFeatures |= feature.mask;
            }
            Class<?> clazz = jsonType.builder();
            if (clazz != Void.TYPE && clazz != Void.class) {
                beanInfo.builder = clazz;
                JSONBuilder jsonBuilder = clazz.getAnnotation(JSONBuilder.class);
                if (jsonBuilder != null) {
                    String buildMethodName = jsonBuilder.buildMethod();
                    beanInfo.buildMethod = BeanUtils.buildMethod(clazz, buildMethodName);
                    String withPrefix = jsonBuilder.withPrefix();
                    if (!withPrefix.isEmpty()) {
                        beanInfo.builderWithPrefix = withPrefix;
                    }
                }
            }
            if (ObjectReader.class.isAssignableFrom(deserializer = jsonType.deserializer())) {
                beanInfo.deserializer = deserializer;
            }
            if ((ignores = jsonType.ignores()).length > 0) {
                beanInfo.ignores = ignores;
            }
            if (!(schema = jsonType.schema().trim()).isEmpty()) {
                beanInfo.schema = schema;
            }
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Parameter parameter) {
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Constructor mixInConstructor = null;
                try {
                    mixInConstructor = mixInSource.getDeclaredConstructor(constructor.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (mixInConstructor != null) {
                    Parameter mixInParam = mixInConstructor.getParameters()[paramIndex];
                    this.processAnnotation(fieldInfo, mixInParam.getAnnotations());
                }
            }
            Annotation[] annotations = null;
            try {
                annotations = parameter.getAnnotations();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (annotations != null) {
                this.processAnnotation(fieldInfo, annotations);
            }
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex, Parameter parameter) {
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Executable mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    Parameter mixInParam = mixInMethod.getParameters()[paramIndex];
                    this.processAnnotation(fieldInfo, mixInParam.getAnnotations());
                }
            }
            this.processAnnotation(fieldInfo, parameter.getAnnotations());
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Field mixInField = null;
                try {
                    mixInField = mixInSource.getDeclaredField(field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInField != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInField);
                }
            }
            this.processAnnotation(fieldInfo, field.getAnnotations());
        }

        @Override
        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
            Annotation[] annotations;
            Class mixInSource = (Class)ObjectReaderBaseModule.this.provider.mixInCache.get(objectClass);
            String methodName = method.getName();
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(methodName, method.getParameterTypes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
            JSONField jsonField = null;
            block18: for (Annotation annotation : annotations = method.getAnnotations()) {
                String annotationTypeName;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == JSONField.class) {
                    jsonField = (JSONField)annotation;
                }
                switch (annotationTypeName = annotationType.getName()) {
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        fieldInfo.ignore = true;
                        continue block18;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAnySetter": {
                        fieldInfo.features |= 0x2000000000000L;
                        continue block18;
                    }
                    case "com.alibaba.fastjson.annotation.JSONField": {
                        this.processJSONField1x(fieldInfo, annotation);
                        continue block18;
                    }
                    case "com.fasterxml.jackson.annotation.JsonProperty": {
                        this.processJacksonJsonProperty(fieldInfo, annotation);
                        continue block18;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAlias": {
                        this.processJacksonJsonAlias(fieldInfo, annotation);
                        continue block18;
                    }
                    case "com.taobao.api.internal.mapping.ApiField": {
                        this.processTaobaoApiField(fieldInfo, annotation);
                        continue block18;
                    }
                }
            }
            this.getFieldInfo(fieldInfo, jsonField);
            String fieldName = methodName.startsWith("set") ? BeanUtils.setterName(methodName, null) : BeanUtils.getterName(methodName, null);
            BeanUtils.declaredFields(objectClass, field -> {
                int modifiers;
                if (field.getName().equals(fieldName) && !Modifier.isPublic(modifiers = field.getModifiers()) && !Modifier.isStatic(modifiers)) {
                    this.getFieldInfo(fieldInfo, objectClass, (Field)field);
                }
            });
        }

        private void processAnnotation(FieldInfo fieldInfo, Annotation[] annotations) {
            JSONField jsonField = null;
            block16: for (Annotation annotation : annotations) {
                String annotationTypeName;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == JSONField.class) {
                    jsonField = (JSONField)annotation;
                }
                switch (annotationTypeName = annotationType.getName()) {
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        fieldInfo.ignore = true;
                        continue block16;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAnyGetter": {
                        fieldInfo.features |= 0x2000000000000L;
                        continue block16;
                    }
                    case "com.alibaba.fastjson.annotation.JSONField": {
                        this.processJSONField1x(fieldInfo, annotation);
                        continue block16;
                    }
                    case "com.fasterxml.jackson.annotation.JsonProperty": {
                        this.processJacksonJsonProperty(fieldInfo, annotation);
                        continue block16;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAlias": {
                        this.processJacksonJsonAlias(fieldInfo, annotation);
                        continue block16;
                    }
                    case "com.taobao.api.internal.mapping.ApiField": {
                        this.processTaobaoApiField(fieldInfo, annotation);
                        continue block16;
                    }
                }
            }
            this.getFieldInfo(fieldInfo, jsonField);
        }

        private void processJacksonJsonProperty(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    block5 : switch (name) {
                        case "value": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.fieldName = value;
                            break;
                        }
                        case "access": {
                            String access;
                            switch (access = ((Enum)result).name()) {
                                case "WRITE_ONLY": {
                                    fieldInfo.ignore = true;
                                    break block5;
                                }
                            }
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJacksonJsonAlias(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "value": {
                            String[] values = (String[])result;
                            if (values.length == 0) break;
                            fieldInfo.alternateNames = values;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processTaobaoApiField(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "value": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void processJSONField1x(FieldInfo fieldInfo, Annotation annotation) {
            Class<?> annotationClass = annotation.getClass();
            BeanUtils.annotationMethods(annotationClass, m -> {
                String name = m.getName();
                try {
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    switch (name) {
                        case "name": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.fieldName = value;
                            break;
                        }
                        case "format": {
                            String format = (String)result;
                            if (format.isEmpty()) break;
                            if ((format = format.trim()).indexOf(84) != -1 && !format.contains("'T'")) {
                                format = format.replaceAll("T", "'T'");
                            }
                            fieldInfo.format = format;
                            break;
                        }
                        case "label": {
                            String label = (String)result;
                            if (label.isEmpty()) break;
                            fieldInfo.label = label;
                            break;
                        }
                        case "defaultValue": {
                            String value = (String)result;
                            if (value.isEmpty()) break;
                            fieldInfo.defaultValue = value;
                            break;
                        }
                        case "alternateNames": {
                            String[] alternateNames = (String[])result;
                            if (alternateNames.length == 0) break;
                            if (fieldInfo.alternateNames == null) {
                                fieldInfo.alternateNames = alternateNames;
                                break;
                            }
                            LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
                            for (String alternateName : alternateNames) {
                                nameSet.add(alternateName);
                            }
                            for (String alternateName : fieldInfo.alternateNames) {
                                nameSet.add(alternateName);
                            }
                            fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
                            break;
                        }
                        case "ordinal": {
                            Integer ordinal = (Integer)result;
                            if (ordinal == 0) break;
                            fieldInfo.ordinal = ordinal;
                            break;
                        }
                        case "deserialize": {
                            Boolean serialize = (Boolean)result;
                            if (serialize.booleanValue()) break;
                            fieldInfo.ignore = true;
                            break;
                        }
                        case "parseFeatures": {
                            Enum[] features;
                            block36: for (Enum feature : features = (Enum[])result) {
                                switch (feature.name()) {
                                    case "SupportAutoType": {
                                        fieldInfo.features |= JSONReader.Feature.SupportAutoType.mask;
                                        continue block36;
                                    }
                                    case "SupportArrayToBean": {
                                        fieldInfo.features |= JSONReader.Feature.SupportArrayToBean.mask;
                                        continue block36;
                                    }
                                    case "InitStringFieldAsEmpty": {
                                        fieldInfo.features |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                                        continue block36;
                                    }
                                }
                            }
                            break;
                        }
                        case "deserializeUsing": {
                            Class deserializeUsing = (Class)result;
                            if (!ObjectReader.class.isAssignableFrom(deserializeUsing)) break;
                            fieldInfo.readUsing = deserializeUsing;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        private void getFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
            Class deserializeUsing;
            String schema;
            boolean value;
            String[] alternateNames;
            String[] parts;
            String locale;
            String defaultValue;
            String label;
            String jsonFieldFormat;
            if (jsonField == null) {
                return;
            }
            String jsonFieldName = jsonField.name();
            if (!jsonFieldName.isEmpty()) {
                fieldInfo.fieldName = jsonFieldName;
            }
            if (!(jsonFieldFormat = jsonField.format()).isEmpty()) {
                if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                    jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                }
                fieldInfo.format = jsonFieldFormat;
            }
            if (!(label = jsonField.label()).isEmpty()) {
                fieldInfo.label = label = label.trim();
            }
            if (!(defaultValue = jsonField.defaultValue()).isEmpty()) {
                fieldInfo.defaultValue = defaultValue;
            }
            if (!(locale = jsonField.locale()).isEmpty() && (parts = locale.split("_")).length == 2) {
                fieldInfo.locale = new Locale(parts[0], parts[1]);
            }
            if ((alternateNames = jsonField.alternateNames()).length != 0) {
                if (fieldInfo.alternateNames == null) {
                    fieldInfo.alternateNames = alternateNames;
                } else {
                    LinkedHashSet nameSet = new LinkedHashSet();
                    for (String alternateName : alternateNames) {
                        nameSet.add(alternateName);
                    }
                    String[] stringArray = fieldInfo.alternateNames;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String alternateName;
                        alternateName = stringArray[i];
                        nameSet.add(alternateName);
                    }
                    fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
                }
            }
            if (!fieldInfo.ignore) {
                fieldInfo.ignore = !jsonField.deserialize();
            }
            for (JSONReader.Feature feature : jsonField.deserializeFeatures()) {
                fieldInfo.features |= feature.mask;
            }
            int ordinal = jsonField.ordinal();
            if (ordinal != 0) {
                fieldInfo.ordinal = ordinal;
            }
            if (value = jsonField.value()) {
                fieldInfo.features |= 0x1000000000000L;
            }
            if (jsonField.unwrapped()) {
                fieldInfo.features |= 0x2000000000000L;
            }
            if (!(schema = jsonField.schema().trim()).isEmpty()) {
                fieldInfo.schema = schema;
            }
            if (ObjectReader.class.isAssignableFrom(deserializeUsing = jsonField.deserializeUsing())) {
                fieldInfo.readUsing = deserializeUsing;
            }
        }
    }

    static class CharacterImpl
    extends PrimitiveImpl {
        static final CharacterImpl INSTANCE = new CharacterImpl();

        CharacterImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String str = jsonReader.readString();
            if (str == null) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String str = jsonReader.readString();
            if (str == null) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    static class BooleanImpl
    extends PrimitiveImpl {
        static final BooleanImpl INSTANCE = new BooleanImpl();

        BooleanImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readBool();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readBool();
        }
    }

    static class IntegerImpl
    extends PrimitiveImpl {
        static final IntegerImpl INSTANCE = new IntegerImpl();

        IntegerImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt32();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt32();
        }
    }

    static class LongImpl
    extends PrimitiveImpl<Long> {
        static final LongImpl INSTANCE = new LongImpl();

        LongImpl() {
        }

        @Override
        public Long readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt64();
        }

        @Override
        public Long readObject(JSONReader jsonReader, long features) {
            return jsonReader.readInt64();
        }
    }

    static class FloatImpl
    extends PrimitiveImpl {
        static final FloatImpl INSTANCE = new FloatImpl();

        FloatImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readFloat();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readFloat();
        }
    }

    static class DoubleImpl
    extends PrimitiveImpl {
        static final DoubleImpl INSTANCE = new DoubleImpl();

        DoubleImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readDouble();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readDouble();
        }
    }

    static class NumberImpl
    extends PrimitiveImpl {
        static final NumberImpl INSTANCE = new NumberImpl();

        NumberImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readNumber();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readNumber();
        }
    }

    static class OptionalLongImpl
    extends PrimitiveImpl {
        static final OptionalLongImpl INSTANCE = new OptionalLongImpl();

        OptionalLongImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Long integer = jsonReader.readInt64();
            if (integer == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(integer);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Long integer = jsonReader.readInt64();
            if (integer == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(integer);
        }
    }

    static class OptionalDoubleImpl
    extends PrimitiveImpl {
        static final OptionalDoubleImpl INSTANCE = new OptionalDoubleImpl();

        OptionalDoubleImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Double value = jsonReader.readDouble();
            if (value == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Double value = jsonReader.readDouble();
            if (value == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(value);
        }
    }

    static class UUIDImpl
    extends PrimitiveImpl {
        static final UUIDImpl INSTANCE = new UUIDImpl();

        UUIDImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readUUID();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readUUID();
        }
    }

    static class LocalDateImpl
    extends PrimitiveImpl {
        static final LocalDateImpl INSTANCE = new LocalDateImpl();

        LocalDateImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalDate();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalDate();
        }
    }

    static class LocalTimeImpl
    extends PrimitiveImpl {
        static final LocalTimeImpl INSTANCE = new LocalTimeImpl();

        LocalTimeImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalTime();
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalTime();
        }
    }

    static class LocalDateTimeImpl
    extends DateTimeCodec
    implements ObjectReader {
        static final LocalDateTimeImpl INSTANCE = new LocalDateTimeImpl(null);
        static final LocalDateTimeImpl INSTANCE_UNIXTIME = new LocalDateTimeImpl("unixtime");

        public LocalDateTimeImpl(String format) {
            super(format);
        }

        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readLocalDateTime();
        }

        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.isInt()) {
                DateTimeFormatter formatter = this.getDateFormatter();
                if (formatter != null) {
                    String str = jsonReader.readString();
                    return LocalDateTime.parse(str, formatter);
                }
                long millis = jsonReader.readInt64Value();
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
                Instant instant = Instant.ofEpochMilli(millis);
                ZoneId zoneId = jsonReader.getContext().getZoneId();
                return LocalDateTime.ofInstant(instant, zoneId);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            return jsonReader.readLocalDateTime();
        }
    }

    static class LocaleImpl
    extends PrimitiveImpl {
        static final LocaleImpl INSTANCE = new LocaleImpl();

        LocaleImpl() {
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            String[] items = strVal.split("_");
            if (items.length == 1) {
                return new Locale(items[0]);
            }
            if (items.length == 2) {
                return new Locale(items[0], items[1]);
            }
            return new Locale(items[0], items[1], items[2]);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            String strVal = jsonReader.readString();
            if (strVal == null || strVal.isEmpty()) {
                return null;
            }
            String[] items = strVal.split("_");
            if (items.length == 1) {
                return new Locale(items[0]);
            }
            if (items.length == 2) {
                return new Locale(items[0], items[1]);
            }
            return new Locale(items[0], items[1], items[2]);
        }
    }

    static class BoolValueArrayImpl
    extends PrimitiveImpl {
        static final BoolValueArrayImpl INSTANCE = new BoolValueArrayImpl();

        BoolValueArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                boolean[] values = new boolean[16];
                int size = 0;
                while (!jsonReader.nextIfMatch(']')) {
                    int minCapacity = size + 1;
                    if (minCapacity - values.length > 0) {
                        int oldCapacity = values.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity - minCapacity < 0) {
                            newCapacity = minCapacity;
                        }
                        values = Arrays.copyOf(values, newCapacity);
                    }
                    values[size++] = jsonReader.readBoolValue();
                }
                jsonReader.nextIfMatch(',');
                return Arrays.copyOf(values, size);
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            boolean[] array = new boolean[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readBoolValue();
            }
            return array;
        }
    }

    static class AtomicIntegerArrayImpl
    extends PrimitiveImpl {
        static final AtomicIntegerArrayImpl INSTANCE = new AtomicIntegerArrayImpl();

        AtomicIntegerArrayImpl() {
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch('[')) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                while (!jsonReader.nextIfMatch(']')) {
                    values.add(jsonReader.readInt32());
                }
                jsonReader.nextIfMatch(',');
                AtomicIntegerArray array = new AtomicIntegerArray(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Integer value = (Integer)values.get(i);
                    if (value == null) continue;
                    array.set(i, value);
                }
                return array;
            }
            throw new JSONException("TODO");
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt == -1) {
                return null;
            }
            AtomicIntegerArray array = new AtomicIntegerArray(entryCnt);
            for (int i = 0; i < entryCnt; ++i) {
                Integer value = jsonReader.readInt32();
                if (value == null) continue;
                array.set(i, value);
            }
            return array;
        }
    }

    static class SingletonSetImpl
    extends PrimitiveImpl {
        static final Class TYPE = Collections.singleton(1).getClass();

        SingletonSetImpl() {
        }

        @Override
        public Class getObjectClass() {
            return TYPE;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 1) {
                throw new JSONException("input not singleton");
            }
            Object value = jsonReader.read(Object.class);
            return Collections.singleton(value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            jsonReader.nextIfMatch('[');
            Object value = jsonReader.readAny();
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException("input not singleton");
            }
            jsonReader.nextIfMatch(',');
            return Collections.singleton(value);
        }
    }

    static class MapEntryImpl
    extends PrimitiveImpl {
        final Type keyType;
        final Type valueType;
        volatile ObjectReader keyReader;
        volatile ObjectReader valueReader;

        public MapEntryImpl(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            Object value;
            Object key;
            int entryCnt = jsonReader.startArray();
            if (entryCnt != 2) {
                throw new JSONException("entryCnt must be 2, but " + entryCnt);
            }
            if (this.keyType == null) {
                key = jsonReader.readAny();
            } else {
                if (this.keyReader == null) {
                    this.keyReader = jsonReader.getObjectReader(this.keyType);
                }
                key = this.keyReader.readObject(jsonReader, features);
            }
            if (this.valueType == null) {
                value = jsonReader.readAny();
            } else {
                if (this.valueReader == null) {
                    this.valueReader = jsonReader.getObjectReader(this.valueType);
                }
                value = this.valueReader.readObject(jsonReader, features);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(key, value);
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Object value;
            jsonReader.nextIfMatch('{');
            Object key = jsonReader.readAny();
            jsonReader.nextIfMatch(':');
            if (this.valueType == null) {
                value = jsonReader.readAny();
            } else {
                if (this.valueReader == null) {
                    this.valueReader = jsonReader.getObjectReader(this.valueType);
                }
                value = this.valueReader.readObject(jsonReader, features);
            }
            jsonReader.nextIfMatch('}');
            jsonReader.nextIfMatch(',');
            return new AbstractMap.SimpleEntry<Object, Object>(key, value);
        }
    }

    static class InterfaceImpl
    extends PrimitiveImpl {
        final Type interfaceType;

        public InterfaceImpl(Type interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public Object readObject(JSONReader jsonReader, long features) {
            Object value;
            if (jsonReader.nextIfMatch('{')) {
                long hash = jsonReader.readFieldNameHashCode();
                JSONReader.Context context = jsonReader.getContext();
                if (hash == HASH_TYPE && context.isEnabled(JSONReader.Feature.SupportAutoType)) {
                    String typeName;
                    long typeHash = jsonReader.readTypeHashCode();
                    ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                    if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                        throw new JSONException("auotype not support : " + typeName);
                    }
                    return autoTypeObjectReader.readObject(jsonReader, 0L);
                }
                return ObjectReaderImplMap.INSTANCE.readObject(jsonReader, 0L);
            }
            switch (jsonReader.current()) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = jsonReader.readNumber();
                    break;
                }
                case '[': {
                    value = jsonReader.readArray();
                    break;
                }
                case '\"': 
                case '\'': {
                    value = jsonReader.readString();
                    break;
                }
                case 'f': 
                case 't': {
                    value = jsonReader.readBoolValue();
                    break;
                }
                case 'n': {
                    jsonReader.readNull();
                    value = null;
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + jsonReader.current());
                }
            }
            return value;
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, long features) {
            return jsonReader.readAny();
        }
    }

    static class GenericArrayImpl
    implements ObjectReader {
        final Type itemType;
        final Class<?> componentClass;
        ObjectReader itemObjectReader;

        public GenericArrayImpl(Type itemType) {
            this.itemType = itemType;
            this.componentClass = TypeUtils.getMapping(itemType);
        }

        public Object createInstance(long features) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldReader getFieldReader(long hashCode) {
            return null;
        }

        public Object readJSONBObject(JSONReader jsonReader, long features) {
            int entryCnt = jsonReader.startArray();
            if (entryCnt > 0 && this.itemObjectReader == null) {
                this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
            }
            Object array = Array.newInstance(this.componentClass, entryCnt);
            for (int i = 0; i < entryCnt; ++i) {
                Object item = this.itemObjectReader.readJSONBObject(jsonReader, 0L);
                Array.set(array, i, item);
            }
            return array;
        }

        public Object readObject(JSONReader jsonReader, long features) {
            if (this.itemObjectReader == null) {
                this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
            }
            if (jsonReader.isJSONB()) {
                return this.readJSONBObject(jsonReader, 0L);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            char ch = jsonReader.current();
            if (ch == '\"') {
                String str = jsonReader.readString();
                if (str.isEmpty()) {
                    return null;
                }
                throw new JSONException("format error");
            }
            ArrayList list = new ArrayList();
            if (ch != '[') {
                throw new JSONException("format error : " + ch);
            }
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                Object item;
                if (this.itemObjectReader != null) {
                    item = this.itemObjectReader.readObject(jsonReader, 0L);
                } else if (this.itemType == String.class) {
                    item = jsonReader.readString();
                } else {
                    throw new JSONException("TODO : " + this.itemType);
                }
                list.add(item);
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            jsonReader.nextIfMatch(',');
            Object array = Array.newInstance(this.componentClass, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
    }

    static abstract class PrimitiveImpl<T>
    implements ObjectReader<T> {
        PrimitiveImpl() {
        }

        @Override
        public T createInstance(long features) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldReader getFieldReader(long hashCode) {
            return null;
        }

        @Override
        public abstract T readJSONBObject(JSONReader var1, long var2);
    }
}

