/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class ObjectReaderImplMapString
extends ObjectReaderImplMapTyped {
    public ObjectReaderImplMapString(Class mapType, Class instanceType, long features) {
        super(mapType, instanceType, null, (Type)((Object)String.class), features, null);
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        HashMap<String, Object> object;
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, features);
        }
        boolean match = jsonReader.nextIfMatch('{');
        if (!match && jsonReader.current() == '[') {
            jsonReader.next();
            if (jsonReader.current() == '{') {
                Object arrayItem = this.readObject(jsonReader, features);
                if (jsonReader.nextIfMatch(']')) {
                    jsonReader.nextIfMatch(',');
                    return arrayItem;
                }
            }
            throw new JSONException("expect '{', but '['");
        }
        JSONReader.Context context = jsonReader.getContext();
        Map<String, Object> map = object = this.instanceType == HashMap.class ? new HashMap<String, Object>() : (Map)this.createInstance(context.getFeatures() | features);
        while (!jsonReader.nextIfMatch('}')) {
            long contextFeatures;
            String value;
            String name = jsonReader.readFieldName();
            String origin = object.put(name, value = jsonReader.readString());
            if (origin == null || ((contextFeatures = features | context.getFeatures()) & JSONReader.Feature.DuplicateKeyValueAsArray.mask) == 0L) continue;
            if (origin instanceof Collection) {
                ((Collection)((Object)origin)).add(value);
                object.put(name, value);
                continue;
            }
            JSONArray array = JSONArray.of((Object)origin, (Object)value);
            object.put(name, array);
        }
        jsonReader.nextIfMatch(',');
        return object;
    }
}

