/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathCompilerReflect;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public final class JSONFactory {
    public static final String CREATOR;
    public static final String PROPERTY_DENY_PROPERTY = "fastjson2.parser.deny";
    public static final String PROPERTY_AUTO_TYPE_ACCEPT = "fastjson2.autoTypeAccept";
    public static final String PROPERTY_AUTO_TYPE_HANDLER = "fastjson2.autoTypeHandler";
    public static final String PROPERTY_AUTO_TYPE_BEFORE_HANDLER = "fastjson2.autoTypeBeforeHandler";
    static long defaultReaderFeatures;
    static long defaultWriterFeatures;
    static final BigDecimal LOW;
    static final BigDecimal HIGH;
    static final BigInteger LOW_BIGINT;
    static final BigInteger HIGH_BIGINT;
    static final char[] CA;
    static final char[] DIGITS;
    static final int[] DIGITS2;
    static final Cache CACHE;
    static final int CACHE_THREAD = 0x100000;
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES0_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES1_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES2_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> BYTES3_UPDATER;
    static final AtomicReferenceFieldUpdater<Cache, byte[]> VALUE_BYTES_UPDATER;
    static final Properties DEFAULT_PROPERTIES;
    static ObjectWriterProvider defaultObjectWriterProvider;
    static ObjectReaderProvider defaultObjectReaderProvider;
    static JSONPathCompiler defaultJSONPathCompiler;
    static final ThreadLocal<ObjectReaderCreator> readerCreatorLocal;
    static final ThreadLocal<ObjectReaderProvider> readerProviderLocal;
    static final ThreadLocal<ObjectWriterCreator> writerCreatorLocal;
    static final ThreadLocal<JSONPathCompiler> jsonPathCompilerLocal;
    static final ObjectReader<JSONArray> ARRAY_READER;
    static final ObjectReader<JSONObject> OBJECT_READER;

    public static String getProperty(String key) {
        return DEFAULT_PROPERTIES.getProperty(key);
    }

    public static JSONWriter.Context createWriteContext() {
        return new JSONWriter.Context(defaultObjectWriterProvider);
    }

    public static JSONWriter.Context createWriteContext(JSONWriter.Feature ... features) {
        return new JSONWriter.Context(defaultObjectWriterProvider, features);
    }

    public static JSONReader.Context createReadContext() {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider);
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, Supplier<List> arraySupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.setArraySupplier(arraySupplier);
        context.config(features);
        return context;
    }

    public static ObjectWriterProvider getDefaultObjectWriterProvider() {
        return defaultObjectWriterProvider;
    }

    public static ObjectReaderProvider getDefaultObjectReaderProvider() {
        ObjectReaderProvider providerLocal = readerProviderLocal.get();
        if (providerLocal != null) {
            return providerLocal;
        }
        return defaultObjectReaderProvider;
    }

    public static JSONPathCompiler getDefaultJSONPathCompiler() {
        JSONPathCompiler compilerLocal = jsonPathCompilerLocal.get();
        if (compilerLocal != null) {
            return compilerLocal;
        }
        return defaultJSONPathCompiler;
    }

    public static void setContextReaderCreator(ObjectReaderCreator creator) {
        readerCreatorLocal.set(creator);
    }

    public static void setContextObjectReaderProvider(ObjectReaderProvider creator) {
        readerProviderLocal.set(creator);
    }

    public static ObjectReaderCreator getContextReaderCreator() {
        return readerCreatorLocal.get();
    }

    public static void setContextJSONPathCompiler(JSONPathCompiler compiler) {
        jsonPathCompilerLocal.set(compiler);
    }

    public static JSONPathCompiler getContextJSONPathCompiler() {
        return jsonPathCompilerLocal.get();
    }

    public static void setContextWriterCreator(ObjectWriterCreator creator) {
        writerCreatorLocal.set(creator);
    }

    public static ObjectWriterCreator getContextWriterCreator() {
        return writerCreatorLocal.get();
    }

    static {
        LOW = BigDecimal.valueOf(-9007199254740991L);
        HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
        LOW_BIGINT = BigInteger.valueOf(-9007199254740991L);
        HIGH_BIGINT = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
        CA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DIGITS2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        Properties properties = new Properties();
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                String resourceFile = "fastjson2.properties";
                if (cl != null) {
                    return cl.getResourceAsStream("fastjson2.properties");
                }
                return ClassLoader.getSystemResourceAsStream("fastjson2.properties");
            }
        });
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.close(inputStream);
            }
        }
        DEFAULT_PROPERTIES = properties;
        String property = System.getProperty("fastjson2.creator");
        if (property != null) {
            property = property.trim();
        }
        CREATOR = property == null ? "asm" : property;
        CACHE = new Cache();
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
        BYTES0_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes0");
        BYTES1_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes1");
        BYTES2_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes2");
        BYTES3_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "bytes3");
        VALUE_BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, byte[].class, "valueBytes");
        defaultObjectWriterProvider = new ObjectWriterProvider();
        defaultObjectReaderProvider = new ObjectReaderProvider();
        defaultJSONPathCompiler = JSONPathCompilerReflect.INSTANCE;
        readerCreatorLocal = new ThreadLocal();
        readerProviderLocal = new ThreadLocal();
        writerCreatorLocal = new ThreadLocal();
        jsonPathCompilerLocal = new ThreadLocal();
        ARRAY_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONArray.class));
        OBJECT_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONObject.class));
    }

    public static interface JSONPathCompiler {
        public JSONPath compile(Class var1, JSONPath var2);
    }

    static final class Cache {
        volatile char[] chars;
        volatile byte[] bytes0;
        volatile byte[] bytes1;
        volatile byte[] bytes2;
        volatile byte[] bytes3;
        volatile byte[] valueBytes;

        Cache() {
        }
    }

    static final class SymbolTableImpl
    implements JSONB.SymbolTable {
        private final String[] names;
        private final long hashCode64;
        private final short[] mapping;
        private final long[] hashCodes;
        private final long[] hashCodesOrigin;

        SymbolTableImpl(String ... input) {
            int i;
            TreeSet<String> set = new TreeSet<String>();
            for (String name : input) {
                set.add(name);
            }
            this.names = new String[set.size()];
            Iterator it = set.iterator();
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                if (!it.hasNext()) continue;
                this.names[i2] = (String)it.next();
            }
            long[] hashCodes = new long[this.names.length];
            for (i = 0; i < this.names.length; ++i) {
                long hashCode;
                hashCodes[i] = hashCode = Fnv.hashCode64(this.names[i]);
            }
            this.hashCodesOrigin = hashCodes;
            this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
            Arrays.sort(this.hashCodes);
            this.mapping = new short[this.hashCodes.length];
            for (i = 0; i < hashCodes.length; ++i) {
                long hashCode = hashCodes[i];
                int index = Arrays.binarySearch(this.hashCodes, hashCode);
                this.mapping[index] = (short)i;
            }
            long hashCode64 = -3750763034362895579L;
            for (long hashCode : hashCodes) {
                hashCode64 ^= hashCode;
                hashCode64 *= 1099511628211L;
            }
            this.hashCode64 = hashCode64;
        }

        @Override
        public int size() {
            return this.names.length;
        }

        @Override
        public long hashCode64() {
            return this.hashCode64;
        }

        @Override
        public String getNameByHashCode(long hashCode) {
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return null;
            }
            short index = this.mapping[m];
            return this.names[index];
        }

        @Override
        public int getOrdinalByHashCode(long hashCode) {
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return -1;
            }
            return this.mapping[m] + 1;
        }

        @Override
        public int getOrdinal(String name) {
            long hashCode = Fnv.hashCode64(name);
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return -1;
            }
            return this.mapping[m] + 1;
        }

        @Override
        public String getName(int ordinal) {
            return this.names[ordinal - 1];
        }

        @Override
        public long getHashCode(int ordinal) {
            return this.hashCodesOrigin[ordinal - 1];
        }
    }
}

