/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

final class FieldReaderInt16Field<T>
extends FieldReaderObjectField<T> {
    FieldReaderInt16Field(String fieldName, Class fieldType, int ordinal, long features, String format, Short defaultValue, JSONSchema schema, Field field) {
        super(fieldName, (Type)fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Integer fieldInt = jsonReader.readInt32();
        if (this.schema != null) {
            this.schema.assertValidate(fieldInt);
        }
        try {
            this.field.set(object, fieldInt == null ? null : Short.valueOf(fieldInt.shortValue()));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, int value) {
        if (this.schema != null) {
            this.schema.assertValidate((long)value);
        }
        try {
            this.field.set(object, (short)value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, long value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.set(object, (short)value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        try {
            this.field.set(object, TypeUtils.toShort(value));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return (byte)jsonReader.readInt32Value();
    }
}

