/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.ObjShortConsumer;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;
import java.util.Locale;

final class FieldReaderInt16ValueFunc<T>
extends FieldReaderImpl<T> {
    final Method method;
    final ObjShortConsumer<T> function;

    public FieldReaderInt16ValueFunc(String fieldName, int ordinal, long features, String format, Locale locale, Short defaultValue, JSONSchema schema, Method method, ObjShortConsumer<T> function) {
        super(fieldName, Short.TYPE, Short.TYPE, ordinal, features, format, locale, defaultValue, schema);
        this.method = method;
        this.function = function;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void accept(T object, short value) {
        this.function.accept(object, value);
    }

    @Override
    public void accept(T object, Object value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        this.function.accept(object, TypeUtils.toShortValue(value));
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        short fieldInt = (short)jsonReader.readInt32Value();
        if (this.schema != null) {
            this.schema.assertValidate(fieldInt);
        }
        this.function.accept(object, fieldInt);
    }
}

