/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class TypeConverts {

    static class StringToAny
    implements Function {
        final Object defaultValue;
        final Class targetClass;

        public StringToAny(Class targetClass, Object defaultValue) {
            this.targetClass = targetClass;
            this.defaultValue = defaultValue;
        }

        public Object apply(Object from) {
            String str = (String)from;
            if (str == null || "null".equals(str) || "".equals(str)) {
                return this.defaultValue;
            }
            if (this.targetClass == Byte.TYPE || this.targetClass == Byte.class) {
                return Byte.parseByte(str);
            }
            if (this.targetClass == Short.TYPE || this.targetClass == Short.class) {
                return Short.parseShort(str);
            }
            if (this.targetClass == Integer.TYPE || this.targetClass == Integer.class) {
                return Integer.parseInt(str);
            }
            if (this.targetClass == Long.TYPE || this.targetClass == Long.class) {
                return Long.parseLong(str);
            }
            if (this.targetClass == Float.TYPE || this.targetClass == Float.class) {
                return Float.valueOf(Float.parseFloat(str));
            }
            if (this.targetClass == Double.TYPE || this.targetClass == Double.class) {
                return Double.parseDouble(str);
            }
            if (this.targetClass == Character.TYPE || this.targetClass == Character.class) {
                return Character.valueOf(str.charAt(0));
            }
            if (this.targetClass == Boolean.TYPE || this.targetClass == Boolean.class) {
                return "true".equals(str);
            }
            if (this.targetClass == BigDecimal.class) {
                return new BigDecimal(str);
            }
            if (this.targetClass == BigInteger.class) {
                return new BigInteger(str);
            }
            if ((this.targetClass == Collections.class || this.targetClass == List.class || this.targetClass == JSONArray.class) && "[]".equals(str)) {
                return new JSONArray();
            }
            throw new JSONException("can not convert to " + this.targetClass + ", value : " + str);
        }
    }

    static class ToBigDecimal
    implements Function {
        ToBigDecimal() {
        }

        public Object apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
                return BigDecimal.valueOf(((Number)o).longValue());
            }
            if (o instanceof Float || o instanceof Double) {
                return BigDecimal.valueOf(((Number)o).doubleValue());
            }
            if (o instanceof BigInteger) {
                return new BigDecimal((BigInteger)o);
            }
            throw new JSONException("can not cast to BigDecimal " + o.getClass());
        }
    }

    static class ToBigInteger
    implements Function {
        ToBigInteger() {
        }

        public Object apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong || o instanceof Float || o instanceof Double) {
                return BigInteger.valueOf(((Number)o).longValue());
            }
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).toBigInteger();
            }
            throw new JSONException("can not cast to BigInteger " + o.getClass());
        }
    }

    static class ToString
    implements Function {
        ToString() {
        }

        public Object apply(Object o) {
            if (o == null) {
                return null;
            }
            return o.toString();
        }
    }

    public static class ToDouble
    implements Function {
        final Double defaultValue;

        public ToDouble(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1.0 : 0.0;
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            throw new JSONException("can not cast to Float " + o.getClass());
        }
    }

    static class ToFloat
    implements Function {
        final Float defaultValue;

        ToFloat(Float defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return Float.valueOf((Boolean)o != false ? 1.0f : 0.0f);
            }
            if (o instanceof Number) {
                return Float.valueOf(((Number)o).floatValue());
            }
            throw new JSONException("can not cast to Float " + o.getClass());
        }
    }

    static class ToLong
    implements Function {
        final Long defaultValue;

        ToLong(Long defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1L : 0L;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            throw new JSONException("can not cast to Long " + o.getClass());
        }
    }

    static class ToInteger
    implements Function {
        final Integer defaultValue;

        ToInteger(Integer defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            throw new JSONException("can not cast to Integer " + o.getClass());
        }
    }

    static class ToShort
    implements Function {
        final Short defaultValue;

        ToShort(Short defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? (short)1 : 0;
            }
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
            throw new JSONException("can not cast to Short " + o.getClass());
        }
    }

    static class ToByte
    implements Function {
        final Byte defaultValue;

        ToByte(Byte defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? (byte)1 : 0;
            }
            if (o instanceof Number) {
                return ((Number)o).byteValue();
            }
            throw new JSONException("can not cast to BigInteger " + o.getClass());
        }
    }

    static final class ToNumber
    implements Function {
        final Number defaultValue;

        ToNumber(Number defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object apply(Object o) {
            if (o == null) {
                return this.defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof Number) {
                return o;
            }
            throw new JSONException("can not cast to Number " + o.getClass());
        }
    }
}

