/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterInt64;
import java.lang.reflect.Field;

final class FieldWriterInt64ValField<T>
extends FieldWriterInt64<T> {
    final Field field;

    FieldWriterInt64ValField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, Long.TYPE);
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T o) {
        long value;
        try {
            value = this.field.getLong(o);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
        if (value == 0L && jsonWriter.isEnabled(JSONWriter.Feature.NotWriteDefaultValue)) {
            return false;
        }
        this.writeInt64(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        try {
            long value = this.field.getLong(object);
            jsonWriter.writeInt64(value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }
}

