/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Optional;

class ObjectReaderImplOptional
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplOptional INSTANCE = new ObjectReaderImplOptional(null, null, null);
    final String format;
    final Locale locale;
    final Type itemType;
    final Class itemClass;
    ObjectReader itemObjectReader;

    static ObjectReaderImplOptional of(Type type, String format, Locale locale) {
        if (type == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplOptional(type, format, locale);
    }

    public ObjectReaderImplOptional(Type type, String format, Locale locale) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type itemType = null;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            itemType = actualTypeArguments[0];
        }
        this.itemType = itemType;
        this.itemClass = TypeUtils.getClass(itemType);
        this.format = format;
        this.locale = locale;
    }

    @Override
    public Class getObjectClass() {
        return Optional.class;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        Object value;
        if (this.itemType == null) {
            value = jsonReader.readAny();
        } else {
            if (this.itemObjectReader == null) {
                ObjectReader formattedObjectReader = null;
                if (this.format != null) {
                    formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.itemType, this.itemClass, this.format, this.locale);
                }
                this.itemObjectReader = formattedObjectReader == null ? jsonReader.getObjectReader(this.itemType) : formattedObjectReader;
            }
            value = this.itemObjectReader.readJSONBObject(jsonReader, 0L);
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        Object value;
        if (this.itemType == null) {
            value = jsonReader.readAny();
        } else {
            if (this.itemObjectReader == null) {
                ObjectReader formattedObjectReader = null;
                if (this.format != null) {
                    formattedObjectReader = FieldReaderObject.createFormattedObjectReader(this.itemType, this.itemClass, this.format, this.locale);
                }
                this.itemObjectReader = formattedObjectReader == null ? jsonReader.getObjectReader(this.itemType) : formattedObjectReader;
            }
            value = this.itemObjectReader.readObject(jsonReader, 0L);
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

