/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.IOUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

final class FieldReaderDateField<T>
extends FieldReaderObjectField<T> {
    private ObjectReaderImplDate dateReader;
    DateTimeFormatter formatter;
    final Locale locale;
    final boolean useSimpleFormatter;
    final boolean formatISO8601;
    final boolean formatUnixTime;
    final boolean formatMillis;
    final boolean formatHasDay;
    final boolean formatHasHour;

    FieldReaderDateField(String fieldName, Class fieldType, int ordinal, long features, String format, Locale locale, Date defaultValue, JSONSchema schema, Field field) {
        super(fieldName, (Type)fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
        this.locale = locale;
        this.useSimpleFormatter = "yyyyMMddHHmmssSSSZ".equals(format);
        boolean formatUnixTime = false;
        boolean formatISO8601 = false;
        boolean formatMillis = false;
        boolean hasDay = false;
        boolean hasHour = false;
        if (format != null) {
            switch (format) {
                case "unixtime": {
                    formatUnixTime = true;
                    break;
                }
                case "iso8601": {
                    formatISO8601 = true;
                    break;
                }
                case "millis": {
                    formatMillis = true;
                    break;
                }
                default: {
                    hasDay = format.indexOf(100) != -1;
                    hasHour = format.indexOf(72) != -1 || format.indexOf(104) != -1 || format.indexOf(75) != -1 || format.indexOf(107) != -1;
                }
            }
        }
        this.formatUnixTime = formatUnixTime;
        this.formatMillis = formatMillis;
        this.formatISO8601 = formatISO8601;
        this.formatHasDay = hasDay;
        this.formatHasHour = hasHour;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplDate.INSTANCE : new ObjectReaderImplDate(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            this.getObjectReader(jsonReader);
            if (this.dateReader.formatUnixTime) {
                millis *= 1000L;
            }
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.useSimpleFormatter) {
            String str = jsonReader.readString();
            try {
                fieldValue = new SimpleDateFormat(this.format).parse(str);
            }
            catch (ParseException e) {
                throw new JSONException(jsonReader.info("parse error : " + str), e);
            }
        } else {
            long millis;
            if (this.format != null) {
                String str = jsonReader.readString();
                if ((this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                    millis = Long.parseLong(str);
                    if (this.formatUnixTime) {
                        millis *= 1000L;
                    }
                } else {
                    DateTimeFormatter formatter = this.getFormatter(jsonReader.getLocale());
                    LocalDateTime ldt = !this.formatHasHour ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                    ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                    millis = zdt.toInstant().toEpochMilli();
                }
            } else {
                millis = jsonReader.readMillisFromString();
            }
            fieldValue = new Date(millis);
        }
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, Object value) {
        if (value instanceof String) {
            long millis;
            String str = (String)value;
            if ((this.format == null || this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                millis = Long.parseLong(str);
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
            } else {
                DateTimeFormatter formatter = this.getFormatter(null);
                LocalDateTime ldt = !this.formatHasHour ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
                millis = zdt.toInstant().toEpochMilli();
            }
            value = new Date(millis);
        } else if (value instanceof Integer) {
            long millis = ((Integer)value).intValue();
            if (this.dateReader.formatUnixTime) {
                millis *= 1000L;
            }
            value = new Date(millis);
        }
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    private DateTimeFormatter getFormatter(Locale locale) {
        if (this.formatter != null && locale == null) {
            return this.formatter;
        }
        String format = this.format.replaceAll("aa", "a");
        if (locale != null && locale != Locale.getDefault()) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        if (this.locale != null) {
            this.formatter = DateTimeFormatter.ofPattern(format, this.locale);
            return this.formatter;
        }
        this.formatter = DateTimeFormatter.ofPattern(format);
        return this.formatter;
    }
}

