/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectMethod;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.IOUtils;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

final class FieldReaderDateMethod<T>
extends FieldReaderObjectMethod<T> {
    DateTimeFormatter formatter;
    ObjectReaderImplDate dateReader;
    final boolean formatISO8601;
    final boolean formatUnixTime;
    final boolean formatMillis;
    final boolean formatHasDay;
    final boolean formatHasHour;

    FieldReaderDateMethod(String fieldName, Class fieldClass, int ordinal, long features, String format, Locale locale, JSONSchema schema, Method method) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, locale, null, schema, method);
        boolean formatUnixTime = false;
        boolean formatISO8601 = false;
        boolean formatMillis = false;
        boolean hasDay = false;
        boolean hasHour = false;
        if (format != null) {
            switch (format) {
                case "unixtime": {
                    formatUnixTime = true;
                    break;
                }
                case "iso8601": {
                    formatISO8601 = true;
                    break;
                }
                case "millis": {
                    formatMillis = true;
                    break;
                }
                default: {
                    hasDay = format.indexOf(100) != -1;
                    hasHour = format.indexOf(72) != -1 || format.indexOf(104) != -1 || format.indexOf(75) != -1 || format.indexOf(107) != -1;
                }
            }
        }
        this.formatUnixTime = formatUnixTime;
        this.formatMillis = formatMillis;
        this.formatISO8601 = formatISO8601;
        this.formatHasDay = hasDay;
        this.formatHasHour = hasHour;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplDate.INSTANCE : new ObjectReaderImplDate(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public void accept(T object, Object value) {
        try {
            if (value instanceof String) {
                long millis;
                String str = (String)value;
                if ((this.format == null || this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                    millis = Long.parseLong(str);
                    if (this.formatUnixTime) {
                        millis *= 1000L;
                    }
                } else {
                    DateTimeFormatter formatter = this.getFormatter(null);
                    LocalDateTime ldt = !this.formatHasHour ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                    ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
                    millis = zdt.toInstant().toEpochMilli();
                }
                value = new Date(millis);
            }
            this.method.invoke(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Date fieldValue;
        if (jsonReader.isInt() && (this.format == null || this.formatUnixTime || this.formatMillis)) {
            long millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            fieldValue = new Date(millis);
        } else if (jsonReader.isNull()) {
            jsonReader.readNull();
            fieldValue = null;
        } else if (this.format != null) {
            long millis;
            String str = jsonReader.readString();
            if ((this.formatUnixTime || this.formatMillis) && IOUtils.isNumber(str)) {
                millis = Long.parseLong(str);
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
            } else {
                Locale locale = jsonReader.getContext().getLocale();
                DateTimeFormatter formatter = this.getFormatter(locale);
                LocalDateTime ldt = !this.formatHasHour ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : LocalDateTime.parse(str, formatter);
                ZonedDateTime zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                millis = zdt.toInstant().toEpochMilli();
            }
            fieldValue = new Date(millis);
        } else {
            long millis = jsonReader.readMillisFromString();
            fieldValue = new Date(millis);
        }
        try {
            this.method.invoke(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    private DateTimeFormatter getFormatter(Locale locale) {
        if (this.formatter != null && locale == null) {
            return this.formatter;
        }
        String format = this.format.replaceAll("aa", "a");
        if (locale != null && locale != Locale.getDefault()) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        if (this.locale != null) {
            this.formatter = DateTimeFormatter.ofPattern(format, this.locale);
            return this.formatter;
        }
        this.formatter = DateTimeFormatter.ofPattern(format);
        return this.formatter;
    }
}

