/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;

final class ObjectWriterMisc
implements ObjectWriter {
    static final ObjectWriterMisc INSTANCE = new ObjectWriterMisc();

    ObjectWriterMisc() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        String str;
        String objectClassName;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        Class<?> objectClass = object.getClass();
        switch (objectClassName = objectClass.getName()) {
            case "net.sf.json.JSONNull": {
                jsonWriter.writeNull();
                return;
            }
            case "java.net.Inet4Address": 
            case "java.net.Inet6Address": {
                str = ((InetAddress)object).getHostName();
                break;
            }
            case "java.text.SimpleDateFormat": {
                str = ((SimpleDateFormat)object).toPattern();
                break;
            }
            case "java.net.InetSocketAddress": {
                InetSocketAddress address = (InetSocketAddress)object;
                jsonWriter.startObject();
                jsonWriter.writeName("address");
                jsonWriter.writeColon();
                jsonWriter.writeAny(address.getAddress());
                jsonWriter.writeName("port");
                jsonWriter.writeColon();
                jsonWriter.writeInt32(address.getPort());
                jsonWriter.endObject();
                return;
            }
            default: {
                throw new JSONException("not support class : " + objectClassName);
            }
        }
        jsonWriter.writeString(str);
    }
}

