/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.RyuFloat;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.UUID;

class JSONWriterUTF8
extends JSONWriter {
    static final byte[] REF_PREF = "{\"$ref\":".getBytes(StandardCharsets.US_ASCII);
    private final int cachedIndex;
    protected byte[] bytes;

    JSONWriterUTF8(JSONWriter.Context ctx) {
        super(ctx, StandardCharsets.UTF_8);
        int identityHashCode = System.identityHashCode(Thread.currentThread());
        this.cachedIndex = identityHashCode & 3;
        this.bytes = JSONFactory.CACHE_BYTES.getAndSet(this.cachedIndex, null);
        if (this.bytes == null) {
            this.bytes = new byte[1024];
        }
    }

    @Override
    public void writeReference(String path) {
        this.lastReference = path;
        this.writeRaw(REF_PREF);
        this.writeString(path);
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 125;
    }

    @Override
    public void writeBase64(byte[] bytes) {
        int i;
        int charsLen = (bytes.length - 1) / 3 + 1 << 2;
        this.ensureCapacity(this.off + charsLen + 2);
        this.bytes[this.off++] = 34;
        int eLen = bytes.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 18 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 12 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i & 0x3F];
        }
        int left = bytes.length - eLen;
        if (left > 0) {
            i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytes.length - 1] & 0xFF) << 2 : 0);
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >> 12];
            this.bytes[this.off++] = (byte)JSONFactory.CA[i >>> 6 & 0x3F];
            this.bytes[this.off++] = left == 2 ? (int)JSONFactory.CA[i & 0x3F] : 61;
            this.bytes[this.off++] = 61;
        }
        this.bytes[this.off++] = 34;
    }

    @Override
    public void close() {
        if (this.bytes.length > 0x100000) {
            return;
        }
        JSONFactory.CACHE_BYTES.set(this.cachedIndex, this.bytes);
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.off);
    }

    @Override
    public int flushTo(OutputStream to) throws IOException {
        int len = this.off;
        to.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }

    @Override
    protected void write0(char c) {
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)c;
    }

    @Override
    public void writeColon() {
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 58;
    }

    @Override
    public void startObject() {
        ++this.level;
        this.startObject = true;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 123;
    }

    @Override
    public void endObject() {
        --this.level;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 125;
        this.startObject = false;
    }

    @Override
    public void writeComma() {
        this.startObject = false;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 44;
    }

    @Override
    public void startArray() {
        ++this.level;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 91;
    }

    @Override
    public void endArray() {
        --this.level;
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = 93;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void writeString(String str) {
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        chars = str.toCharArray();
        minCapacity = this.off + chars.length * 3 + 2;
        if (minCapacity - this.bytes.length > 0) {
            oldCapacity = this.bytes.length;
            newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - JSONWriterUTF8.MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        i = 0;
        while (i + 4 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            c2 = chars[i + 2];
            c3 = chars[i + 3];
            if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f') break;
            this.bytes[this.off] = (byte)c0;
            this.bytes[this.off + 1] = (byte)c1;
            this.bytes[this.off + 2] = (byte)c2;
            this.bytes[this.off + 3] = (byte)c3;
            this.off += 4;
            i += 4;
        }
        if (i + 2 <= chars.length) {
            c0 = chars[i];
            c1 = chars[i + 1];
            if (c0 != this.quote && c1 != this.quote && c0 != '\\' && c1 != '\\' && c0 >= ' ' && c1 >= ' ' && c0 <= '\u007f' && c1 <= '\u007f') {
                this.bytes[this.off] = (byte)c0;
                this.bytes[this.off + 1] = (byte)c1;
                this.off += 2;
                i += 2;
            }
        }
        if (i + 1 == chars.length && (c0 = chars[i]) != this.quote && c0 != '\\' && c0 >= ' ' && c0 <= '\u007f') {
            this.bytes[this.off++] = (byte)c0;
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        while (i < chars.length) {
            block30: {
                block31: {
                    block32: {
                        block34: {
                            block33: {
                                block29: {
                                    ch = chars[i];
                                    if (ch < '\u0000' || ch > '\u007f') break block29;
                                    switch (ch) {
                                        case 92: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 92;
                                            break;
                                        }
                                        case 10: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 110;
                                            break;
                                        }
                                        case 13: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 114;
                                            break;
                                        }
                                        case 12: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 102;
                                            break;
                                        }
                                        case 8: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 98;
                                            break;
                                        }
                                        case 9: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 116;
                                            break;
                                        }
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 117;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = (byte)(48 + ch);
                                            break;
                                        }
                                        case 11: 
                                        case 14: 
                                        case 15: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 117;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                            break;
                                        }
                                        case 16: 
                                        case 17: 
                                        case 18: 
                                        case 19: 
                                        case 20: 
                                        case 21: 
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 117;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 49;
                                            this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                            break;
                                        }
                                        case 26: 
                                        case 27: 
                                        case 28: 
                                        case 29: 
                                        case 30: 
                                        case 31: {
                                            this.bytes[this.off++] = 92;
                                            this.bytes[this.off++] = 117;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 48;
                                            this.bytes[this.off++] = 49;
                                            this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                            break;
                                        }
                                        default: {
                                            if (ch == this.quote) {
                                                this.bytes[this.off++] = 92;
                                                this.bytes[this.off++] = (byte)this.quote;
                                                break;
                                            }
                                            this.bytes[this.off++] = (byte)ch;
                                            break;
                                        }
                                    }
                                    break block30;
                                }
                                if (ch < '\ud800' || ch >= '\ue000') break block31;
                                if (ch < '\ud800' || ch >= '\udc00') break block32;
                                if (chars.length - i >= 2) break block33;
                                uc = '\uffffffff';
                                ** GOTO lbl131
                            }
                            d = chars[i + 1];
                            if (d < '\udc00' || d >= '\ue000') break block34;
                            uc = (ch << 10) + d + -56613888;
                            ** GOTO lbl131
                        }
                        this.bytes[this.off++] = 63;
                        break block30;
                    }
                    if (ch >= '\udc00' && ch < '\ue000') {
                        this.bytes[this.off++] = 63;
                    } else {
                        uc = ch;
lbl131:
                        // 3 sources

                        if (uc < '\u0000') {
                            this.bytes[this.off++] = 63;
                        } else {
                            this.bytes[this.off++] = (byte)(240 | uc >> 18);
                            this.bytes[this.off++] = (byte)(128 | uc >> 12 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc >> 6 & 63);
                            this.bytes[this.off++] = (byte)(128 | uc & 63);
                            ++i;
                        }
                    }
                    break block30;
                }
                if (ch > '\u07ff') {
                    this.bytes[this.off++] = (byte)(224 | ch >> 12 & 15);
                    this.bytes[this.off++] = (byte)(128 | ch >> 6 & 63);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                } else {
                    this.bytes[this.off++] = (byte)(192 | ch >> 6 & 31);
                    this.bytes[this.off++] = (byte)(128 | ch >> 0 & 63);
                }
            }
            ++i;
        }
        this.bytes[this.off++] = (byte)this.quote;
    }

    @Override
    public void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        this.ensureCapacity(this.off + 38);
        this.bytes[this.off++] = 34;
        JSONWriterUTF8.formatUnsignedLong0(lsb, this.bytes, this.off + 24, 12);
        JSONWriterUTF8.formatUnsignedLong0(lsb >>> 48, this.bytes, this.off + 19, 4);
        JSONWriterUTF8.formatUnsignedLong0(msb, this.bytes, this.off + 14, 4);
        JSONWriterUTF8.formatUnsignedLong0(msb >>> 16, this.bytes, this.off + 9, 4);
        JSONWriterUTF8.formatUnsignedLong0(msb >>> 32, this.bytes, this.off + 0, 8);
        this.bytes[this.off + 23] = 45;
        this.bytes[this.off + 18] = 45;
        this.bytes[this.off + 13] = 45;
        this.bytes[this.off + 8] = 45;
        this.off += 36;
        this.bytes[this.off++] = 34;
    }

    @Override
    public void writeRaw(String str) {
        char[] chars = str.toCharArray();
        int minCapacity = this.off + chars.length * 3;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.bytes[this.off++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytes[this.off++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytes[this.off++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytes[this.off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytes[this.off++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public void writeRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeNameRaw(byte[] bytes) {
        int minCapacity = this.off + bytes.length + (this.startObject ? 0 : 1);
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.bytes[this.off++] = 44;
        }
        System.arraycopy(bytes, 0, this.bytes, this.off, bytes.length);
        this.off += bytes.length;
    }

    @Override
    public void writeRaw(char ch) {
        if (ch < '\u0000' || ch > '\u0080') {
            throw new JSONException("not support " + ch);
        }
        if (this.off == this.bytes.length) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.off + 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        this.bytes[this.off++] = (byte)ch;
    }

    @Override
    public void writeNameRaw(byte[] bytes, int off, int len) {
        int minCapacity = this.off + len + (this.startObject ? 0 : 1);
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.bytes[this.off++] = 44;
        }
        System.arraycopy(bytes, off, this.bytes, this.off, len);
        this.off += len;
    }

    void ensureCapacity(int minCapacity) {
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
    }

    @Override
    public void writeInt32(int i) {
        int r;
        int q;
        int index;
        int minCapacity;
        int x;
        if ((this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            this.writeString(Integer.toString(i));
            return;
        }
        if (i == Integer.MIN_VALUE) {
            this.writeRaw("-2147483648");
            return;
        }
        int n = x = i < 0 ? -i : i;
        int size = x <= 9 ? 1 : (x <= 99 ? 2 : (x <= 999 ? 3 : (x <= 9999 ? 4 : (x <= 99999 ? 5 : (x <= 999999 ? 6 : (x <= 9999999 ? 7 : (x <= 99999999 ? 8 : (x <= 999999999 ? 9 : 10))))))));
        if (i < 0) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        int p = index = this.off + size;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.bytes[--p] = IOUtils.DigitOnes[r];
            this.bytes[--p] = IOUtils.DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.bytes[--p] = IOUtils.digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            this.bytes[--p] = sign;
        }
        this.off += size;
    }

    @Override
    public void writeInt64(long i) {
        int q2;
        int r;
        int index;
        int minCapacity;
        long x;
        if ((this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L || (this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (i > 0x1FFFFFFFFFFFFFL || i < -9007199254740991L)) {
            String str = Long.toString(i);
            this.writeString(str);
            return;
        }
        if (i == Long.MIN_VALUE) {
            this.writeRaw("-9223372036854775808");
            return;
        }
        long l = x = i < 0L ? -i : i;
        int size = x <= 9L ? 1 : (x <= 99L ? 2 : (x <= 999L ? 3 : (x <= 9999L ? 4 : (x <= 99999L ? 5 : (x <= 999999L ? 6 : (x <= 9999999L ? 7 : (x <= 99999999L ? 8 : (x <= 999999999L ? 9 : (x <= 9999999999L ? 10 : (x <= 99999999999L ? 11 : (x <= 999999999999L ? 12 : (x <= 9999999999999L ? 13 : (x <= 99999999999999L ? 14 : (x <= 999999999999999L ? 15 : (x <= 9999999999999999L ? 16 : (x <= 99999999999999999L ? 17 : (x <= 999999999999999999L ? 18 : 19)))))))))))))))));
        if (i < 0L) {
            ++size;
        }
        if ((minCapacity = this.off + size) - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        int charPos = index = this.off + size;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.bytes[--charPos] = IOUtils.DigitOnes[r];
            this.bytes[--charPos] = IOUtils.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.bytes[--charPos] = IOUtils.DigitOnes[r];
            this.bytes[--charPos] = IOUtils.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.bytes[--charPos] = IOUtils.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.bytes[--charPos] = sign;
        }
        this.off += size;
    }

    @Override
    public void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 15);
        int len = RyuFloat.toString(value, this.bytes, this.off);
        this.off += len;
    }

    @Override
    public void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.writeNull();
            return;
        }
        this.ensureCapacity(this.off + 24);
        int len = RyuDouble.toString(value, this.bytes, this.off);
        this.off += len;
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 21);
        this.bytes[this.off++] = 34;
        this.bytes[this.off++] = (byte)(year / 1000 + 48);
        this.bytes[this.off++] = (byte)(year / 100 % 10 + 48);
        this.bytes[this.off++] = (byte)(year / 10 % 10 + 48);
        this.bytes[this.off++] = (byte)(year % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(month / 10 + 48);
        this.bytes[this.off++] = (byte)(month % 10 + 48);
        this.bytes[this.off++] = 45;
        this.bytes[this.off++] = (byte)(dayOfMonth / 10 + 48);
        this.bytes[this.off++] = (byte)(dayOfMonth % 10 + 48);
        this.bytes[this.off++] = 32;
        this.bytes[this.off++] = (byte)(hour / 10 + 48);
        this.bytes[this.off++] = (byte)(hour % 10 + 48);
        this.bytes[this.off++] = 58;
        this.bytes[this.off++] = (byte)(minute / 10 + 48);
        this.bytes[this.off++] = (byte)(minute % 10 + 48);
        this.bytes[this.off++] = 58;
        this.bytes[this.off++] = (byte)(second / 10 + 48);
        this.bytes[this.off++] = (byte)(second % 10 + 48);
        this.bytes[this.off++] = 34;
    }

    @Override
    public void writeLocalDate(LocalDate date) {
        int year = date.getYear();
        int month = date.getMonthValue();
        int dayOfMonth = date.getDayOfMonth();
        int yearSize = IOUtils.stringSize(year);
        int len = 8 + yearSize;
        byte[] chars = new byte[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, len - 1, (byte)48);
        IOUtils.getChars(year, yearSize + 1, chars);
        chars[yearSize + 1] = 45;
        IOUtils.getChars(month, yearSize + 4, chars);
        chars[yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, yearSize + 7, chars);
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime dateTime) {
        int small;
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        int yearSize = IOUtils.stringSize(year);
        int len = 17 + yearSize;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        byte[] chars = new byte[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, len - 1, (byte)48);
        IOUtils.getChars(year, yearSize + 1, chars);
        chars[yearSize + 1] = 45;
        IOUtils.getChars(month, yearSize + 4, chars);
        chars[yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, yearSize + 7, chars);
        chars[yearSize + 7] = 32;
        IOUtils.getChars(hour, yearSize + 10, chars);
        chars[yearSize + 10] = 58;
        IOUtils.getChars(minute, yearSize + 13, chars);
        chars[yearSize + 13] = 58;
        IOUtils.getChars(second, yearSize + 16, chars);
        if (small != 0) {
            chars[yearSize + 16] = 46;
            IOUtils.getChars(small, len - 1, chars);
        }
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        byte[] chars = new byte[]{34, (byte)(year / 1000 + 48), (byte)(year / 100 % 10 + 48), (byte)(year / 10 % 10 + 48), (byte)(year % 10 + 48), 45, (byte)(month / 10 + 48), (byte)(month % 10 + 48), 45, (byte)(dayOfMonth / 10 + 48), (byte)(dayOfMonth % 10 + 48), 34};
        this.writeRaw(chars);
    }

    @Override
    public void writeTimeHHMMSS8(int hour, int minute, int second) {
        byte[] chars = new byte[]{34, (byte)(hour / 10 + 48), (byte)(hour % 10 + 48), 58, (byte)(minute / 10 + 48), (byte)(minute % 10 + 48), 58, (byte)(second / 10 + 48), (byte)(second % 10 + 48), 34};
        this.writeRaw(chars);
    }

    @Override
    public void writeLocalTime(LocalTime time) {
        int small;
        int hour = time.getHour();
        int minute = time.getMinute();
        int second = time.getSecond();
        int nano = time.getNano();
        int len = 10;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        byte[] chars = new byte[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, chars.length - 1, (byte)48);
        IOUtils.getChars(hour, 3, chars);
        chars[3] = 58;
        IOUtils.getChars(minute, 6, chars);
        chars[6] = 58;
        IOUtils.getChars(second, 9, chars);
        if (small != 0) {
            chars[9] = 46;
            IOUtils.getChars(small, len - 1, chars);
        }
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    @Override
    public void writeZonedDateTime(ZonedDateTime dateTime) {
        int small;
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int dayOfMonth = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        String zoneId = dateTime.getZone().getId();
        int len = 17;
        if ("UTC".equals(zoneId)) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = 2 + zoneId.length();
        }
        len += zoneSize;
        int yearSize = IOUtils.stringSize(year);
        len += yearSize;
        if (nano % 1000000000 == 0) {
            small = 0;
        } else if (nano % 100000000 == 0) {
            len += 2;
            small = nano / 100000000;
        } else if (nano % 10000000 == 0) {
            len += 3;
            small = nano / 10000000;
        } else if (nano % 1000000 == 0) {
            len += 4;
            small = nano / 1000000;
        } else if (nano % 100000 == 0) {
            len += 5;
            small = nano / 100000;
        } else if (nano % 10000 == 0) {
            len += 6;
            small = nano / 10000;
        } else if (nano % 1000 == 0) {
            len += 7;
            small = nano / 1000;
        } else if (nano % 100 == 0) {
            len += 8;
            small = nano / 100;
        } else if (nano % 10 == 0) {
            len += 9;
            small = nano / 10;
        } else {
            len += 10;
            small = nano;
        }
        byte[] chars = new byte[len];
        chars[0] = 34;
        Arrays.fill(chars, 1, chars.length - 1, (byte)48);
        IOUtils.getChars(year, yearSize + 1, chars);
        chars[yearSize + 1] = 45;
        IOUtils.getChars(month, yearSize + 4, chars);
        chars[yearSize + 4] = 45;
        IOUtils.getChars(dayOfMonth, yearSize + 7, chars);
        chars[yearSize + 7] = 84;
        IOUtils.getChars(hour, yearSize + 10, chars);
        chars[yearSize + 10] = 58;
        IOUtils.getChars(minute, yearSize + 13, chars);
        chars[yearSize + 13] = 58;
        IOUtils.getChars(second, yearSize + 16, chars);
        if (small != 0) {
            chars[yearSize + 16] = 46;
            IOUtils.getChars(small, len - 1 - zoneSize, chars);
        }
        if (zoneSize == 1) {
            chars[len - 2] = 90;
        } else {
            chars[len - zoneSize - 1] = 91;
            zoneId.getBytes(0, zoneId.length(), chars, len - zoneSize);
            chars[len - 2] = 93;
        }
        chars[len - 1] = 34;
        this.writeRaw(chars);
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        String str = value.toString(10);
        if (((this.context.features | features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW_BIGINT) < 0 || value.compareTo(JSONFactory.HIGH_BIGINT) > 0)) {
            this.writeString(str);
            return;
        }
        int strlen = str.length();
        int minCapacity = this.off + strlen;
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - MAX_ARRAY_SIZE > 0) {
                throw new OutOfMemoryError();
            }
            this.bytes = Arrays.copyOf(this.bytes, newCapacity);
        }
        str.getBytes(0, strlen, this.bytes, this.off);
        this.off += strlen;
    }

    @Override
    public void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds) {
        int millislen;
        int n = millislen = millis == 0 ? 0 : IOUtils.stringSize(millis) + 1;
        millislen = millis == 0 ? 0 : (millis < 10 ? 4 : (millis % 100 == 0 ? 2 : (millis % 10 == 0 ? 3 : 4)));
        int zonelen = offsetSeconds == 0 ? 1 : 6;
        int offset = offsetSeconds / 3600;
        int len = 21 + millislen + zonelen;
        byte[] chars = new byte[len];
        chars[0] = 34;
        chars[1] = (byte)(year / 1000 + 48);
        chars[2] = (byte)(year / 100 % 10 + 48);
        chars[3] = (byte)(year / 10 % 10 + 48);
        chars[4] = (byte)(year % 10 + 48);
        chars[5] = 45;
        chars[6] = (byte)(month / 10 + 48);
        chars[7] = (byte)(month % 10 + 48);
        chars[8] = 45;
        chars[9] = (byte)(dayOfMonth / 10 + 48);
        chars[10] = (byte)(dayOfMonth % 10 + 48);
        chars[11] = 84;
        chars[12] = (byte)(hour / 10 + 48);
        chars[13] = (byte)(hour % 10 + 48);
        chars[14] = 58;
        chars[15] = (byte)(minute / 10 + 48);
        chars[16] = (byte)(minute % 10 + 48);
        chars[17] = 58;
        chars[18] = (byte)(second / 10 + 48);
        chars[19] = (byte)(second % 10 + 48);
        if (millislen > 0) {
            chars[20] = 46;
            Arrays.fill(chars, 21, 20 + millislen, (byte)48);
            if (millis < 10) {
                IOUtils.getChars(millis, 20 + millislen, chars);
            } else if (millis % 100 == 0) {
                IOUtils.getChars(millis / 100, 20 + millislen, chars);
            } else if (millis % 10 == 0) {
                IOUtils.getChars(millis / 10, 20 + millislen, chars);
            } else {
                IOUtils.getChars(millis, 20 + millislen, chars);
            }
        }
        if (offsetSeconds == 0) {
            chars[20 + millislen] = 90;
        } else {
            int offsetAbs = Math.abs(offset);
            chars[20 + millislen] = offset >= 0 ? 43 : 45;
            chars[20 + millislen + 1] = 48;
            IOUtils.getChars(offsetAbs, 20 + millislen + 3, chars);
            chars[20 + millislen + 3] = 58;
            chars[20 + millislen + 4] = 48;
            int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
            if (offsetMinutes < 0) {
                offsetMinutes = -offsetMinutes;
            }
            IOUtils.getChars(offsetMinutes, 20 + millislen + zonelen, chars);
        }
        chars[chars.length - 1] = 34;
        this.writeRaw(chars);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        String str = value.toString();
        if ((this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0)) {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen + 2);
            this.bytes[this.off++] = 34;
            str.getBytes(0, strlen, this.bytes, this.off);
            this.off += strlen;
            this.bytes[this.off++] = 34;
        } else {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen);
            str.getBytes(0, strlen, this.bytes, this.off);
            this.off += strlen;
        }
    }

    @Override
    public void writeNameRaw(char[] chars) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void writeNameRaw(char[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    public String toString() {
        return new String(this.bytes, 0, this.off, StandardCharsets.UTF_8);
    }

    static void formatUnsignedLong0(long val, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = (byte)JSONFactory.DIGITS[(int)val & mask];
            val >>>= 4;
        } while (charPos > offset);
    }

    @Override
    public int flushTo(OutputStream out, Charset charset) throws IOException {
        if (charset != null && charset != StandardCharsets.UTF_8) {
            throw new JSONException("UnsupportedOperation");
        }
        int len = this.off;
        out.write(this.bytes, 0, this.off);
        this.off = 0;
        return len;
    }
}

