/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplCalendar;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDateTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import com.alibaba.fastjson2.reader.ObjectReaderImplZonedDateTime;
import com.alibaba.fastjson2.util.JdbcSupport;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;

public interface FieldReaderObject<T, V>
extends FieldReader<T> {
    public ObjectReader<V> getFieldObjectReader(JSONReader.Context var1);

    @Override
    default public void readFieldValue(JSONReader jsonReader, T object) {
        this.accept(object, this.getFieldObjectReader(jsonReader.getContext()).readObject(jsonReader, 0L));
    }

    public static ObjectReader createFormattedObjectReader(Type fieldType, Class fieldClass, String format, Locale locale) {
        if (format != null && !format.isEmpty()) {
            String typeName;
            switch (typeName = fieldType.getTypeName()) {
                case "java.sql.Time": {
                    return JdbcSupport.createTimeReader((Class)fieldType, format, locale);
                }
                case "java.sql.Timestamp": {
                    return JdbcSupport.createTimestampReader((Class)fieldType, format, locale);
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader((Class)fieldType, format, locale);
                }
                case "byte[]": 
                case "[B": {
                    return new ObjectReaderImplInt8Array(format);
                }
            }
            if (Calendar.class.isAssignableFrom(fieldClass)) {
                return ObjectReaderImplCalendar.of(format, locale);
            }
            if (fieldClass == ZonedDateTime.class) {
                return ObjectReaderImplZonedDateTime.of(format, locale);
            }
            if (fieldClass == LocalDateTime.class) {
                if (format == null) {
                    return ObjectReaderImplLocalDateTime.INSTANCE;
                }
                return new ObjectReaderImplLocalDateTime(format, locale);
            }
            if (fieldClass == LocalDate.class) {
                if (format == null) {
                    return ObjectReaderImplLocalDate.INSTANCE;
                }
                return new ObjectReaderImplLocalDate(format, locale);
            }
            if (fieldClass == LocalTime.class) {
                if (format == null) {
                    return ObjectReaderImplLocalTime.INSTANCE;
                }
                return new ObjectReaderImplLocalTime(format, locale);
            }
            if (fieldClass == Instant.class) {
                return ObjectReaderImplInstant.of(format, locale);
            }
            if (fieldClass == Optional.class) {
                return ObjectReaderImplOptional.of(fieldType, format, locale);
            }
            if (fieldClass == Date.class) {
                return ObjectReaderImplDate.of(format, locale);
            }
        }
        return null;
    }
}

