/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;

public final class ObjectReaderImplEnum
implements ObjectReader {
    final Method createMethod;
    final Type createMethodParamType;
    final Member valueField;
    final Class enumClass;
    final long typeNameHash;
    protected final Enum[] enums;
    protected final Enum[] ordinalEnums;
    protected long[] enumNameHashCodes;

    public ObjectReaderImplEnum(Class enumClass, Method createMethod, Member valueField, Enum[] enums, Enum[] ordinalEnums, long[] enumNameHashCodes) {
        this.enumClass = enumClass;
        this.createMethod = createMethod;
        this.valueField = valueField;
        Class<?> createMethodParamType = null;
        if (createMethod != null && createMethod.getParameterCount() == 1) {
            createMethodParamType = createMethod.getParameterTypes()[0];
        }
        this.createMethodParamType = createMethodParamType;
        this.typeNameHash = Fnv.hashCode64(TypeUtils.getTypeName(enumClass));
        this.enums = enums;
        this.ordinalEnums = ordinalEnums;
        this.enumNameHashCodes = enumNameHashCodes;
    }

    public Class getObjectClass() {
        return this.enumClass;
    }

    public Enum getEnumByHashCode(long hashCode) {
        if (this.enums == null) {
            return null;
        }
        int enumIndex = Arrays.binarySearch(this.enumNameHashCodes, hashCode);
        if (enumIndex < 0) {
            return null;
        }
        return this.enums[enumIndex];
    }

    public Enum getEnumByOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= this.ordinalEnums.length) {
            throw new JSONException("No enum ordinal " + this.enumClass.getCanonicalName() + "." + ordinal);
        }
        return this.ordinalEnums[ordinal];
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        Enum fieldValue;
        boolean isInt;
        byte type = jsonReader.getType();
        if (jsonReader.getType() == -110) {
            ObjectReader autoTypeObjectReader = jsonReader.checkAutoType(this.enumClass, 0L, features);
            if (autoTypeObjectReader != null) {
                if (autoTypeObjectReader != this) {
                    return autoTypeObjectReader.readJSONBObject(jsonReader, features);
                }
            } else {
                throw new JSONException(jsonReader.info("not support enumType : " + jsonReader.getString()));
            }
        }
        boolean bl = isInt = type >= -16 && type <= 72;
        if (isInt) {
            int ordinal = jsonReader.readInt32Value();
            fieldValue = this.getEnumByOrdinal(ordinal);
        } else {
            fieldValue = this.getEnumByHashCode(jsonReader.readValueHashCode());
            if (fieldValue == null) {
                long nameHash = jsonReader.getNameHashCodeLCase();
                fieldValue = this.getEnumByHashCode(nameHash);
            }
        }
        return fieldValue;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        if (this.createMethodParamType != null) {
            Object paramValue = jsonReader.read(this.createMethodParamType);
            try {
                return this.createMethod.invoke(null, paramValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException(jsonReader.info("create enum error, enumClass " + this.enumClass.getName() + ", paramValue " + paramValue), e);
            }
        }
        Enum fieldValue = null;
        if (jsonReader.isInt()) {
            int intValue = jsonReader.readInt32Value();
            if (this.valueField == null) {
                fieldValue = this.getEnumByOrdinal(intValue);
            } else {
                try {
                    if (this.valueField instanceof Field) {
                        for (Enum e : this.enums) {
                            if (((Field)this.valueField).getInt(e) != intValue) continue;
                            fieldValue = e;
                        }
                    }
                    Method valueMethod = (Method)this.valueField;
                    for (Enum e : this.enums) {
                        if (((Number)valueMethod.invoke((Object)e, new Object[0])).intValue() != intValue) continue;
                        fieldValue = e;
                    }
                }
                catch (Exception error) {
                    throw new JSONException(jsonReader.info("parse enum error, class " + this.enumClass.getName() + ", value " + intValue), error);
                }
            }
        } else {
            long hashCode = jsonReader.readValueHashCode();
            fieldValue = this.getEnumByHashCode(hashCode);
            if (hashCode == -3750763034362895579L) {
                return null;
            }
            if (fieldValue == null) {
                fieldValue = this.getEnumByHashCode(jsonReader.getNameHashCodeLCase());
            }
            if (fieldValue == null && jsonReader.getContext().isEnabled(JSONReader.Feature.ErrorOnEnumNotMatch)) {
                String strVal = jsonReader.getString();
                throw new JSONException(jsonReader.info("parse enum error, class " + this.enumClass.getName() + ", value " + strVal));
            }
        }
        return fieldValue;
    }
}

