/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

class ObjectReaderImplLocalDateTime
extends DateTimeCodec
implements ObjectReader {
    static final ObjectReaderImplLocalDateTime INSTANCE = new ObjectReaderImplLocalDateTime(null, null);

    public ObjectReaderImplLocalDateTime(String format, Locale locale) {
        super(format, locale);
    }

    public Class getObjectClass() {
        return LocalDateTime.class;
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        return jsonReader.readLocalDateTime();
    }

    public Object readObject(JSONReader jsonReader, long features) {
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.isInt()) {
            DateTimeFormatter formatter = this.getDateFormatter();
            if (formatter != null) {
                String str = jsonReader.readString();
                return LocalDateTime.parse(str, formatter);
            }
            long millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            ZoneId zoneId = context.getZoneId();
            return LocalDateTime.ofInstant(instant, zoneId);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (this.format == null || this.yyyyMMddhhmmss19 || this.formatISO8601) {
            return jsonReader.readLocalDateTime();
        }
        String str = jsonReader.readString();
        if (str.isEmpty()) {
            return null;
        }
        if (this.formatMillis || this.formatUnixTime) {
            long millis = Long.parseLong(str);
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, context.getZoneId());
        }
        DateTimeFormatter formatter = this.getDateFormatter(context.getLocale());
        if (!this.formatHasHour) {
            return LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN);
        }
        if (!this.formatHasDay) {
            return LocalDateTime.of(LocalDate.of(1970, 1, 1), LocalTime.parse(str, formatter));
        }
        return LocalDateTime.parse(str, formatter);
    }
}

