/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import java.lang.reflect.Type;
import java.util.AbstractMap;

class ObjectReaderImplMapEntry
extends ObjectReaderBaseModule.PrimitiveImpl {
    final Type keyType;
    final Type valueType;
    volatile ObjectReader keyReader;
    volatile ObjectReader valueReader;

    public ObjectReaderImplMapEntry(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        Object value;
        Object key;
        int entryCnt = jsonReader.startArray();
        if (entryCnt != 2) {
            throw new JSONException(jsonReader.info("entryCnt must be 2, but " + entryCnt));
        }
        if (this.keyType == null) {
            key = jsonReader.readAny();
        } else {
            if (this.keyReader == null) {
                this.keyReader = jsonReader.getObjectReader(this.keyType);
            }
            key = this.keyReader.readObject(jsonReader, features);
        }
        if (this.valueType == null) {
            value = jsonReader.readAny();
        } else {
            if (this.valueReader == null) {
                this.valueReader = jsonReader.getObjectReader(this.valueType);
            }
            value = this.valueReader.readObject(jsonReader, features);
        }
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        Object value;
        jsonReader.nextIfMatch('{');
        Object key = jsonReader.readAny();
        jsonReader.nextIfMatch(':');
        if (this.valueType == null) {
            value = jsonReader.readAny();
        } else {
            if (this.valueReader == null) {
                this.valueReader = jsonReader.getObjectReader(this.valueType);
            }
            value = this.valueReader.readObject(jsonReader, features);
        }
        jsonReader.nextIfMatch('}');
        jsonReader.nextIfMatch(',');
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }
}

