/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.util.Fnv;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.List;

public class ObjectReaderException<T>
extends ObjectReaderBean<T> {
    static final long HASH_TYPE = Fnv.hashCode64("@type");
    static final long HASH_MESSAGE = Fnv.hashCode64("message");
    static final long HASH_DETAIL_MESSAGE = Fnv.hashCode64("detailMessage");
    static final long HASH_CAUSE = Fnv.hashCode64("cause");
    static final long HASH_STACKTRACE = Fnv.hashCode64("stackTrace");
    static final long HASH_SUPPRESSED_EXCEPTIONS = Fnv.hashCode64("suppressedExceptions");
    private FieldReader fieldReaderStackTrace = ObjectReaders.fieldReader("stackTrace", StackTraceElement[].class, Throwable::setStackTrace);

    protected ObjectReaderException(Class<T> objectClass) {
        super(objectClass, objectClass.getName(), null);
    }

    @Override
    public T readObject(JSONReader jsonReader, long features) {
        jsonReader.nextIfObjectStart();
        String message = null;
        Throwable cause = null;
        StackTraceElement[] stackTrace = null;
        List suppressedExceptions = null;
        String stackTraceReference = null;
        String suppressedExceptionsReference = null;
        String causeReference = null;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (i == 0 && hash == HASH_TYPE && jsonReader.isSupportAutoType(features)) {
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader reader = this.autoType(context, typeHash);
                String typeName = null;
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass, features)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for" + typeName));
                }
                if (reader != this) {
                    return reader.readObject(jsonReader);
                }
            } else if (hash == HASH_MESSAGE || hash == HASH_DETAIL_MESSAGE) {
                message = jsonReader.readString();
            } else if (hash == HASH_CAUSE) {
                if (jsonReader.isReference()) {
                    causeReference = jsonReader.readReference();
                } else {
                    cause = jsonReader.read(Throwable.class);
                }
            } else if (hash == HASH_STACKTRACE) {
                if (jsonReader.isReference()) {
                    stackTraceReference = jsonReader.readReference();
                } else {
                    stackTrace = jsonReader.read(StackTraceElement[].class);
                }
            } else if (hash == HASH_SUPPRESSED_EXCEPTIONS) {
                if (jsonReader.isReference()) {
                    suppressedExceptionsReference = jsonReader.readReference();
                } else {
                    suppressedExceptions = jsonReader.getType() == -110 ? (List)jsonReader.readAny() : jsonReader.readArray((Type)((Object)Throwable.class));
                }
            } else {
                jsonReader.skipValue();
            }
            ++i;
        }
        Throwable object = this.createObject(message, cause);
        if (object == null) {
            throw new JSONException(jsonReader.info(jsonReader.info("not support : " + this.objectClass.getName())));
        }
        if (stackTrace != null) {
            object.setStackTrace(stackTrace);
        }
        if (stackTraceReference != null) {
            jsonReader.addResolveTask(this.fieldReaderStackTrace, (Object)object, JSONPath.of(stackTraceReference));
        }
        return (T)object;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, long features) {
        if (jsonReader.getType() == -110 && jsonReader.isSupportAutoType(features)) {
            String typeName;
            jsonReader.next();
            long typeHash = jsonReader.readTypeHashCode();
            JSONReader.Context context = jsonReader.getContext();
            ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                throw new JSONException("auoType not support : " + typeName + ", offset " + jsonReader.getOffset());
            }
            return autoTypeObjectReader.readJSONBObject(jsonReader, 0L);
        }
        return this.readObject(jsonReader, features);
    }

    private Throwable createObject(String message, Throwable cause) {
        Throwable object = null;
        if (this.objectClass == UncheckedIOException.class) {
            if (message != null && cause != null) {
                object = new UncheckedIOException(message, (IOException)cause);
            } else if (cause != null) {
                object = new UncheckedIOException((IOException)cause);
            }
        } else if (this.objectClass == RuntimeException.class) {
            object = message != null && cause != null ? new RuntimeException(message, cause) : (cause != null ? new RuntimeException(cause) : (message != null ? new RuntimeException(message) : new RuntimeException()));
        } else if (this.objectClass == IOException.class) {
            object = message != null && cause != null ? new IOException(message, cause) : (cause != null ? new IOException(cause) : (message != null ? new IOException(message) : new IOException()));
        } else if (this.objectClass == Exception.class) {
            object = message != null && cause != null ? new Exception(message, cause) : (cause != null ? new Exception(cause) : (message != null ? new Exception(message) : new Exception()));
        } else if (this.objectClass == Throwable.class) {
            object = message != null && cause != null ? new Throwable(message, cause) : (cause != null ? new Throwable(cause) : (message != null ? new Throwable(message) : new Throwable()));
        } else if (this.objectClass == IllegalStateException.class) {
            object = message != null && cause != null ? new IllegalStateException(message, cause) : (cause != null ? new IllegalStateException(cause) : (message != null ? new IllegalStateException(message) : new IllegalStateException()));
        }
        return object;
    }
}

