/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public interface FieldReader<T>
extends Comparable<FieldReader> {
    public Type getFieldType();

    default public Class getFieldClass() {
        return TypeUtils.getMapping(this.getFieldType());
    }

    default public boolean isFieldClassSerializable() {
        return false;
    }

    default public ObjectReader getObjectReader(JSONReader jsonReader) {
        return jsonReader.getObjectReader(this.getFieldType());
    }

    default public int ordinal() {
        return 0;
    }

    default public ObjectReader getInitReader() {
        return null;
    }

    default public boolean isUnwrapped() {
        return (this.getFeatures() & 0x2000000000000L) != 0L;
    }

    public JSONSchema getSchema();

    default public void processExtra(JSONReader jsonReader, Object object) {
        jsonReader.skipValue();
    }

    default public long getFeatures() {
        return 0L;
    }

    default public String getFormat() {
        return null;
    }

    default public Object getDefaultValue() {
        return null;
    }

    default public void setDefault(T object) {
        Object defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            this.accept(object, defaultValue);
        }
    }

    public String getFieldName();

    default public long getFieldNameHash() {
        return Fnv.hashCode64(this.getFieldName());
    }

    default public boolean isReadOnly() {
        return false;
    }

    default public Method getMethod() {
        return null;
    }

    default public Field getField() {
        return null;
    }

    @Override
    default public int compareTo(FieldReader o) {
        int cmp;
        String otherFieldName;
        String thisFieldName = this.getFieldName();
        int nameCompare = thisFieldName.compareTo(otherFieldName = o.getFieldName());
        if (nameCompare != 0) {
            int otherOrdinal;
            int thisOrdinal = this.ordinal();
            if (thisOrdinal < (otherOrdinal = o.ordinal())) {
                return -1;
            }
            if (thisOrdinal > otherOrdinal) {
                return 1;
            }
            return nameCompare;
        }
        int n = this.isReadOnly() == o.isReadOnly() ? 0 : (cmp = this.isReadOnly() ? 1 : -1);
        if (cmp != 0) {
            return cmp;
        }
        Field thisField = this.getField();
        Field otherField = o.getField();
        if (thisField != null && otherField != null) {
            Class<?> superClass;
            Class<?> thisFieldDeclaringClass = thisField.getDeclaringClass();
            Class<?> otherFieldDeclaringClass = otherField.getDeclaringClass();
            for (superClass = thisFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != otherFieldDeclaringClass) continue;
                return 1;
            }
            for (superClass = otherFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != thisFieldDeclaringClass) continue;
                return -1;
            }
        }
        Method thisMethod = this.getMethod();
        Method otherMethod = o.getMethod();
        if (thisMethod != null && otherMethod != null) {
            Class<?> superClass;
            Class<?> thisFieldDeclaringClass = thisMethod.getDeclaringClass();
            Class<?> otherFieldDeclaringClass = otherMethod.getDeclaringClass();
            for (superClass = thisFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != otherFieldDeclaringClass) continue;
                return 1;
            }
            for (superClass = otherFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != thisFieldDeclaringClass) continue;
                return -1;
            }
            if (thisMethod.getParameterCount() == 1 && otherMethod.getParameterCount() == 1) {
                Class<?> otherParamType;
                Class<?> thisParamType = thisMethod.getParameterTypes()[0];
                if (thisParamType.isAssignableFrom(otherParamType = otherMethod.getParameterTypes()[0])) {
                    return 1;
                }
                if (otherParamType.isAssignableFrom(thisParamType)) {
                    return -1;
                }
                if (thisParamType.isEnum() && (otherParamType == Integer.class || otherParamType == Integer.TYPE)) {
                    return 1;
                }
                if (otherParamType.isEnum() && (thisParamType == Integer.class || thisParamType == Integer.TYPE)) {
                    return -1;
                }
            }
        }
        ObjectReader thisInitReader = this.getInitReader();
        ObjectReader otherInitReader = o.getInitReader();
        if (thisInitReader != null && otherInitReader == null) {
            return -1;
        }
        if (thisInitReader == null && otherInitReader != null) {
            return 1;
        }
        return cmp;
    }

    default public Enum getEnumByHashCode(long hashCode) {
        throw new UnsupportedOperationException();
    }

    default public Enum getEnumByOrdinal(int ordinal) {
        throw new UnsupportedOperationException();
    }

    default public Type getItemType() {
        return null;
    }

    default public Class getItemClass() {
        return TypeUtils.getClass(this.getItemType());
    }

    default public long getItemClassHash() {
        Class itemClass = this.getItemClass();
        if (itemClass == null) {
            return 0L;
        }
        return Fnv.hashCode64(itemClass.getName());
    }

    default public ObjectReader getItemObjectReader(JSONReader.Context ctx) {
        return ctx.getObjectReader((Type)((Object)Object.class));
    }

    default public ObjectReader getItemObjectReader(JSONReader jsonReader) {
        return this.getItemObjectReader(jsonReader.getContext());
    }

    default public void accept(T object, boolean value) {
        this.accept(object, (Object)value);
    }

    default public void accept(T object, byte value) {
        this.accept(object, (Object)value);
    }

    default public void accept(T object, short value) {
        this.accept(object, (Object)value);
    }

    default public void accept(T object, int value) {
        this.accept(object, (Object)value);
    }

    default public void accept(T object, long value) {
        this.accept(object, (Object)value);
    }

    default public void accept(T object, char value) {
        this.accept(object, Character.valueOf(value));
    }

    default public void accept(T object, float value) {
        this.accept(object, Float.valueOf(value));
    }

    default public void accept(T object, double value) {
        this.accept(object, (Object)value);
    }

    default public void accept(T object, Object value) {
    }

    public void readFieldValue(JSONReader var1, T var2);

    default public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        this.readFieldValue(jsonReader, object);
    }

    default public Object readFieldValue(JSONReader jsonReader) {
        throw new JSONException(jsonReader.info("TODO : " + this.getClass()));
    }

    default public void addResolveTask(JSONReader jsonReader, Object object, String reference) {
        jsonReader.addResolveTask(this, object, JSONPath.of(reference));
    }

    default public void addResolveTask(JSONReader jsonReader, List object, int i, String reference) {
        jsonReader.addResolveTask(object, i, JSONPath.of(reference));
    }

    default public ObjectReader checkObjectAutoType(JSONReader jsonReader) {
        long features = this.getFeatures();
        if (jsonReader.nextIfMatch((byte)-110)) {
            long typeHash = jsonReader.readTypeHashCode();
            boolean isSupportAutoType = jsonReader.isSupportAutoType(features);
            if (!isSupportAutoType) {
                throw new JSONException(jsonReader.info("autoType not support input " + jsonReader.getString()));
            }
            ObjectReader autoTypeObjectReader = jsonReader.getContext().getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = jsonReader.getContext().getObjectReaderAutoType(typeName, this.getFieldClass(), features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + jsonReader.getString());
            }
            return autoTypeObjectReader;
        }
        return null;
    }
}

