/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Function;

class FieldReaderListField<T>
extends FieldReaderObjectField<T>
implements FieldReaderList<T, Object> {
    private Type itemType;
    final long fieldClassHash;
    ObjectReader itemReader;

    FieldReaderListField(String fieldName, Type fieldType, Class fieldClass, Type itemType, int ordinal, long features, String format, Locale locale, Collection defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, schema, field);
        this.itemType = itemType;
        this.fieldClassHash = fieldClass == null ? 0L : Fnv.hashCode64(TypeUtils.getTypeName(fieldClass));
        this.fieldObjectReader = ObjectReaderImplList.of(fieldType, fieldClass, features);
        if (format != null && itemType == Date.class) {
            this.itemReader = new ObjectReaderImplDate(format, locale);
        }
    }

    @Override
    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public ObjectReader getItemObjectReader(JSONReader.Context ctx) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        this.itemReader = ctx.getObjectReader(this.itemType);
        return this.itemReader;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (jsonReader.nextIfNull()) {
            return;
        }
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        JSONReader.Context context = jsonReader.getContext();
        Function builder = this.fieldObjectReader.getBuildFunction();
        if (jsonReader.isJSONB()) {
            long typeHash;
            Class fieldClass = this.fieldClass;
            ObjectReader autoTypeReader = null;
            if (jsonReader.nextIfMatch((byte)-110) && (typeHash = jsonReader.readTypeHashCode()) != this.fieldClassHash && jsonReader.isSupportAutoType(this.features)) {
                autoTypeReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeReader == null) {
                    String typeName = jsonReader.getString();
                    autoTypeReader = context.getObjectReaderAutoType(typeName, fieldClass, this.fieldClassHash);
                }
                builder = autoTypeReader.getBuildFunction();
            }
            Collection list = autoTypeReader != null ? (Collection)autoTypeReader.createInstance(context.getFeatures() | this.features) : (Collection)this.fieldObjectReader.createInstance(context.getFeatures() | this.features);
            int entryCnt = jsonReader.startArray();
            ObjectReader itemObjectReader = this.getItemObjectReader(context);
            for (int i = 0; i < entryCnt; ++i) {
                Collection<Object> value;
                if (jsonReader.isReference()) {
                    String reference = jsonReader.readReference();
                    if ("..".equals(reference)) {
                        value = list;
                    } else {
                        this.addResolveTask(jsonReader, list, i, reference);
                        if (list instanceof TreeSet) continue;
                        value = null;
                    }
                } else {
                    value = itemObjectReader.readJSONBObject(jsonReader, this.itemType, null, this.features);
                }
                list.add(value);
            }
            if (builder != null) {
                list = (Collection)builder.apply(list);
            }
            this.accept(object, list);
            return;
        }
        boolean set = false;
        if (jsonReader.current() == '[' || (set = jsonReader.nextIfSet())) {
            JSONReader.Context ctx = context;
            ObjectReader itemObjectReader = null;
            Collection<Object> list = null;
            jsonReader.next();
            Object first = null;
            Object second = null;
            int i = 0;
            while (!jsonReader.nextIfMatch(']')) {
                if (itemObjectReader == null) {
                    itemObjectReader = this.getItemObjectReader(ctx);
                }
                Object itemObject = itemObjectReader.readObject(jsonReader, this.itemType, null, this.features);
                if (i == 0) {
                    first = itemObject;
                } else if (i == 1) {
                    second = itemObject;
                } else if (i == 2) {
                    list = this.fieldClass == List.class ? new ArrayList() : (Collection)this.fieldObjectReader.createInstance(context.getFeatures() | this.features);
                    list.add(first);
                    list.add(second);
                    list.add(itemObject);
                } else {
                    list.add(itemObject);
                }
                if (jsonReader.nextIfMatch(',')) {
                    // empty if block
                }
                ++i;
            }
            if (list == null) {
                list = this.fieldClass == List.class ? new ArrayList<Object>(i) : (set && this.fieldClass == Collection.class ? new LinkedHashSet() : (Collection)this.fieldObjectReader.createInstance(context.getFeatures() | this.features));
                if (i == 1) {
                    list.add(first);
                } else if (i == 2) {
                    list.add(first);
                    list.add(second);
                }
            }
            if (builder != null) {
                list = (ArrayList<Object>)builder.apply(list);
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            return;
        }
        if (jsonReader.isString()) {
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                this.accept(object, null);
                return;
            }
            throw new JSONException(jsonReader.info("listField not support input : " + str));
        }
        ObjectReader itemObjectReader = this.getItemObjectReader(jsonReader);
        Object itemObject = itemObjectReader.readObject(jsonReader, this.itemType, null, this.features);
        Collection list = (Collection)this.fieldObjectReader.createInstance(context.getFeatures() | this.features);
        list.add(itemObject);
        if (builder != null) {
            list = (Collection)builder.apply(list);
        }
        this.accept(object, list);
        jsonReader.nextIfMatch(',');
    }
}

