/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.context;

import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.core.context.ContextCore;
import com.alibaba.fescar.core.context.ContextCoreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootContext.class);
    public static final String KEY_XID = "TX_XID";
    public static final String KEY_GLOBAL_LOCK_FLAG = "TX_LOCK";
    private static ContextCore CONTEXT_HOLDER = ContextCoreLoader.load();

    public static String getXID() {
        return CONTEXT_HOLDER.get(KEY_XID);
    }

    public static void bind(String xid) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bind " + xid);
        }
        CONTEXT_HOLDER.put(KEY_XID, xid);
    }

    public static void bindGlobalLockFlag() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Local Transaction Global Lock support enabled");
        }
        CONTEXT_HOLDER.put(KEY_GLOBAL_LOCK_FLAG, KEY_GLOBAL_LOCK_FLAG);
    }

    public static String unbind() {
        String xid = CONTEXT_HOLDER.remove(KEY_XID);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unbind " + xid);
        }
        return xid;
    }

    public static void unbindGlobalLockFlag() {
        String lockFlag = CONTEXT_HOLDER.remove(KEY_GLOBAL_LOCK_FLAG);
        if (LOGGER.isDebugEnabled() && lockFlag != null) {
            LOGGER.debug("unbind global lock flag");
        }
    }

    public static boolean inGlobalTransaction() {
        return CONTEXT_HOLDER.get(KEY_XID) != null;
    }

    public static boolean requireGlobalLock() {
        return CONTEXT_HOLDER.get(KEY_GLOBAL_LOCK_FLAG) != null;
    }

    public static void assertNotInGlobalTransaction() {
        if (RootContext.inGlobalTransaction()) {
            throw new ShouldNeverHappenException();
        }
    }
}

