/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.protocol.transaction;

import com.alibaba.fescar.core.model.BranchStatus;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.protocol.MergedMessage;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequestToTC;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionResponse;
import com.alibaba.fescar.core.rpc.RpcContext;
import java.nio.ByteBuffer;

public class BranchReportRequest
extends AbstractTransactionRequestToTC
implements MergedMessage {
    private long transactionId;
    private long branchId;
    private String resourceId;
    private BranchStatus status;
    private String applicationData;
    private BranchType branchType = BranchType.AT;

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public BranchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BranchStatus status) {
        this.status = status;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public short getTypeCode() {
        return 13;
    }

    @Override
    public byte[] encode() {
        byte[] applicationDataBytes = null;
        if (this.applicationData != null && (applicationDataBytes = this.applicationData.getBytes(UTF8)).length > 512) {
            this.byteBuffer = ByteBuffer.allocate(applicationDataBytes.length + 1024);
        }
        this.byteBuffer.putLong(this.transactionId);
        this.byteBuffer.putLong(this.branchId);
        this.byteBuffer.put((byte)this.status.getCode());
        if (this.resourceId != null) {
            byte[] bs = this.resourceId.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.applicationData != null) {
            this.byteBuffer.putInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                this.byteBuffer.put(applicationDataBytes);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.put((byte)this.branchType.ordinal());
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        int iLen;
        this.transactionId = byteBuffer.getLong();
        this.branchId = byteBuffer.getLong();
        this.status = BranchStatus.get(byteBuffer.get());
        short len = byteBuffer.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            byteBuffer.get(bs);
            this.resourceId = new String(bs, UTF8);
        }
        if ((iLen = byteBuffer.getInt()) > 0) {
            byte[] bs = new byte[iLen];
            byteBuffer.get(bs);
            this.applicationData = new String(bs, UTF8);
        }
        this.branchType = BranchType.get(byteBuffer.get());
    }

    @Override
    public AbstractTransactionResponse handle(RpcContext rpcContext) {
        return this.handler.handle(this, rpcContext);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("transactionId=");
        result.append(this.transactionId);
        result.append(",");
        result.append("branchId=");
        result.append(this.branchId);
        result.append(",");
        result.append("resourceId=");
        result.append(this.resourceId);
        result.append(",");
        result.append("status=");
        result.append((Object)this.status);
        result.append(",");
        result.append("applicationData=");
        result.append(this.applicationData);
        return result.toString();
    }
}

