/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.rpc;

import com.alibaba.fescar.common.exception.FrameworkException;
import com.alibaba.fescar.common.util.StringUtils;
import com.alibaba.fescar.core.protocol.IncompatibleVersionException;
import com.alibaba.fescar.core.protocol.RegisterRMRequest;
import com.alibaba.fescar.core.protocol.RegisterTMRequest;
import com.alibaba.fescar.core.protocol.Version;
import com.alibaba.fescar.core.rpc.RpcContext;
import com.alibaba.fescar.core.rpc.netty.NettyPoolKey;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private static final ConcurrentMap<Channel, RpcContext> IDENTIFIED_CHANNELS = new ConcurrentHashMap<Channel, RpcContext>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>>>> RM_CHANNELS = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>>>>();
    private static final ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>> TM_CHANNELS = new ConcurrentHashMap<String, ConcurrentMap<Integer, RpcContext>>();

    public static boolean isRegistered(Channel channel) {
        return IDENTIFIED_CHANNELS.containsKey(channel);
    }

    public static NettyPoolKey.TransactionRole getRoleFromChannel(Channel channel) {
        if (IDENTIFIED_CHANNELS.containsKey(channel)) {
            return ((RpcContext)IDENTIFIED_CHANNELS.get(channel)).getClientRole();
        }
        return null;
    }

    public static RpcContext getContextFromIdentified(Channel channel) {
        return (RpcContext)IDENTIFIED_CHANNELS.get(channel);
    }

    private static String buildClientId(String applicationId, Channel channel) {
        return applicationId + ":" + ChannelManager.getAddressFromChannel(channel);
    }

    private static String[] readClientId(String clientId) {
        return clientId.split(":");
    }

    private static RpcContext buildChannelHolder(NettyPoolKey.TransactionRole clientRole, String version, String applicationId, String txServiceGroup, String dbkeys, Channel channel) {
        RpcContext holder = new RpcContext();
        holder.setClientRole(clientRole);
        holder.setVersion(version);
        holder.setClientId(ChannelManager.buildClientId(applicationId, channel));
        holder.setApplicationId(applicationId);
        holder.setTransactionServiceGroup(txServiceGroup);
        holder.addResources(ChannelManager.dbKeytoSet(dbkeys));
        holder.setChannel(channel);
        return holder;
    }

    public static void registerTMChannel(RegisterTMRequest request, Channel channel) throws IncompatibleVersionException {
        Version.checkVersion(request.getVersion());
        RpcContext rpcContext = ChannelManager.buildChannelHolder(NettyPoolKey.TransactionRole.TMROLE, request.getVersion(), request.getApplicationId(), request.getTransactionServiceGroup(), null, channel);
        rpcContext.holdInIdentifiedChannels(IDENTIFIED_CHANNELS);
        String clientIdentified = rpcContext.getApplicationId() + ":" + ChannelManager.getClientIpFromChannel(channel);
        TM_CHANNELS.putIfAbsent(clientIdentified, new ConcurrentHashMap());
        ConcurrentMap clientIdentifiedMap = (ConcurrentMap)TM_CHANNELS.get(clientIdentified);
        rpcContext.holdInClientChannels(clientIdentifiedMap);
    }

    public static void registerRMChannel(RegisterRMRequest resourceManagerRequest, Channel channel) throws IncompatibleVersionException {
        RpcContext rpcContext;
        Version.checkVersion(resourceManagerRequest.getVersion());
        Set<String> dbkeySet = ChannelManager.dbKeytoSet(resourceManagerRequest.getResourceIds());
        if (!IDENTIFIED_CHANNELS.containsKey(channel)) {
            rpcContext = ChannelManager.buildChannelHolder(NettyPoolKey.TransactionRole.RMROLE, resourceManagerRequest.getVersion(), resourceManagerRequest.getApplicationId(), resourceManagerRequest.getTransactionServiceGroup(), resourceManagerRequest.getResourceIds(), channel);
            rpcContext.holdInIdentifiedChannels(IDENTIFIED_CHANNELS);
        } else {
            rpcContext = (RpcContext)IDENTIFIED_CHANNELS.get(channel);
            rpcContext.addResources(dbkeySet);
        }
        if (null == dbkeySet || dbkeySet.isEmpty()) {
            return;
        }
        for (String resourceId : dbkeySet) {
            RM_CHANNELS.putIfAbsent(resourceId, new ConcurrentHashMap());
            ConcurrentMap applicationIdMap = (ConcurrentMap)RM_CHANNELS.get(resourceId);
            applicationIdMap.putIfAbsent(resourceManagerRequest.getApplicationId(), new ConcurrentHashMap());
            ConcurrentMap clientIpMap = (ConcurrentMap)applicationIdMap.get(resourceManagerRequest.getApplicationId());
            String clientIp = ChannelManager.getClientIpFromChannel(channel);
            clientIpMap.putIfAbsent(clientIp, new ConcurrentHashMap());
            ConcurrentMap portMap = (ConcurrentMap)clientIpMap.get(clientIp);
            rpcContext.holdInResourceManagerChannels(resourceId, portMap);
            ChannelManager.updateChannelsResource(resourceId, clientIp, resourceManagerRequest.getApplicationId());
        }
    }

    private static void updateChannelsResource(String resourceId, String clientIp, String applicationId) {
        ConcurrentMap sourcePortMap = (ConcurrentMap)((ConcurrentMap)((ConcurrentMap)RM_CHANNELS.get(resourceId)).get(applicationId)).get(clientIp);
        for (Map.Entry rmChannelEntry : RM_CHANNELS.entrySet()) {
            ConcurrentMap clientIpMap;
            ConcurrentMap applicationIdMap;
            if (((String)rmChannelEntry.getKey()).equals(resourceId) || !(applicationIdMap = (ConcurrentMap)rmChannelEntry.getValue()).containsKey(applicationId) || !(clientIpMap = (ConcurrentMap)applicationIdMap.get(applicationId)).containsKey(clientIp)) continue;
            ConcurrentMap portMap = (ConcurrentMap)clientIpMap.get(clientIp);
            for (Map.Entry portMapEntry : portMap.entrySet()) {
                Integer port = (Integer)portMapEntry.getKey();
                if (sourcePortMap.containsKey(port)) continue;
                RpcContext rpcContext = (RpcContext)portMapEntry.getValue();
                sourcePortMap.put(port, rpcContext);
                rpcContext.holdInResourceManagerChannels(resourceId, port);
            }
        }
    }

    private static String getAddressFromChannel(Channel channel) {
        SocketAddress socketAddress = channel.remoteAddress();
        String address = socketAddress.toString();
        if (socketAddress.toString().indexOf("/") == 0) {
            address = socketAddress.toString().substring("/".length());
        }
        return address;
    }

    private static String getClientIpFromChannel(Channel channel) {
        String address = ChannelManager.getAddressFromChannel(channel);
        String clientIp = address;
        if (clientIp.contains(":")) {
            clientIp = clientIp.substring(0, clientIp.lastIndexOf(":"));
        }
        return clientIp;
    }

    private static Integer getClientPortFromChannel(Channel channel) {
        String address = ChannelManager.getAddressFromChannel(channel);
        Integer port = 0;
        try {
            if (address.contains(":")) {
                port = Integer.parseInt(address.substring(address.lastIndexOf(":") + 1));
            }
        }
        catch (NumberFormatException exx) {
            LOGGER.error(exx.getMessage());
        }
        return port;
    }

    private static Set<String> dbKeytoSet(String dbkey) {
        if (StringUtils.isNullOrEmpty((String)dbkey)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String s : dbkey.split(",")) {
            set.add(s);
        }
        return set;
    }

    public static void releaseRpcContext(Channel channel) {
        if (IDENTIFIED_CHANNELS.containsKey(channel)) {
            RpcContext rpcContext = ChannelManager.getContextFromIdentified(channel);
            rpcContext.release();
        }
    }

    public static Channel getSameClientChannel(Channel channel) {
        if (channel.isActive()) {
            return channel;
        }
        RpcContext rpcContext = ChannelManager.getContextFromIdentified(channel);
        if (null == rpcContext) {
            LOGGER.error("rpcContext is null,channel:" + channel + ",active:" + channel.isActive());
            return null;
        }
        if (rpcContext.getChannel().isActive()) {
            return rpcContext.getChannel();
        }
        Integer clientPort = ChannelManager.getClientPortFromChannel(channel);
        NettyPoolKey.TransactionRole clientRole = rpcContext.getClientRole();
        if (clientRole == NettyPoolKey.TransactionRole.TMROLE) {
            String clientIdentified = rpcContext.getApplicationId() + ":" + ChannelManager.getClientIpFromChannel(channel);
            if (!TM_CHANNELS.containsKey(clientIdentified)) {
                return null;
            }
            ConcurrentMap clientRpcMap = (ConcurrentMap)TM_CHANNELS.get(clientIdentified);
            return ChannelManager.getChannelFromSameClientMap(clientRpcMap, clientPort);
        }
        if (clientRole == NettyPoolKey.TransactionRole.RMROLE) {
            for (Map clientRmMap : rpcContext.getClientRMHolderMap().values()) {
                Channel sameClientChannel = ChannelManager.getChannelFromSameClientMap(clientRmMap, clientPort);
                if (null == sameClientChannel) continue;
                return sameClientChannel;
            }
        }
        return null;
    }

    private static Channel getChannelFromSameClientMap(Map<Integer, RpcContext> clientChannelMap, int exclusivePort) {
        if (null != clientChannelMap && !clientChannelMap.isEmpty()) {
            for (Map.Entry<Integer, RpcContext> entry : clientChannelMap.entrySet()) {
                if (entry.getKey() == exclusivePort) {
                    clientChannelMap.remove(entry.getKey());
                    continue;
                }
                Channel channel = entry.getValue().getChannel();
                if (channel.isActive()) {
                    return channel;
                }
                clientChannelMap.remove(entry.getKey());
            }
        }
        return null;
    }

    public static Channel getChannel(String resourceId, String clientId) {
        Channel resultChannel = null;
        String[] clientIdInfo = ChannelManager.readClientId(clientId);
        if (clientIdInfo == null || clientIdInfo.length != 3) {
            throw new FrameworkException("Invalid Client ID: " + clientId);
        }
        String targetApplicationId = clientIdInfo[0];
        String targetIP = clientIdInfo[1];
        int targetPort = Integer.parseInt(clientIdInfo[2]);
        ConcurrentMap applicationIdMap = (ConcurrentMap)RM_CHANNELS.get(resourceId);
        if (targetApplicationId == null || applicationIdMap == null || applicationIdMap.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No channel is available for resource[" + resourceId + "]");
            }
            return null;
        }
        ConcurrentMap ipMap = (ConcurrentMap)applicationIdMap.get(targetApplicationId);
        if (null != ipMap && !ipMap.isEmpty()) {
            ConcurrentMap portMapOnTargetIP = (ConcurrentMap)ipMap.get(targetIP);
            if (portMapOnTargetIP != null && !portMapOnTargetIP.isEmpty()) {
                RpcContext exactRpcContext = (RpcContext)portMapOnTargetIP.get(targetPort);
                if (exactRpcContext != null) {
                    Channel channel = exactRpcContext.getChannel();
                    if (channel.isActive()) {
                        resultChannel = channel;
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Just got exactly the one " + channel + " for " + clientId);
                        }
                    } else if (portMapOnTargetIP.remove(targetPort, exactRpcContext) && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Removed inactive " + channel);
                    }
                }
                if (resultChannel == null) {
                    for (Map.Entry entry : portMapOnTargetIP.entrySet()) {
                        Channel channel = ((RpcContext)entry.getValue()).getChannel();
                        if (channel.isActive()) {
                            resultChannel = channel;
                            if (!LOGGER.isInfoEnabled()) break;
                            LOGGER.info("Choose " + channel + " on the same IP[" + targetIP + "]  as alternative of " + clientId);
                            break;
                        }
                        if (!portMapOnTargetIP.remove(entry.getKey(), entry.getValue()) || !LOGGER.isInfoEnabled()) continue;
                        LOGGER.info("Removed inactive " + channel);
                    }
                }
            }
            if (resultChannel == null) {
                for (Map.Entry ipMapEntry : ipMap.entrySet()) {
                    ConcurrentMap concurrentMap;
                    if (((String)ipMapEntry.getKey()).equals(targetIP) || (concurrentMap = (ConcurrentMap)ipMapEntry.getValue()) == null || concurrentMap.isEmpty()) continue;
                    for (Map.Entry portMapOnOtherIPEntry : concurrentMap.entrySet()) {
                        Channel channel = ((RpcContext)portMapOnOtherIPEntry.getValue()).getChannel();
                        if (channel.isActive()) {
                            resultChannel = channel;
                            if (!LOGGER.isInfoEnabled()) break;
                            LOGGER.info("Choose " + channel + " on the same application[" + targetApplicationId + "] as alternative of " + clientId);
                            break;
                        }
                        if (!concurrentMap.remove(portMapOnOtherIPEntry.getKey(), portMapOnOtherIPEntry.getValue()) || !LOGGER.isInfoEnabled()) continue;
                        LOGGER.info("Removed inactive " + channel);
                    }
                    if (resultChannel == null) continue;
                    break;
                }
            }
        }
        if (resultChannel == null) {
            resultChannel = ChannelManager.tryOtherApp(applicationIdMap, targetApplicationId);
            if (resultChannel == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("No channel is available for resource[" + resourceId + "]  as alternative of " + clientId);
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Choose " + resultChannel + " on the same resource[" + resourceId + "]  as alternative of " + clientId);
            }
        }
        return resultChannel;
    }

    private static Channel tryOtherApp(ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>>> applicationIdMap, String myApplicationId) {
        Channel chosenChannel = null;
        for (Map.Entry applicationIdMapEntry : applicationIdMap.entrySet()) {
            ConcurrentMap targetIPMap;
            if (((String)applicationIdMapEntry.getKey()).equals(myApplicationId) || (targetIPMap = (ConcurrentMap)applicationIdMapEntry.getValue()) == null || targetIPMap.isEmpty()) continue;
            for (Map.Entry targetIPMapEntry : targetIPMap.entrySet()) {
                ConcurrentMap portMap = (ConcurrentMap)targetIPMapEntry.getValue();
                if (portMap == null || portMap.isEmpty()) continue;
                for (Map.Entry portMapEntry : portMap.entrySet()) {
                    Channel channel = ((RpcContext)portMapEntry.getValue()).getChannel();
                    if (channel.isActive()) {
                        chosenChannel = channel;
                        break;
                    }
                    if (!portMap.remove(portMapEntry.getKey(), portMapEntry.getValue()) || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Removed inactive " + channel);
                }
                if (chosenChannel == null) continue;
                break;
            }
            if (chosenChannel == null) continue;
            break;
        }
        return chosenChannel;
    }
}

