/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.rpc.netty;

import com.alibaba.fescar.common.exception.FrameworkErrorCode;
import com.alibaba.fescar.core.protocol.ResultCode;
import com.alibaba.fescar.core.protocol.transaction.BranchCommitRequest;
import com.alibaba.fescar.core.protocol.transaction.BranchCommitResponse;
import com.alibaba.fescar.core.protocol.transaction.BranchRollbackRequest;
import com.alibaba.fescar.core.protocol.transaction.BranchRollbackResponse;
import com.alibaba.fescar.core.rpc.ClientMessageListener;
import com.alibaba.fescar.core.rpc.ClientMessageSender;
import com.alibaba.fescar.core.rpc.TransactionMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmMessageListener
implements ClientMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmMessageListener.class);
    private TransactionMessageHandler handler;

    public RmMessageListener(TransactionMessageHandler handler) {
        this.handler = handler;
    }

    public void setHandler(TransactionMessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onMessage(long msgId, String serverAddress, Object msg, ClientMessageSender sender) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("onMessage:" + msg);
        }
        if (msg instanceof BranchCommitRequest) {
            this.handleBranchCommit(msgId, serverAddress, (BranchCommitRequest)msg, sender);
        } else if (msg instanceof BranchRollbackRequest) {
            this.handleBranchRollback(msgId, serverAddress, (BranchRollbackRequest)msg, sender);
        }
    }

    private void handleBranchRollback(long msgId, String serverAddress, BranchRollbackRequest branchRollbackRequest, ClientMessageSender sender) {
        BranchRollbackResponse resultMessage = null;
        resultMessage = (BranchRollbackResponse)this.handler.onRequest(branchRollbackRequest, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("branch rollback result:" + resultMessage);
        }
        try {
            sender.sendResponse(msgId, serverAddress, resultMessage);
        }
        catch (Throwable throwable) {
            LOGGER.error("", (Object)"send response error", (Object)throwable);
        }
    }

    private void handleBranchCommit(long msgId, String serverAddress, BranchCommitRequest branchCommitRequest, ClientMessageSender sender) {
        BranchCommitResponse resultMessage = null;
        try {
            resultMessage = (BranchCommitResponse)this.handler.onRequest(branchCommitRequest, null);
            sender.sendResponse(msgId, serverAddress, resultMessage);
        }
        catch (Exception e) {
            LOGGER.error(FrameworkErrorCode.NetOnMessage.errCode, (Object)e.getMessage(), (Object)e);
            resultMessage.setResultCode(ResultCode.Failed);
            resultMessage.setMsg(e.getMessage());
            sender.sendResponse(msgId, serverAddress, resultMessage);
        }
    }
}

