/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.rpc.netty;

import com.alibaba.fescar.common.util.NetUtil;
import com.alibaba.fescar.core.protocol.HeartbeatMessage;
import com.alibaba.fescar.core.protocol.RegisterRMRequest;
import com.alibaba.fescar.core.protocol.RegisterTMRequest;
import com.alibaba.fescar.core.protocol.RpcMessage;
import com.alibaba.fescar.core.rpc.ChannelManager;
import com.alibaba.fescar.core.rpc.DefaultServerMessageListenerImpl;
import com.alibaba.fescar.core.rpc.RpcContext;
import com.alibaba.fescar.core.rpc.ServerMessageListener;
import com.alibaba.fescar.core.rpc.ServerMessageSender;
import com.alibaba.fescar.core.rpc.TransactionMessageHandler;
import com.alibaba.fescar.core.rpc.netty.AbstractRpcRemotingServer;
import com.alibaba.fescar.core.rpc.netty.NettyServerConfig;
import com.alibaba.fescar.core.rpc.netty.RegisterCheckAuthHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.SocketAddress;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RpcServer
extends AbstractRpcRemotingServer
implements ServerMessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServer.class);
    protected ServerMessageListener serverMessageListener;
    private TransactionMessageHandler transactionMessageHandler;
    private RegisterCheckAuthHandler checkAuthHandler;

    public void setHandler(TransactionMessageHandler transactionMessageHandler) {
        this.setHandler(transactionMessageHandler, null);
    }

    public void setHandler(TransactionMessageHandler transactionMessageHandler, RegisterCheckAuthHandler checkAuthHandler) {
        this.transactionMessageHandler = transactionMessageHandler;
        this.checkAuthHandler = checkAuthHandler;
    }

    public RpcServer(ThreadPoolExecutor messageExecutor) {
        super(new NettyServerConfig(), messageExecutor, new ChannelHandler[0]);
    }

    public ServerMessageListener getServerMessageListener() {
        return this.serverMessageListener;
    }

    public void setServerMessageListener(ServerMessageListener serverMessageListener) {
        this.serverMessageListener = serverMessageListener;
    }

    public void debugLog(String info) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(info);
        }
    }

    @Override
    public void init() {
        super.init();
        this.setChannelHandlers(new ChannelHandler[]{this});
        DefaultServerMessageListenerImpl defaultServerMessageListenerImpl = new DefaultServerMessageListenerImpl(this.transactionMessageHandler);
        defaultServerMessageListenerImpl.init();
        defaultServerMessageListenerImpl.setServerMessageSender(this);
        this.setServerMessageListener(defaultServerMessageListenerImpl);
        super.start();
    }

    private void closeChannelHandlerContext(ChannelHandlerContext ctx) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("closeChannelHandlerContext channel:" + ctx.channel());
        }
        ctx.disconnect();
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            this.debugLog("idle:" + evt);
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.READER_IDLE) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("channel:" + ctx.channel() + " read idle.");
                }
                this.handleDisconnect(ctx);
                try {
                    this.closeChannelHandlerContext(ctx);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        super.shutdown();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("destroyed rpcServer");
        }
    }

    @Override
    public void sendResponse(long msgId, Channel channel, Object msg) {
        Channel clientChannel = channel;
        if (!(msg instanceof HeartbeatMessage)) {
            clientChannel = ChannelManager.getSameClientChannel(channel);
        }
        if (clientChannel == null) {
            throw new RuntimeException("channel is error. channel:" + clientChannel);
        }
        super.sendResponse(msgId, clientChannel, msg);
    }

    @Override
    public Object sendSyncRequest(String resourceId, String clientId, Object message, long timeout) throws TimeoutException {
        Channel clientChannel = ChannelManager.getChannel(resourceId, clientId);
        if (clientChannel == null) {
            throw new RuntimeException("rm client is not connected. dbkey:" + resourceId + ",clientId:" + clientId);
        }
        return this.sendAsyncRequestWithResponse(null, clientChannel, message, timeout);
    }

    @Override
    public Object sendSyncRequest(String resourceId, String clientId, Object message) throws TimeoutException {
        return this.sendSyncRequest(resourceId, clientId, message, NettyServerConfig.getRpcRequestTimeout());
    }

    @Override
    public void dispatch(long msgId, ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof RegisterRMRequest) {
            this.serverMessageListener.onRegRmMessage(msgId, ctx, (RegisterRMRequest)msg, this, this.checkAuthHandler);
        } else if (ChannelManager.isRegistered(ctx.channel())) {
            this.serverMessageListener.onTrxMessage(msgId, ctx, msg, this);
        } else {
            try {
                this.closeChannelHandlerContext(ctx);
            }
            catch (Exception exx) {
                LOGGER.error(exx.getMessage());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("close a unhandled connection! [%s]", ctx.channel().toString()));
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.debugLog("inactive:" + ctx);
        if (this.messageExecutor.isShutdown()) {
            return;
        }
        this.handleDisconnect(ctx);
        super.channelInactive(ctx);
    }

    private void handleDisconnect(ChannelHandlerContext ctx) {
        String ipAndPort = NetUtil.toStringAddress((SocketAddress)ctx.channel().remoteAddress());
        RpcContext rpcContext = ChannelManager.getContextFromIdentified(ctx.channel());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(ipAndPort + " to server channel inactive.");
        }
        if (null != rpcContext && null != rpcContext.getClientRole()) {
            rpcContext.release();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("remove channel:" + ctx.channel() + "context:" + rpcContext);
            }
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("remove unused channel:" + ctx.channel());
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)msg;
            this.debugLog("read:" + rpcMessage.getBody().toString());
            if (rpcMessage.getBody() instanceof RegisterTMRequest) {
                RegisterTMRequest request = (RegisterTMRequest)rpcMessage.getBody();
                this.serverMessageListener.onRegTmMessage(rpcMessage.getId(), ctx, request, this, this.checkAuthHandler);
                return;
            }
            if (rpcMessage.getBody() == HeartbeatMessage.PING) {
                this.serverMessageListener.onCheckMessage(rpcMessage.getId(), ctx, this);
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("channel exx:" + cause.getMessage() + ",channel:" + ctx.channel());
        }
        ChannelManager.releaseRpcContext(ctx.channel());
        super.exceptionCaught(ctx, cause);
    }
}

