/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import java.util.Map;

public class ConfigValidation {
    public static Object NumbersValidator = ConfigValidation.listFv(Number.class, true);
    public static Object StringsValidator = ConfigValidation.listFv(String.class, true);
    public static Object MapOfStringToNumberValidator = ConfigValidation.mapFv(String.class, Number.class, true);
    public static Object MapOfStringToMapValidator = ConfigValidation.mapFv(ConfigValidation.fv(String.class, false), ConfigValidation.mapFv(ConfigValidation.fv(String.class, false), ConfigValidation.listFv(String.class, false), false), true);
    public static Object MapsValidator = ConfigValidation.listFv(Map.class, true);
    public static Object IntegerValidator = new FieldValidator(){

        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            long i;
            if (o == null) {
                return;
            }
            if (o instanceof Number && (double)(i = ((Number)o).longValue()) == ((Number)o).doubleValue() && i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be an Integer within type range.");
        }
    };
    public static Object IntegersValidator = new FieldValidator(){

        @Override
        public void validateField(String name, Object field) throws IllegalArgumentException {
            if (field == null) {
                return;
            }
            if (field instanceof Iterable) {
                for (Object o : (Iterable)field) {
                    long i;
                    if (o instanceof Number && (double)(i = ((Number)o).longValue()) == ((Number)o).doubleValue() && i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) continue;
                    throw new IllegalArgumentException("Each element of the list " + name + " must be an Integer within type range.");
                }
                return;
            }
        }
    };
    public static Object DoubleValidator = new FieldValidator(){

        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            if (o == null) {
                return;
            }
            if (o instanceof Number) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be an Double.");
        }
    };
    public static Object PowerOf2Validator = new FieldValidator(){

        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            long i;
            if (o == null) {
                return;
            }
            if (o instanceof Number && (double)(i = ((Number)o).longValue()) == ((Number)o).doubleValue() && i > 0L && (i & i - 1L) == 0L) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be a power of 2.");
        }
    };
    public static Object PositiveIntegerValidator = new FieldValidator(){

        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            long i;
            if (o == null) {
                return;
            }
            if (o instanceof Number && (double)(i = ((Number)o).longValue()) == ((Number)o).doubleValue() && i > 0L) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be a positive integer.");
        }
    };
    public static Object KryoRegValidator = new FieldValidator(){

        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            if (o == null) {
                return;
            }
            if (o instanceof Iterable) {
                for (Object e : (Iterable)o) {
                    if (e instanceof Map) {
                        for (Map.Entry entry : ((Map)e).entrySet()) {
                            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
                            throw new IllegalArgumentException("Each element of the list " + name + " must be a String or a Map of Strings");
                        }
                        continue;
                    }
                    if (e instanceof String) continue;
                    throw new IllegalArgumentException("Each element of the list " + name + " must be a String or a Map of Strings");
                }
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be an Iterable containing only Strings or Maps of Strings");
        }
    };
    public static Object StringOrStringListValidator = new FieldValidator(){
        private FieldValidator fv = ConfigValidation.listFv(String.class, false);

        @Override
        public void validateField(String name, Object o) throws IllegalArgumentException {
            if (o == null || o instanceof String) {
                return;
            }
            this.fv.validateField(name, o);
        }
    };

    public static NestableFieldValidator fv(final Class cls, final boolean nullAllowed) {
        return new NestableFieldValidator(){

            @Override
            public void validateField(String pd, String name, Object field) throws IllegalArgumentException {
                if (nullAllowed && field == null) {
                    return;
                }
                if (!cls.isInstance(field)) {
                    throw new IllegalArgumentException(pd + name + " must be a " + cls.getName() + ". (" + field + ")");
                }
            }
        };
    }

    public static NestableFieldValidator listFv(Class cls, boolean nullAllowed) {
        return ConfigValidation.listFv(ConfigValidation.fv(cls, false), nullAllowed);
    }

    public static NestableFieldValidator listFv(final NestableFieldValidator validator, final boolean nullAllowed) {
        return new NestableFieldValidator(){

            @Override
            public void validateField(String pd, String name, Object field) throws IllegalArgumentException {
                if (nullAllowed && field == null) {
                    return;
                }
                if (field instanceof Iterable) {
                    for (Object e : (Iterable)field) {
                        validator.validateField(pd + "Each element of the list ", name, e);
                    }
                    return;
                }
                throw new IllegalArgumentException("Field " + name + " must be an Iterable but was " + (field == null ? "null" : "a " + field.getClass()));
            }
        };
    }

    public static NestableFieldValidator mapFv(Class key, Class val, boolean nullAllowed) {
        return ConfigValidation.mapFv(ConfigValidation.fv(key, false), ConfigValidation.fv(val, false), nullAllowed);
    }

    public static NestableFieldValidator mapFv(final NestableFieldValidator key, final NestableFieldValidator val, final boolean nullAllowed) {
        return new NestableFieldValidator(){

            @Override
            public void validateField(String pd, String name, Object field) throws IllegalArgumentException {
                if (nullAllowed && field == null) {
                    return;
                }
                if (field instanceof Map) {
                    for (Map.Entry entry : ((Map)field).entrySet()) {
                        key.validateField("Each key of the map ", name, entry.getKey());
                        val.validateField("Each value in the map ", name, entry.getValue());
                    }
                    return;
                }
                throw new IllegalArgumentException("Field " + name + " must be a Map");
            }
        };
    }

    public static abstract class NestableFieldValidator
    implements FieldValidator {
        @Override
        public void validateField(String name, Object field) throws IllegalArgumentException {
            this.validateField(null, name, field);
        }

        public abstract void validateField(String var1, String var2, Object var3) throws IllegalArgumentException;
    }

    public static interface FieldValidator {
        public void validateField(String var1, Object var2) throws IllegalArgumentException;
    }
}

