/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import backtype.storm.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class GenericOptionsParser {
    static final Logger LOG = LoggerFactory.getLogger(GenericOptionsParser.class);
    static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String TOPOLOGY_LIB_PATH = "topology.lib.path";
    public static final String TOPOLOGY_LIB_NAME = "topology.lib.name";
    Config conf;
    CommandLine commandLine;
    static final LinkedHashMap<String, OptionProcessor> optionProcessors = new LinkedHashMap();

    public GenericOptionsParser(Config conf, String[] args) throws ParseException {
        this(conf, new Options(), args);
    }

    public GenericOptionsParser(Config conf, Options options, String[] args) throws ParseException {
        this.conf = conf;
        this.parseGeneralOptions(options, conf, args);
    }

    public String[] getRemainingArgs() {
        return this.commandLine.getArgs();
    }

    public Config getConfiguration() {
        return this.conf;
    }

    static Options buildGeneralOptions(Options opts) {
        Options r = new Options();
        for (Object o : opts.getOptions()) {
            r.addOption((Option)o);
        }
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated jars to be used by the submitted topology");
        Option libjars = OptionBuilder.create((String)"libjars");
        r.addOption(libjars);
        optionProcessors.put("libjars", new LibjarsProcessor());
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"an application configuration file");
        Option conf = OptionBuilder.create((String)"conf");
        r.addOption(conf);
        optionProcessors.put("conf", new ConfFileProcessor());
        OptionBuilder.withArgName((String)"D");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"extra configurations (preserving types)");
        Option extraConfig = OptionBuilder.create((String)"D");
        r.addOption(extraConfig);
        optionProcessors.put("D", new ExtraConfigProcessor());
        return r;
    }

    void parseGeneralOptions(Options opts, Config conf, String[] args) throws ParseException {
        opts = GenericOptionsParser.buildGeneralOptions(opts);
        GnuParser parser = new GnuParser();
        this.commandLine = parser.parse(opts, args, true);
        this.processGeneralOptions(conf, this.commandLine);
    }

    void processGeneralOptions(Config conf, CommandLine commandLine) throws ParseException {
        for (Map.Entry<String, OptionProcessor> e : optionProcessors.entrySet()) {
            if (!commandLine.hasOption(e.getKey())) continue;
            e.getValue().process(conf, commandLine);
        }
    }

    static List<File> validateFiles(String pathList) throws IOException {
        ArrayList<File> l = new ArrayList<File>();
        for (String s : pathList.split(",")) {
            File file = new File(s);
            if (!file.exists()) {
                throw new FileNotFoundException("File `" + file.getAbsolutePath() + "' does not exist");
            }
            l.add(file);
        }
        return l;
    }

    public static void printGenericCommandUsage(PrintStream out) {
        String[] strs;
        for (String s : strs = new String[]{"Generic options supported are", "  -conf <conf.xml>                            load configurations from", "                                              <conf.xml>", "  -conf <conf.yaml>                           load configurations from", "                                              <conf.yaml>", "  -D <key>=<value>                            set <key> in configuration", "                                              to <value> (preserve value's type)", "  -libjars <comma separated list of jars>     specify comma separated", "                                              jars to be used by", "                                              the submitted topology"}) {
            out.println(s);
        }
    }

    static class ConfFileProcessor
    implements OptionProcessor {
        static final Yaml yaml = new Yaml();

        ConfFileProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Map loadYamlConf(String f) throws IOException {
            try (InputStreamReader reader = null;){
                FileInputStream fis = new FileInputStream(f);
                reader = new InputStreamReader((InputStream)fis, UTF8);
                Map map = (Map)yaml.load((Reader)reader);
                return map;
            }
        }

        static Map loadConf(String f) throws IOException {
            if (f.endsWith(".yaml")) {
                return ConfFileProcessor.loadYamlConf(f);
            }
            throw new IOException("Unknown configuration file type: " + f + " does not end with either .yaml");
        }

        @Override
        public void process(Config conf, CommandLine commandLine) throws ParseException {
            try {
                for (String f : commandLine.getOptionValues("conf")) {
                    Map m = ConfFileProcessor.loadConf(f);
                    if (m == null) {
                        throw new ParseException("Empty configuration file " + f);
                    }
                    conf.putAll(m);
                }
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
    }

    static class ExtraConfigProcessor
    implements OptionProcessor {
        static final Yaml yaml = new Yaml();

        ExtraConfigProcessor() {
        }

        @Override
        public void process(Config conf, CommandLine commandLine) throws ParseException {
            for (String s : commandLine.getOptionValues("D")) {
                String[] keyval = s.split("=", 2);
                if (keyval.length != 2) {
                    throw new ParseException("Invalid option value `" + s + "'");
                }
                conf.putAll((Map)yaml.load(keyval[0] + ": " + keyval[1]));
            }
        }
    }

    static class LibjarsProcessor
    implements OptionProcessor {
        LibjarsProcessor() {
        }

        @Override
        public void process(Config conf, CommandLine commandLine) throws ParseException {
            try {
                List<File> jarFiles = GenericOptionsParser.validateFiles(commandLine.getOptionValue("libjars"));
                HashMap<String, String> jars = new HashMap<String, String>(jarFiles.size());
                ArrayList<String> names = new ArrayList<String>(jarFiles.size());
                for (File f : jarFiles) {
                    jars.put(f.getName(), f.getAbsolutePath());
                    names.add(f.getName());
                }
                conf.put(GenericOptionsParser.TOPOLOGY_LIB_PATH, jars);
                conf.put(GenericOptionsParser.TOPOLOGY_LIB_NAME, names);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
    }

    static interface OptionProcessor {
        public void process(Config var1, CommandLine var2) throws ParseException;
    }
}

