/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import backtype.storm.ILocalCluster;
import backtype.storm.LocalClusterMap;
import backtype.storm.LocalUtils;
import backtype.storm.generated.ClusterSummary;
import backtype.storm.generated.Credentials;
import backtype.storm.generated.KillOptions;
import backtype.storm.generated.NotAliveException;
import backtype.storm.generated.RebalanceOptions;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.SubmitOptions;
import backtype.storm.generated.TopologyInfo;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCluster
implements ILocalCluster {
    public static Logger LOG = LoggerFactory.getLogger(LocalCluster.class);
    private LocalClusterMap state;
    protected static LocalCluster instance = null;

    protected void setLogger() {
    }

    public static LocalCluster getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalCluster() {
        Class<LocalCluster> clazz = LocalCluster.class;
        synchronized (LocalCluster.class) {
            if (instance != null) {
                throw new RuntimeException("LocalCluster should be single");
            }
            this.setLogger();
            System.setProperty("java.net.preferIPv4Stack", "true");
            this.state = LocalUtils.prepareLocalCluster();
            if (this.state == null) {
                throw new RuntimeException("prepareLocalCluster error");
            }
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void submitTopology(String topologyName, Map conf, StormTopology topology) {
        this.submitTopologyWithOpts(topologyName, conf, topology, null);
    }

    @Override
    public void submitTopologyWithOpts(String topologyName, Map conf, StormTopology topology, SubmitOptions submitOpts) {
        if (!Utils.isValidConf(conf)) {
            throw new RuntimeException("Topology conf is not json-serializable");
        }
        conf.putAll(LocalUtils.getLocalBaseConf());
        conf.putAll(Utils.readCommandLineOpts());
        try {
            if (submitOpts == null) {
                this.state.getNimbus().submitTopology(topologyName, null, Utils.to_json(conf), topology);
            } else {
                this.state.getNimbus().submitTopologyWithOpts(topologyName, null, Utils.to_json(conf), topology, submitOpts);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to submit topology " + topologyName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void killTopology(String topologyName) {
        try {
            KillOptions killOps = new KillOptions();
            killOps.set_wait_secs(0);
            this.state.getNimbus().killTopologyWithOpts(topologyName, killOps);
        }
        catch (Exception e) {
            LOG.error("fail to kill Topology " + topologyName, (Throwable)e);
        }
    }

    @Override
    public void killTopologyWithOpts(String name, KillOptions options) throws NotAliveException {
        try {
            this.state.getNimbus().killTopologyWithOpts(name, options);
        }
        catch (TException e) {
            LOG.error("fail to kill Topology " + name, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void activate(String topologyName) {
        try {
            this.state.getNimbus().activate(topologyName);
        }
        catch (Exception e) {
            LOG.error("fail to activate " + topologyName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deactivate(String topologyName) {
        try {
            this.state.getNimbus().deactivate(topologyName);
        }
        catch (Exception e) {
            LOG.error("fail to deactivate " + topologyName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rebalance(String name, RebalanceOptions options) {
        try {
            this.state.getNimbus().rebalance(name, options);
        }
        catch (Exception e) {
            LOG.error("fail to rebalance " + name, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        JStormUtils.sleepMs(10000L);
        this.state.clean();
        instance = null;
    }

    @Override
    public String getTopologyConf(String id) {
        try {
            return this.state.getNimbus().getTopologyConf(id);
        }
        catch (Exception e) {
            LOG.error("fail to get topology Conf of topologId: " + id, (Throwable)e);
            return null;
        }
    }

    @Override
    public StormTopology getTopology(String id) {
        try {
            return this.state.getNimbus().getTopology(id);
        }
        catch (NotAliveException e) {
            LOG.error("fail to get topology of topologId: " + id, (Throwable)((Object)e));
        }
        catch (TException e) {
            LOG.error("fail to get topology of topologId: " + id, (Throwable)e);
        }
        return null;
    }

    @Override
    public ClusterSummary getClusterInfo() {
        try {
            return this.state.getNimbus().getClusterInfo();
        }
        catch (TException e) {
            LOG.error("fail to get cluster info", (Throwable)e);
            return null;
        }
    }

    @Override
    public TopologyInfo getTopologyInfo(String id) {
        try {
            return this.state.getNimbus().getTopologyInfo(id);
        }
        catch (NotAliveException e) {
            LOG.error("fail to get topology info of topologyId: " + id, (Throwable)((Object)e));
        }
        catch (TException e) {
            LOG.error("fail to get topology info of topologyId: " + id, (Throwable)e);
        }
        return null;
    }

    @Override
    @Deprecated
    public Map getState() {
        return null;
    }

    public LocalClusterMap getLocalClusterMap() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LocalCluster localCluster = null;
        try {
            localCluster = new LocalCluster();
        }
        finally {
            if (localCluster != null) {
                localCluster.shutdown();
            }
        }
    }

    @Override
    public void uploadNewCredentials(String topologyName, Credentials creds) {
        try {
            this.state.getNimbus().uploadNewCredentials(topologyName, creds);
        }
        catch (Exception e) {
            LOG.error("fail to uploadNewCredentials of topologyId: " + topologyName, (Throwable)e);
        }
    }
}

