/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import com.alibaba.jstorm.daemon.nimbus.NimbusServer;
import com.alibaba.jstorm.daemon.nimbus.ServiceHandler;
import com.alibaba.jstorm.daemon.supervisor.SupervisorManger;
import com.alibaba.jstorm.utils.PathUtils;
import com.alibaba.jstorm.zk.Factory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClusterMap {
    public static Logger LOG = LoggerFactory.getLogger(LocalClusterMap.class);
    private NimbusServer nimbusServer;
    private ServiceHandler nimbus;
    private Factory zookeeper;
    private Map conf;
    private List<String> tmpDir;
    private SupervisorManger supervisor;

    public ServiceHandler getNimbus() {
        return this.nimbus;
    }

    public void setNimbus(ServiceHandler nimbus) {
        this.nimbus = nimbus;
    }

    public Factory getZookeeper() {
        return this.zookeeper;
    }

    public void setZookeeper(Factory zookeeper) {
        this.zookeeper = zookeeper;
    }

    public Map getConf() {
        return this.conf;
    }

    public void setConf(Map conf) {
        this.conf = conf;
    }

    public NimbusServer getNimbusServer() {
        return this.nimbusServer;
    }

    public void setNimbusServer(NimbusServer nimbusServer) {
        this.nimbusServer = nimbusServer;
    }

    public SupervisorManger getSupervisor() {
        return this.supervisor;
    }

    public void setSupervisor(SupervisorManger supervisor) {
        this.supervisor = supervisor;
    }

    public List<String> getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(List<String> tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void clean() {
        if (this.supervisor != null) {
            this.supervisor.ShutdownAllWorkers();
            this.supervisor.shutdown();
        }
        if (this.nimbusServer != null) {
            this.nimbusServer.cleanup();
        }
        if (this.zookeeper != null) {
            this.zookeeper.shutdown();
        }
        if (this.tmpDir != null) {
            for (String dir : this.tmpDir) {
                try {
                    PathUtils.rmr(dir);
                }
                catch (IOException e) {
                    LOG.error("Fail to delete " + dir);
                }
            }
        }
    }
}

