/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import backtype.storm.ILocalDRPC;
import backtype.storm.generated.DRPCRequest;
import backtype.storm.utils.ServiceRegistry;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.drpc.Drpc;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.File;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDRPC
implements ILocalDRPC {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDRPC.class);
    private Drpc handler = new Drpc();
    private Thread thread = new Thread(new Runnable(){

        @Override
        public void run() {
            LOG.info("Begin to init local Drpc");
            try {
                LocalDRPC.this.killOldDrpcPids();
                LocalDRPC.this.handler.init();
            }
            catch (Exception e) {
                LOG.info("Failed to  start local drpc");
                System.exit(-1);
            }
            LOG.info("Successfully start local drpc");
        }
    });
    private final String serviceId;

    public LocalDRPC() {
        this.thread.start();
        this.serviceId = ServiceRegistry.registerService(this.handler);
    }

    public void killOldDrpcPids() throws Exception {
        String[] existPids;
        Map conf = StormConfig.read_storm_config();
        LOG.info("Configuration is \n" + conf);
        String pidDir = StormConfig.drpcPids(conf);
        File file = new File(pidDir);
        if (!file.exists()) {
            return;
        }
        for (String existPid : existPids = file.list()) {
            try {
                PathUtils.rmpath(pidDir + File.separator + existPid);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String execute(String functionName, String funcArgs) {
        try {
            return this.handler.execute(functionName, funcArgs);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void result(String id, String result2) throws TException {
        this.handler.result(id, result2);
    }

    @Override
    public DRPCRequest fetchRequest(String functionName) throws TException {
        return this.handler.fetchRequest(functionName);
    }

    @Override
    public void failRequest(String id) throws TException {
        this.handler.failRequest(id);
    }

    @Override
    public void shutdown() {
        ServiceRegistry.unregisterService(this.serviceId);
        this.handler.shutdown();
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }
}

