/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import backtype.storm.Config;
import backtype.storm.GenericOptionsParser;
import backtype.storm.Tool;
import backtype.storm.utils.Utils;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolRunner {
    static final Logger LOG = LoggerFactory.getLogger(ToolRunner.class);

    public static void run(Tool tool, String[] args) {
        ToolRunner.run(tool.getConf(), tool, args);
    }

    public static void run(Config conf, Tool tool, String[] args) {
        try {
            if (conf == null) {
                conf = new Config();
                conf.putAll(Utils.readStormConfig());
            }
            GenericOptionsParser parser = new GenericOptionsParser(conf, args);
            LOG.info(conf.toString());
            tool.setConf(conf);
            System.exit(tool.run(parser.getRemainingArgs()));
        }
        catch (ParseException e) {
            LOG.error("Error parsing generic options: {}", (Object)e.getMessage());
            GenericOptionsParser.printGenericCommandUsage(System.err);
            System.exit(2);
        }
        catch (Exception e) {
            LOG.error("Error running tool", (Throwable)e);
            System.exit(1);
        }
    }
}

