/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.clojure;

import backtype.storm.coordination.CoordinatedBolt;
import backtype.storm.generated.StreamInfo;
import backtype.storm.task.IBolt;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.Utils;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.RT;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClojureBolt
implements IRichBolt,
CoordinatedBolt.FinishedCallback {
    Map<String, StreamInfo> _fields;
    List<String> _fnSpec;
    List<String> _confSpec;
    List<Object> _params;
    IBolt _bolt;

    public ClojureBolt(List fnSpec, List confSpec, List<Object> params, Map<String, StreamInfo> fields) {
        this._fnSpec = fnSpec;
        this._confSpec = confSpec;
        this._params = params;
        this._fields = fields;
    }

    @Override
    public void prepare(final Map stormConf, final TopologyContext context, OutputCollector collector) {
        IFn hof = Utils.loadClojureFn(this._fnSpec.get(0), this._fnSpec.get(1));
        try {
            IFn preparer = (IFn)hof.applyTo(RT.seq(this._params));
            PersistentArrayMap collectorMap = new PersistentArrayMap(new Object[]{Keyword.intern((Symbol)Symbol.create((String)"output-collector")), collector, Keyword.intern((Symbol)Symbol.create((String)"context")), context});
            ArrayList<Object> args = new ArrayList<Object>((Map)collectorMap){
                final /* synthetic */ Map val$collectorMap;
                {
                    this.val$collectorMap = map2;
                    this.add(stormConf);
                    this.add(context);
                    this.add(this.val$collectorMap);
                }
            };
            this._bolt = (IBolt)preparer.applyTo(RT.seq((Object)args));
            try {
                this._bolt.prepare(stormConf, context, collector);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void execute(Tuple input) {
        this._bolt.execute(input);
    }

    @Override
    public void cleanup() {
        try {
            this._bolt.cleanup();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (String stream : this._fields.keySet()) {
            StreamInfo info = this._fields.get(stream);
            declarer.declareStream(stream, info.is_direct(), new Fields(info.get_output_fields()));
        }
    }

    @Override
    public void finishedId(Object id) {
        if (this._bolt instanceof CoordinatedBolt.FinishedCallback) {
            ((CoordinatedBolt.FinishedCallback)((Object)this._bolt)).finishedId(id);
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        IFn hof = Utils.loadClojureFn(this._confSpec.get(0), this._confSpec.get(1));
        try {
            return (Map)hof.applyTo(RT.seq(this._params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

