/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.command;

import backtype.storm.utils.ShellUtils;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.daemon.supervisor.MachineCheckStatus;
import com.alibaba.jstorm.utils.JStormUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class health {
    private static Logger LOG = LoggerFactory.getLogger(health.class);
    private static final String NOT_PASSED_PATTERN = "check don't passed";

    public static MachineCheckStatus check() {
        MachineCheckStatus status = new MachineCheckStatus();
        Map conf = Utils.readStormConfig();
        status.updatePanic();
        health.runJStormMachineResourceCheckScript(status, conf);
        if (status.getType() == MachineCheckStatus.StatusType.panic) {
            return status;
        }
        status.updateError();
        health.runJStormMachineResourceCheckScript(status, conf);
        if (status.getType() == MachineCheckStatus.StatusType.error) {
            return status;
        }
        status.updateWarning();
        health.runJStormMachineResourceCheckScript(status, conf);
        return status;
    }

    private static void runJStormMachineResourceCheckScript(MachineCheckStatus status, Map conf) {
        try {
            long timeOut = ConfigExtension.getStormHealthTimeoutMs(conf);
            List<String> evalScripts = null;
            if (status.getType().equals((Object)MachineCheckStatus.StatusType.panic)) {
                evalScripts = health.getEvalScriptAbsolutePath(ConfigExtension.getStormMachineResourcePanicCheckDir(conf));
            } else if (status.getType().equals((Object)MachineCheckStatus.StatusType.error)) {
                evalScripts = health.getEvalScriptAbsolutePath(ConfigExtension.getStormMachineResourceErrorCheckDir(conf));
            } else if (status.getType().equals((Object)MachineCheckStatus.StatusType.warning)) {
                evalScripts = health.getEvalScriptAbsolutePath(ConfigExtension.getStormMachineResourceWarningCheckDir(conf));
            }
            if (evalScripts != null && evalScripts.size() > 0) {
                for (String command : evalScripts) {
                    ScriptProcessLauncher scriptProcessLauncher = new ScriptProcessLauncher(command, timeOut, status);
                    ExitStatus exit = scriptProcessLauncher.launch();
                    if (!exit.equals((Object)ExitStatus.FAILED)) continue;
                    return;
                }
            } else {
                status.updateInfo();
                LOG.warn("jstorm machine resource " + (Object)((Object)status.getType()) + "'s check scripts is non-existent");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to run machine resource check scripts: " + e.getCause(), (Throwable)e);
            status.updateInfo();
        }
    }

    private static List<String> getEvalScriptAbsolutePath(String scriptDir) {
        if (scriptDir == null) {
            LOG.warn("jstorm machine resource check script directory is not configured, please check .");
            return null;
        }
        File parentFile = new File(scriptDir);
        return health.getChildLlist(parentFile);
    }

    private static List<String> getChildLlist(File parentFile) {
        ArrayList<String> ret = new ArrayList<String>();
        if (parentFile.exists()) {
            File[] list2;
            for (File file : list2 = parentFile.listFiles()) {
                if (file.isDirectory() || !file.canExecute()) continue;
                ret.add(file.getAbsolutePath());
            }
        }
        LOG.debug("valid scripts are {}", ret);
        return ret;
    }

    public static void main(String[] args) {
        health.check();
    }

    private static enum ExitStatus {
        SUCCESS,
        TIMED_OUT,
        FAILED_WITH_EXIT_CODE,
        FAILED_WITH_EXCEPTION,
        FAILED,
        NO_RESOURCE;

    }

    static class ScriptProcessLauncher {
        ShellUtils.ShellCommandExecutor shexec = null;
        MachineCheckStatus status = null;
        String execScript;

        public ScriptProcessLauncher(String execScript, long timeOut, MachineCheckStatus status) {
            this.status = status;
            this.execScript = execScript;
            String[] execString = new String[]{execScript};
            this.shexec = new ShellUtils.ShellCommandExecutor(execString, null, null, timeOut);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExitStatus launch() {
            ExitStatus exitStatus = ExitStatus.SUCCESS;
            try {
                this.shexec.execute();
            }
            catch (ShellUtils.ExitCodeException e) {
                exitStatus = ExitStatus.FAILED_WITH_EXIT_CODE;
                if (this.shexec.isTimedOut()) {
                    exitStatus = ExitStatus.TIMED_OUT;
                }
                LOG.warn(this.execScript + " exitCode exception, exit code : " + e.getExitCode() + "; the exitStatus is: " + (Object)((Object)exitStatus));
            }
            catch (Exception e) {
                exitStatus = !this.shexec.isTimedOut() ? ExitStatus.FAILED_WITH_EXCEPTION : ExitStatus.TIMED_OUT;
                LOG.warn(this.execScript + " exception, the exitStatus is: " + (Object)((Object)exitStatus));
                LOG.warn(JStormUtils.getErrorInfo(e));
            }
            finally {
                if (exitStatus == ExitStatus.SUCCESS && this.notPassed(this.shexec.getOutput())) {
                    exitStatus = ExitStatus.FAILED;
                } else {
                    this.status.updateInfo();
                }
                LOG.debug("Script execute output: " + this.shexec.getOutput());
            }
            return exitStatus;
        }

        private boolean notPassed(String output) {
            String[] splits;
            for (String split : splits = output.split("\n")) {
                if (!split.startsWith(health.NOT_PASSED_PATTERN)) continue;
                return true;
            }
            return false;
        }
    }
}

