/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.command;

import backtype.storm.generated.RebalanceOptions;
import backtype.storm.utils.NimbusClient;
import backtype.storm.utils.Utils;
import java.util.Map;

public class rebalance {
    static final String REASSIGN_FLAG = "-r";

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            rebalance.printErrorInfo();
            return;
        }
        int argsIndex = 0;
        try {
            String topologyName;
            RebalanceOptions options = new RebalanceOptions();
            options.set_reassign(false);
            options.set_conf(null);
            if (args[argsIndex].equalsIgnoreCase(REASSIGN_FLAG)) {
                options.set_reassign(true);
                if (args.length <= ++argsIndex) {
                    rebalance.printErrorInfo();
                    return;
                }
                topologyName = args[argsIndex];
            } else {
                topologyName = args[argsIndex];
            }
            if (args.length > ++argsIndex) {
                for (int i = argsIndex; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.endsWith("yaml") || arg.endsWith("prop")) {
                        Map userConf = Utils.loadConf(arg);
                        String jsonConf = Utils.to_json(userConf);
                        options.set_conf(jsonConf);
                        continue;
                    }
                    try {
                        int delaySeconds = Integer.parseInt(args[1]);
                        options.set_wait_secs(delaySeconds);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unsupported argument found, arg=" + arg + ". Full args are " + args);
                        rebalance.printErrorInfo();
                        return;
                    }
                }
            }
            rebalance.submitRebalance(topologyName, options);
            System.out.println("Successfully submit command rebalance " + topologyName + ", delaySecs=" + options.get_wait_secs() + ", reassignFlag=" + options.is_reassign() + ", newConfiguration=" + options.get_conf());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void printErrorInfo() {
        System.out.println("Error: Invalid parameters!");
        System.out.println("USAGE: jstorm rebalance [-r] TopologyName [DelayTime] [NewConfig]");
    }

    public static void submitRebalance(String topologyName, RebalanceOptions options) throws Exception {
        rebalance.submitRebalance(topologyName, options, null);
    }

    public static void submitRebalance(String topologyName, RebalanceOptions options, Map conf) throws Exception {
        Map stormConf = Utils.readStormConfig();
        if (conf != null) {
            stormConf.putAll(conf);
        }
        try (NimbusClient client = null;){
            client = NimbusClient.getConfiguredClient(stormConf);
            client.getClient().rebalance(topologyName, options);
        }
    }
}

