/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.command;

import backtype.storm.StormSubmitter;
import backtype.storm.utils.NimbusClient;
import backtype.storm.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class update_topology {
    public static void usage() {
        System.out.println("update topology config, please do as following:");
        System.out.println("update_topology topologyName -conf configFile");
        System.out.println("update topology jar, please do as following:");
        System.out.println("update_topology topologyName -jar jarFile");
        System.out.println("update topology jar and conf, please do as following:");
        System.out.println("update_topology topologyName -jar jarFile -conf configFile");
    }

    private static Options buildGeneralOptions(Options opts) {
        Options r = new Options();
        for (Object o : opts.getOptions()) {
            r.addOption((Option)o);
        }
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"topology jar of the submitted topology");
        Option jar = OptionBuilder.create((String)"jar");
        r.addOption(jar);
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"an application configuration file");
        Option conf = OptionBuilder.create((String)"conf");
        r.addOption(conf);
        return r;
    }

    private static void updateTopology(String topologyName, String pathJar, String pathConf) {
        HashMap loadMap = pathConf != null ? Utils.loadConf(pathConf) : new HashMap();
        Map conf = Utils.readStormConfig();
        conf.putAll(loadMap);
        try (NimbusClient client = NimbusClient.getConfiguredClient(conf);){
            String uploadLocation = null;
            if (pathJar != null) {
                System.out.println("Jar update to master yet. Submitting jar of " + pathJar);
                String path = client.getClient().beginFileUpload();
                String[] pathCache = path.split("/");
                uploadLocation = path + "/stormjar-" + pathCache[pathCache.length - 1] + ".jar";
                List lib = (List)conf.get("topology.lib.name");
                Map libPath = (Map)conf.get("topology.lib.path");
                if (lib != null && lib.size() != 0) {
                    for (String libName : lib) {
                        String jarPath = path + "/lib/" + libName;
                        client.getClient().beginLibUpload(jarPath);
                        StormSubmitter.submitJar(conf, (String)libPath.get(libName), jarPath, client);
                    }
                }
                StormSubmitter.submitJar(conf, pathJar, uploadLocation, client);
            }
            String jsonConf = Utils.to_json(loadMap);
            System.out.println("New configuration:\n" + jsonConf);
            client.getClient().updateTopology(topologyName, uploadLocation, jsonConf);
            System.out.println("Successfully submit command update " + topologyName);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.out.println("Invalid parameter");
            update_topology.usage();
            return;
        }
        String topologyName = args[0];
        try {
            String[] str2 = Arrays.copyOfRange(args, 1, args.length);
            GnuParser parser = new GnuParser();
            Options r = update_topology.buildGeneralOptions(new Options());
            CommandLine commandLine = parser.parse(r, str2, true);
            String pathConf = null;
            String pathJar = null;
            if (commandLine.hasOption("conf")) {
                pathConf = commandLine.getOptionValues("conf")[0];
            }
            if (commandLine.hasOption("jar")) {
                pathJar = commandLine.getOptionValues("jar")[0];
            }
            if (pathConf != null || pathJar != null) {
                update_topology.updateTopology(topologyName, pathJar, pathConf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

