/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.drpc;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinResult
extends BaseRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(JoinResult.class);
    String returnComponent;
    Map<Object, Tuple> returns = new HashMap<Object, Tuple>();
    Map<Object, Tuple> results = new HashMap<Object, Tuple>();
    OutputCollector _collector;

    public JoinResult(String returnComponent) {
        this.returnComponent = returnComponent;
    }

    @Override
    public void prepare(Map map, TopologyContext context, OutputCollector collector) {
        this._collector = collector;
    }

    @Override
    public void execute(Tuple tuple) {
        Object requestId = tuple.getValue(0);
        if (tuple.getSourceComponent().equals(this.returnComponent)) {
            this.returns.put(requestId, tuple);
        } else {
            this.results.put(requestId, tuple);
        }
        if (this.returns.containsKey(requestId) && this.results.containsKey(requestId)) {
            Tuple result2 = this.results.remove(requestId);
            Tuple returner = this.returns.remove(requestId);
            LOG.debug(result2.getValue(1).toString());
            ArrayList<Tuple> anchors = new ArrayList<Tuple>();
            anchors.add(result2);
            anchors.add(returner);
            this._collector.emit(anchors, (List<Object>)new Values("" + result2.getValue(1), returner.getValue(1)));
            this._collector.ack(result2);
            this._collector.ack(returner);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("result", "return-info"));
    }
}

