/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging;

import backtype.storm.messaging.IContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportFactory {
    public static final Logger LOG = LoggerFactory.getLogger(TransportFactory.class);

    public static IContext makeContext(Map storm_conf) {
        String transport_plugin_klassName = (String)storm_conf.get("storm.messaging.transport");
        LOG.info("JStorm peer transport plugin:" + transport_plugin_klassName);
        IContext transport = null;
        try {
            Class<?> klass = Class.forName(transport_plugin_klassName);
            Constructor<?> constructor = klass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            LOG.info("TransportFactory makeContext: new klass: " + obj);
            if (obj instanceof IContext) {
                transport = (IContext)obj;
                transport.prepare(storm_conf);
                LOG.info("TransportFactory makeContext: start prepare... " + storm_conf);
            } else {
                Method method = klass.getMethod("makeContext", Map.class);
                LOG.debug("object:" + obj + " method:" + method);
                transport = (IContext)method.invoke(obj, storm_conf);
            }
            LOG.info("TransportFactory makeContext done...");
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to construct messaging plugin from plugin " + transport_plugin_klassName, e);
        }
        return transport;
    }
}

