/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.scheduler;

import backtype.storm.scheduler.ExecutorDetails;
import backtype.storm.scheduler.INimbus;
import backtype.storm.scheduler.SchedulerAssignment;
import backtype.storm.scheduler.SchedulerAssignmentImpl;
import backtype.storm.scheduler.SupervisorDetails;
import backtype.storm.scheduler.Topologies;
import backtype.storm.scheduler.TopologyDetails;
import backtype.storm.scheduler.WorkerSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Cluster {
    private Map<String, SupervisorDetails> supervisors;
    private Map<String, SchedulerAssignmentImpl> assignments;
    private Map<String, String> status;
    private Map<String, List<String>> hostToId;
    private Set<String> blackListedHosts = new HashSet<String>();
    private INimbus inimbus;

    public Cluster(INimbus nimbus, Map<String, SupervisorDetails> supervisors, Map<String, SchedulerAssignmentImpl> assignments) {
        this.inimbus = nimbus;
        this.supervisors = new HashMap<String, SupervisorDetails>(supervisors.size());
        this.supervisors.putAll(supervisors);
        this.assignments = new HashMap<String, SchedulerAssignmentImpl>(assignments.size());
        this.assignments.putAll(assignments);
        this.status = new HashMap<String, String>();
        this.hostToId = new HashMap<String, List<String>>();
        for (String nodeId : supervisors.keySet()) {
            SupervisorDetails supervisor = supervisors.get(nodeId);
            String host = supervisor.getHost();
            if (!this.hostToId.containsKey(host)) {
                this.hostToId.put(host, new ArrayList());
            }
            this.hostToId.get(host).add(nodeId);
        }
    }

    public void setBlacklistedHosts(Set<String> hosts) {
        this.blackListedHosts = hosts;
    }

    public Set<String> getBlacklistedHosts() {
        return this.blackListedHosts;
    }

    public void blacklistHost(String host) {
        if (this.blackListedHosts == null) {
            this.blackListedHosts = new HashSet<String>();
        }
        if (!(this.blackListedHosts instanceof HashSet)) {
            this.blackListedHosts = new HashSet<String>(this.blackListedHosts);
        }
        this.blackListedHosts.add(host);
    }

    public boolean isBlackListed(String supervisorId) {
        return this.blackListedHosts != null && this.blackListedHosts.contains(this.getHost(supervisorId));
    }

    public boolean isBlacklistedHost(String host) {
        return this.blackListedHosts != null && this.blackListedHosts.contains(host);
    }

    public String getHost(String supervisorId) {
        return this.inimbus.getHostName(this.supervisors, supervisorId);
    }

    public List<TopologyDetails> needsSchedulingTopologies(Topologies topologies) {
        ArrayList<TopologyDetails> ret = new ArrayList<TopologyDetails>();
        for (TopologyDetails topology : topologies.getTopologies()) {
            if (!this.needsScheduling(topology)) continue;
            ret.add(topology);
        }
        return ret;
    }

    public boolean needsScheduling(TopologyDetails topology) {
        int assignedNumWorkers;
        int desiredNumWorkers = topology.getNumWorkers();
        if (desiredNumWorkers > (assignedNumWorkers = this.getAssignedNumWorkers(topology))) {
            return true;
        }
        return this.getUnassignedExecutors(topology).size() > 0;
    }

    public Map<ExecutorDetails, String> getNeedsSchedulingExecutorToComponents(TopologyDetails topology) {
        HashSet<ExecutorDetails> allExecutors = new HashSet<ExecutorDetails>(topology.getExecutors());
        SchedulerAssignment assignment = this.assignments.get(topology.getId());
        if (assignment != null) {
            Set<ExecutorDetails> assignedExecutors = assignment.getExecutors();
            allExecutors.removeAll(assignedExecutors);
        }
        return topology.selectExecutorToComponent(allExecutors);
    }

    public Map<String, List<ExecutorDetails>> getNeedsSchedulingComponentToExecutors(TopologyDetails topology) {
        Map<ExecutorDetails, String> executorToComponents = this.getNeedsSchedulingExecutorToComponents(topology);
        HashMap<String, List<ExecutorDetails>> componentToExecutors = new HashMap<String, List<ExecutorDetails>>();
        for (ExecutorDetails executor : executorToComponents.keySet()) {
            String component = executorToComponents.get(executor);
            if (!componentToExecutors.containsKey(component)) {
                componentToExecutors.put(component, new ArrayList());
            }
            ((List)componentToExecutors.get(component)).add(executor);
        }
        return componentToExecutors;
    }

    public Set<Integer> getUsedPorts(SupervisorDetails supervisor) {
        Map<String, SchedulerAssignment> assignments = this.getAssignments();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (SchedulerAssignment assignment : assignments.values()) {
            for (WorkerSlot slot : assignment.getExecutorToSlot().values()) {
                if (!slot.getNodeId().equals(supervisor.getId())) continue;
                usedPorts.add(slot.getPort());
            }
        }
        return usedPorts;
    }

    public Set<Integer> getAvailablePorts(SupervisorDetails supervisor) {
        Set<Integer> usedPorts = this.getUsedPorts(supervisor);
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getAssignablePorts(supervisor));
        ret.removeAll(usedPorts);
        return ret;
    }

    public Set<Integer> getAssignablePorts(SupervisorDetails supervisor) {
        if (this.isBlackListed(supervisor.id)) {
            return new HashSet<Integer>();
        }
        return supervisor.allPorts;
    }

    public List<WorkerSlot> getAvailableSlots(SupervisorDetails supervisor) {
        Set<Integer> ports = this.getAvailablePorts(supervisor);
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>(ports.size());
        for (Integer port : ports) {
            slots.add(new WorkerSlot(supervisor.getId(), port));
        }
        return slots;
    }

    public List<WorkerSlot> getAssignableSlots(SupervisorDetails supervisor) {
        Set<Integer> ports = this.getAssignablePorts(supervisor);
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>(ports.size());
        for (Integer port : ports) {
            slots.add(new WorkerSlot(supervisor.getId(), port));
        }
        return slots;
    }

    public Collection<ExecutorDetails> getUnassignedExecutors(TopologyDetails topology) {
        if (topology == null) {
            return new ArrayList<ExecutorDetails>(0);
        }
        HashSet<ExecutorDetails> ret = new HashSet<ExecutorDetails>(topology.getExecutors());
        SchedulerAssignment assignment = this.getAssignmentById(topology.getId());
        if (assignment != null) {
            Set<ExecutorDetails> assignedExecutors = assignment.getExecutors();
            ret.removeAll(assignedExecutors);
        }
        return ret;
    }

    public int getAssignedNumWorkers(TopologyDetails topology) {
        SchedulerAssignment assignment = this.getAssignmentById(topology.getId());
        if (topology == null || assignment == null) {
            return 0;
        }
        HashSet<WorkerSlot> slots = new HashSet<WorkerSlot>();
        slots.addAll(assignment.getExecutorToSlot().values());
        return slots.size();
    }

    public void assign(WorkerSlot slot, String topologyId, Collection<ExecutorDetails> executors) {
        if (this.isSlotOccupied(slot)) {
            throw new RuntimeException("slot: [" + slot.getNodeId() + ", " + slot.getPort() + "] is already occupied.");
        }
        SchedulerAssignmentImpl assignment = (SchedulerAssignmentImpl)this.getAssignmentById(topologyId);
        if (assignment == null) {
            assignment = new SchedulerAssignmentImpl(topologyId, new HashMap<ExecutorDetails, WorkerSlot>());
            this.assignments.put(topologyId, assignment);
        } else {
            for (ExecutorDetails executor : executors) {
                if (!assignment.isExecutorAssigned(executor)) continue;
                throw new RuntimeException("the executor is already assigned, you should unassign it before assign it to another slot.");
            }
        }
        assignment.assign(slot, executors);
    }

    public List<WorkerSlot> getAvailableSlots() {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            slots.addAll(this.getAvailableSlots(supervisor));
        }
        return slots;
    }

    public List<WorkerSlot> getAssignableSlots() {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            slots.addAll(this.getAssignableSlots(supervisor));
        }
        return slots;
    }

    public void freeSlot(WorkerSlot slot) {
        for (SchedulerAssignmentImpl assignment : this.assignments.values()) {
            if (!assignment.isSlotOccupied(slot)) continue;
            assignment.unassignBySlot(slot);
        }
    }

    public void freeSlots(Collection<WorkerSlot> slots) {
        if (slots != null) {
            for (WorkerSlot slot : slots) {
                this.freeSlot(slot);
            }
        }
    }

    public boolean isSlotOccupied(WorkerSlot slot) {
        for (SchedulerAssignment schedulerAssignment : this.assignments.values()) {
            if (!schedulerAssignment.isSlotOccupied(slot)) continue;
            return true;
        }
        return false;
    }

    public SchedulerAssignment getAssignmentById(String topologyId) {
        if (this.assignments.containsKey(topologyId)) {
            return this.assignments.get(topologyId);
        }
        return null;
    }

    public SupervisorDetails getSupervisorById(String nodeId) {
        if (this.supervisors.containsKey(nodeId)) {
            return this.supervisors.get(nodeId);
        }
        return null;
    }

    public Collection<WorkerSlot> getUsedSlots() {
        HashSet<WorkerSlot> ret = new HashSet<WorkerSlot>();
        for (SchedulerAssignmentImpl s : this.assignments.values()) {
            ret.addAll(s.getExecutorToSlot().values());
        }
        return ret;
    }

    public List<SupervisorDetails> getSupervisorsByHost(String host) {
        List<String> nodeIds = this.hostToId.get(host);
        ArrayList<SupervisorDetails> ret = new ArrayList<SupervisorDetails>();
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                ret.add(this.getSupervisorById(nodeId));
            }
        }
        return ret;
    }

    public Map<String, SchedulerAssignment> getAssignments() {
        HashMap<String, SchedulerAssignment> ret = new HashMap<String, SchedulerAssignment>(this.assignments.size());
        for (String topologyId : this.assignments.keySet()) {
            ret.put(topologyId, this.assignments.get(topologyId));
        }
        return ret;
    }

    public Map<String, SupervisorDetails> getSupervisors() {
        return this.supervisors;
    }

    public void setStatus(String topologyId, String status) {
        this.status.put(topologyId, status);
    }

    public Map<String, String> getStatusMap() {
        return this.status;
    }
}

