/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.scheduler.multitenant;

import backtype.storm.scheduler.SchedulerAssignment;
import backtype.storm.scheduler.TopologyDetails;
import backtype.storm.scheduler.WorkerSlot;
import backtype.storm.scheduler.multitenant.Node;
import backtype.storm.scheduler.multitenant.NodePool;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedPool
extends NodePool {
    private static final Logger LOG = LoggerFactory.getLogger(IsolatedPool.class);
    private Map<String, Set<Node>> _topologyIdToNodes = new HashMap<String, Set<Node>>();
    private HashMap<String, TopologyDetails> _tds = new HashMap();
    private HashSet<String> _isolated = new HashSet();
    private int _maxNodes;
    private int _usedNodes;

    public IsolatedPool(int maxNodes) {
        this._maxNodes = maxNodes;
        this._usedNodes = 0;
    }

    @Override
    public void addTopology(TopologyDetails td) {
        String topId = td.getId();
        LOG.debug("Adding in Topology {}", (Object)topId);
        SchedulerAssignment assignment = this._cluster.getAssignmentById(topId);
        HashSet<Node> assignedNodes = new HashSet<Node>();
        if (assignment != null) {
            for (WorkerSlot ws : assignment.getSlots()) {
                Node n = (Node)this._nodeIdToNode.get(ws.getNodeId());
                assignedNodes.add(n);
            }
        }
        this._usedNodes += assignedNodes.size();
        this._topologyIdToNodes.put(topId, assignedNodes);
        this._tds.put(topId, td);
        if (td.getConf().get("topology.isolate.machines") != null) {
            this._isolated.add(topId);
        }
    }

    @Override
    public boolean canAdd(TopologyDetails td) {
        String topId = td.getId();
        SchedulerAssignment assignment = this._cluster.getAssignmentById(topId);
        if (assignment != null) {
            for (WorkerSlot ws : assignment.getSlots()) {
                Node n = (Node)this._nodeIdToNode.get(ws.getNodeId());
                if (n.getRunningTopologies().size() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void scheduleAsNeeded(NodePool ... lesserPools) {
        for (String topId : this._topologyIdToNodes.keySet()) {
            Set<Node> found;
            TopologyDetails td = this._tds.get(topId);
            if (this._cluster.needsScheduling(td)) {
                Node n;
                LOG.debug("Scheduling topology {}", (Object)topId);
                Set<Node> allNodes = this._topologyIdToNodes.get(topId);
                Number nodesRequested = (Number)td.getConf().get("topology.isolate.machines");
                int slotsToUse = 0;
                slotsToUse = nodesRequested == null ? this.getNodesForNotIsolatedTop(td, allNodes, lesserPools) : this.getNodesForIsolatedTop(td, allNodes, lesserPools, nodesRequested.intValue());
                if (slotsToUse <= 0) continue;
                NodePool.RoundRobinSlotScheduler slotSched = new NodePool.RoundRobinSlotScheduler(td, slotsToUse, this._cluster);
                LinkedList<Node> sortedNodes = new LinkedList<Node>(allNodes);
                Collections.sort(sortedNodes, Node.FREE_NODE_COMPARATOR_DEC);
                LOG.debug("Nodes sorted by free space {}", sortedNodes);
                while (slotSched.assignSlotTo(n = sortedNodes.remove())) {
                    int freeSlots = n.totalSlotsFree();
                    for (int i = 0; i < sortedNodes.size(); ++i) {
                        if (freeSlots < sortedNodes.get(i).totalSlotsFree()) continue;
                        sortedNodes.add(i, n);
                        n = null;
                        break;
                    }
                    if (n == null) continue;
                    sortedNodes.add(n);
                }
            }
            int nc = (found = this._topologyIdToNodes.get(topId)) == null ? 0 : found.size();
            this._cluster.setStatus(topId, "Scheduled Isolated on " + nc + " Nodes");
        }
    }

    private int getNodesForIsolatedTop(TopologyDetails td, Set<Node> allNodes, NodePool[] lesserPools, int nodesRequested) {
        String topId = td.getId();
        LOG.debug("Topology {} is isolated", (Object)topId);
        int nodesFromUsAvailable = this.nodesAvailable();
        int nodesFromOthersAvailable = NodePool.nodesAvailable(lesserPools);
        int nodesUsed = this._topologyIdToNodes.get(topId).size();
        int nodesNeeded = nodesRequested - nodesUsed;
        LOG.debug("Nodes... requested {} used {} available from us {} avail from other {} needed {}", new Object[]{nodesRequested, nodesUsed, nodesFromUsAvailable, nodesFromOthersAvailable, nodesNeeded});
        if (nodesNeeded - nodesFromUsAvailable > this._maxNodes - this._usedNodes) {
            this._cluster.setStatus(topId, "Max Nodes(" + this._maxNodes + ") for this user would be exceeded. " + (nodesNeeded - nodesFromUsAvailable - (this._maxNodes - this._usedNodes)) + " more nodes needed to run topology.");
            return 0;
        }
        int nodesNeededFromOthers = Math.min(Math.min(this._maxNodes - this._usedNodes, nodesFromOthersAvailable), nodesNeeded);
        int nodesNeededFromUs = nodesNeeded - nodesNeededFromOthers;
        LOG.debug("Nodes... needed from us {} needed from others {}", (Object)nodesNeededFromUs, (Object)nodesNeededFromOthers);
        if (nodesNeededFromUs > nodesFromUsAvailable) {
            this._cluster.setStatus(topId, "Not Enough Nodes Available to Schedule Topology");
            return 0;
        }
        Collection<Node> found = NodePool.takeNodes(nodesNeededFromOthers, lesserPools);
        this._usedNodes += found.size();
        allNodes.addAll(found);
        Collection<Node> foundMore = this.takeNodes(nodesNeededFromUs);
        this._usedNodes += foundMore.size();
        allNodes.addAll(foundMore);
        int totalTasks = td.getExecutors().size();
        int origRequest = td.getNumWorkers();
        int slotsRequested = Math.min(totalTasks, origRequest);
        int slotsUsed = Node.countSlotsUsed(allNodes);
        int slotsFree = Node.countFreeSlotsAlive(allNodes);
        int slotsToUse = Math.min(slotsRequested - slotsUsed, slotsFree);
        if (slotsToUse <= 0) {
            this._cluster.setStatus(topId, "Node has partially crashed, if this situation persists rebalance the topology.");
        }
        return slotsToUse;
    }

    private int getNodesForNotIsolatedTop(TopologyDetails td, Set<Node> allNodes, NodePool[] lesserPools) {
        String topId = td.getId();
        LOG.debug("Topology {} is not isolated", (Object)topId);
        int totalTasks = td.getExecutors().size();
        int origRequest = td.getNumWorkers();
        int slotsRequested = Math.min(totalTasks, origRequest);
        int slotsUsed = Node.countSlotsUsed(topId, allNodes);
        int slotsFree = Node.countFreeSlotsAlive(allNodes);
        int slotsAvailable = 0;
        if (slotsRequested > slotsFree) {
            slotsAvailable = NodePool.slotsAvailable(lesserPools);
        }
        int slotsToUse = Math.min(slotsRequested - slotsUsed, slotsFree + slotsAvailable);
        LOG.debug("Slots... requested {} used {} free {} available {} to be used {}", new Object[]{slotsRequested, slotsUsed, slotsFree, slotsAvailable, slotsToUse});
        if (slotsToUse <= 0) {
            this._cluster.setStatus(topId, "Not Enough Slots Available to Schedule Topology");
            return 0;
        }
        int slotsNeeded = slotsToUse - slotsFree;
        int numNewNodes = NodePool.getNodeCountIfSlotsWereTaken(slotsNeeded, lesserPools);
        LOG.debug("Nodes... new {} used {} max {}", new Object[]{numNewNodes, this._usedNodes, this._maxNodes});
        if (numNewNodes + this._usedNodes > this._maxNodes) {
            this._cluster.setStatus(topId, "Max Nodes(" + this._maxNodes + ") for this user would be exceeded. " + (numNewNodes - (this._maxNodes - this._usedNodes)) + " more nodes needed to run topology.");
            return 0;
        }
        Collection<Node> found = NodePool.takeNodesBySlot(slotsNeeded, lesserPools);
        this._usedNodes += found.size();
        allNodes.addAll(found);
        return slotsToUse;
    }

    @Override
    public Collection<Node> takeNodes(int nodesNeeded) {
        LOG.debug("Taking {} from {}", (Object)nodesNeeded, (Object)this);
        HashSet<Node> ret = new HashSet<Node>();
        for (Map.Entry<String, Set<Node>> entry : this._topologyIdToNodes.entrySet()) {
            if (this._isolated.contains(entry.getKey())) continue;
            Iterator<Node> it = entry.getValue().iterator();
            while (it.hasNext()) {
                if (nodesNeeded <= 0) {
                    return ret;
                }
                Node n = it.next();
                it.remove();
                n.freeAllSlots(this._cluster);
                ret.add(n);
                --nodesNeeded;
                --this._usedNodes;
            }
        }
        return ret;
    }

    @Override
    public int nodesAvailable() {
        int total = 0;
        for (Map.Entry<String, Set<Node>> entry : this._topologyIdToNodes.entrySet()) {
            if (this._isolated.contains(entry.getKey())) continue;
            total += entry.getValue().size();
        }
        return total;
    }

    @Override
    public int slotsAvailable() {
        int total = 0;
        for (Map.Entry<String, Set<Node>> entry : this._topologyIdToNodes.entrySet()) {
            if (this._isolated.contains(entry.getKey())) continue;
            total += Node.countTotalSlotsAlive((Collection<Node>)entry.getValue());
        }
        return total;
    }

    @Override
    public Collection<Node> takeNodesBySlots(int slotsNeeded) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Map.Entry<String, Set<Node>> entry : this._topologyIdToNodes.entrySet()) {
            if (this._isolated.contains(entry.getKey())) continue;
            Iterator<Node> it = entry.getValue().iterator();
            while (it.hasNext()) {
                Node n = it.next();
                if (!n.isAlive()) continue;
                it.remove();
                --this._usedNodes;
                n.freeAllSlots(this._cluster);
                ret.add(n);
                if ((slotsNeeded -= n.totalSlots()) > 0) continue;
                return ret;
            }
        }
        return ret;
    }

    @Override
    public NodePool.NodeAndSlotCounts getNodeAndSlotCountIfSlotsWereTaken(int slotsNeeded) {
        int nodesFound = 0;
        int slotsFound = 0;
        for (Map.Entry<String, Set<Node>> entry : this._topologyIdToNodes.entrySet()) {
            if (this._isolated.contains(entry.getKey())) continue;
            for (Node n : entry.getValue()) {
                if (!n.isAlive()) continue;
                ++nodesFound;
                int totalSlotsFree = n.totalSlots();
                slotsFound += totalSlotsFree;
                if ((slotsNeeded -= totalSlotsFree) > 0) continue;
                return new NodePool.NodeAndSlotCounts(nodesFound, slotsFound);
            }
        }
        return new NodePool.NodeAndSlotCounts(nodesFound, slotsFound);
    }

    public String toString() {
        return "IsolatedPool... ";
    }
}

